/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.RegulationFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import java.io.IOException;

public class RegulationGffFileIterator
extends RegulationFileIterator {
    public static final int GFF_OFFSET = 1;

    public RegulationGffFileIterator(String fileName) {
        super(fileName, 1);
    }

    public RegulationGffFileIterator(String fileName, Genome genome) {
        super(fileName, genome, 1);
    }

    @Override
    protected Regulation readNext() {
        try {
            while (this.ready()) {
                String[] infos;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int start = this.parsePosition(fields[3]);
                int end = this.parsePosition(fields[4]);
                String strandStr = fields[6];
                boolean strandMinus = strandStr.equals("-");
                String info = fields[8];
                String name = "";
                String cellType = "";
                for (String nv : infos = info.split(";")) {
                    String[] nameValue = nv.split("=");
                    if (nameValue.length <= 0) continue;
                    String attr = nameValue[0].trim();
                    String val = nameValue[1].trim();
                    if (attr.equals("Name")) {
                        name = val;
                        continue;
                    }
                    if (attr.equals("Cell_type")) {
                        cellType = val;
                        continue;
                    }
                    if (!attr.equals("Alias") || !cellType.isEmpty()) continue;
                    cellType = val.split("_")[0];
                }
                String id = cellType + "_" + name + "_" + this.lineNum;
                Regulation reg = new Regulation(chromo, start, end, strandMinus, id, name, cellType);
                return reg;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

