/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.FileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.IOException;
import net.sf.samtools.tabix.TabixReader;

public abstract class MarkerFileIterator<M extends Marker>
extends FileIterator<M> {
    protected boolean createChromos = false;
    protected Genome genome;
    protected boolean ignoreChromosomeErrors = true;
    protected int inOffset;
    protected TabixReader tabixReader;
    protected TabixReader.TabixIterator tabixIterator;

    public MarkerFileIterator(BufferedReader reader, int inOffset) {
        super(reader);
        this.inOffset = inOffset;
        this.genome = new Genome("genome");
        this.createChromos = true;
    }

    public MarkerFileIterator(String fileName, Genome genome, int inOffset) {
        super(fileName);
        this.inOffset = inOffset;
        this.genome = genome != null ? genome : new Genome("genome");
    }

    public MarkerFileIterator(String fileName, int inOffset) {
        super(fileName);
        this.inOffset = inOffset;
        this.genome = new Genome("genome");
        this.createChromos = true;
    }

    public Chromosome getChromosome(String chromoName) {
        if (this.createChromos) {
            return this.genome.getOrCreateChromosome(chromoName);
        }
        return this.genome.getChromosome(chromoName);
    }

    public Genome getGenome() {
        return this.genome;
    }

    @Override
    public boolean hasNext() {
        if (this.tabixReader == null) {
            return super.hasNext();
        }
        if (this.tabixIterator == null) {
            return false;
        }
        if (this.next == null) {
            this.next = this.readNext();
            if (this.next == null && this.autoClose) {
                this.close();
            }
        }
        return this.next != null;
    }

    @Override
    protected void init(String fileName, int inOffset) {
        this.line = null;
        this.lineNum = 0;
        this.next = null;
        this.fileName = fileName;
        if (fileName != null && !this.initTabix(fileName)) {
            this.reader = Gpr.reader(fileName);
        }
    }

    protected boolean initTabix(String fileName) {
        try {
            if (!Gpr.exists(fileName + ".tbi")) {
                return false;
            }
            if (this.tabixReader != null) {
                this.tabixReader.close();
            }
            this.tabixReader = new TabixReader(fileName);
            this.tabixIterator = this.tabixReader.iterator();
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening tabix file '" + fileName + "'", e);
        }
        return true;
    }

    public boolean isIgnoreChromosomeErrors() {
        return this.ignoreChromosomeErrors;
    }

    public boolean isTabix() {
        return this.tabixReader != null;
    }

    public Markers loadMarkers() {
        Markers list2 = new Markers();
        for (Marker t : this) {
            list2.add(t);
        }
        this.close();
        return list2;
    }

    public int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - this.inOffset;
    }

    @Override
    protected String readLine() throws IOException {
        if (this.tabixReader == null) {
            return super.readLine();
        }
        if (this.nextLine != null) {
            String nl = this.nextLine;
            this.nextLine = null;
            return nl;
        }
        if (this.tabixIterator != null) {
            this.nextLine = this.tabixIterator.next();
        }
        if (this.nextLine != null && this.nextLine.length() > 0 && this.nextLine.charAt(this.nextLine.length() - 1) == '\r') {
            this.nextLine = this.nextLine.substring(0, this.nextLine.length() - 1);
        }
        if (this.nextLine != null) {
            ++this.lineNum;
        }
        return this.nextLine;
    }

    @Override
    protected boolean ready() throws IOException {
        if (this.tabixReader == null) {
            return super.ready();
        }
        if (this.nextLine != null) {
            return true;
        }
        return this.readLine() != null;
    }

    public void sanityCheckChromo(String chromoName, Chromosome chromo) {
        if (chromo == null) {
            if (this.ignoreChromosomeErrors) {
                System.err.println("WARNING: Chromosome '" + chromoName + "' not found. File '" + this.fileName + "', line " + this.lineNum);
                return;
            }
            throw new RuntimeException("ERROR: Chromosome '" + chromoName + "' not found! File '" + this.fileName + "', line " + this.lineNum);
        }
    }

    public void seek(String chr) {
        this.nextLine = null;
        this.next = null;
        this.tabixReader.query(chr + ":1");
        this.tabixIterator = this.tabixReader.iterator();
    }

    public boolean seek(String chr, int pos) {
        this.nextLine = null;
        this.next = null;
        this.tabixIterator = this.tabixReader.query(chr + ":" + (pos + 1));
        return this.tabixIterator != null;
    }

    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setIgnoreChromosomeErrors(boolean ignoreChromosomeErrors) {
        this.ignoreChromosomeErrors = ignoreChromosomeErrors;
    }

    public void setInOffset(int inOffset) {
        this.inOffset = inOffset;
    }
}

