/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.GffMarker;
import ca.mcgill.mcb.pcingola.util.KeyValue;
import java.io.IOException;
import java.util.LinkedList;

public class Gff3FileIterator
extends MarkerFileIterator<GffMarker> {
    public Gff3FileIterator(String fileName) {
        super(fileName, 0);
    }

    public Gff3FileIterator(String fileName, Genome genome) {
        super(fileName, genome, 0);
    }

    public Gff3FileIterator(String fileName, Genome genome, int inOffset) {
        super(fileName, genome, inOffset);
    }

    GffMarker parse(String line) {
        if (line.isEmpty()) {
            return null;
        }
        if (line.startsWith("#")) {
            return null;
        }
        String[] fields = line.split("\t");
        if (fields.length < 9) {
            return null;
        }
        String chromo = fields[0];
        String source = fields[1];
        String type = fields[2];
        int start = this.parsePosition(fields[3]);
        int end = this.parsePosition(fields[4]);
        boolean strandMinus = false;
        if (fields[6].equals("+")) {
            strandMinus = false;
        } else if (fields[6].equals("-")) {
            strandMinus = true;
        }
        String attrStr = fields[8];
        String id = null;
        LinkedList<KeyValue<String, String>> kvs = new LinkedList<KeyValue<String, String>>();
        if (attrStr.length() > 0) {
            String[] attrs = attrStr.split(";");
            for (int i = 0; i < attrs.length; ++i) {
                String[] kv = attrs[i].split("=");
                if (kv.length <= 1) continue;
                String string2 = kv[0].trim();
                String value2 = kv[1].trim();
                if (string2.equalsIgnoreCase("ID")) {
                    id = value2;
                    continue;
                }
                if (id == null && string2.equalsIgnoreCase("Name")) {
                    id = value2;
                    continue;
                }
                kvs.add(new KeyValue<String, String>(string2, value2));
            }
        }
        if (id == null) {
            id = type + "_" + chromo + "_" + (start + 1) + "_" + (end + 1);
        }
        id = id.trim();
        Chromosome chromosome = this.getChromosome(chromo);
        GffMarker gffMarker = new GffMarker(chromosome, start, end, strandMinus, id);
        if (!type.isEmpty() && !type.equals(".")) {
            gffMarker.add("type", type);
        }
        if (!source.isEmpty() && !source.equals(".")) {
            gffMarker.add("source", source);
        }
        for (KeyValue keyValue : kvs) {
            gffMarker.add(keyValue);
        }
        return gffMarker;
    }

    @Override
    protected GffMarker readNext() {
        try {
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                GffMarker seqChange = this.parse(this.line);
                if (seqChange == null) continue;
                return seqChange;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

