/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.SeekableBufferedReader;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class FileIterator<T>
implements Iterable<T>,
Iterator<T> {
    protected boolean debug = false;
    protected boolean autoClose = true;
    protected int lineNum;
    protected T next;
    protected BufferedReader reader;
    protected String fileName;
    protected String line;
    protected String nextLine;
    protected long fileSize = -1L;

    public FileIterator(BufferedReader reader) {
        this.init(null, 0);
        this.reader = reader;
        this.autoClose = false;
    }

    public FileIterator(String fileName) {
        this.init(fileName, 0);
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
        this.line = null;
        this.lineNum = 0;
        this.next = null;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            return false;
        }
        if (this.next == null) {
            this.next = this.readNext();
            if (this.next == null && this.autoClose) {
                this.close();
            }
        }
        return this.next != null;
    }

    public boolean hasSeek() {
        return this.reader instanceof SeekableBufferedReader;
    }

    protected void init(String fileName, int inOffset) {
        this.line = null;
        this.lineNum = 0;
        this.next = null;
        this.fileName = fileName;
        if (fileName != null) {
            this.reader = Gpr.reader(fileName);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public List<T> load() {
        LinkedList<T> list2 = new LinkedList<T>();
        for (T t : this) {
            list2.add(t);
        }
        this.close();
        return list2;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T ret = this.next;
            this.next = null;
            return ret;
        }
        return null;
    }

    protected String readLine() throws IOException {
        if (this.nextLine != null) {
            String nl = this.nextLine;
            this.nextLine = null;
            return nl;
        }
        this.nextLine = this.reader.readLine();
        if (this.nextLine != null && this.nextLine.length() > 0 && this.nextLine.charAt(this.nextLine.length() - 1) == '\r') {
            this.nextLine = this.nextLine.substring(0, this.nextLine.length() - 1);
        }
        if (this.nextLine != null) {
            ++this.lineNum;
        }
        return this.nextLine;
    }

    protected abstract T readNext();

    protected boolean ready() throws IOException {
        if (this.reader == null) {
            return false;
        }
        if (this.nextLine != null) {
            return true;
        }
        this.readLine();
        return this.nextLine != null;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented");
    }

    public void seek(long pos) throws IOException {
        if (!this.hasSeek()) {
            throw new IOException("Seek operation not supported!");
        }
        ((SeekableBufferedReader)this.reader).seek(pos);
        this.next = null;
        this.nextLine = null;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":'" + this.fileName + "'" + ",autoClose:" + this.autoClose + (this.hasSeek() ? ",pos:" + ((SeekableBufferedReader)this.reader).position() : "");
    }
}

