/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.DbNsfpEntry;
import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DbNsfpFileIterator
extends MarkerFileIterator<DbNsfpEntry> {
    public static final int MIN_LINES = 10000;
    public static final int MAX_LINES = 100000;
    public static final String HEADER_PREFIX = "#";
    public static final char COLUMN_SEPARATOR = '\t';
    public static final String COLUMN_SEPARATOR_STR = "\t";
    public static final String SUBFIELD_SEPARATOR = ";";
    public static final String SUBFIELD_SEPARATOR_ALT = ",";
    public static final String COLUMN_CHR_NAME = "chr";
    public static final String COLUMN_POS_NAME_v2 = "pos(1-coor)";
    public static final String COLUMN_POS_NAME_v3 = "pos(1-based)";
    public static final String ALT_NAME = "alt";
    private final TObjectIntHashMap<String> columnNames2Idx = new TObjectIntHashMap();
    boolean collapseRepeatedValues = true;
    int chromosomeIdx;
    int startIdx;
    int altIdx;
    String[] fieldNames = null;
    VcfInfoType[] types = null;
    boolean[] multipleValues = null;
    HashMap<String, Integer> names2index;

    public static String[] split(String value2, char delim) {
        if (value2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value2, delim);
        return st.tokens(String.class);
    }

    public DbNsfpFileIterator(String fileName) {
        super(fileName, 1);
    }

    public void forceMissingTypesAsString() {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) continue;
            this.types[i] = VcfInfoType.String;
        }
    }

    public Set<String> getFieldNames() {
        if (this.columnNames2Idx.size() == 0) {
            this.parseHeader(null);
        }
        return this.columnNames2Idx.keySet();
    }

    public String[] getFieldNamesSorted() {
        return this.fieldNames;
    }

    public boolean[] getMultipleValues() {
        return this.multipleValues;
    }

    public HashMap<String, Integer> getNames2index() {
        return this.names2index;
    }

    public VcfInfoType[] getTypes() {
        return this.types;
    }

    public VcfInfoType guessDataType(String value2) {
        if (value2 == null || value2.isEmpty() || value2.equals(".")) {
            return null;
        }
        if (this.isMultipleValues(value2)) {
            String[] values2 = null;
            values2 = value2.indexOf(SUBFIELD_SEPARATOR_ALT) >= 0 ? value2.split(SUBFIELD_SEPARATOR_ALT) : value2.split(SUBFIELD_SEPARATOR);
            VcfInfoType type = null;
            for (String val : values2) {
                VcfInfoType valType = this.guessDataType(val);
                if (type == null) {
                    type = valType;
                    continue;
                }
                if (valType == null || type == valType) continue;
                return null;
            }
            return type;
        }
        try {
            Long.parseLong(value2);
            return VcfInfoType.Integer;
        }
        catch (Exception e) {
            try {
                Double.parseDouble(value2);
                return VcfInfoType.Float;
            }
            catch (Exception exception) {
                if (value2.length() == 1) {
                    return VcfInfoType.Character;
                }
                if (value2.equalsIgnoreCase("true") || value2.equalsIgnoreCase("false") || value2.equalsIgnoreCase("yes") || value2.equalsIgnoreCase("no")) {
                    return VcfInfoType.Flag;
                }
                return VcfInfoType.String;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean guessDataTypes(boolean verbose) {
        boolean header = true;
        this.fieldNames = null;
        this.types = null;
        this.multipleValues = null;
        this.names2index = null;
        try {
            int entryNum = 0;
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return false;
                }
                if (header) {
                    header = false;
                    if (!HEADER_PREFIX.isEmpty() && !this.line.startsWith(HEADER_PREFIX)) return false;
                    this.line = this.line.substring(HEADER_PREFIX.length());
                    this.fieldNames = this.line.split(COLUMN_SEPARATOR_STR);
                    this.types = new VcfInfoType[this.fieldNames.length];
                    this.multipleValues = new boolean[this.fieldNames.length];
                    this.names2index = new HashMap();
                    for (int i = 0; i < this.fieldNames.length; ++i) {
                        this.fieldNames[i] = this.fieldNames[i].trim();
                        this.names2index.put(this.fieldNames[i], i);
                    }
                } else {
                    if (this.multipleValues == null) {
                        throw new RuntimeException("Cannot parse file '" + this.fileName + "'. Missing header?");
                    }
                    boolean done = true;
                    String[] values2 = this.line.split(COLUMN_SEPARATOR_STR);
                    for (int i = 0; i < this.fieldNames.length; ++i) {
                        VcfInfoType type = this.guessDataType(values2[i]);
                        if (this.types[i] == null) {
                            this.types[i] = type;
                        } else if (this.types[i] == VcfInfoType.Integer && type == VcfInfoType.Float) {
                            this.types[i] = type;
                        } else if (type == VcfInfoType.String) {
                            this.types[i] = type;
                        }
                        int n = i;
                        this.multipleValues[n] = this.multipleValues[n] | this.isMultipleValues(values2[i]);
                        done &= this.types[i] != null;
                    }
                    if (verbose) {
                        Gpr.showMark(entryNum, 1000);
                    }
                    if (done && entryNum > 10000) {
                        return true;
                    }
                    if (entryNum > 100000) {
                        return false;
                    }
                }
                ++entryNum;
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'", e);
        }
    }

    public boolean guessVcfTypes(boolean verbose) {
        boolean ok = this.guessDataTypes(verbose);
        this.init(this.fileName, this.inOffset);
        return ok;
    }

    public boolean hasField(String filedName) {
        if (this.columnNames2Idx.size() == 0) {
            this.parseHeader(null);
        }
        return this.columnNames2Idx.containsKey(filedName);
    }

    boolean isMultipleValues(String value2) {
        return value2.indexOf(SUBFIELD_SEPARATOR) >= 0 || value2.indexOf(SUBFIELD_SEPARATOR_ALT) >= 0;
    }

    private DbNsfpEntry parseEntry(List<String[]> valuesForEntry) {
        String[] vals = valuesForEntry.get(0);
        String chromosome = vals[this.chromosomeIdx];
        int start = this.parsePosition(vals[this.startIdx]);
        DbNsfpEntry dbNsfp = new DbNsfpEntry(this.getChromosome(chromosome), start);
        dbNsfp.setCollapseRepeatedValues(this.collapseRepeatedValues);
        for (String[] altAlleleValues : valuesForEntry) {
            String alt = altAlleleValues[this.altIdx];
            for (String columnName : this.columnNames2Idx.keySet()) {
                int colIndex = this.columnNames2Idx.get(columnName);
                String value2 = altAlleleValues[colIndex];
                dbNsfp.add(alt, columnName, value2);
            }
        }
        return dbNsfp;
    }

    void parseHeader(String line) {
        if (line == null) {
            try {
                if (!this.ready()) {
                    throw new RuntimeException("Error reading (parsing header) from file '" + this.fileName + "'.");
                }
                line = this.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + line + "'");
            }
        }
        if (!line.startsWith(HEADER_PREFIX)) {
            throw new RuntimeException("First line is not a valid header!\n\tFirst line: " + line);
        }
        line = line.substring(1);
        String[] values2 = DbNsfpFileIterator.split(line, '\t');
        this.altIdx = -1;
        this.startIdx = -1;
        this.chromosomeIdx = -1;
        block13: for (int idx = 0; idx < values2.length; ++idx) {
            this.columnNames2Idx.put(values2[idx].trim(), idx);
            switch (values2[idx].toLowerCase()) {
                case "chr": {
                    this.chromosomeIdx = idx;
                    continue block13;
                }
                case "pos(1-coor)": 
                case "pos(1-based)": {
                    this.startIdx = idx;
                    continue block13;
                }
                case "alt": {
                    this.altIdx = idx;
                    continue block13;
                }
            }
        }
        if (this.chromosomeIdx == -1) {
            throw new RuntimeException("Missing 'chr' columns in dbNSFP file");
        }
        if (this.startIdx == -1) {
            throw new RuntimeException("Missing 'pos(1-coor)' columns in dbNSFP file");
        }
        if (this.altIdx == -1) {
            throw new RuntimeException("Missing 'alt' columns in dbNSFP file");
        }
    }

    @Override
    protected DbNsfpEntry readNext() {
        if (this.types == null) {
            throw new RuntimeException("Data types have not been identified. Forgot to invoke guessVcfTypes()?");
        }
        try {
            ArrayList<String[]> valuesForEntry = new ArrayList<String[]>();
            while (this.ready()) {
                String[] currentValues;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.columnNames2Idx.size() == 0) {
                    this.parseHeader(this.line);
                    continue;
                }
                String[] values2 = DbNsfpFileIterator.split(this.line, '\t');
                if (!(valuesForEntry.size() <= 0 || (currentValues = (String[])valuesForEntry.get(0))[this.chromosomeIdx].equals(values2[this.chromosomeIdx]) && currentValues[this.startIdx].equals(values2[this.startIdx]))) {
                    this.nextLine = this.line;
                    break;
                }
                valuesForEntry.add(values2);
            }
            if (valuesForEntry.size() == 0) {
                return null;
            }
            DbNsfpEntry entry = this.parseEntry(valuesForEntry);
            return entry;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
    }

    public void setCollapseRepeatedValues(boolean collapseRepeatedValues) {
        this.collapseRepeatedValues = collapseRepeatedValues;
    }

    private static class StringTokenizer {
        String string = null;
        int tokens = 0;
        int[] separatorPosition = new int[1000];

        StringTokenizer(String value2, char delim) {
            this.string = value2;
            StringCharacterIterator sci = new StringCharacterIterator(this.string);
            char c = sci.first();
            while (c != '\uffff') {
                if (c == delim) {
                    this.separatorPosition[this.tokens] = sci.getIndex();
                    ++this.tokens;
                    if (this.tokens >= this.separatorPosition.length) {
                        int[] copy = new int[this.separatorPosition.length * 10];
                        System.arraycopy(this.separatorPosition, 0, copy, 0, this.separatorPosition.length);
                        this.separatorPosition = copy;
                    }
                }
                c = sci.next();
            }
            ++this.tokens;
        }

        <T> T[] tokens(Class<T> componentType) {
            Constructor<T> ctor;
            Object[] r = (Object[])Array.newInstance(componentType, this.tokens);
            try {
                ctor = componentType.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot create an array of type [" + componentType + "] from an array of String. The type [" + componentType.getSimpleName() + "] must define a single arg constructor that takes a String.class instance.");
            }
            String currentValue = null;
            int i = 0;
            try {
                int start = 0;
                for (i = 0; i < this.tokens; ++i) {
                    int length;
                    int nextStart = this.separatorPosition[i];
                    if (i == this.tokens - 1) {
                        nextStart = this.string.length();
                    }
                    if ((length = nextStart - start) > 0) {
                        currentValue = this.string.substring(start, nextStart);
                        r[i] = ctor.newInstance(currentValue);
                    }
                    start = nextStart + 1;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create an instance of type [" + componentType + "] from the " + i + "th string value [" + currentValue + "].", e);
            }
            return r;
        }
    }
}

