/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.interval.Marker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DbNsfpEntry
extends Marker {
    private static final long serialVersionUID = -3275792763917755927L;
    AutoHashMap<String, HashMap<String, String>> values = new AutoHashMap(new HashMap());
    boolean collapseRepeatedValues = true;

    public DbNsfpEntry() {
    }

    public DbNsfpEntry(Marker parent, int start) {
        super(parent, start, start, false, "");
    }

    public void add(String alt, String columnName, String valuesToAdd) {
        HashMap<String, String> altVals = this.values.getOrCreate(alt);
        valuesToAdd = valuesToAdd.isEmpty() ? "." : valuesToAdd.replace(';', '\t');
        if (!altVals.containsKey(columnName)) {
            altVals.put(columnName, valuesToAdd);
            return;
        }
        if (this.collapseRepeatedValues) {
            HashSet<String> currVals = new HashSet<String>();
            for (String cv : altVals.get(columnName).split("\t")) {
                currVals.add(cv);
            }
            for (String nv : valuesToAdd.split("\t")) {
                if (currVals.contains(nv)) continue;
                altVals.put(columnName, altVals.get(columnName) + "\t" + nv);
                currVals.add(nv);
            }
            return;
        }
        String newValue = altVals.get(columnName) + "\t" + valuesToAdd;
        altVals.put(columnName, newValue);
    }

    @Override
    public DbNsfpEntry cloneShallow() {
        DbNsfpEntry clone2 = (DbNsfpEntry)super.cloneShallow();
        clone2.collapseRepeatedValues = this.collapseRepeatedValues;
        return clone2;
    }

    public String get(String alt, String key) {
        HashMap altVals = (HashMap)this.values.get(alt);
        if (altVals == null) {
            return null;
        }
        return (String)altVals.get(key);
    }

    public String getCsv(String alt, String key) {
        String val = this.get(alt, key);
        if (val == null) {
            return null;
        }
        return val.replace('\t', ',');
    }

    public boolean hasValues(String allele) {
        return this.values.containsKey(allele);
    }

    public void setCollapseRepeatedValues(boolean collapseRepeatedValues) {
        this.collapseRepeatedValues = collapseRepeatedValues;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + "\t");
        sb.append(this.getStart() + "\t");
        for (String alt : this.values.keySet()) {
            sb.append(alt + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('\n');
        for (String key : this.values.keySet()) {
            Map map2 = (Map)this.values.get(key);
            sb.append("\tALT '" + key + "':\n");
            for (String mk : map2.keySet()) {
                sb.append("\t\t" + mk + ": '" + (String)map2.get(mk) + "'\n");
            }
        }
        return sb.toString();
    }
}

