/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.binseq;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSeq;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalTree;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class GenomicSequences
implements Iterable<MarkerSeq>,
Serializable {
    private static final long serialVersionUID = 2339867422366567569L;
    public static final int MAX_ITERATIONS = 1000000;
    public static boolean debug = false;
    public static boolean verbose = false;
    boolean disableLoad = false;
    Genome genome;
    IntervalForest intervalForest;

    public GenomicSequences(Genome genome) {
        this.genome = genome;
        this.intervalForest = new IntervalForest();
    }

    public void addChromosomeSequence(String chr, String chrSeq) {
        MarkerSeq ms = new MarkerSeq(this.genome.getOrCreateChromosome(chr), 0, chrSeq.length() - 1, chrSeq);
        this.intervalForest.add(ms);
    }

    boolean addExonSequences(String chr) {
        if (verbose) {
            Timer.showStdErr("Creating sequences from exon information '" + chr + "'");
        }
        IntervalTree tree = this.intervalForest.getOrCreateTree(chr);
        Markers exonMarkers = this.exonMarkers(chr);
        if (debug) {
            Gpr.debug("Before union: " + exonMarkers.size());
        }
        exonMarkers = exonMarkers.union();
        if (debug) {
            Gpr.debug("After union: " + exonMarkers.size());
        }
        tree.add(exonMarkers);
        if (verbose) {
            Timer.showStdErr("Building sequence tree for chromosome '" + chr + "'");
        }
        tree.build();
        if (verbose) {
            Timer.showStdErr("Done. Loaded " + tree.getIntervals().size() + " sequences.");
        }
        return !tree.isEmpty();
    }

    public int addGeneSequences(String chr, String chrSeq) {
        int seqsAdded = 0;
        Markers markers = this.genesMarkers(chr, chrSeq.length());
        markers = markers.merge();
        for (Marker genes : markers) {
            if (!genes.getChromosomeName().equalsIgnoreCase(chr)) continue;
            int ssStart = genes.getStart();
            int ssEnd = genes.getEnd() + 1;
            if (ssStart < 0 || ssEnd > chrSeq.length()) {
                System.err.println("Ignoring gene outside chromosome range (chromo length: " + chrSeq.length() + "). Sequence (merged genes): " + genes.toStr());
                continue;
            }
            try {
                String seq2 = chrSeq.substring(ssStart, ssEnd).toUpperCase();
                ++seqsAdded;
                MarkerSeq m = new MarkerSeq(genes.getChromosome(), genes.getStart(), genes.getEnd(), false, genes.getChromosomeName() + ":" + genes.getStart() + "-" + genes.getEnd());
                m.setSequence(seq2);
                this.intervalForest.add(m);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException("Error trying to add sequence for gene:\n\tChromosome sequence length: " + chrSeq.length() + "\n\tGene: " + genes.toStr());
            }
        }
        return seqsAdded;
    }

    public void build() {
        this.intervalForest.build();
    }

    Markers exonMarkers(String chr) {
        Markers markers = new Markers();
        for (Gene g : this.genome.getGenes()) {
            if (!g.getChromosomeName().equals(chr)) continue;
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    String seq2 = ex.getSequence();
                    if (seq2 == null || seq2.length() < ex.size()) continue;
                    if (ex.isStrandPlus()) {
                        markers.add(ex);
                        continue;
                    }
                    Exon exRwc = (Exon)ex.clone();
                    exRwc.setSequence(GprSeq.reverseWc(ex.getSequence()));
                    markers.add(exRwc);
                }
            }
        }
        return markers;
    }

    Markers genesMarkers(String chr, int chrLen) {
        Markers markers = new Markers();
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.getChromosomeName().equalsIgnoreCase(chr)) continue;
            int ssStart = gene.getStart();
            int ssEnd = gene.getEnd() + 1;
            if (ssStart < 0 || ssEnd > chrLen) {
                System.err.println("Ignoring gene outside chromosome range (chromo length: " + chrLen + "). Gene: " + gene.toStr());
                continue;
            }
            try {
                MarkerSeq m = new MarkerSeq(gene.getChromosome(), gene.getStart(), gene.getEnd(), false, gene.getId());
                markers.add(m);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException("Error trying to add sequence for gene:\n\tChromosome sequence length: " + chrLen + "\n\tGene: " + gene.toStr());
            }
        }
        return markers;
    }

    public boolean hasChromosome(String chr) {
        if (!this.intervalForest.hasTree(chr)) {
            return false;
        }
        IntervalTree tree = this.intervalForest.getTree(chr);
        return tree == null || !tree.isEmpty();
    }

    public boolean isEmpty() {
        for (IntervalTree tree : this.intervalForest) {
            if (tree.getIntervals().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<MarkerSeq> iterator() {
        ArrayList<MarkerSeq> all = new ArrayList<MarkerSeq>();
        for (IntervalTree tree : this.intervalForest) {
            for (Marker m : tree.getIntervals()) {
                all.add((MarkerSeq)m);
            }
        }
        return all.iterator();
    }

    public synchronized boolean load(String chr) {
        if (this.hasChromosome(chr)) {
            return true;
        }
        if (this.disableLoad) {
            return false;
        }
        String fileName = Config.get().getFileNameSequence(chr);
        if (!Gpr.exists(fileName)) {
            if (Config.get().isDebug()) {
                Timer.showStdErr("Attempting to load sequences for chromosome '" + chr + "' from file '" + fileName + "' failed, nothing done.");
            }
            return false;
        }
        if (verbose) {
            Timer.showStdErr("Loading sequences for chromosome '" + chr + "' from file '" + fileName + "'");
        }
        IntervalTree tree = this.intervalForest.getOrCreateTree(chr);
        tree.load(fileName, this.genome);
        if (verbose) {
            Timer.showStdErr("Building sequence tree for chromosome '" + chr + "'");
        }
        tree.build();
        if (verbose) {
            Timer.showStdErr("Done. Loaded " + tree.getIntervals().size() + " sequences.");
        }
        return !tree.isEmpty();
    }

    public synchronized boolean loadOrCreateFromGenome(String chr) {
        if (this.hasChromosome(chr)) {
            return true;
        }
        if (this.load(chr)) {
            return true;
        }
        return this.addExonSequences(chr);
    }

    public synchronized MarkerSeq queryMarkerSequence(Marker marker) {
        IntervalTree tree;
        String chr = marker.getChromosomeName();
        if (!this.intervalForest.hasTree(chr)) {
            this.loadOrCreateFromGenome(chr);
        }
        if ((tree = this.intervalForest.getTree(chr)) == null || tree.isEmpty()) {
            return null;
        }
        Markers res = tree.query(marker);
        if (res.isEmpty()) {
            return null;
        }
        for (Marker m : res) {
            if (!m.includes(marker) || !(m instanceof MarkerSeq)) continue;
            return (MarkerSeq)m;
        }
        return null;
    }

    public String querySequence(Marker marker) {
        MarkerSeq ms = this.queryMarkerSequence(marker);
        if (ms == null) {
            return null;
        }
        int sstart = marker.getStart() - ms.getStart();
        int ssend = marker.size() + sstart;
        String seq2 = ms.getSequence().substring(sstart, ssend);
        if (marker.isStrandMinus()) {
            seq2 = GprSeq.reverseWc(seq2);
        }
        return seq2;
    }

    public void reset() {
        this.intervalForest = new IntervalForest();
    }

    public void save(Config config) {
        if (this.isEmpty()) {
            return;
        }
        ArrayList<String> chrNames = new ArrayList<String>();
        chrNames.addAll(this.intervalForest.getTreeNames());
        Collections.sort(chrNames);
        for (String chr : chrNames) {
            this.save(chr);
        }
    }

    void save(String chr) {
        if (!this.intervalForest.hasTree(chr)) {
            if (verbose) {
                Timer.showStdErr("No tree found for chromosome '" + chr + "'");
            }
            return;
        }
        IntervalTree tree = this.intervalForest.getTree(chr);
        String fileName = Config.get().getFileNameSequence(chr);
        if (verbose) {
            Timer.showStdErr("Saving sequences for chromosome '" + chr + "' to file '" + fileName + "'");
        }
        tree.getIntervals().save(fileName);
    }

    public void setDisableLoad(boolean disableLoad) {
        this.disableLoad = disableLoad;
    }

    public void setVerbose(boolean verbose) {
        GenomicSequences.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Genomic sequences '" + this.genome.getId() + "'\n");
        long sumMarkers = 0L;
        long sumLen = 0L;
        for (String chr : this.intervalForest.getTreeNames()) {
            IntervalTree tree = this.intervalForest.getTree(chr);
            long len = 0L;
            for (Marker m : tree.getIntervals()) {
                len += (long)m.size();
                sumLen += (long)m.size();
            }
            sumMarkers += (long)tree.getIntervals().size();
            sb.append("\t" + chr + "\t" + tree.size() + "\t" + len + "\n");
        }
        sb.append("\tTOTAL\t" + sumMarkers + "\t" + sumLen + "\n");
        return sb.toString();
    }
}

