/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.align;

import ca.mcgill.mcb.pcingola.binseq.GenomicSequences;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSeq;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class VariantRealign {
    public static final int INITIAL_BASES_MULTIPLIER = 3;
    public static final int INITIAL_BASES_EXTRA = 10;
    public static final int PROGRESSIVE_BASES_MULTIPLIER = 2;
    public static final int PROGRESSIVE_BASES_EXTRA = 1;
    public static final int MAX_ITERATIONS = 100;
    public static boolean debug = false;
    boolean alignLeft = true;
    boolean realigned;
    boolean needMoreBasesLeft;
    boolean needMoreBasesRight;
    char[] basesRef;
    char[] basesAlt;
    int basesTrimLeft;
    int basesTrimRight;
    int basesAddedLeft;
    int basesAddedRight;
    int maxBasesLeft;
    int maxBasesRight;
    String sequenceRef;
    String sequenceAlt;
    String refRealign;
    String altRealign;
    GenomicSequences genSeqs;
    Variant variant;
    Variant variantRealigned;

    public VariantRealign() {
    }

    public VariantRealign(GenomicSequences genSeqs, Variant variant) {
        this.genSeqs = genSeqs;
        this.variant = variant;
    }

    boolean basesToAdd(int addBasesLeft, int addBasesRight) {
        MarkerSeq ms = this.genSeqs.queryMarkerSequence(this.variant);
        if (ms == null) {
            return false;
        }
        this.maxBasesLeft = this.variant.getStart() - ms.getStart();
        this.maxBasesRight = ms.getEnd() - this.variant.getEnd();
        this.basesAddedLeft = this.variant.getStart() - (this.variant.getStart() - addBasesLeft);
        this.basesAddedRight = this.variant.getEnd() + addBasesRight - this.variant.getEnd();
        this.basesAddedLeft = Math.min(this.basesAddedLeft, this.maxBasesLeft);
        this.basesAddedRight = Math.min(this.basesAddedRight, this.maxBasesRight);
        return true;
    }

    boolean createAltSeq() {
        String seqPre = this.sequenceRef.substring(0, this.basesAddedLeft);
        String seqVar = this.sequenceRef.substring(this.basesAddedLeft);
        String vref = this.variant.getReference().toLowerCase();
        if (!vref.isEmpty()) {
            if (!seqVar.startsWith(vref)) {
                if (debug) {
                    Gpr.debug("Variant not found in reference sequence. This should never happen!\n\tSeq: '" + seqVar + "'\n\tVariant's ref: '" + vref + "'");
                }
                return false;
            }
            seqVar = seqVar.substring(vref.length());
        }
        this.sequenceAlt = seqPre + this.variant.getAlt().toLowerCase() + seqVar;
        return true;
    }

    boolean createRealignedVariant() {
        int start = this.variant.getStart() - this.basesAddedLeft + this.basesTrimLeft;
        int end = this.variant.getEnd() + this.basesAddedRight - this.basesTrimRight;
        if (end < start) {
            end = start;
        }
        if (start == this.variant.getStart() && end == this.variant.getEnd()) {
            return false;
        }
        this.variantRealigned = new Variant(this.variant.getParent(), start, this.refRealign, this.altRealign, this.variant.getId());
        this.variantRealigned.setGenotype(this.variant.getGenotype());
        return true;
    }

    boolean createRefSeq() {
        Marker m = new Marker(this.variant.getChromosome(), this.variant.getStart() - this.basesAddedLeft, this.variant.getEnd() + this.basesAddedRight);
        this.sequenceRef = this.genSeqs.querySequence(m);
        return this.sequenceRef != null;
    }

    public String getAltRealign() {
        return this.altRealign;
    }

    public String getRefRealign() {
        return this.refRealign;
    }

    public Variant getVariantRealigned() {
        return this.variantRealigned;
    }

    boolean needMoreBases() {
        this.needMoreBasesLeft = this.basesTrimLeft == 0;
        this.needMoreBasesRight = this.basesTrimRight == 0;
        return this.needMoreBasesLeft || this.needMoreBasesRight;
    }

    public boolean realign() {
        int basesAddedLeftPrev = 0;
        int basesAddedRightPrev = 0;
        boolean needMoreBases = true;
        for (int i = 0; i < 100 && needMoreBases; ++i) {
            if (i == 0) {
                int maxVarLen = 3 * Math.max(this.variant.getReference().length(), this.variant.getAlt().length());
                this.basesAddedLeft = this.basesAddedRight = Math.max(maxVarLen, 10);
            } else {
                this.basesAddedLeft = 2 * this.basesAddedLeft + 1;
                this.basesAddedRight = 2 * this.basesAddedRight + 1;
            }
            if (debug) {
                Gpr.debug("Bases\tleft: " + this.basesAddedLeft + (this.needMoreBasesLeft ? " [more]" : "") + "\tright: " + this.basesAddedRight + (this.needMoreBasesRight ? " [more]" : ""));
            }
            if (!this.basesToAdd(this.basesAddedLeft, this.basesAddedRight)) {
                return false;
            }
            if (this.needMoreBasesLeft && basesAddedLeftPrev == this.basesAddedLeft || this.needMoreBasesRight && basesAddedRightPrev == this.basesAddedRight) break;
            if (!this.createRefSeq()) {
                return false;
            }
            if (!this.createAltSeq()) {
                return false;
            }
            this.realigned = this.realignSeqs();
            needMoreBases = this.needMoreBases();
            basesAddedLeftPrev = this.basesAddedLeft;
            basesAddedRightPrev = this.basesAddedRight;
        }
        if (!this.realigned) {
            return false;
        }
        boolean ok = this.createRealignedVariant();
        if (debug) {
            Gpr.debug(this);
        }
        return ok;
    }

    public boolean realignSeqs() {
        this.basesTrimRight = 0;
        this.basesTrimLeft = 0;
        this.basesRef = this.sequenceRef.toCharArray();
        this.basesAlt = this.sequenceAlt.toCharArray();
        if (this.alignLeft) {
            this.basesTrimLeft = this.trimBasesLeft();
            this.basesTrimRight = this.trimBasesRight();
        } else {
            this.basesTrimRight = this.trimBasesRight();
            this.basesTrimLeft = this.trimBasesLeft();
        }
        this.refRealign = this.trimedSequence(this.sequenceRef).toUpperCase();
        this.altRealign = this.trimedSequence(this.sequenceAlt).toUpperCase();
        return true;
    }

    public void setAlignLeft() {
        this.alignLeft = true;
    }

    public void setAlignRight() {
        this.alignLeft = false;
    }

    public void setSequenceAlt(String sequenceAlt) {
        this.sequenceAlt = sequenceAlt;
    }

    public void setSequenceRef(String sequenceRef) {
        this.sequenceRef = sequenceRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Realigned: " + (this.realigned ? "Yes" : "No") + "\n");
        sb.append("\tVariant (original)   : " + this.variant + "\n");
        sb.append("\tVariant (realinged)  : " + this.variantRealigned + "\n");
        sb.append("\tReference sequence   : '" + this.sequenceRef + "'\tlen: " + this.sequenceRef.length() + "\n");
        sb.append("\tAlternative sequence : '" + this.sequenceAlt + "'\tlen: " + this.sequenceAlt.length() + "\n");
        sb.append("\tRef (after realign)  : '" + this.refRealign + "'\n");
        sb.append("\tAlt (after realign)  : '" + this.altRealign + "'\n");
        sb.append("\tBases added          : left: " + this.basesAddedLeft + ", right: " + this.basesAddedRight + "\n");
        sb.append("\tIndexes              : left: " + this.basesTrimLeft + ", right: " + this.basesTrimRight + "\n");
        if (this.needMoreBasesLeft) {
            sb.append("\tWARNING: Needs more bases to the left.\n");
        }
        if (this.needMoreBasesRight) {
            sb.append("\tWARNING: Needs more bases to the right.\n");
        }
        return sb.toString();
    }

    int trimBasesLeft() {
        int bases = 0;
        int refIdx = 0;
        int altIdx = 0;
        while (refIdx < this.sequenceRef.length() && altIdx < this.sequenceAlt.length()) {
            if (this.basesRef[refIdx] != this.basesAlt[altIdx]) {
                return bases;
            }
            ++refIdx;
            ++altIdx;
            ++bases;
        }
        return bases;
    }

    int trimBasesRight() {
        int bases = 0;
        int refIdx = this.basesRef.length - 1;
        int altIdx = this.basesAlt.length - 1;
        while (refIdx >= this.basesTrimLeft && altIdx >= this.basesTrimLeft) {
            if (this.basesRef[refIdx] != this.basesAlt[altIdx]) {
                return bases;
            }
            --refIdx;
            --altIdx;
            ++bases;
        }
        return bases;
    }

    String trimedSequence(String seq2) {
        int end = seq2.length() - this.basesTrimRight;
        if (this.basesTrimLeft <= end) {
            return seq2.substring(this.basesTrimLeft, end);
        }
        return "";
    }
}

