/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.align;

import ca.mcgill.mcb.pcingola.align.NeedlemanWunsch;

public class SmithWaterman
extends NeedlemanWunsch {
    public SmithWaterman(String a, String b) {
        super(a, b);
        this.useSpace = false;
    }

    @Override
    void calcAlignment() {
        int h;
        int i;
        int maxLen = Math.max(this.a.length, this.b.length);
        this.alignmentA = new char[maxLen];
        this.alignmentB = new char[maxLen];
        for (i = 0; i < maxLen; ++i) {
            this.alignmentB[i] = 32;
            this.alignmentA[i] = 32;
        }
        i = this.a.length;
        int j = this.b.length;
        int maxScore = 0;
        for (int ii = 0; ii <= this.a.length; ++ii) {
            for (int jj = 0; jj <= this.b.length; ++jj) {
                if (this.getScore(ii, jj) <= maxScore) continue;
                maxScore = this.getScore(ii, jj);
                i = ii;
                j = jj;
            }
        }
        for (h = Math.max(i, j) - 1; i > 0 && j > 0 && h >= 0; --h) {
            int s = this.getScore(i, j);
            int scorediag = this.getScore(i - 1, j - 1);
            int scoreup = this.getScore(i, j - 1);
            int scoreleft = this.getScore(i - 1, j);
            if (s <= 0) break;
            if (s == scoreup + this.deletion) {
                this.alignmentA[h] = 45;
                this.alignmentB[h] = this.b[j - 1];
                --j;
                continue;
            }
            if (s == scoreleft + this.deletion) {
                this.alignmentA[h] = this.a[i - 1];
                this.alignmentB[h] = 45;
                --i;
                continue;
            }
            if (s != scorediag + this.simmilarity(i, j)) break;
            if (this.useSpace) {
                this.alignmentA[h] = 32;
                this.alignmentB[h] = 32;
            } else {
                this.alignmentA[h] = this.a[i - 1];
                this.alignmentB[h] = this.b[j - 1];
            }
            --i;
            --j;
        }
        while (i > 0 && h >= 0) {
            this.alignmentA[h] = this.a[i - 1];
            this.alignmentB[h] = 45;
            --i;
            --h;
        }
        while (j > 0 && h >= 0) {
            this.alignmentA[h] = 45;
            this.alignmentB[h] = this.b[j - 1];
            --j;
            --h;
        }
        this.offset = 0;
        while (this.offset < maxLen && this.alignmentA[this.offset] == ' ') {
            ++this.offset;
        }
        StringBuffer alsb = new StringBuffer();
        int prev = 32;
        for (i = 0; i < maxLen; ++i) {
            if (this.alignmentA[i] == '-') {
                if (prev != 45) {
                    alsb.append('-');
                }
                alsb.append(this.alignmentB[i]);
                prev = 45;
                continue;
            }
            if (this.alignmentB[i] != '-') continue;
            if (prev != 43) {
                alsb.append('+');
            }
            alsb.append(this.alignmentA[i]);
            prev = 43;
        }
        this.alignment = alsb.toString();
    }

    @Override
    void scoreMatrix() {
        int i;
        this.score = new int[this.a.length + 1][this.b.length + 1];
        for (i = 0; i <= this.a.length; ++i) {
            this.setScore(i, 0, 0);
        }
        for (int j = 0; j <= this.b.length; ++j) {
            this.setScore(0, j, 0);
        }
        this.bestScore = Integer.MIN_VALUE;
        for (i = 1; i <= this.a.length; ++i) {
            for (int j = 1; j <= this.b.length; ++j) {
                int match = this.getScore(i - 1, j - 1) + this.simmilarity(i, j);
                int del = this.getScore(i - 1, j) + this.deletion;
                int ins = this.getScore(i, j - 1) + this.deletion;
                int s = Math.max(0, Math.max(match, Math.max(del, ins)));
                this.setScore(i, j, s);
                this.bestScore = Math.max(this.bestScore, s);
            }
        }
    }
}

