/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfHapMapFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.snpSift.VcfLd;
import ca.mcgill.mcb.pcingola.snpSift.hwe.VcfHwe;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashMap;

public class ZzzHapMap {
    static boolean verbose = false;
    Genome genome = new Genome("genome");
    double minPhew = 0.5;
    HashMap<String, VcfEntry> vcfEntries;

    public static void main(String[] args) {
        String hapMapFileName = Gpr.HOME + "/ld/hapmap3_r2_b36_fwd.consensus.qc.poly.chr22_yri.phased";
        String fastaFile = Gpr.HOME + "/ld/hg36.chr22.fa";
        String chrName = "22";
        String ldFile = Gpr.HOME + "/ld/ld_chr22_YRI.txt";
        hapMapFileName = Gpr.HOME + "/ld/test.phased";
        ldFile = Gpr.HOME + "/ld/ld_test.txt";
    }

    void calcToCenter() {
        VcfLd vcfLd = new VcfLd();
        int center = this.vcfEntries.size() / 2;
        VcfEntry eCenter = this.vcfEntries.get(center);
        System.out.println("h\ti\tj\tdist\tr2\tDprime");
        int h = 1;
        while (center - h >= 0 && center + h < this.vcfEntries.size()) {
            int i = center - h;
            int j = center + h;
            VcfEntry ei = this.vcfEntries.get(i);
            VcfEntry ej = this.vcfEntries.get(j);
            vcfLd.ld(eCenter, ei);
            int dist = eCenter.getStart() - ei.getStart();
            if (vcfLd.getDprime() != Double.NaN) {
                System.out.println(h + "\t" + i + "\t" + j + "\t" + dist + "\t" + vcfLd.getrSquare() + "\t" + vcfLd.getDprime());
            }
            vcfLd.ld(eCenter, ej);
            dist = eCenter.getStart() - ej.getStart();
            if (vcfLd.getDprime() != Double.NaN) {
                System.out.println(h + "\t" + i + "\t" + j + "\t" + dist + "\t" + vcfLd.getrSquare() + "\t" + vcfLd.getDprime());
            }
            ++h;
        }
    }

    void readHapMapPhase(String hapMapFileName, String fastaFile) {
        Timer.showStdErr("Reading '" + hapMapFileName + "'");
        VcfHapMapFileIterator vhmFile = new VcfHapMapFileIterator(hapMapFileName, fastaFile, this.genome);
        this.vcfEntries = new HashMap();
        double minPhew = 0.1;
        VcfHwe vcfHwe = new VcfHwe();
        for (VcfEntry vcfEntry : vhmFile) {
            double p = vcfHwe.hwe(vcfEntry, true);
            if (p > minPhew) {
                this.vcfEntries.put(vcfEntry.getId(), vcfEntry);
                if (!verbose) continue;
                System.out.println("YES\t" + p + "\t" + vcfEntry);
                continue;
            }
            if (!verbose) continue;
            System.out.println("NO\t" + p + "\t" + vcfEntry);
        }
        Timer.showStdErr("Done: " + this.vcfEntries.size() + " entries added.");
    }

    void readVcf(String vcfFileName) {
        VcfFileIterator vcfFile = new VcfFileIterator(vcfFileName, this.genome);
        vcfFile.setCreateChromos(true);
        int entryNum = 0;
        this.vcfEntries = new HashMap();
        VcfHwe vcfHwe = new VcfHwe();
        for (VcfEntry vcfEntry : vcfFile) {
            double p = vcfHwe.hwe(vcfEntry, false);
            if (p > this.minPhew) {
                this.vcfEntries.put(vcfEntry.getId(), vcfEntry);
                System.out.println("YES\t" + entryNum + "\t" + p);
            } else {
                System.out.println("NO\t" + entryNum + "\t" + p);
            }
            ++entryNum;
        }
        System.out.println("Total added: " + this.vcfEntries.size());
    }

    void zzz(String hapMapFileName, String fastaFile, String chrName, String ldFile) {
        Chromosome chr = new Chromosome(this.genome, 0, 0, "22");
        this.genome.add(chr);
        this.readHapMapPhase(hapMapFileName, fastaFile);
        System.out.println(this.vcfEntries.get("rs9606669"));
        System.out.println(this.vcfEntries.get("rs5994258"));
        Timer.showStdErr("Reading LD file " + ldFile);
        VcfLd.debug = true;
        VcfLd vcfLd = new VcfLd();
        LineFileIterator lfi = new LineFileIterator(ldFile);
        for (String line : lfi) {
            try {
                String[] recs = line.split("\\s");
                int pos1 = Gpr.parseIntSafe(recs[0]);
                int pos2 = Gpr.parseIntSafe(recs[1]);
                String id1 = recs[3];
                String id2 = recs[4];
                double dPrime = Gpr.parseDoubleSafe(recs[5]);
                double rSquare = Gpr.parseDoubleSafe(recs[6]);
                if (!this.vcfEntries.containsKey(id1) || !this.vcfEntries.containsKey(id2)) continue;
                VcfEntry vcf1 = this.vcfEntries.get(id1);
                VcfEntry vcf2 = this.vcfEntries.get(id2);
                int delta1 = pos1 - 1 - vcf1.getStart();
                int delta2 = pos2 - 1 - vcf2.getStart();
                if (delta1 == 0 && delta2 == 0) {
                    vcfLd.ld(vcf1, vcf2);
                    System.out.println(id1 + "\t" + id2 + "\n\tD'   : " + dPrime + "\t" + vcfLd.getDprime() + "\t" + vcfLd.getD() + "\n\tr^2  : " + rSquare + "\t" + vcfLd.getrSquare());
                    continue;
                }
                System.out.println("ERROR:\t" + id1 + "\t" + id2 + "\tdeltas: " + delta1 + "\t" + delta2);
            }
            catch (Exception e) {
                System.err.println("Error parsing line " + line);
            }
        }
        Timer.showStdErr("Done.");
    }
}

