/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpSift.caseControl.VariantCounter;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ZzzAffectedSamples {
    public static final String VCF_INFO_FREQ_TYPE = "FREQ";
    public static final String VCF_INFO_FREQ_SINGLETON = "Singleton";
    public static final int MIN_NON_ZERO_COUNTS = 3;
    HashMap<String, VariantCounter> varCounters = new HashMap();
    List<String> sampleNames;

    public static void main(String[] args) {
        String vcfFileName = Gpr.HOME + "/fly_pvuseq/dnaSeq.eff.TET_EL.vcf";
        ZzzAffectedSamples zzz = new ZzzAffectedSamples();
        zzz.run(vcfFileName);
        zzz.showResults();
    }

    VariantCounter getVarCounter(String geneName, VcfEntry ve) {
        VariantCounter varCounter = this.varCounters.get(geneName);
        if (varCounter == null) {
            varCounter = new VariantCounter(ve.getVcfGenotypes().size());
            this.varCounters.put(geneName, varCounter);
        }
        return varCounter;
    }

    public void run(String vcfFileName) {
        Timer.showStdErr("Reading file " + vcfFileName);
        for (VcfEntry ve : new VcfFileIterator(vcfFileName)) {
            if (this.sampleNames == null) {
                this.sampleNames = ve.getVcfFileIterator().getVcfHeader().getSampleNames();
            }
            if (!ve.isSingleton()) continue;
            HashSet<String> genesCounted = new HashSet<String>();
            for (VcfEffect veff : ve.parseEffects()) {
                if (veff.getImpact() != VariantEffect.EffectImpact.HIGH && veff.getImpact() != VariantEffect.EffectImpact.MODERATE) continue;
                String geneName = ve.getChromosomeName() + "\t" + veff.getGeneName();
                VariantCounter variantCounter = this.getVarCounter(geneName, ve);
                if (!genesCounted.contains(geneName)) {
                    variantCounter.parseGenotypes(ve);
                    genesCounted.add(geneName);
                }
                variantCounter.addEffect(veff.toString());
            }
        }
        Timer.showStdErr("Done");
    }

    void showResults() {
        ArrayList<String> genes = new ArrayList<String>();
        genes.addAll(this.varCounters.keySet());
        Collections.sort(genes);
        System.out.print("Chromosome\tGeneName\tAffected samples");
        for (String sample : this.sampleNames) {
            System.out.print("\t" + sample);
        }
        System.out.println("\tEffects");
        for (String gene : genes) {
            VariantCounter vc = this.varCounters.get(gene);
            if (vc.countNonZeroGenotypes() <= 3) continue;
            System.out.println(gene + "\t" + vc);
        }
        System.out.println("Total\t" + genes.size());
    }
}

