/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Qseq2FastqSplit {
    public static final int SHOW_EVERY = 100000;
    FastqVariant fastqVariant = FastqVariant.FASTQ_ILLUMINA;
    Options options;
    String inPe1;
    String inPe2;
    String inIndex;
    String outBase;
    HashSet<String> seqs = new HashSet();
    HashMap<String, BufferedWriter> outsPe1 = new HashMap();
    HashMap<String, BufferedWriter> outsPe2 = new HashMap();

    public static void main(String[] args) {
        Qseq2FastqSplit qseq2FastqSplit = new Qseq2FastqSplit();
        qseq2FastqSplit.parseCmdLineOptions(args);
        qseq2FastqSplit.run();
    }

    void parseCmdLineOptions(String[] args) {
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withDescription((String)"Show this help message");
        Option help2 = OptionBuilder.create((String)"help");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Qseq file for pair end 1");
        Option inPe1Opt = OptionBuilder.create((String)"1");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Qseq file for pair end 2");
        Option inPe2Opt = OptionBuilder.create((String)"2");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Qseq index ");
        Option indexOpt = OptionBuilder.create((String)"i");
        OptionBuilder.withArgName((String)"seqs");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma separated list of sequences");
        Option seqsOpt = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"base");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Base name for output files");
        Option outOpt = OptionBuilder.create((String)"o");
        this.options = new Options();
        this.options.addOption(help2).addOption(inPe1Opt).addOption(inPe2Opt).addOption(indexOpt).addOption(seqsOpt).addOption(outOpt);
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(Qseq2FastqSplit.class.getSimpleName(), this.options);
                System.exit(-1);
            }
            if (line.hasOption("1")) {
                this.inPe1 = line.getOptionValue("1");
            } else {
                this.parsingError("Missing required parameter '-1'");
            }
            if (line.hasOption("2")) {
                this.inPe2 = line.getOptionValue("2");
            } else {
                this.parsingError("Missing required parameter '-2'");
            }
            if (line.hasOption("i")) {
                this.inIndex = line.getOptionValue("i");
            } else {
                this.parsingError("Missing required parameter '-i'");
            }
            if (line.hasOption("o")) {
                this.outBase = line.getOptionValue("o");
            } else {
                this.parsingError("Missing required parameter '-o'");
            }
            if (line.hasOption("s")) {
                String seqsStr = line.getOptionValue("s");
                for (String s : seqsStr.split(",")) {
                    this.seqs.add(s.toUpperCase());
                }
            } else {
                this.parsingError("Missing required parameter '-s'");
            }
        }
        catch (ParseException e) {
            this.parsingError(e.getMessage());
        }
    }

    void parsingError(String msg) {
        if (msg != null) {
            System.out.println("Error:" + msg);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Qseq2FastqSplit.class.getSimpleName(), this.options);
        System.exit(-1);
    }

    void run() {
        long countUnknown = 0L;
        long lineNum = 1L;
        Timer.showStdErr("Converting lines from QSEQ to FASTQ (Sanger)");
        try {
            BufferedReader inPe1Buff = new BufferedReader(new InputStreamReader(new FileInputStream(this.inPe1)));
            BufferedReader inPe2Buff = new BufferedReader(new InputStreamReader(new FileInputStream(this.inPe2)));
            BufferedReader indexBuff = new BufferedReader(new InputStreamReader(new FileInputStream(this.inIndex)));
            for (String seq2 : this.seqs) {
                String fileName = this.outBase + "_1_" + seq2 + ".fastq";
                BufferedWriter outBuff = new BufferedWriter(new FileWriter(fileName));
                this.outsPe1.put(seq2, outBuff);
                fileName = this.outBase + "_2_" + seq2 + ".fastq";
                outBuff = new BufferedWriter(new FileWriter(fileName));
                this.outsPe2.put(seq2, outBuff);
            }
            while (true) {
                String linePe2 = inPe2Buff.readLine();
                String lineIdx = indexBuff.readLine();
                String linePe1 = inPe1Buff.readLine();
                if (!(linePe1 != null & linePe2 != null & lineIdx != null)) break;
                String[] t = lineIdx.split("\t");
                String seqIdx = t[8].toUpperCase();
                if (this.seqs.contains(seqIdx)) {
                    this.writeFastq(linePe1, this.outsPe1.get(seqIdx), lineNum);
                    this.writeFastq(linePe2, this.outsPe2.get(seqIdx), lineNum);
                } else {
                    ++countUnknown;
                }
                if (lineNum % 100000L == 0L) {
                    Timer.showStdErr(lineNum + " lines, " + countUnknown + " unknown.");
                }
                ++lineNum;
            }
            for (String seq2 : this.seqs) {
                this.outsPe1.get(seq2).close();
                this.outsPe2.get(seq2).close();
            }
            inPe1Buff.close();
            inPe2Buff.close();
            indexBuff.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Timer.showStdErr(--lineNum + " lines, " + countUnknown + " unknown.");
    }

    void writeFastq(String qseqLine, BufferedWriter outBuff, long seqNum) throws IOException {
        String[] t = qseqLine.split("\t");
        outBuff.write("@seq_" + seqNum + "\n");
        outBuff.write(t[8] + "\n");
        outBuff.write("+\n");
        outBuff.write(GprSeq.changeQuality(t[9], this.fastqVariant, FastqVariant.FASTQ_SANGER) + "\n");
    }
}

