/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PromoterSequences {
    public static String HOME = System.getProperty("user.home");
    public static int LEN_UPSTREAM = 3000;
    public static int LEN_AFTER_TSS = 200;
    SnpEffectPredictor snpEffectPredictor;
    Config config;
    Genome genome;
    HashSet<String> geneIds;
    HashSet<Gene> genes;
    String fastaFile;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: " + PromoterSequences.class.getSimpleName() + " genomeName fastaFile.fa geneId_1 geneId_2 ... geneId_N");
            System.exit(1);
        }
        String genomeName = args[0];
        String fastaFile = args[1];
        ArrayList<String> geneIds = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            geneIds.add(args[i]);
        }
        PromoterSequences promoterSequences = new PromoterSequences(genomeName, fastaFile, geneIds);
        promoterSequences.run();
    }

    public PromoterSequences(String genomeName, String fastaFile, List<String> geneIds) {
        this.fastaFile = fastaFile;
        this.geneIds = new HashSet();
        this.geneIds.addAll(geneIds);
        this.genes = new HashSet();
        Timer.showStdErr("Loading database");
        String configFile = HOME + "/snpEff/snpEff.config";
        this.config = new Config(genomeName, configFile);
        this.config.loadSnpEffectPredictor();
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        this.genome = this.snpEffectPredictor.getGenome();
    }

    public void run() {
        Timer.showStdErr("Finding genes ");
        for (Gene gene : this.genome.getGenes()) {
            if (!this.geneIds.contains(gene.getId())) continue;
            System.err.println("\t" + gene.getId());
            this.genes.add(gene);
            this.geneIds.remove(gene.getId());
        }
        if (!this.geneIds.isEmpty()) {
            Timer.showStdErr("Not found: " + this.geneIds);
        }
        Timer.showStdErr("Reading fasta file: " + this.fastaFile);
        HashSet<Gene> done = new HashSet<Gene>();
        FastaFileIterator ffi = new FastaFileIterator(this.fastaFile);
        block1: for (String seq2 : ffi) {
            String chrName = ffi.getName();
            Timer.showStdErr("Read: " + chrName);
            for (Gene gene : this.genes) {
                if (gene.getChromosomeName().equals(chrName)) {
                    int start = 0;
                    int end = 0;
                    if (gene.isStrandPlus()) {
                        start = gene.getStart() - LEN_UPSTREAM;
                        end = gene.getStart() + LEN_AFTER_TSS;
                    } else {
                        start = gene.getEnd() - LEN_AFTER_TSS;
                        end = gene.getEnd() + LEN_UPSTREAM;
                    }
                    String subSeq = seq2.substring(start, end + 1);
                    System.out.println(GprSeq.string2fasta(gene.getId(), subSeq));
                    done.add(gene);
                }
                if (!done.containsAll(this.genes)) continue;
                continue block1;
            }
        }
        ffi.close();
        Timer.showStdErr("Done");
    }
}

