/*
 * Decompiled with CFR 0.152.
 */
package akka.jsr166y;

import akka.jsr166y.ForkJoinPool;

public class ForkJoinWorkerThread
extends Thread {
    final ForkJoinPool.WorkQueue workQueue;
    final ForkJoinPool pool;

    protected ForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
        super(forkJoinPool.nextWorkerName());
        this.setDaemon(true);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = forkJoinPool.ueh;
        if (uncaughtExceptionHandler != null) {
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        this.pool = forkJoinPool;
        this.workQueue = new ForkJoinPool.WorkQueue(forkJoinPool, this, forkJoinPool.localMode);
        forkJoinPool.registerWorker(this.workQueue);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.workQueue.poolIndex;
    }

    protected void onStart() {
    }

    protected void onTermination(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable throwable = null;
        try {
            this.onStart();
            this.pool.runWorker(this.workQueue);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            try {
                this.onTermination(throwable);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                }
            }
            finally {
                this.pool.deregisterWorker(this, throwable);
            }
        }
    }
}

