/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.gaf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PreDestroy;
import org.molgenis.file.FileStore;
import org.molgenis.gaf.GafListValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Scope(value="session")
public class GafListValidationReport {
    private static final Logger LOG = LoggerFactory.getLogger(GafListValidationReport.class);
    private final Map<String, List<GafListValidationError>> validationErrorsPerRunId;
    private final List<String> validationGlobalErrorMessages;
    private final List<String> validRunIds = new ArrayList();
    private final List<String> invalidRunIds = new ArrayList();
    private List<String> allRunIds = new ArrayList();
    private String dataSetName = null;
    private String dataSetIdentifier = null;
    private File tempFile;
    private String tempFileName;
    private String tempFileOriginalName;
    @Autowired
    FileStore fileStore;

    public GafListValidationReport() {
        this.validationErrorsPerRunId = new LinkedHashMap();
        this.validationGlobalErrorMessages = new ArrayList();
    }

    public void addEntry(String runId, GafListValidationError validationError) {
        ArrayList<GafListValidationError> gafListValidationErrorList = (ArrayList<GafListValidationError>)this.validationErrorsPerRunId.get(runId);
        if (gafListValidationErrorList == null) {
            gafListValidationErrorList = new ArrayList<GafListValidationError>();
            this.validationErrorsPerRunId.put(runId, gafListValidationErrorList);
        }
        gafListValidationErrorList.add(validationError);
        Collections.sort(gafListValidationErrorList);
    }

    public void addGlobalErrorMessage(String globalErrorMessage) {
        this.validationGlobalErrorMessages.add(globalErrorMessage);
    }

    public Map<String, List<GafListValidationError>> getEntries() {
        return Collections.unmodifiableMap(this.validationErrorsPerRunId);
    }

    public boolean hasRunIdsErrors() {
        return !this.validationErrorsPerRunId.isEmpty();
    }

    public boolean hasGlobalErrors() {
        return !this.validationGlobalErrorMessages.isEmpty();
    }

    public boolean hasErrors(String runId) {
        return this.validationErrorsPerRunId.containsKey(runId);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (String string : this.validationGlobalErrorMessages) {
            strBuilder.append('\t').append(string).append('\n');
        }
        for (Map.Entry entry : this.validationErrorsPerRunId.entrySet()) {
            String runId = (String)entry.getKey();
            if (runId == null) {
                runId = "<undefined>";
            }
            strBuilder.append("Validation errors for run ").append(runId).append('\n');
            for (GafListValidationError validationError : (List)entry.getValue()) {
                strBuilder.append('\t').append(validationError).append('\n');
            }
        }
        return strBuilder.toString();
    }

    public String toStringHtml() {
        StringBuilder strBuilder = new StringBuilder();
        for (Map.Entry reportEntry : this.validationErrorsPerRunId.entrySet()) {
            String runId = (String)reportEntry.getKey();
            if (runId == null) {
                runId = "NO RUN ID!";
            }
            strBuilder.append("Run: ").append(runId).append('\n');
            strBuilder.append("<div class=\"molgenis-table-container\" id=\"table-container\">").append('\n');
            strBuilder.append("<table class=\"table molgenis-table table-striped table-bordered table-hover table-condensed listtable\">").append('\n');
            strBuilder.append("<thead><tr><th>Row</th><th>Column</th><th>Value</th><th>Message</th></tr></thead>").append('\n').append("<tbody>");
            for (GafListValidationError validationError : (List)reportEntry.getValue()) {
                strBuilder.append(validationError.toStringHtml()).append('\n');
            }
            strBuilder.append("</tbody>");
            strBuilder.append("</table>").append('\n');
            strBuilder.append("</div>").append('\n');
        }
        return strBuilder.toString();
    }

    public List<String> getAllRunIds() {
        return this.allRunIds;
    }

    public List<String> getValidRunIds() {
        return this.validRunIds;
    }

    public List<String> getInvalidRunIds() {
        return this.invalidRunIds;
    }

    public void populateStatusImportedRuns() {
        for (String runId : this.allRunIds) {
            if (this.hasErrors(runId)) {
                if (this.invalidRunIds.contains(runId)) continue;
                this.invalidRunIds.add(runId);
                continue;
            }
            if (this.validRunIds.contains(runId)) continue;
            this.validRunIds.add(runId);
        }
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public String getTempFileName() {
        return this.tempFileName;
    }

    protected void setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public String getTempFileOriginalName() {
        return this.tempFileOriginalName;
    }

    protected void setTempFileOriginalName(String tempFileOriginalName) {
        this.tempFileOriginalName = tempFileOriginalName;
    }

    @PreDestroy
    public void cleanUp() throws Exception {
        boolean deleted;
        String fileName = this.getTempFileName();
        if (null != fileName && !(deleted = this.fileStore.delete(fileName))) {
            LOG.error("File " + this.getTempFileName() + " cannot be deleted from filestore!");
        }
        this.validationErrorsPerRunId.clear();
        this.validationGlobalErrorMessages.clear();
        this.validRunIds.clear();
        this.invalidRunIds.clear();
        this.allRunIds.clear();
        this.dataSetName = null;
        this.dataSetIdentifier = null;
        this.tempFile = null;
        this.tempFileName = null;
        this.tempFileOriginalName = null;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    protected void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public void uploadCsvFile(MultipartFile csvFile) throws Exception {
        this.cleanUp();
        String fileName = UUID.randomUUID().toString().toLowerCase() + csvFile.getOriginalFilename();
        File tmpFile = this.fileStore.store(csvFile.getInputStream(), fileName);
        this.setTempFileName(tmpFile.getName());
        this.setTempFileOriginalName(csvFile.getOriginalFilename());
        this.setTempFile(tmpFile);
    }

    public String getDataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public void setDataSetIdentifier(String dataSetIdentifier) {
        this.dataSetIdentifier = dataSetIdentifier;
    }

    public List<String> getValidationGlobalErrorMessages() {
        return this.validationGlobalErrorMessages;
    }
}

