webpackJsonp([1],{

/***/ 0:
/*!***********************!*\
  !*** multi global-ui ***!
  \***********************/
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(/*! ./src/main/javascript/molgenis-global-ui-webpack */274);


/***/ },

/***/ 6:
/*!***********************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/DeepPureRenderMixin.js ***!
  \***********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * Only render components if their state or props changed
	 *
	 * @memberOf component.mixin
	 */
	var DeepPureRenderMixin = {
	    shouldComponentUpdate: function shouldComponentUpdate(nextProps, nextState) {
	        return !_underscore2.default.isEqual(this.state, nextState) || !_underscore2.default.isEqual(this.props, nextProps);
	    }
	};
	
	exports.default = DeepPureRenderMixin;

/***/ },

/***/ 12:
/*!*****************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Spinner.js ***!
  \*****************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Spinner = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    img = _react2.default.DOM.img;
	
	/**
	 * @memberOf component
	 */
	var Spinner = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Spinner',
		render: function render() {
			return div(null, img({ src: __webpack_require__(/*! ./css/wrapper/select2-spinner.gif */ 29), alt: 'Spinner', width: 16, height: 16 }));
		}
	});
	
	exports.Spinner = Spinner;
	exports.default = _react2.default.createFactory(Spinner);

/***/ },

/***/ 16:
/*!****************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Button.js ***!
  \****************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Button = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Icon = __webpack_require__(/*! ./Icon */ 48);
	
	var _Icon2 = _interopRequireDefault(_Icon);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var button = _react2.default.DOM.button,
	    a = _react2.default.DOM.a;
	
	/**
	 * @memberOf component
	 */
	var Button = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Button',
		propTypes: {
			id: _react2.default.PropTypes.string,
			type: _react2.default.PropTypes.oneOf(['button', 'submit', 'reset']),
			style: _react2.default.PropTypes.oneOf(['default', 'primary', 'success', 'info', 'warning', 'danger', 'link']),
			size: _react2.default.PropTypes.oneOf(['xsmall', 'small', 'medium', 'large']),
			text: _react2.default.PropTypes.string,
			icon: _react2.default.PropTypes.string,
			css: _react2.default.PropTypes.object,
			name: _react2.default.PropTypes.string,
			title: _react2.default.PropTypes.string,
			value: _react2.default.PropTypes.string,
			disabled: _react2.default.PropTypes.bool,
			onClick: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				type: 'button',
				style: 'default',
				size: 'medium'
			};
		},
		render: function render() {
			var buttonClasses = 'btn btn-' + this.props.style;
			switch (this.props.size) {
				case 'xsmall':
					buttonClasses += ' btn-xs';
					break;
				case 'small':
					buttonClasses += ' btn-sm';
					break;
				case 'medium':
					break;
				case 'large':
					buttonClasses += ' btn-lg';
					break;
				default:
					throw 'Unknown Button style [' + this.props.style + ']';
			}
	
			if (this.props.style !== 'link') {
				var buttonProps = {
					className: buttonClasses,
					id: this.props.id,
					type: this.props.type,
					name: this.props.name,
					style: this.props.css,
					disabled: this.props.disabled,
					title: this.props.title,
					value: this.props.value,
					onClick: this.props.onClick
				};
	
				return button(buttonProps, this.props.icon ? (0, _Icon2.default)({ name: this.props.icon }) : null, this.props.text ? this.props.icon ? ' ' + this.props.text : this.props.text : null);
			} else {
				if (this.props.disabled) {
					buttonClasses += ' disabled';
				}
				var anchorProps = {
					className: buttonClasses,
					href: '#',
					role: 'button',
					id: this.props.id,
					name: this.props.name,
					style: this.props.css,
					value: this.props.value,
					onClick: this.props.onClick
				};
	
				return a(anchorProps, this.props.icon ? (0, _Icon2.default)({ name: this.props.icon }) : null, this.props.text ? this.props.icon ? ' ' + this.props.text : this.props.text : null);
			}
		}
	});
	
	exports.Button = Button;
	exports.default = _react2.default.createFactory(Button);

/***/ },

/***/ 39:
/*!***************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Modal.js ***!
  \***************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.Modal = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    button = _react2.default.DOM.button,
	    span = _react2.default.DOM.span,
	    h4 = _react2.default.DOM.h4;
	
	/**
	    * @memberOf component
	    */
	var Modal = _react2.default.createClass({
	  mixins: [_DeepPureRenderMixin2.default],
	  displayName: 'Modal',
	  propTypes: {
	    title: _react2.default.PropTypes.string.isRequired,
	    size: _react2.default.PropTypes.oneOf(['small', 'medium', 'large']),
	    show: _react2.default.PropTypes.bool,
	    onHide: _react2.default.PropTypes.func,
	    footer: _react2.default.PropTypes.bool
	  },
	  getDefaultProps: function getDefaultProps() {
	    return {
	      size: 'medium',
	      show: false,
	      onHide: function onHide() {}
	    };
	  },
	  componentDidMount: function componentDidMount() {
	    var $modal = (0, _jquery2.default)(this.refs.modal.getDOMNode());
	    $modal.on('hide.bs.modal', function () {
	      this.props.onHide();
	    }.bind(this));
	    this._initModal();
	  },
	  componentWillUnmount: function componentWillUnmount() {
	    var $modal = (0, _jquery2.default)(this.refs.modal.getDOMNode());
	    $modal.modal('hide'); // remove modal backdrop
	    $modal.off();
	    $modal.data('bs.modal', null); // see http://stackoverflow.com/a/18169689
	  },
	  render: function render() {
	    var modalDialogClasses = _react2.default.addons.classSet({
	      'modal-dialog': true,
	      'modal-sm': this.props.size == 'small',
	      'modal-lg': this.props.size == 'large'
	    });
	    var id = 'modal-title-' + new Date().getTime();
	    return div({ className: 'modal', tabIndex: -1, role: 'dialog', 'aria-labelledby': id, ref: 'modal' }, div({ className: modalDialogClasses }, div({ className: 'modal-content' }, div({ className: 'modal-header' }, button({ type: 'button', className: 'close', 'data-dismiss': 'modal', 'aria-label': 'Close' }, span({ 'aria-hidden': true }, String.fromCharCode(215)) // &times;
	    ), h4({ className: 'modal-title', id: id }, this.props.title)), div({ className: 'modal-body' }, this.props.show ? this.props.children : null), this.props.footer && _react2.default.createElement(
	      "div",
	      { className: "modal-footer" },
	      _react2.default.createElement(
	        "button",
	        { type: "button", className: "btn btn-primary",
	          "data-dismiss": "modal" },
	        "Close"
	      )
	    ))));
	  },
	  componentDidUpdate: function componentDidUpdate() {
	    if (this.isMounted()) {
	      this._initModal();
	    }
	  },
	  _initModal: function _initModal() {
	    var $modal = (0, _jquery2.default)(this.refs.modal.getDOMNode());
	    if (this.props.show) {
	      $modal.modal('show');
	    } else {
	      $modal.modal('hide');
	    }
	  }
	});
	
	exports.Modal = Modal;
	exports.default = _react2.default.createFactory(Modal);

/***/ },

/***/ 40:
/*!******************************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/ReactLayeredComponentMixin.js ***!
  \******************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * See http://stackoverflow.com/a/26789089
	 * 
	 * @memberOf component.mixin
	 */
	var ReactLayeredComponentMixin = {
		componentWillUnmount: function componentWillUnmount() {
			this._unrenderLayer();
			document.body.removeChild(this._target);
		},
		componentDidUpdate: function componentDidUpdate() {
			this._renderLayer();
		},
		componentDidMount: function componentDidMount() {
			// Appending to the body is easier than managing the z-index of everything on the page.
			// It's also better for accessibility and makes stacking a snap (since components will stack
			// in mount order).
			this._target = document.createElement('div');
			document.body.appendChild(this._target);
			this._renderLayer();
		},
		_renderLayer: function _renderLayer() {
			// By calling this method in componentDidMount() and componentDidUpdate(), you're effectively
			// creating a "wormhole" that funnels React's hierarchical updates through to a DOM node on an
			// entirely different part of the page.
			var Element = this.renderLayer();
			if (Element === null) {
				Element = _react2.default.DOM.span();
			}
			_react2.default.render(Element, this._target);
		},
		_unrenderLayer: function _unrenderLayer() {
			_react2.default.unmountComponentAtNode(this._target);
		}
	};
	
	exports.default = ReactLayeredComponentMixin;

/***/ },

/***/ 47:
/*!**************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Form.js ***!
  \**************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _EntityLoaderMixin = __webpack_require__(/*! ./mixin/EntityLoaderMixin */ 52);
	
	var _EntityLoaderMixin2 = _interopRequireDefault(_EntityLoaderMixin);
	
	var _EntityInstanceLoaderMixin = __webpack_require__(/*! ./mixin/EntityInstanceLoaderMixin */ 69);
	
	var _EntityInstanceLoaderMixin2 = _interopRequireDefault(_EntityInstanceLoaderMixin);
	
	var _ReactLayeredComponentMixin = __webpack_require__(/*! ./mixin/ReactLayeredComponentMixin */ 40);
	
	var _ReactLayeredComponentMixin2 = _interopRequireDefault(_ReactLayeredComponentMixin);
	
	var _Modal = __webpack_require__(/*! ./Modal */ 39);
	
	var _Modal2 = _interopRequireDefault(_Modal);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _JQueryForm = __webpack_require__(/*! ./wrapper/JQueryForm */ 119);
	
	var _JQueryForm2 = _interopRequireDefault(_JQueryForm);
	
	var _AlertMessage = __webpack_require__(/*! ./AlertMessage */ 63);
	
	var _AlertMessage2 = _interopRequireDefault(_AlertMessage);
	
	var _promise = __webpack_require__(/*! promise */ 219);
	
	var _promise2 = _interopRequireDefault(_promise);
	
	var _FormControlGroup = __webpack_require__(/*! ./FormControlGroup */ 107);
	
	var _FormControlGroup2 = _interopRequireDefault(_FormControlGroup);
	
	var _FormControl = __webpack_require__(/*! ./FormControl */ 66);
	
	var _FormControl2 = _interopRequireDefault(_FormControl);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    span = _react2.default.DOM.span,
	    ol = _react2.default.DOM.ol,
	    li = _react2.default.DOM.li,
	    a = _react2.default.DOM.a;
	var api = new _RestClientV2.default();
	
	/**
	 * @memberOf component
	 */
	var Form = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _EntityLoaderMixin2.default, _EntityInstanceLoaderMixin2.default, _ReactLayeredComponentMixin2.default],
		displayName: 'Form',
		propTypes: {
			entity: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.object]).isRequired,
			entityInstance: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number, _react2.default.PropTypes.object]),
			mode: _react2.default.PropTypes.oneOf(['create', 'edit', 'view']),
			formLayout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
			modal: _react2.default.PropTypes.bool, // whether or not to render form in a modal dialog
			enableOptionalFilter: _react2.default.PropTypes.bool, // whether or not to show a control to filter optional form fields
			saveOnBlur: _react2.default.PropTypes.bool, // save form control values on blur
			enableFormIndex: _react2.default.PropTypes.bool, // whether or not to show a form index to navigate to form controls
			enableAlertMessageInFormIndex: _react2.default.PropTypes.bool, // whether or not to show a alert messages above the index to navigate to form controls. (Only works if the enableFormIndex prop is set to true)
			showHidden: _react2.default.PropTypes.bool, // whether or not to show not-visible attributes
			categoricalMrefShowSelectAll: _react2.default.PropTypes.bool, //whether to show 'select all' and 'hide all' links under the categorical mref checkboxes
			showAsteriskIfNotNillable: _react2.default.PropTypes.bool, //whether to show a '*' after the label when an attribute is not nillable
			beforeSubmit: _react2.default.PropTypes.func,
			onSubmitCancel: _react2.default.PropTypes.func,
			onSubmitSuccess: _react2.default.PropTypes.func,
			onSubmitError: _react2.default.PropTypes.func,
			onValueChange: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				mode: 'create',
				formLayout: 'horizontal',
				modal: false,
				enableOptionalFilter: true,
				enableFormIndex: true,
				enableAlertMessageInFormIndex: false,
				colOffset: 3,
				saveOnBlur: false,
				showHidden: false,
				categoricalMrefShowSelectAll: true,
				showAsteriskIfNotNillable: true,
				beforeSubmit: function beforeSubmit() {},
				onSubmitCancel: function onSubmitCancel() {},
				onSubmitSuccess: function onSubmitSuccess() {},
				onSubmitError: function onSubmitError() {},
				onValueChange: function onValueChange() {}
			};
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			var entity = this.props.entity;
			var entityInstance = this.props.entityInstance;
			var resetProps = false;
	
			// Check if the entity meta data is changed.
			// Check if the entity instance is changed.
			if (typeof entity === "string" && nextProps.entity !== entity) {
				resetProps = true;
			} else if ((typeof entity === "undefined" ? "undefined" : _typeof(entity)) === "object" && nextProps.entity.name !== entity.name) {
				resetProps = true;
			} else if (typeof entityInstance === "string" && nextProps.entityInstance !== entityInstance) {
				resetProps = true;
			} else if (typeof entityInstance === "number" && nextProps.entityInstance !== entityInstance) {
				resetProps = true;
			} else if ((typeof entityInstance === "undefined" ? "undefined" : _typeof(entityInstance)) === "object" && nextProps.entityInstance.id !== entityInstance.id) {
				resetProps = true;
			}
	
			if (resetProps) {
				var resetState = {
					errorMessages: {},
					validate: false,
					showModal: true,
					submitMsg: null
				};
	
				// Reset state form component
				this.setState(resetState);
			}
		},
		getInitialState: function getInitialState() {
			return {
				entity: null, // transfered from props to state, loaded from server if required
				entityInstance: null, // transfered from props to state, loaded from server if required
				errorMessages: {},
				validate: false,
				showModal: true,
				hideOptional: false
			};
		},
		_setDefaultValue: function _setDefaultValue(attr, entityInstance) {
			try {
				switch (attr.fieldType) {
					case 'BOOL':
						entityInstance[attr.name] = attr.defaultValue.toLowerCase() === 'true';
						break;
					case 'INT':
					case 'LONG':
						entityInstance[attr.name] = parseInt(attr.defaultValue);
						break;
					case 'DECIMAL':
						entityInstance[attr.name] = parseFloat(attr.defaultValue);
						break;
					case 'DATE':
						entityInstance[attr.name] = attr.defaultValue.substring(0, 10);
						break;
					case 'XREF':
					case 'CATEGORICAL':
						var value = {
							href: attr.refEntity.hrefCollection + '/' + attr.defaultValue
						};
						// TODO: both name and value for the label attribute are missing!
						value[attr.refEntity.idAttribute] = attr.defaultValue;
						entityInstance[attr.name] = value;
						break;
					case 'MREF':
					case 'CATEGORICAL_MREF':
						entityInstance[attr.name] = {
							href: attr.refEntity.hrefCollection,
							items: attr.defaultValue.split(',').map(function (idValue) {
								var value = {};
								// TODO: both name and value for the label attribute are missing!
								value[attr.refEntity.idAttribute] = idValue;
								return value;
							})
						};
						break;
					case 'COMPOUND':
						// makes no sense to have a defaultValue for a compound
						break;
					default:
						entityInstance[attr.name] = attr.defaultValue;
						break;
				}
			} catch (exception) {
				console.log("Failed to set default value for attr " + attr.name, exception);
			}
		},
		_willSetEntityInstance: function _willSetEntityInstance(entity, entityInstance) {
			_underscore2.default.each(entity.allAttributes, function (attr) {
				if (attr.visibleExpression) {
					attr.visible = this._resolveBoolExpression(attr.visibleExpression, entityInstance);
				}
				if (attr.defaultValue && this.props.mode == 'create') {
					this._setDefaultValue(attr, entityInstance);
				}
			}, this);
		},
		render: function render() {
			// render form in component container
			return this.props.modal ? span() : this._render();
		},
		renderLayer: function renderLayer() {
			// render form in modal dialog
			return this.props.modal ? this._render() : span();
		},
		_render: function _render() {
			var Form = this._renderForm();
	
			if (this.props.modal === true) {
				// determine modal title based on form mode
				var title;
				if (this.state.entity !== null) {
					switch (this.props.mode) {
						case 'create':
							title = 'Create ' + this.state.entity.label;
							break;
						case 'edit':
							title = 'Edit ' + this.state.entity.label;
							break;
						case 'view':
							title = 'View' + this.state.entity.label;
							break;
						default:
							throw 'unknown mode [' + this.props.mode + ']';
					}
				} else {
					title = '';
				}
	
				return (0, _Modal2.default)({ title: title, size: 'large', show: this.state.showModal, onHide: this._handleCancel }, Form);
			} else {
				return Form;
			}
		},
		_renderForm: function _renderForm() {
			// return empty div if entity data is not yet available
			if (this.state.entity === null) {
				return (0, _Spinner2.default)();
			}
			// return empty div if entity value is not yet available
			if ((this.props.mode === 'edit' || this.props.mode === 'view') && this.state.entityInstance === null) {
				return (0, _Spinner2.default)();
			}
	
			var action, method;
			switch (this.props.mode) {
				case 'create':
					action = this.state.entity.hrefCollection;
					method = 'post';
					break;
				case 'edit':
					action = this.state.entityInstance.href + '?_method=PUT';
					method = 'post';
					break;
				case 'view':
					action = undefined;
					method = undefined;
					break;
				default:
					throw 'unknown mode [' + this.props.mode + ']';
			}
	
			var formProps = {
				className: this.props.formLayout === 'horizontal' ? 'form-horizontal' : undefined,
				action: action,
				method: method,
				encType: 'application/x-www-form-urlencoded', // TODO use multipart/form-data if form contains one or more file inputs
				noValidate: true,
				beforeSubmit: this.props.beforeSubmit,
				success: this._handleSubmitSuccess,
				error: this._handleSubmitError,
				key: 'form'
			};
	
			var formControlsProps = {
				entity: this.state.entity,
				value: this.state.entityInstance, // FIXME replace value with entity instance
				mode: this.props.mode,
				formLayout: this.props.formLayout,
				colOffset: this.props.colOffset,
				hideOptional: this.state.hideOptional,
				showHidden: this.props.showHidden,
				enableFormIndex: this.props.enableFormIndex,
				enableAlertMessageInFormIndex: this.props.enableAlertMessageInFormIndex,
				categoricalMrefShowSelectAll: this.props.categoricalMrefShowSelectAll,
				showAsteriskIfNotNillable: this.props.showAsteriskIfNotNillable,
				onValueChange: this._handleValueChange,
				onBlur: this._handleBlur,
				errorMessages: this.state.errorMessages
			};
	
			var Filter = this.props.enableOptionalFilter ? div({ className: 'row', style: { textAlign: 'right' }, key: 'filter' }, div({ className: 'col-md-12' }, (0, _Button2.default)({
				icon: this.state.hideOptional ? 'eye-open' : 'eye-close',
				title: this.state.hideOptional ? 'Show all fields' : 'Hide optional fields',
				size: 'xsmall',
				css: {
					marginBottom: 15,
					textAlign: 'right'
				},
				onClick: this._handleOptionalFilterClick
			}))) : null;
	
			//TODO: Rename; this shadows the Form class!
			var Form = (0, _JQueryForm2.default)(formProps, FormControlsFactory(formControlsProps), this.props.mode !== 'view' && !(this.props.mode === 'edit' && this.props.saveOnBlur) ? FormButtonsFactory({
				mode: this.props.mode,
				formLayout: this.props.formLayout,
				colOffset: this.props.colOffset,
				cancelBtn: this.props.modal === true,
				onCancelClick: this.props.modal === true ? this._handleCancel : undefined,
				onSubmitClick: this.submit
			}) : null, this.props.children);
	
			var SubmitAlertMessage = this.state.submitMsg ? (0, _AlertMessage2.default)({ type: this.state.submitMsg.type, message: this.state.submitMsg.message, onDismiss: this._handleAlertMessageDismiss, key: 'alert' }) : null;
	
			var ErrorMessageAlertMessage = !_jquery2.default.isEmptyObject(this.state.errorMessages) ? (0, _AlertMessage2.default)({ type: 'danger', message: 'Validation failed', onDismiss: undefined, key: 'alert' }) : null;
	
			var FormWithMessageAndFilter;
	
			if (this.props.enableFormIndex) {
				FormWithMessageAndFilter = div(null, this.props.enableAlertMessageInFormIndex ? null : ErrorMessageAlertMessage, this.props.enableAlertMessageInFormIndex ? null : SubmitAlertMessage, Filter, Form);
				return div({ className: 'row' }, div({ className: 'col-md-10' }, FormWithMessageAndFilter), div({ className: 'col-md-2' }, FormIndexFactory({
					entity: this.state.entity,
					errorMessageAlertMessage: this.props.enableAlertMessageInFormIndex ? ErrorMessageAlertMessage : null,
					submitAlertMessage: this.props.enableAlertMessageInFormIndex ? SubmitAlertMessage : null
				})));
			} else {
				FormWithMessageAndFilter = div(null, ErrorMessageAlertMessage, SubmitAlertMessage, Filter, Form);
				return FormWithMessageAndFilter;
			}
		},
		_handleBlur: function _handleBlur(e) {
			var attr = e.attr;
			var value = e.value;
	
			this._validate(attr, this._getValue(this.state.entityInstance, attr), function (validationResult) {
				if (validationResult.valid === true && this._doPersistAttributeValue(attr)) {
					this._persistAttributeValue(attr, value);
				}
	
				this.setState({
					errorMessages: this._updateErrorMessages(attr, validationResult)
				});
			}.bind(this));
		},
		_doPersistAttributeValue: function _doPersistAttributeValue(attr) {
			return this.props.mode === 'edit' && this.props.saveOnBlur && !attr.readOnly;
		},
		_persistAttributeValue: function _persistAttributeValue(attr, value) {
			// persist attribute
			var val;
			switch (attr.fieldType) {
				case 'CATEGORICAL':
				case 'XREF':
					val = value !== null && value !== undefined ? value[attr.refEntity.idAttribute] : null;
					break;
				case 'CATEGORICAL_MREF':
				case 'MREF':
					val = _underscore2.default.map(value.items, function (item) {
						return item[attr.refEntity.idAttribute];
					});
					break;
				default:
					val = value;
					break;
			}
	
			api.update(this.state.entityInstance.href + '/' + attr.name, val, {}, false);
		},
		_handleValueChange: function _handleValueChange(e) {
			var self = this;
			if (!self.valueChangeTimers) self.valueChangeTimers = [];
	
			if (self.valueChangeTimers[e.attr]) {
				clearTimeout(self.valueChangeTimers[e.attr]);
			}
			self.valueChangeTimers[e.attr] = setTimeout(function () {
				self._doHandleValueChange(e);
			}, 300);
		},
		_doHandleValueChange: function _doHandleValueChange(e) {
			var attribute = this.state.entity.allAttributes[e.attr];
			if (attribute === undefined) return; //compound
	
			// update value in entity instance
			var value = e.value;
			var entityInstance = _underscore2.default.extend({}, this.state.entityInstance);
			entityInstance[e.attr] = value;
			var attr = this.state.entity.allAttributes[e.attr];
	
			//Validate new value
			this._validate(attr, value, function (validationResult) {
	
				if (validationResult.valid === true) {
					// Resolve visible expressions
					_underscore2.default.each(this.state.entity.allAttributes, function (entityAttr) {
						if (entityAttr.visibleExpression) {
							entityAttr.visible = this._resolveBoolExpression(entityAttr.visibleExpression, entityInstance);
							if (entityAttr.visible === false) {
								this._updateErrorMessages(entityAttr, { valid: true });
							}
						}
					}, this);
				}
	
				this.setState({
					entityInstance: entityInstance,
					errorMessages: this._updateErrorMessages(attr, validationResult)
				});
	
				if (validationResult.valid) {
					this.props.onValueChange(e);
				}
	
				if (validationResult.valid === true && this._doPersistAttributeValue(attr)) {
					// persist changes for controls that do not have a blur event
					switch (attr.fieldType) {
						case 'BOOL':
						case 'CATEGORICAL':
						case 'CATEGORICAL_MREF':
						case 'ENUM':
						case 'MREF':
						case 'XREF':
						case 'DATE':
						case 'DATE_TIME':
							this._persistAttributeValue(attr, value);
							break;
						default:
							break;
					}
				}
	
				clearTimeout(this.valueChangeTimers[e.attr]);
			}.bind(this));
		},
		submit: function submit(e) {
			// determine if form is valid
			var errorMessages = {};
			var promises = [];
			var target = e.target;
	
			_underscore2.default.each(this.state.entity.allAttributes, function (attr) {
				if (attr.visible === true && attr.fieldType !== 'COMPOUND') {
	
					var p = new _promise2.default(function (resolve, reject) {
						this._validate(attr, this._getValue(this.state.entityInstance, attr), function (validationResult) {
							if (validationResult.valid === false) {
								errorMessages[attr.name] = validationResult.errorMessage;
							}
							resolve(validationResult.valid);
						}.bind(this));
					}.bind(this));
	
					promises.push(p);
				}
			}, this);
	
			_promise2.default.all(promises).done(function (results) {
				var valid = true;
				for (var i = 0; i < results.length && valid; i++) {
					valid = valid && results[i];
				}
	
				if (valid) {
					(0, _jquery2.default)(target).closest('form').submit(); //TODO remove jquery form submit workaround, see also componentDidMount in JQueryForm.js
				} else {
						this.setState({ errorMessages: errorMessages });
					}
			}.bind(this));
		},
		_handleCancel: function _handleCancel() {
			if (this.props.modal) {
				this.setState({ showModal: false });
			}
			this.props.onSubmitCancel();
		},
		_handleSubmitSuccess: function _handleSubmitSuccess(responseText, statusText, xhr, element) {
			var message = this.props.mode === 'create' ? 'has been created.' : 'changes have been saved.';
			var stateProps = {
				submitMsg: { type: 'success', message: this.state.entity.label + ' ' + message },
				errorMessages: {},
				validate: false
			};
			if (this.props.modal) {
				_underscore2.default.extend(stateProps, {
					showModal: false
				});
			}
			if (this.props.mode === 'create') {
				// clear form to create new entity
				_underscore2.default.extend(stateProps, {
					entityInstance: {}
				});
			}
			this.setState(stateProps);
	
			if (!this.props.modal) {
				window.scrollTo(0, 0);
			}
	
			var e = {};
			if (this.props.mode === 'create') {
				e.location = xhr.getResponseHeader('Location');
			}
			this.props.onSubmitSuccess(e);
		},
		_handleSubmitError: function _handleSubmitError(e) {
			var message = this.props.mode === 'create' ? 'could not be created.' : 'changes could not be saved.';
			if (e.responseJSON && e.responseJSON.errors && e.responseJSON.errors.length > 0 && e.responseJSON.errors[0].message) {
				message += ' ' + e.responseJSON.errors[0].message;
			}
			this.setState({
				submitMsg: { type: 'danger', message: this.state.entity.label + ' ' + message }
			});
	
			if (!this.props.modal) {
				window.scrollTo(0, 0);
			}
	
			this.props.onSubmitError();
		},
		_handleAlertMessageDismiss: function _handleAlertMessageDismiss() {
			this.setState({
				submitMsg: undefined
			});
		},
		_handleOptionalFilterClick: function _handleOptionalFilterClick() {
			this.setState({
				hideOptional: !this.state.hideOptional
			});
		},
		_updateErrorMessages: function _updateErrorMessages(attr, validationResult) {
			var errorMessages = this.state.errorMessages;
	
			if (validationResult.valid) {
				if (_underscore2.default.has(errorMessages, attr.name)) {
					delete errorMessages[attr.name];
				}
			} else {
				errorMessages[attr.name] = validationResult.errorMessage;
			}
	
			return errorMessages;
		},
		_validate: function _validate(attr, value, callback) {
			// apply validation rules, not that IE9 does not support constraint validation API
			var type = attr.fieldType;
			var nullOrUndefinedValue = value === null || value === undefined;
			var entityInstance = _underscore2.default.extend({}, this.state.entityInstance);
			var errorMessage = undefined;
			var computed = attr.expression !== undefined;
	
			if (!computed) {
				//Do not validate computed attributes
				if (attr.nillable === false && type !== 'CATEGORICAL_MREF' && type !== 'MREF' && nullOrUndefinedValue && !attr.auto) {
					// required value constraint
					if (attr.visibleExpression === undefined || this._resolveBoolExpression(attr.visibleExpression, entityInstance) === true) {
						errorMessage = 'Please enter a value.';
					}
				} else if (attr.nillable === false && (type === 'CATEGORICAL_MREF' || type === 'MREF') && (nullOrUndefinedValue || value.items.length === 0)) {
					// required value constraint
					if (attr.visibleExpression === undefined || this._resolveBoolExpression(attr.visibleExpression, entityInstance) === true) {
						errorMessage = 'Please enter a value.';
					}
				} else if (type === 'EMAIL' && !nullOrUndefinedValue && !this._statics.REGEX_EMAIL.test(value)) {
					errorMessage = 'Please enter a valid email address.';
				} else if (type === 'HYPERLINK' && !nullOrUndefinedValue && !this._statics.REGEX_URL.test(value)) {
					errorMessage = 'Please enter a valid URL.';
				} else if (!attr.range && (type === 'INT' || type === 'LONG') && !nullOrUndefinedValue && !this._isInteger(value)) {
					errorMessage = 'Please enter an integer value.';
				} else if (!attr.range && type === 'INT' && !nullOrUndefinedValue && !this._inRange(value, { min: this._statics.INT_MIN, max: this._statics.INT_MAX })) {
					errorMessage = 'Please enter a value between ' + this._statics.INT_MIN + ' and ' + this._statics.INT_MAX + '.';
				} else if (!attr.range && type === 'LONG' && !nullOrUndefinedValue && !this._inRange(value, { min: this._statics.LONG_MIN, max: this._statics.LONG_MAX })) {
					errorMessage = 'Please enter a value between ' + this._statics.LONG_MIN + ' and ' + this._statics.LONG_MAX + '.';
				} else if (attr.range && (type === 'INT' || type === 'LONG') && !nullOrUndefinedValue && !this._inRange(value, attr.range)) {
					if (attr.range.min !== undefined && attr.range.max !== undefined) {
						errorMessage = 'Please enter a value between ' + attr.range.min + ' and ' + attr.range.max + '.';
					} else if (attr.range.min !== undefined) {
						errorMessage = 'Please enter a value greater than or equal to ' + attr.range.min + '.';
					} else if (attr.range.max !== undefined) {
						errorMessage = 'Please enter a value lower than or equal to ' + attr.range.max + '.';
					}
				} else if (type === 'DECIMAL' && !nullOrUndefinedValue && !_jquery2.default.isNumeric(value)) {
					errorMessage = 'Please enter a valid number.';
				} else if (attr.unique === true && !nullOrUndefinedValue) {
					// value uniqueness constraint
	
					// determine query value
					var queryValue;
					switch (type) {
						case 'CATEGORICAL':
						case 'XREF':
							queryValue = value[attr.refEntity.idAttribute];
							break;
						case 'CATEGORICAL_MREF':
						case 'MREF':
							queryValue = _underscore2.default.map(value, function (item) {
								return item[attr.refEntity.idAttribute];
							});
							break;
						default:
							queryValue = value;
							break;
					}
	
					// check if value already exists for this attribute
					var rules = [{ field: attr.name, operator: 'EQUALS', value: queryValue }];
	
					api.getAsync(this.state.entity.hrefCollection, { q: { q: rules } }, function (data) {
						var idAttribute = data.meta.idAttribute;
						if (data.total > 0 && (this.props.mode === 'create' || data.items[0][idAttribute] !== this.state.entityInstance[idAttribute])) {
							callback({ valid: false, errorMessage: 'This ' + attr.label + ' already exists. It must be unique.' });
						} else {
							callback({ valid: true, errorMessage: undefined });
						}
					}.bind(this));
					return;
				}
	
				if (attr.validationExpression) {
					entityInstance[attr.name] = value;
					if (this._resolveBoolExpression(attr.validationExpression, entityInstance) === false) {
						errorMessage = 'Please enter a valid value.';
					}
				}
			}
	
			callback({ valid: errorMessage === undefined, errorMessage: errorMessage });
		},
		_resolveBoolExpression: function _resolveBoolExpression(expression, entityInstance) {
			//TODO make evalScript work with entities
			var form = {};
			_underscore2.default.each(this.state.entity.allAttributes, function (attr) {
				var value = entityInstance[attr.name];
	
				if (value !== null && value !== undefined) {
					switch (attr.fieldType) {
						case 'CATEGORICAL':
						case 'XREF':
							form[attr.name] = value[attr.refEntity.idAttribute];
							break;
						case 'CATEGORICAL_MREF':
						case 'MREF':
							form[attr.name] = _underscore2.default.map(value.items, function (item) {
								return item[attr.refEntity.idAttribute];
							}).join();
							break;
						case 'COMPOUND':
							//nothing, no value
							break;
						default:
							form[attr.name] = value;
							break;
					}
				}
			}, this);
	
			try {
				return evalScript(expression, form);
			} catch (e) {
				return false;
			}
		},
		_statics: {
			// http://jmrware.com/articles/2009/uri_regexp/URI_regex.html#uri-34
			REGEX_URL: /^(?:[A-Za-z][A-Za-z0-9+\-.]*:(?:\/\/(?:(?:[A-Za-z0-9\-._~!$&'()*+,;=:]|%[0-9A-Fa-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9A-Fa-f]{1,4}:){6}|::(?:[0-9A-Fa-f]{1,4}:){5}|(?:[0-9A-Fa-f]{1,4})?::(?:[0-9A-Fa-f]{1,4}:){4}|(?:(?:[0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::(?:[0-9A-Fa-f]{1,4}:){3}|(?:(?:[0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::(?:[0-9A-Fa-f]{1,4}:){2}|(?:(?:[0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:|(?:(?:[0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::)(?:[0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4}|(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))|(?:(?:[0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}|(?:(?:[0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::)|[Vv][0-9A-Fa-f]+\.[A-Za-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|(?:[A-Za-z0-9\-._~!$&'()*+,;=]|%[0-9A-Fa-f]{2})*)(?::[0-9]*)?(?:\/(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})*)*|\/(?:(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})+(?:\/(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})*)*)?|(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})+(?:\/(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})*)*|)(?:\?(?:[A-Za-z0-9\-._~!$&'()*+,;=:@\/?]|%[0-9A-Fa-f]{2})*)?(?:\#(?:[A-Za-z0-9\-._~!$&'()*+,;=:@\/?]|%[0-9A-Fa-f]{2})*)?|(?:\/\/(?:(?:[A-Za-z0-9\-._~!$&'()*+,;=:]|%[0-9A-Fa-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9A-Fa-f]{1,4}:){6}|::(?:[0-9A-Fa-f]{1,4}:){5}|(?:[0-9A-Fa-f]{1,4})?::(?:[0-9A-Fa-f]{1,4}:){4}|(?:(?:[0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::(?:[0-9A-Fa-f]{1,4}:){3}|(?:(?:[0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::(?:[0-9A-Fa-f]{1,4}:){2}|(?:(?:[0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:|(?:(?:[0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::)(?:[0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4}|(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))|(?:(?:[0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}|(?:(?:[0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::)|[Vv][0-9A-Fa-f]+\.[A-Za-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|(?:[A-Za-z0-9\-._~!$&'()*+,;=]|%[0-9A-Fa-f]{2})*)(?::[0-9]*)?(?:\/(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})*)*|\/(?:(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})+(?:\/(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})*)*)?|(?:[A-Za-z0-9\-._~!$&'()*+,;=@]|%[0-9A-Fa-f]{2})+(?:\/(?:[A-Za-z0-9\-._~!$&'()*+,;=:@]|%[0-9A-Fa-f]{2})*)*|)(?:\?(?:[A-Za-z0-9\-._~!$&'()*+,;=:@\/?]|%[0-9A-Fa-f]{2})*)?(?:\#(?:[A-Za-z0-9\-._~!$&'()*+,;=:@\/?]|%[0-9A-Fa-f]{2})*)?)$/,
			// http://www.w3.org/TR/html5/forms.html#valid-e-mail-address
			REGEX_EMAIL: /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/,
			INT_MIN: -2147483648,
			INT_MAX: 2147483647,
			LONG_MIN: Number.MIN_SAFE_INTEGER,
			LONG_MAX: Number.MAX_SAFE_INTEGER
		},
		_isInteger: function _isInteger(value) {
			return Number.isInteger(value);
		},
		_inRange: function _inRange(value, range) {
			var inRange = true;
			if (range.min !== undefined) {
				inRange = inRange && value >= range.min;
			}
			if (range.max !== undefined) {
				inRange = inRange && value <= range.max;
			}
			return inRange;
		},
		_getValue: function _getValue(entityInstance, attr) {
			//Please don't manipulate the values here. It is not the place to do it!
			return entityInstance[attr.name];
		}
	});
	
	/**
	 * @memberOf component
	 */
	var FormControls = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'FormControls',
		propTypes: {
			entity: _react2.default.PropTypes.object.isRequired,
			value: _react2.default.PropTypes.object,
			mode: _react2.default.PropTypes.oneOf(['create', 'edit', 'view']),
			formLayout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
			colOffset: _react2.default.PropTypes.number,
			hideOptional: _react2.default.PropTypes.bool,
			showHidden: _react2.default.PropTypes.bool,
			categoricalMrefShowSelectAll: _react2.default.PropTypes.bool,
			showAsteriskIfNotNillable: _react2.default.PropTypes.bool,
			enableFormIndex: _react2.default.PropTypes.bool,
			enableAlertMessageInFormIndex: _react2.default.PropTypes.bool,
			errorMessages: _react2.default.PropTypes.object.isRequired,
			onValueChange: _react2.default.PropTypes.func.isRequired,
			onBlur: _react2.default.PropTypes.func.isRequired
		},
		render: function render() {
			// add control for each attribute
			var foundFocusControl = false;
			var attributes = this.props.entity.attributes;
			var controls = [];
			for (var key in attributes) {
				if (attributes.hasOwnProperty(key)) {
					var attr = attributes[key];
					if (this.props.mode !== 'create' || this.props.mode === 'create' && attr.auto !== true) {
						var ControlFactory = attr.fieldType === 'COMPOUND' ? _FormControlGroup2.default : _FormControl2.default;
						var controlProps = {
							entity: this.props.entity,
							entityInstance: this.props.value,
							attr: attr,
							value: attr.fieldType === 'COMPOUND' ? this.props.value : this.props.value ? this.props.value[key] : undefined,
							mode: this.props.mode,
							formLayout: this.props.formLayout,
							colOffset: this.props.colOffset,
							onBlur: this.props.onBlur,
							categoricalMrefShowSelectAll: this.props.categoricalMrefShowSelectAll,
							showAsteriskIfNotNillable: this.props.showAsteriskIfNotNillable,
							onValueChange: this.props.onValueChange,
							key: key
						};
	
						if (attr.fieldType === 'COMPOUND') {
							_underscore2.default.extend(controlProps, {
								errorMessages: this.props.errorMessages,
								hideOptional: this.props.hideOptional
							});
						} else {
							controlProps['errorMessage'] = this.props.errorMessages[attr.name];
						}
	
						// IE9 does not support the autofocus attribute, focus the first visible input manually
						if (this.props.mode !== 'view' && !foundFocusControl && attr.visible === true && (this.props.mode === 'create' || attr.readOnly !== true)) {
							_underscore2.default.extend(controlProps, { focus: true });
							foundFocusControl = true;
						}
	
						var Control = ControlFactory(controlProps);
						if (attr.nillable === true && this.props.hideOptional === true || this.props.showHidden === false && attr.visible === false || attr.visibleExpression !== undefined && this.props.entity.allAttributes[attr.name].visible === false) {
							Control = div({ className: 'hide', key: key + '-hide' }, Control);
						} else if (this.props.enableFormIndex === true && attr.fieldType === 'COMPOUND') {
							controls.push(div({ id: this._getLinkId(attr), className: 'anchor', key: key + '-link' }));
						}
						controls.push(Control);
					}
				}
			}
			return div({}, controls);
		},
		_getLinkId: function _getLinkId(attr) {
			return attr.name + '-link';
		}
	});
	var FormControlsFactory = _react2.default.createFactory(FormControls);
	
	/**
	 * @memberOf component
	 */
	var FormButtons = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'FormButtons',
		propTypes: {
			mode: _react2.default.PropTypes.oneOf(['create', 'edit']).isRequired,
			formLayout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']).isRequired,
			colOffset: _react2.default.PropTypes.number,
			cancelBtn: _react2.default.PropTypes.bool,
			onCancelClick: _react2.default.PropTypes.func,
			onSubmitClick: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onCancelClick: function onCancelClick() {}
			};
		},
		render: function render() {
			var divClasses;
			if (this.props.formLayout === 'horizontal') {
				divClasses = 'col-md-offset-' + this.props.colOffset + ' col-md-' + (12 - this.props.colOffset);
			} else {
				divClasses = 'col-md-12';
			}
	
			var submitBtnText = this.props.mode === 'create' ? 'Create' : 'Save changes';
			var submitBtnName = this.props.mode === 'create' ? 'create' : 'save-changes';
			return div({ className: 'row', style: { textAlign: 'right' } }, div({ className: divClasses }, this.props.cancelBtn ? (0, _Button2.default)({ name: 'cancel', text: 'Cancel', onClick: this.props.onCancelClick }, 'Cancel') : null, (0, _Button2.default)({ type: 'button', style: 'primary', css: { marginLeft: 5 }, name: submitBtnName, text: submitBtnText, onClick: this.props.onSubmitClick })));
		}
	});
	var FormButtonsFactory = _react2.default.createFactory(FormButtons);
	
	/**
	 * @memberOf component
	 */
	var FormIndex = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'FormIndex',
		propTypes: {
			entity: _react2.default.PropTypes.object.isRequired,
			errorMessageAlertMessage: _react2.default.PropTypes.object,
			submitAlertMessage: _react2.default.PropTypes.object
		},
		render: function render() {
			var IndexItems = [];
			var attrs = this.props.entity.attributes;
			for (var key in attrs) {
				if (attrs.hasOwnProperty(key)) {
					var attr = attrs[key];
					if (attr.fieldType === 'COMPOUND') {
						var IndexItem = li({ key: attr.name, className: 'list-group-item' }, a({ href: this._getLinkName(attr) }, attr.label));
						IndexItems.push(IndexItem);
					}
				}
			}
	
			return div({ id: 'sidebar', className: 'affix' }, this.props.errorMessageAlertMessage, this.props.submitAlertMessage, ol({ style: { listStyleType: 'none' }, className: 'list-group' }, IndexItems));
		},
		_getLinkName: function _getLinkName(attr) {
			return '#' + attr.name + '-link';
		}
	});
	var FormIndexFactory = _react2.default.createFactory(FormIndex);
	
	exports.default = _react2.default.createFactory(Form);

/***/ },

/***/ 48:
/*!**************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Icon.js ***!
  \**************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var span = _react2.default.DOM.span;
	
	/**
	 * @memberOf component
	 */
	var Icon = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Icon',
		propTypes: {
			name: _react2.default.PropTypes.string.isRequired,
			onClick: _react2.default.PropTypes.func,
			style: _react2.default.PropTypes.object
		},
		render: function render() {
			var style = this.props.onClick ? _underscore2.default.extend({ cursor: 'pointer' }, this.props.style) : this.props.style;
			return span({ onClick: this.props.onClick, style: style }, span({ className: 'glyphicon glyphicon-' + this.props.name, 'aria-hidden': true }), span({ className: 'sr-only' }, this.props.name));
		}
	});
	
	exports.default = _react2.default.createFactory(Icon);

/***/ },

/***/ 49:
/*!***************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Input.js ***!
  \***************************************************************/
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function($) {"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Input = undefined;
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var input = _react2.default.DOM.input,
	    div = _react2.default.DOM.div,
	    span = _react2.default.DOM.span;
	
	/**
	 * @memberOf component
	 */
	var Input = _react2.default.createClass({
		displayName: 'Input',
		mixins: [_DeepPureRenderMixin2.default],
		propTypes: {
			type: _react2.default.PropTypes.string.isRequired,
			onValueChange: _react2.default.PropTypes.func.isRequired,
			id: _react2.default.PropTypes.string,
			name: _react2.default.PropTypes.string,
			placeholder: _react2.default.PropTypes.string,
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			step: _react2.default.PropTypes.string,
			min: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
			max: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
			maxLength: _react2.default.PropTypes.number,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
			checked: _react2.default.PropTypes.bool,
			onBlur: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return this._isRadioOrCheckbox() ? { checked: this.props.checked } : { value: this.props.value };
		},
		componentDidMount: function componentDidMount() {
			this._focus();
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			this.setState(this._isRadioOrCheckbox() ? { checked: nextProps.checked } : { value: nextProps.value });
		},
		render: function render() {
			var props = this.props;
	
			var inputProps = {
				type: props.type,
				className: this._isRadioOrCheckbox() || this._isFile() ? undefined : 'form-control',
				id: props.id,
				name: props.name,
				placeholder: props.placeholder,
				required: props.required,
				disabled: props.disabled,
				readOnly: props.readOnly,
				step: props.step,
				min: props.min,
				max: props.max,
				maxLength: props.maxLength,
				value: this._isRadioOrCheckbox() ? this.props.value : this.state.value,
				checked: this._isRadioOrCheckbox() ? this.state.checked : undefined,
				onChange: this._handleChange,
				onBlur: this._handleBlur,
				ref: this.props.focus || this._isFile() ? 'input' : undefined
			};
	
			if (props.readOnly && this._isRadioOrCheckbox()) {
				// readonly attribute doesn't work on checkboxes and radio buttons:
				// http://stackoverflow.com/questions/155291/can-html-checkboxes-be-set-to-readonly
				_underscore2.default.extend(inputProps, { name: undefined, disabled: true });
	
				if (this.state.checked) {
					// for checked checkboxes/radio buttons submit the value of a hidden input,
					// disable visible input to display a readonly view to the user
					return div({}, input({
						type: 'hidden',
						name: props.name,
						value: props.value
					}), input(inputProps));
				} else {
					// values of unchecked checkboxes/radio buttons are never submitted:
					// http://www.w3.org/TR/html401/interact/forms.html#h-17.13.2
					return input(inputProps);
				}
			} else {
				if (this._isFile()) {
					// see http://www.abeautifulsite.net/whipping-file-inputs-into-shape-with-bootstrap-3/
					return div({ className: 'input-group' }, span({ className: 'input-group-btn' }, span({ className: 'btn btn-primary', style: { position: 'relative', overflow: 'hidden' } }, 'Browse...', input(_underscore2.default.extend(inputProps, {
						onChange: this._handleFileBrowseClick,
						style: {
							position: 'absolute',
							top: 0,
							right: 0,
							minWidth: '100%',
							minHeight: '100%',
							fontSize: 100,
							textAlign: 'right',
							opacity: 0,
							outline: 'none',
							background: 'white',
							cursor: 'inherit',
							display: 'block'
						}
					})))), input({
						type: 'text',
						className: 'form-control',
						readOnly: true,
						style: { backgroundColor: 'white !important', cursor: 'text !important' },
						value: this.state.value ? this.state.value.filename : null,
						ref: 'fileTextInput'
					}));
				} else {
					return input(inputProps);
				}
			}
		},
		_handleChange: function _handleChange(event) {
			var value = event.target.value;
			var newState;
			if (this._isRadioOrCheckbox()) {
				newState = { checked: event.target.checked };
			} else {
				// apply constraint: maximum number of characters allowed in input
				if (this.props.maxLength) {
					value = value.substr(0, this.props.maxLength);
				}
	
				// number change event with invalid number value (e.g. '1abc') will trigger a change event with value '',
				// use input validation status to determine is the value was cleared or if we are dealing with an invalid value.
				// Note: this does not apply to IE9 which does not support the input number type and the validation API.
				if (this.props.type === 'number' && event.target.validity && event.target.validity.badInput === true) {
					value = this.state.value;
				}
				newState = { value: value };
			}
			this.setState(newState);
			this._handleChangeOrBlur(value, event.target.checked, this.props.onValueChange);
		},
		_handleBlur: function _handleBlur(event) {
			if (this.props.onBlur) {
				this._handleChangeOrBlur(event.target.value, event.target.checked, this.props.onBlur);
			}
		},
		_handleChangeOrBlur: function _handleChangeOrBlur(value, checked, callback) {
			var valueEvent;
			if (this._isRadioOrCheckbox()) {
				valueEvent = { value: this._emptyValueToNull(value), checked: checked };
			} else {
				var val = this._emptyValueToNull(value);
	
				if (this.props.type === 'number' && val !== null) {
					val = parseFloat(val); // convert js string to js number
				}
				valueEvent = { value: val };
			}
			callback(valueEvent);
		},
		_handleFileBrowseClick: function _handleFileBrowseClick() {
			var input = $(this.refs.input.getDOMNode()),
			    value = input.val(),
			    label = this._toFileLabel(value);
			$(this.refs.fileTextInput.getDOMNode()).val(label);
	
			this.setState({ value: value });
			this._handleChangeOrBlur(value, undefined, this.props.onValueChange);
		},
		_toFileLabel: function _toFileLabel(value) {
			return value.replace(/\\/g, '/').replace(/.*\//, '');
		},
		_isRadioOrCheckbox: function _isRadioOrCheckbox() {
			return this.props.type === 'radio' || this.props.type === 'checkbox';
		},
		_isFile: function _isFile() {
			return this.props.type === 'file';
		},
		_emptyValueToNull: function _emptyValueToNull(value) {
			return value !== '' ? value : null;
		},
		_focus: function _focus() {
			if (this.props.focus) {
				this.refs.input.getDOMNode().focus();
			}
		}
	});
	
	exports.Input = Input;
	exports.default = _react2.default.createFactory(Input);
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(/*! jquery */ 5)))

/***/ },

/***/ 50:
/*!********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/RadioGroup.js ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.RadioGroup = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _GroupMixin = __webpack_require__(/*! ./mixin/GroupMixin */ 70);
	
	var _GroupMixin2 = _interopRequireDefault(_GroupMixin);
	
	__webpack_require__(/*! ./css/Radio.css */ 412);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * @memberOf component
	 */
	var RadioGroup = _react2.default.createClass({
		displayName: 'RadioGroup',
		mixins: [_DeepPureRenderMixin2.default, _GroupMixin2.default],
		propTypes: {
			name: _react2.default.PropTypes.string.isRequired,
			layout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			options: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.shape({ value: _react2.default.PropTypes.string, label: _react2.default.PropTypes.string })).isRequired,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.string,
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				type: 'radio',
				layout: 'vertical'
			};
		},
		getInitialState: function getInitialState() {
			return {
				value: this.props.value
			};
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			if (this.state.value !== nextProps.value) {
				this.setState({ value: nextProps.value });
			}
		},
		_handleChange: function _handleChange(event) {
			this.setState({ value: event.value });
			this.props.onValueChange({ value: event.value });
		},
		_isChecked: function _isChecked(option) {
			var value = this.state.value === undefined && !this.props.required ? null : this.state.value;
			return value === this._inputToValue(option.value);
		}
	});
	
	exports.RadioGroup = RadioGroup;
	exports.default = _react2.default.createFactory(RadioGroup);

/***/ },

/***/ 51:
/*!************************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/AttributeLoaderMixin.js ***!
  \************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var api = new _RestClientV2.default();
	
	/**
	 * @memberOf component.mixin
	 */
	var AttributeLoaderMixin = {
		componentDidMount: function componentDidMount() {
			this._initAttr(this.props.attr);
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			if (!_underscore2.default.isEqual(this.props.attr, nextProps.attr)) {
				this._initAttr(nextProps.attr);
			}
		},
		_isLoaded: function _isLoaded(attr) {
			if (attr.name !== undefined && (attr.refEntity === undefined || attr.refEntity.name !== undefined)) {
				if (attr.attributes.length > 0) {
					for (var i = 0; i < attr.attributes.length; i++) {
						if (attr.attributes[i].name == undefined) {
							return false;
						}
					}
				}
				return true;
			}
		},
		_initAttr: function _initAttr(attr) {
			// fetch attribute if not exists
			if ((typeof attr === "undefined" ? "undefined" : _typeof(attr)) === 'object') {
				if (!this._isLoaded(attr)) {
					this._loadAttr(attr.href);
				} else {
					this._setAttr(attr);
				}
			} else if (typeof attr === 'string') {
				this._loadAttr(attr);
			}
		},
		_loadAttr: function _loadAttr(href) {
			api.getAsync(href, { expand: ['refEntity', 'attributes'] }).done(function (attr) {
				if (this.isMounted()) {
					this._setAttr(attr);
				}
			}.bind(this));
		},
		_setAttr: function _setAttr(attr) {
			if (this._onAttrInit) {
				this.setState({ attr: attr }, this._onAttrInit);
			} else {
				this.setState({ attr: attr });
			}
		}
	};
	
	exports.default = AttributeLoaderMixin;

/***/ },

/***/ 52:
/*!*********************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/EntityLoaderMixin.js ***!
  \*********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _AttributeFunctions = __webpack_require__(/*! rest-client/AttributeFunctions */ 74);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var api = new _RestClientV2.default();
	
	/**
	 * Loads an entity (meta data) from this.props.entity and stores in this.state.entity
	 * 
	 * @memberOf component.mixin
	 */
	var EntityLoaderMixin = {
		componentDidMount: function componentDidMount() {
			this._initEntity(this.props.entity);
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			if (!_underscore2.default.isEqual(this.props.entity, nextProps.entity)) {
				this._initEntity(nextProps.entity);
			}
		},
		_isLoaded: function _isLoaded(entity) {
			if (entity.idAttribute !== undefined) {
				return false;
			} else if (entity.attributes && entity.attributes.length > 0) {
				return _underscore2.default.size(entity.attributes[0] > 1);
			} else {
				return true;
			}
		},
		_initEntity: function _initEntity(entity) {
			// fetch entity meta if not exists
			if (entity === undefined) {
				this._setEntity(entity);
			} else if ((typeof entity === "undefined" ? "undefined" : _typeof(entity)) === 'object') {
				if (!this._isLoaded(entity)) {
					this._loadEntity(entity.href);
				} else {
					this._setEntity(entity);
				}
			} else if (typeof entity === 'string') {
				var href = entity.startsWith('/api/') ? entity : '/api/v1/' + entity + '/meta';
				this._loadEntity(href);
			}
		},
		_loadEntity: function _loadEntity(href) {
			api.getAsync(href, { 'expand': ['attributes'] }).done(function (entity) {
				if (this.isMounted()) {
					var attributes = (0, _AttributeFunctions.getAllAttributes)(entity.attributes, api);
					entity.allAttributes = {};
					for (var i = 0; i < attributes.length; i++) {
						entity.allAttributes[attributes[i].name] = attributes[i];
					}
	
					this._setEntity(entity);
				}
			}.bind(this));
		},
		_setEntity: function _setEntity(entity) {
			this.setState({ entity: entity });
			if (this._onEntityInit) {
				this._onEntityInit(entity);
			}
		}
	};
	
	exports.default = EntityLoaderMixin;

/***/ },

/***/ 53:
/*!********************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/I18nStringsMixin.js ***!
  \********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	
	var _I18nStrings = __webpack_require__(/*! i18n/I18nStrings */ 259);
	
	var I18nStringsMixin = {
	    componentDidMount: function componentDidMount() {
	        var self = this;
	        (0, _I18nStrings.I18nStrings)(function (i18nStrings) {
	            self.setState({ i18nStrings: i18nStrings });
	        });
	    }
	};
	
	exports.default = I18nStringsMixin;

/***/ },

/***/ 63:
/*!**********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/AlertMessage.js ***!
  \**********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _Icon = __webpack_require__(/*! ./Icon */ 48);
	
	var _Icon2 = _interopRequireDefault(_Icon);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    span = _react2.default.DOM.span,
	    button = _react2.default.DOM.button;
	
	/**
	 * @memberOf component
	 */
	var AlertMessage = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'AlertMessage',
		propTypes: {
			type: _react2.default.PropTypes.oneOf(['success', 'info', 'warning', 'danger']),
			message: _react2.default.PropTypes.string.isRequired,
			onDismiss: _react2.default.PropTypes.func
		},
		render: function render() {
			return div({ className: 'alert alert-' + this.props.type + ' alert-dismissible', role: 'alert' }, this.props.onDismiss ? button({ type: 'button', className: 'close', 'aria-label': 'Close', onClick: this.props.onDismiss }, // TODO use Button
			span({ 'aria-hidden': true }, String.fromCharCode(215)) // &times;
			) : null, this.props.type === 'danger' ? (0, _Icon2.default)({ name: 'exclamation-sign' }) : null, this.props.type === 'danger' ? ' ' + this.props.message : this.props.message);
		}
	});
	
	exports.default = _react2.default.createFactory(AlertMessage);

/***/ },

/***/ 64:
/*!***********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/CheckboxGroup.js ***!
  \***********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _GroupMixin = __webpack_require__(/*! ./mixin/GroupMixin */ 70);
	
	var _GroupMixin2 = _interopRequireDefault(_GroupMixin);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	__webpack_require__(/*! ./css/Checkbox.css */ 411);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * @memberOf component
	 */
	var CheckboxGroup = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _GroupMixin2.default],
		displayName: 'CheckboxGroup',
		propTypes: {
			name: _react2.default.PropTypes.string,
			layout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			selectAll: _react2.default.PropTypes.bool, // add select all and deselect all options for checkbox group
			options: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.shape({ value: _react2.default.PropTypes.string, label: _react2.default.PropTypes.string })).isRequired,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.string),
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				type: 'checkbox',
				layout: 'vertical',
				selectAll: true
			};
		},
		getInitialState: function getInitialState() {
			return {
				value: this.props.value || []
			};
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			this.setState({
				value: nextProps.value || []
			});
		},
		_handleChange: function _handleChange(event) {
			var value = this._inputToValue(event.value);
	
			var values = this.state.value;
			if (event.checked) {
				values = values.concat(value);
			} else {
				values = values.slice(0);
				values.splice(values.indexOf(value), 1);
			}
	
			this.setState({ value: values });
			this.props.onValueChange({ value: values });
		},
		_isChecked: function _isChecked(option) {
			return this.state.value && this.state.value.indexOf(this._inputToValue(option.value)) > -1;
		},
		_selectAll: function _selectAll(e) {
			e.preventDefault(); // do not scroll to top of page
	
			var values = [];
			for (var i = 0; i < this.props.options.length; ++i) {
				values.push(this.props.options[i].value);
			}
			this.setState({ value: values });
			this.props.onValueChange({ value: values });
		},
		_deselectAll: function _deselectAll(e) {
			e.preventDefault(); // do not scroll to top of page
	
			this.setState({ value: [] });
			this.props.onValueChange({ value: [] });
		}
	});
	
	exports.default = _react2.default.createFactory(CheckboxGroup);

/***/ },

/***/ 65:
/*!****************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Dialog.js ***!
  \****************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _Modal = __webpack_require__(/*! ./Modal */ 39);
	
	var _Modal2 = _interopRequireDefault(_Modal);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div;
	
	/**
	 * @memberOf component
	 */
	var Dialog = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Dialog',
		propTypes: {
			type: _react2.default.PropTypes.oneOf(['alert', 'confirm']),
			message: _react2.default.PropTypes.string.isRequired,
			onCancel: _react2.default.PropTypes.func, // confirm dialogs
			onConfirm: _react2.default.PropTypes.func },
		// alert and confirm dialogs
		render: function render() {
			return (0, _Modal2.default)({ title: this.props.message, show: true }, div({ className: 'row', style: { textAlign: 'right' } }, div({ className: 'col-md-12' }, this.props.type === 'confirm' ? (0, _Button2.default)({ text: 'Cancel', onClick: this.props.onCancel }, 'Cancel') : null, (0, _Button2.default)({ text: 'Ok', style: 'primary', css: { marginLeft: 5 }, onClick: this.props.onConfirm }, 'Ok'))));
		}
	});
	
	exports.default = _react2.default.createFactory(Dialog);

/***/ },

/***/ 66:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/FormControl.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _AttributeLoaderMixin = __webpack_require__(/*! ./mixin/AttributeLoaderMixin */ 51);
	
	var _AttributeLoaderMixin2 = _interopRequireDefault(_AttributeLoaderMixin);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _AttributeControl = __webpack_require__(/*! ./AttributeControl */ 102);
	
	var _AttributeControl2 = _interopRequireDefault(_AttributeControl);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _urijs = __webpack_require__(/*! urijs */ 256);
	
	var _urijs2 = _interopRequireDefault(_urijs);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    span = _react2.default.DOM.span,
	    label = _react2.default.DOM.label,
	    strong = _react2.default.DOM.strong,
	    a = _react2.default.DOM.a;
	
	/**
	 * @memberOf component
	 */
	var FormControl = _react2.default.createClass({
	    mixins: [_DeepPureRenderMixin2.default, _AttributeLoaderMixin2.default],
	    displayName: 'FormControl',
	    propTypes: {
	        entity: _react2.default.PropTypes.object.isRequired,
	        entityInstance: _react2.default.PropTypes.object,
	        attr: _react2.default.PropTypes.object.isRequired,
	        formLayout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
	        mode: _react2.default.PropTypes.oneOf(['create', 'edit', 'view']),
	        colOffset: _react2.default.PropTypes.number,
	        errorMessage: _react2.default.PropTypes.string,
	        focus: _react2.default.PropTypes.bool,
	        value: _react2.default.PropTypes.any,
	        onValueChange: _react2.default.PropTypes.func.isRequired,
	        onBlur: _react2.default.PropTypes.func.isRequired,
	        categoricalMrefShowSelectAll: _react2.default.PropTypes.bool,
	        showAsteriskIfNotNillable: _react2.default.PropTypes.bool
	    },
	    getInitialState: function getInitialState() {
	        return {
	            attr: null,
	            pristine: true
	        };
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            colOffset: 2
	        };
	    },
	    render: function render() {
	        if (this.state.attr === null) {
	            // attribute not fetched yet
	            return (0, _Spinner2.default)();
	        }
	
	        var attr = this.state.attr;
	
	        var lbl = attr.label;
	
	        if (attr.nillable === false && this.props.showAsteriskIfNotNillable === true) {
	            lbl += ' *';
	        }
	
	        // add validation error message
	        var errorMessage = this.props.errorMessage;
	        var showErrorMessage = errorMessage !== undefined && errorMessage !== null;
	        var errorMessageSpan = showErrorMessage ? span({ className: 'help-block' }, strong({}, this.props.errorMessage)) : null;
	
	        // determine success and error classes for control
	        var formGroupClasses = 'form-group';
	        if (showErrorMessage) {
	            formGroupClasses += ' has-error';
	        }
	
	        var id = attr.name;
	
	        var description = attr.description !== undefined ? FormControlDescriptionFactory({ description: attr.description }) : undefined;
	        var labelClasses = this.props.formLayout === 'horizontal' ? 'col-md-' + this.props.colOffset + ' control-label' : 'control-label';
	        var labelElement = label({ className: labelClasses, htmlFor: id }, lbl);
	
	        var attributeControlProps = _underscore2.default.extend({}, this.props, {
	            attr: attr,
	            id: id,
	            name: id,
	            disabled: this.props.mode === 'view',
	            focus: this.props.focus,
	            formLayout: undefined,
	            value: this._getValue(this.props.value),
	            onValueChange: this._handleValueChange,
	            onBlur: this._handleBlur,
	            categoricalMrefShowSelectAll: this.props.categoricalMrefShowSelectAll
	        });
	
	        // allow editing readonly controls in create mode
	        if (this.props.mode === 'create' && attr.readOnly === true) {
	            _underscore2.default.extend(attributeControlProps, { readOnly: false, required: true });
	        }
	        // show hidden controls and create and edit form
	        if ((this.props.mode === 'create' || this.props.mode === 'edit') && attr.visible !== true) {
	            attributeControlProps.visible = true;
	        }
	        // show auto controls as readonly in edit mode
	        if (this.props.mode === 'edit' && attr.auto === true) {
	            attributeControlProps.readOnly = true;
	        }
	
	        var control = (0, _AttributeControl2.default)(attributeControlProps);
	
	        if (this.props.formLayout === 'horizontal') {
	            return div({ className: formGroupClasses }, labelElement, div({ className: 'col-md-' + (12 - this.props.colOffset) }, control, description, errorMessageSpan));
	        } else {
	            return div({ className: formGroupClasses }, labelElement, description, control, errorMessageSpan);
	        }
	    },
	
	    _handleValueChange: function _handleValueChange(e) {
	        this.setState({ pristine: false });
	
	        this.props.onValueChange({
	            attr: this.state.attr.name,
	            value: this._getValue(e.value)
	        });
	    },
	
	    _handleBlur: function _handleBlur(e) {
	        // only validate if control was touched
	        if (this.state.pristine === true || this.props.onBlur === undefined) {
	            return;
	        }
	
	        e.attr = this.state.attr;
	        this.props.onBlur(e);
	    },
	    _getValue: function _getValue(value) {
	        //Please don't manipulate the values here. It is not the place to do it!
	        return value;
	    }
	});
	
	/**
	 * @memberOf component
	 */
	var FormControlDescription = _react2.default.createClass({
	    mixins: [_DeepPureRenderMixin2.default],
	    displayName: 'FormControlDescription',
	    propTypes: {
	        description: _react2.default.PropTypes.string.isRequired
	    },
	    render: function render() {
	        var text = this.props.description;
	
	        var keyIdx = 0;
	        var idx = 0;
	        var DescriptionParts = [];
	        _urijs2.default.withinString(text, function (url, start, end) {
	            if (start > idx) {
	                DescriptionParts.push(span({ key: '' + keyIdx++ }, text.substr(idx, start)));
	            }
	            DescriptionParts.push(a({ href: url, target: '_blank', key: '' + keyIdx++ }, url));
	
	            idx = end;
	            return url;
	        });
	        if (idx < text.length) {
	            DescriptionParts.push(span({ key: '' + keyIdx++ }, text.substr(idx)));
	        }
	        return span({ className: 'help-block' }, DescriptionParts);
	    }
	});
	var FormControlDescriptionFactory = _react2.default.createFactory(FormControlDescription);
	
	exports.default = _react2.default.createFactory(FormControl);

/***/ },

/***/ 67:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/ProgressBar.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ProgressBar = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * This react component renders a progress bar.
	 * 
	 * @module ProgressBar
	 * 
	 * @param progressPct
	 *            The percentage that represents the shown width of the bar
	 * @param progressMessage
	 *            Message shown within the bar
	 * @param status
	 *            The status of the job, will affect bar color
	 * @param active
	 *            Whether the bar should be animated or not
	 * 
	 * @exports ProgressBarClass, ProgressBar factory
	 */
	
	var div = _react2.default.DOM.div;
	
	var ProgressBar = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'ProgressBar',
		propTypes: {
			progressPct: _react2.default.PropTypes.number.isRequired,
			progressMessage: _react2.default.PropTypes.string.isRequired,
			status: _react2.default.PropTypes.oneOf(['info', 'danger', 'success', 'warning', 'primary']).isRequired,
			active: _react2.default.PropTypes.bool
		},
		render: function render() {
			var _props = this.props;
			var status = _props.status;
			var active = _props.active;
			var progressPct = _props.progressPct;
			var progressMessage = _props.progressMessage;
	
			return _react2.default.createElement(
				'div',
				{ className: 'progress background-lightgrey' },
				_react2.default.createElement(
					'div',
					{ className: 'progress-bar progress-bar-' + status + (active ? ' progress-bar-striped active' : ''),
						role: 'progressbar', style: { minWidth: '2em', 'width': progressPct + '%' } },
					progressMessage
				)
			);
		}
	});
	
	exports.ProgressBar = ProgressBar;
	exports.default = _react2.default.createFactory(ProgressBar);

/***/ },

/***/ 68:
/*!******************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/Job.js ***!
  \******************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.Job = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _ProgressBar = __webpack_require__(/*! ../ProgressBar */ 67);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var Job = _react2.default.createClass({
	    mixins: [_DeepPureRenderMixin2.default],
	    displayName: 'Job',
	    propTypes: {
	        job: _react2.default.PropTypes.object.isRequired,
	        onClick: _react2.default.PropTypes.func
	    },
	    render: function render() {
	        var _props = this.props;
	        var job = _props.job;
	        var onClick = _props.onClick;
	
	        return _react2.default.createElement(
	            'div',
	            null,
	            _react2.default.createElement(
	                'p',
	                null,
	                job.type,
	                ' job',
	                _react2.default.createElement(
	                    'div',
	                    null,
	                    job.progressMessage,
	                    _react2.default.createElement(_ProgressBar.ProgressBar, {
	                        progressMessage: this._formatProgressMessage(),
	                        progressPct: job.progressMax !== undefined ? this._getProgressPct() : 100,
	                        status: this._getCssClass() || 'primary',
	                        active: this._isActive()
	                    })
	                ),
	                _react2.default.createElement(
	                    'div',
	                    { className: 'btn-group', role: 'group' },
	                    onClick && _react2.default.createElement(
	                        'button',
	                        { type: 'button', className: 'btn btn-default',
	                            onClick: this.props.onClick },
	                        'Show details'
	                    ),
	                    job.resultUrl && _react2.default.createElement(
	                        'a',
	                        { className: 'btn btn-default', role: 'button',
	                            href: job.resultUrl },
	                        'Go to result'
	                    )
	                )
	            )
	        );
	    },
	    _getCssClass: function _getCssClass() {
	        var cssTable = {
	            'PENDING': 'info',
	            'RUNNING': 'primary',
	            'SUCCESS': 'success',
	            'FAILED': 'danger',
	            'CANCELED': 'warning'
	        };
	        return cssTable[this.props.job.status];
	    },
	    _isActive: function _isActive() {
	        var activeTable = {
	            'PENDING': true,
	            'RUNNING': true,
	            'SUCCESS': false,
	            'FAILED': false
	        };
	        return activeTable[this.props.job.status];
	    },
	    _getProgressPct: function _getProgressPct() {
	        var progressInt = this.props.job.progressInt;
	        var progressMax = this.props.job.progressMax;
	        var calculatedWidth = progressInt / progressMax * 100;
	        return calculatedWidth;
	    },
	    _formatProgressMessage: function _formatProgressMessage() {
	        var _props$job = this.props.job;
	        var progressInt = _props$job.progressInt;
	        var progressMax = _props$job.progressMax;
	
	        if (progressInt === undefined) {
	            return undefined;
	        }
	        if (progressMax === undefined) {
	            return "" + progressInt;
	        } else {
	            return progressInt + "/" + progressMax;
	        }
	    }
	}); /**
	     * The Job component translates information from the Job entity to a visual
	     * representation of the progress of that job, i.e a progress bar
	     *
	     * @module Job
	     *
	     * @param job
	     *            A key value object containing all the details of a job including
	     *            its status and progress message
	     *
	     * @exports Job class
	     */
	
	exports.Job = Job;
	exports.default = _react2.default.createFactory(Job);

/***/ },

/***/ 69:
/*!*****************************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/EntityInstanceLoaderMixin.js ***!
  \*****************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var api = new _RestClientV2.default();
	
	/**
	 * Loads an entity instance (row of data) from this.props.entityInstance and stores in this.state.entityInstance
	 * 
	 * @memberOf component.mixin
	 */
	var EntityInstanceLoaderMixin = {
		_isEntityInstanceLoaded: function _isEntityInstanceLoaded(entityInstance) {
			return this.props.mode !== 'create' && (typeof entityInstance === "undefined" ? "undefined" : _typeof(entityInstance)) === 'object' && _underscore2.default.size(entityInstance) > 1;
		},
		_initEntityInstance: function _initEntityInstance(entity, entityInstance) {
			// fetch entity instance if not exists
			if ((typeof entityInstance === "undefined" ? "undefined" : _typeof(entityInstance)) === 'object') {
				if (!this._isEntityInstanceLoaded(entityInstance)) {
					this._loadEntityInstance(entity, entityInstance.href);
				} else {
					this._setEntityInstance(entity, entityInstance);
				}
			} else if (typeof entityInstance === 'string') {
				if (entity && entity.name) {
					var href = entityInstance.startsWith('/api/') ? entityInstance : '/api/v1/' + this.state.entity.name + '/' + entityInstance;
					this._loadEntityInstance(entity, href);
				}
			} else if (typeof entityInstance === 'number') {
				if (entity && entity.name) {
					var href = '/api/v1/' + this.state.entity.name + '/' + entityInstance.toString();
					this._loadEntityInstance(entity, href);
				}
			}
		},
		_loadEntityInstance: function _loadEntityInstance(entity, href) {
			if (entity && entity.name) {
				// expand attributes with ref entity
				var expands = _underscore2.default.chain(entity.allAttributes).filter(function (attr) {
					return attr.refEntity !== undefined;
				}).map(function (attr) {
					return attr.name;
				}).value();
	
				api.getAsync(href, expands.length > 0 ? { 'expand': expands } : undefined).done(function (entityInstance) {
					if (this.isMounted()) {
						this._setEntityInstance(entity, entityInstance);
					}
				}.bind(this));
			}
		},
		_setEntityInstance: function _setEntityInstance(entity, entityInstance) {
			if (this._willSetEntityInstance) {
				this._willSetEntityInstance(entity, entityInstance);
			}
	
			this.setState({ entityInstance: entityInstance });
	
			if (this._onEntityInstanceInit) {
				this._onEntityInstanceInit(entityInstance);
			}
		},
		_onEntityInit: function _onEntityInit(entity) {
			if (this.props.mode === 'create') {
				this._setEntityInstance(entity, {});
			} else {
				this._initEntityInstance(entity, this.props.entityInstance);
			}
		}
	};
	
	exports.default = EntityInstanceLoaderMixin;

/***/ },

/***/ 70:
/*!**************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/GroupMixin.js ***!
  \**************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Input = __webpack_require__(/*! ../Input */ 49);
	
	var _Input2 = _interopRequireDefault(_Input);
	
	var _Button = __webpack_require__(/*! ../Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    label = _react2.default.DOM.label;
	
	/**
	 * Mixin containing common code for RadioGroup and CheckboxGroup
	 *  
	 * @memberOf component.mixin
	 */
	var GroupMixin = {
		render: function render() {
			var type = this.props.type;
			var options = this.props.options;
	
			var inputs = _underscore2.default.map(options, function (option, i) {
				var control = (0, _Input2.default)({
					type: type,
					name: this.props.name,
					checked: this._isChecked(option),
					disabled: this.props.disabled,
					readOnly: this.props.readOnly,
					value: option.value,
					focus: i === 0 ? this.props.focus : undefined,
					onValueChange: this._handleChange
				});
				if (this.props.layout === 'vertical') {
					var divClasses = this.props.disabled ? type + ' disabled' : type;
					return div({ className: divClasses, key: '' + i }, label({}, control, option.label));
				} else {
					var labelClasses = this.props.disabled ? type + '-inline disabled' : type + '-inline';
					return label({ className: labelClasses, key: '' + i }, control, option.label);
				}
			}.bind(this));
	
			return div({}, inputs, type === 'checkbox' ? div({ className: 'row' }, div({ className: 'col-md-12' }, this.props.selectAll ? (0, _Button2.default)({ style: 'link', size: 'small', text: 'Select all', disabled: this.props.disabled, onClick: this._selectAll }) : null, this.props.selectAll ? (0, _Button2.default)({ style: 'link', size: 'small', text: 'Deselect all', disabled: this.props.disabled, onClick: this._deselectAll }) : null)) : null);
		},
		_inputToValue: function _inputToValue(value) {
			return value === '' ? null : value;
		}
	};
	
	exports.default = GroupMixin;

/***/ },

/***/ 71:
/*!********************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/SetIntervalMixin.js ***!
  \********************************************************************************/
/***/ function(module, exports) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Mixin that you can use for components that need to call setInterval.
	 * It'll keep track of the intervalIDs returned by the calls to the methods
	 * and clear them before unmounting.
	 */
	var SetIntervalMixin = {
	  componentWillMount: function componentWillMount() {
	    this.intervals = [];
	  },
	  setInterval: function (_setInterval) {
	    function setInterval() {
	      return _setInterval.apply(this, arguments);
	    }
	
	    setInterval.toString = function () {
	      return _setInterval.toString();
	    };
	
	    return setInterval;
	  }(function () {
	    this.intervals.push(setInterval.apply(null, arguments));
	  }),
	  componentWillUnmount: function componentWillUnmount() {
	    this.intervals.forEach(clearInterval);
	  }
	};
	
	exports.default = SetIntervalMixin;

/***/ },

/***/ 72:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/wrapper/Ace.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Ace = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	try {
		var ace = __webpack_require__(/*! brace */ 120); // fails server-side
	} catch (exception) {
		ace = _react2.default.DOM.textarea;
	}
	
	var div = _react2.default.DOM.div,
	    textarea = _react2.default.DOM.textarea;
	
	/**
	 * React component for code editor Ace (http://ace.c9.io/)
	 * 
	 * @memberOf component.wrapper
	 */
	var Ace = _react2.default.createClass({
		displayName: 'Ace',
		mixins: [_DeepPureRenderMixin2.default],
		propTypes: {
			name: _react2.default.PropTypes.string,
			required: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			maxLength: _react2.default.PropTypes.number,
			height: _react2.default.PropTypes.number,
			theme: _react2.default.PropTypes.string,
			mode: _react2.default.PropTypes.oneOf(['ftl', 'html', 'javascript', 'json', 'markdown', 'markdown', 'mysql', 'python', 'r', 'plain_text', 'properties', 'text', 'xml']),
			value: _react2.default.PropTypes.string,
			onChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				height: 250,
				theme: 'eclipse',
				mode: 'r'
			};
		},
		getInitialState: function getInitialState() {
			return { value: this.props.value };
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			this.setState({ value: nextProps.value });
		},
		componentDidMount: function componentDidMount() {
			var container = this.refs.editor.getDOMNode();
			var editor = ace.edit(container);
			editor.setTheme('ace/theme/' + this.props.theme);
	
			var session = editor.getSession();
			session.setMode('ace/mode/' + this.props.mode);
			if (this.props.tail) {
				session.setValue(this.state.value, 1);
				editor.scrollToRow(session.getLength() - 1);
			} else {
				session.setValue(this.state.value, -1);
			}
	
			session.on('change', function () {
				var value = session.getValue();
				this.setState({ value: value });
				if (this.props.onChange) {
					this.props.onChange(value);
				}
			}.bind(this));
	
			this._updateAce();
		},
		componentWillUnmount: function componentWillUnmount() {
			var container = this.refs.editor.getDOMNode();
			var editor = ace.edit(container);
			editor.destroy();
		},
		render: function render() {
			// editor won't show up unless height is defined
			return div({}, div({ ref: 'editor', style: { height: this.props.height } }), textarea({
				className: 'form-control hidden',
				name: this.props.name,
				required: this.props.required,
				disabled: this.props.disabled,
				readOnly: this.props.readOnly,
				maxLength: this.props.maxLength,
				value: this.state.value,
				onChange: this._handleChange
			}));
		},
		componentDidUpdate: function componentDidUpdate() {
			if (this.isMounted()) {
				this._updateAce();
			}
		},
		_updateAce: function _updateAce() {
			var container = this.refs.editor.getDOMNode();
			var editor = ace.edit(container);
			var session = editor.getSession();
			editor.setReadOnly(this.props.readOnly === true || this.props.disabled === true);
			if (editor.getValue() !== this.state.value) {
				// I THINK this always means the value got updated programmatically so we can safely update the editor's value
				if (this.props.tail) {
					session.setValue(this.state.value, 1);
					editor.scrollToRow(session.getLength() - 1);
				} else {
					session.setValue(this.state.value, -1);
				}
			}
		},
		_handleChange: function _handleChange(value) {
			// apply constraint: maximum number of characters allowed in input
			if (this.props.maxLength) {
				value = value.substr(0, this.props.maxLength);
			}
			this.setState({ value: value });
			this.props.onChange(value);
		}
	});
	
	exports.Ace = Ace;
	exports.default = _react2.default.createFactory(Ace);

/***/ },

/***/ 73:
/*!*************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/wrapper/Select2.js ***!
  \*************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _Button = __webpack_require__(/*! ../Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	__webpack_require__(/*! ../css/wrapper/select2.css */ 255);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var input = _react2.default.DOM.input,
	    span = _react2.default.DOM.span,
	    div = _react2.default.DOM.div;
	
	/**
	 * React component for select box replacement Select2 (http://select2.github.io/)
	 * 
	 * @memberOf component.wrapper
	 */
	var Select2 = _react2.default.createClass({
		displayName: 'Select2',
		mixins: [_DeepPureRenderMixin2.default],
		propTypes: {
			options: _react2.default.PropTypes.object,
			readOnly: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			focus: _react2.default.PropTypes.bool,
			addonBtn: _react2.default.PropTypes.bool,
			addonBtnIcon: _react2.default.PropTypes.string,
			addonBtnTitle: _react2.default.PropTypes.string,
			onAddonBtnClick: _react2.default.PropTypes.func,
			value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.object, _react2.default.PropTypes.array]),
			onChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				addonBtn: false,
				addonBtnIcon: 'plus'
			};
		},
		getInitialState: function getInitialState() {
			return { value: this.props.value };
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			if (!_underscore2.default.isEqual(this.props.options, nextProps.options)) {
				this._destroySelect2();
				this._createSelect2(nextProps.options);
			}
			this.setState({ value: nextProps.value });
		},
		componentDidMount: function componentDidMount() {
			this._createSelect2(this.props.options);
			this._updateSelect2();
		},
		componentWillUnmount: function componentWillUnmount() {
			this._destroySelect2();
		},
		render: function render() {
			var inputControl = input({ type: 'hidden', name: this.props.name, ref: 'select2', onChange: function onChange() {} }); // empty onChange callback to suppress React warning
			if (this.props.addonBtn) {
				return div({ className: 'input-group select2-bootstrap-append' }, inputControl, span({ className: 'input-group-btn' }, (0, _Button2.default)({
					icon: this.props.addonBtnIcon,
					title: this.props.addonBtnTitle,
					disabled: this.props.readOnly || this.props.disabled,
					onClick: this.props.onAddonBtnClick
				})));
			} else {
				return inputControl;
			}
		},
		componentDidUpdate: function componentDidUpdate() {
			if (this.isMounted()) {
				this._updateSelect2();
			}
		},
		_handleChange: function _handleChange(value) {
			this.setState({ value: value });
			this.props.onChange(value);
		},
		_createSelect2: function _createSelect2(options) {
			var $container = (0, _jquery2.default)(this.refs.select2.getDOMNode());
	
			// create select2
			$container.select2(_jquery2.default.extend({
				containerCssClass: 'form-control',
				placeholder: ' ', // cannot be an empty string
				width: '100%'
			}, options));
	
			$container.on('change', function () {
				this._handleChange($container.select2('data'));
			}.bind(this));
		},
		_updateSelect2: function _updateSelect2() {
			var $container = (0, _jquery2.default)(this.refs.select2.getDOMNode());
			$container.select2('data', this.state.value);
			$container.select2('enable', !this.props.disabled);
			$container.select2('readonly', this.props.readOnly);
			if (this.props.focus) {
				$container.select2('focus');
			}
		},
		_destroySelect2: function _destroySelect2() {
			var $container = (0, _jquery2.default)(this.refs.select2.getDOMNode());
			$container.off();
			$container.select2('destroy');
		}
	});
	
	exports.default = _react2.default.createFactory(Select2);

/***/ },

/***/ 78:
/*!*******************************************************!*\
  !*** ./~/react-notification-system/dist/constants.js ***!
  \*******************************************************/
/***/ function(module, exports) {

	var CONSTANTS = {
	
	  // Positions
	  positions: {
	    tl: 'tl',
	    tr: 'tr',
	    tc: 'tc',
	    bl: 'bl',
	    br: 'br',
	    bc: 'bc'
	  },
	
	  // Levels
	  levels: {
	    success: 'success',
	    error: 'error',
	    warning: 'warning',
	    info: 'info'
	  },
	
	  // Notification defaults
	  notification: {
	    title: null,
	    message: null,
	    level: null,
	    position: 'tr',
	    autoDismiss: 5,
	    dismissible: true,
	    action: null
	  }
	};
	
	
	module.exports = CONSTANTS;


/***/ },

/***/ 79:
/*!*****************************************************!*\
  !*** ./~/react-notification-system/dist/helpers.js ***!
  \*****************************************************/
/***/ function(module, exports) {

	var Helpers = {
	  timer: function(callback, delay) {
	    var timerId, start, remaining = delay;
	
	    this.pause = function() {
	        clearTimeout(timerId);
	        remaining -= new Date() - start;
	    };
	
	    this.resume = function() {
	        start = new Date();
	        clearTimeout(timerId);
	        timerId = setTimeout(callback, remaining);
	    };
	
	    this.clear = function() {
	      clearTimeout(timerId);
	    }
	
	    this.resume();
	  }
	}
	
	module.exports = Helpers;


/***/ },

/***/ 102:
/*!**************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/AttributeControl.js ***!
  \**************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _AttributeLoaderMixin = __webpack_require__(/*! ./mixin/AttributeLoaderMixin */ 51);
	
	var _AttributeLoaderMixin2 = _interopRequireDefault(_AttributeLoaderMixin);
	
	var _I18nStringsMixin = __webpack_require__(/*! ./mixin/I18nStringsMixin */ 53);
	
	var _I18nStringsMixin2 = _interopRequireDefault(_I18nStringsMixin);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _BoolControl = __webpack_require__(/*! ./BoolControl */ 103);
	
	var _BoolControl2 = _interopRequireDefault(_BoolControl);
	
	var _CheckboxGroup = __webpack_require__(/*! ./CheckboxGroup */ 64);
	
	var _CheckboxGroup2 = _interopRequireDefault(_CheckboxGroup);
	
	var _RadioGroup = __webpack_require__(/*! ./RadioGroup */ 50);
	
	var _RadioGroup2 = _interopRequireDefault(_RadioGroup);
	
	var _CodeEditor = __webpack_require__(/*! ./CodeEditor */ 104);
	
	var _CodeEditor2 = _interopRequireDefault(_CodeEditor);
	
	var _TextArea = __webpack_require__(/*! ./TextArea */ 112);
	
	var _TextArea2 = _interopRequireDefault(_TextArea);
	
	var _Input = __webpack_require__(/*! ./Input */ 49);
	
	var _Input2 = _interopRequireDefault(_Input);
	
	var _DateControl = __webpack_require__(/*! ./DateControl */ 105);
	
	var _DateControl2 = _interopRequireDefault(_DateControl);
	
	var _EntitySelectBox = __webpack_require__(/*! ./EntitySelectBox */ 106);
	
	var _EntitySelectBox2 = _interopRequireDefault(_EntitySelectBox);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var api = new _RestClientV2.default();
	
	/**
	 * REST entity attribute control
	 * 
	 * @memberOf component
	 */
	var AttributeControl = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _AttributeLoaderMixin2.default, _I18nStringsMixin2.default],
		displayName: 'AttributeControl',
		propTypes: {
			attr: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.object]),
			required: _react2.default.PropTypes.bool, // optional overwrite for attr.required
			readOnly: _react2.default.PropTypes.bool, // optional overwrite for attr.readOnly
			visible: _react2.default.PropTypes.bool, // optional overwrite for attr.visible
			disabled: _react2.default.PropTypes.bool, // optional overwrite for attr.disabled
			multiple: _react2.default.PropTypes.bool,
			focus: _react2.default.PropTypes.bool,
			onValueChange: _react2.default.PropTypes.func.isRequired,
			onBlur: _react2.default.PropTypes.func,
			categoricalMrefShowSelectAll: _react2.default.PropTypes.bool
		},
		getDefaultProps: function getDefaultProps() {
			return {
				focus: false,
				onBlur: function onBlur() {}
			};
		},
		getInitialState: function getInitialState() {
			return {
				attr: null,
				i18nStrings: null
			};
		},
		render: function render() {
			if (this.state.attr === null || this.state.i18nStrings === null) {
				// attribute not available yet
				return (0, _Spinner2.default)();
			}
	
			var props = this.props;
			var attr = this.state.attr;
	
			if (attr.expression === undefined) {
				// default props for all controls
				var controlProps = {
					id: props.id,
					name: attr.name,
					required: this._isRequired(),
					disabled: this._isDisabled(),
					readOnly: this._isReadOnly(),
					focus: this.props.focus,
					value: props.value,
					onValueChange: this._handleValueChange,
					onBlur: this.props.onBlur
				};
	
				switch (attr.fieldType) {
					case 'BOOL':
						return (0, _BoolControl2.default)(_underscore2.default.extend({}, controlProps, {
							label: props.label,
							layout: props.layout || 'horizontal'
						}));
					case 'CATEGORICAL':
						if (this.state.options === undefined) {
							// options not yet available
							return (0, _Spinner2.default)();
						}
	
						// convert entity to component value
						var value = props.value !== undefined ? props.value[attr.refEntity.idAttribute] : undefined;
	
						var CategoricalControl = props.multiple === true ? _CheckboxGroup2.default : _RadioGroup2.default;
						var options = this.state.options;
						if (CategoricalControl === _RadioGroup2.default && controlProps.required === false) {
							options = options.concat({ value: '', label: this.state.i18nStrings.form_bool_missing });
						}
	
						return CategoricalControl(_underscore2.default.extend({}, controlProps, {
							options: options,
							layout: props.layout || 'vertical',
							value: value,
							onValueChange: function (event) {
								// convert component value back to entity
								event.value = this._idValueToEntity(event.value);
								this._handleValueChange(event);
							}.bind(this)
						}));
					case 'CATEGORICAL_MREF':
						if (this.state.options === undefined) {
							// options not yet available
							return (0, _Spinner2.default)();
						}
	
						// convert entities to component values
						var values = props.value ? _underscore2.default.map(this._pagedValueToValue(props.value), function (item) {
							return item[attr.refEntity.idAttribute];
						}) : [];
						return (0, _CheckboxGroup2.default)(_underscore2.default.extend({}, controlProps, {
							options: this.state.options,
							selectAll: this.props.categoricalMrefShowSelectAll,
							layout: 'vertical', // FIXME make configurable
							value: values,
							onValueChange: function (event) {
								// convert component values back to entities
								event.value = this._valueToPagedValue(event.value);
								event.value.items = _underscore2.default.map(event.value.items, function (id) {
									return this._idValueToEntity(id);
								}.bind(this));
								this._handleValueChange(event);
							}.bind(this)
						}));
					case 'DATE':
						return this._createDateControl(controlProps, false, props.placeholder || this.state.i18nStrings.form_date_control_placeholder);
					case 'DATE_TIME':
						return this._createDateControl(controlProps, true, props.placeholder || this.state.i18nStrings.form_date_control_placeholder);
					case 'DECIMAL':
						return this._createStringControl(controlProps, 'text', props.placeholder || '');
					case 'EMAIL':
						return this._createStringControl(controlProps, 'email', props.placeholder || this.state.i18nStrings.form_email_control_placeholder);
					case 'ENUM':
						if (this.state.options === undefined) {
							// options not yet available
							return (0, _Spinner2.default)();
						}
	
						var EnumControl = props.multiple === true ? _CheckboxGroup2.default : _RadioGroup2.default;
						var options = this.state.options;
						if (EnumControl === _RadioGroup2.default && controlProps.required === false) {
							options = options.concat({ value: '', label: this.state.i18nStrings.form_bool_missing });
						}
	
						return EnumControl(_underscore2.default.extend({}, controlProps, {
							options: options,
							layout: props.layout
						}));
					case 'FILE':
						return this._createFileControl(controlProps);
					case 'HTML':
						return (0, _CodeEditor2.default)(_underscore2.default.extend({}, controlProps, {
							placeholder: this.props.placeholder,
							language: 'html',
							maxLength: attr.maxLength
						}));
					case 'HYPERLINK':
						return this._createStringControl(controlProps, 'url', props.placeholder || this.state.i18nStrings.form_url_control_placeholder);
					case 'INT':
					case 'LONG':
						return this._createNumberControl(controlProps, '1');
					case 'XREF':
						return this._createEntitySelectBox(controlProps, props.multiple || false, props.placeholder || this.state.i18nStrings.form_xref_control_placeholder, props.value);
					case 'MREF':
						return this._createEntitySelectBox(controlProps, props.multiple || true, props.placeholder || this.state.i18nStrings.form_mref_control_placeholder, props.value);
					case 'SCRIPT':
						return (0, _CodeEditor2.default)(_underscore2.default.extend({}, controlProps, {
							placeholder: this.props.placeholder
						}));
					case 'STRING':
						return this._createStringControl(controlProps, 'text', props.placeholder || '');
					case 'TEXT':
						return (0, _TextArea2.default)(_underscore2.default.extend({}, controlProps, {
							placeholder: this.props.placeholder,
							maxLength: attr.maxLength
						}));
					case 'COMPOUND':
						throw 'Unsupported data type: ' + attr.fieldType;
					default:
						throw 'Unknown data type: ' + attr.fieldType;
				}
			} else {
				return (0, _Input2.default)({
					type: 'text',
					disabled: true,
					placeholder: this.state.i18nStrings.form_computed_control_placeholder,
					onValueChange: function onValueChange() {}
				});
			}
		},
		_handleValueChange: function _handleValueChange(event) {
			this.props.onValueChange(_underscore2.default.extend({}, event, { attr: this.state.attr.name }));
		},
		_isRequired: function _isRequired() {
			return this.props.required !== undefined ? this.props.required : !this.state.attr.nillable;
		},
		_isVisible: function _isVisible() {
			return this.props.visible !== undefined ? this.props.visible : this.state.attr.visible;
		},
		_isDisabled: function _isDisabled() {
			return this.props.disabled !== undefined ? this.props.disabled : this.state.attr.disabled;
		},
		_isReadOnly: function _isReadOnly() {
			return this.props.readOnly !== undefined ? this.props.readOnly : this.state.attr.readOnly;
		},
		_createNumberControl: function _createNumberControl(controlProps, step) {
			var range = this.state.attr.range;
			var min = range ? range.min : undefined;
			var max = range ? range.max : undefined;
			var placeholder = this.props.placeholder || this.state.i18nStrings.form_number_control_placeholder;
	
			return (0, _Input2.default)(_underscore2.default.extend({}, controlProps, {
				type: 'number',
				placeholder: placeholder,
				step: step,
				min: min,
				max: max
			}));
		},
		_createFileControl: function _createFileControl(controlProps) {
			return (0, _Input2.default)(_underscore2.default.extend({}, controlProps, {
				type: 'file',
				value: this.props.value ? this.props.value.filename : null,
				onValueChange: function (event) {
					event.value = _underscore2.default.extend({}, this.state.attr.refEntity, { filename: event.value });
					this._handleValueChange(event);
				}.bind(this)
			}));
		},
		_createStringControl: function _createStringControl(controlProps, type, placeholder) {
			return (0, _Input2.default)(_underscore2.default.extend({}, controlProps, {
				type: type,
				placeholder: placeholder,
				maxLength: this.state.attr.maxLength
			}));
		},
		_createDateControl: function _createDateControl(controlProps, time, placeholder) {
			return (0, _DateControl2.default)(_underscore2.default.extend({}, controlProps, {
				placeholder: placeholder,
				time: time
			}));
		},
		_createEntitySelectBox: function _createEntitySelectBox(controlProps, multiple, placeholder, value) {
			return (0, _EntitySelectBox2.default)(_underscore2.default.extend({}, controlProps, {
				mode: 'create',
				placeholder: placeholder,
				multiple: multiple,
				entity: this.state.attr.refEntity,
				value: multiple ? this._pagedValueToValue(value) : value, // TODO same for CATEGORICAL_MREF
				onValueChange: multiple ? function (event) {
					event.value = this._valueToPagedValue(event.value);
					this._handleValueChange(event);
				}.bind(this) : this._handleValueChange
			}));
		},
		_pagedValueToValue: function _pagedValueToValue(value) {
			return value ? value.items : value;
		},
		_valueToPagedValue: function _valueToPagedValue(value) {
			if (value) {
				return {
					start: 0,
					num: value.length,
					total: value.length,
					items: value
				};
			} else {
				return {
					start: 0,
					num: 0,
					total: 0,
					items: []
				};
			}
		},
		_idValueToEntity: function _idValueToEntity(id) {
			if (id === null || id === undefined) {
				return undefined; // N/A selected
			}
	
			var refEntity = this.state.attr.refEntity;
			if (refEntity.attributes[refEntity.idAttribute].fieldType === 'INT' || refEntity.attributes[refEntity.idAttribute].fieldType === 'LONG') {
				id = parseInt(id);
			} else if (refEntity.attributes[refEntity.idAttribute].fieldType === 'DOUBLE') {
				id = parseInt(id);
			}
	
			var entity = {};
			entity[refEntity.idAttribute] = id;
			entity[refEntity.labelAttribute] = _underscore2.default.find(this.state.options, function (option) {
				return option.value === id;
			}).label;
			return entity;
		},
		_onAttrInit: function _onAttrInit() {
			var attr = this.state.attr;
			if (attr.fieldType === 'CATEGORICAL' || attr.fieldType === 'CATEGORICAL_MREF') {
				// retrieve all categories
				api.getAsync(attr.refEntity.hrefCollection).done(function (data) {
					// FIXME problems in case of large number of categories
					var idAttr = data.meta.idAttribute;
					var lblAttr = data.meta.labelAttribute;
	
					if (this.isMounted()) {
						var options = _underscore2.default.map(data.items, function (entity) {
							return { value: entity[idAttr], label: entity[lblAttr] };
						});
						this.setState({ options: options });
					}
				}.bind(this));
			} else if (attr.fieldType === 'ENUM') {
				var options = _underscore2.default.map(attr.enumOptions, function (option) {
					return { value: option, label: option };
				});
				this.setState({ options: options });
			}
		}
	});
	
	exports.default = _react2.default.createFactory(AttributeControl);

/***/ },

/***/ 103:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/BoolControl.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _I18nStringsMixin = __webpack_require__(/*! ./mixin/I18nStringsMixin */ 53);
	
	var _I18nStringsMixin2 = _interopRequireDefault(_I18nStringsMixin);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _CheckboxGroup = __webpack_require__(/*! ./CheckboxGroup */ 64);
	
	var _CheckboxGroup2 = _interopRequireDefault(_CheckboxGroup);
	
	var _RadioGroup = __webpack_require__(/*! ./RadioGroup */ 50);
	
	var _RadioGroup2 = _interopRequireDefault(_RadioGroup);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    label = _react2.default.DOM.label;
	
	/**
	 * Input control for BOOL type with checkbox or radio buttons
	 * 
	 * @memberOf component
	 */
	var BoolControl = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _I18nStringsMixin2.default],
		displayName: 'BoolControl',
		propTypes: {
			id: _react2.default.PropTypes.string,
			name: _react2.default.PropTypes.string,
			label: _react2.default.PropTypes.string,
			layout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
			type: _react2.default.PropTypes.oneOf(['single', 'group']),
			multiple: _react2.default.PropTypes.bool,
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.bool, _react2.default.PropTypes.array]),
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				type: 'single',
				layout: 'horizontal',
				required: true
			};
		},
		getInitialState: function getInitialState() {
			return {
				i18nStrings: null //loaded from server
			};
		},
		render: function render() {
			if (this.state.i18nStrings === null) {
				return (0, _Spinner2.default)();
			}
	
			var options = [{ value: 'true', label: this.state.i18nStrings.form_bool_true }, { value: 'false', label: this.state.i18nStrings.form_bool_false }];
			if (!this.props.required && !this.props.multiple) {
				options = options.concat({ value: '', label: this.state.i18nStrings.form_bool_missing });
			}
	
			var Element = this.props.multiple ? _CheckboxGroup2.default : _RadioGroup2.default;
			return Element({
				id: this.props.id,
				name: this.props.name,
				options: options,
				required: this.props.required,
				disabled: this.props.disabled,
				readOnly: this.props.readOnly,
				layout: this.props.layout,
				focus: this.props.focus,
				value: this._boolToString(this.props.value),
				onValueChange: this._handleValueChange
			});
		},
		_handleValueChange: function _handleValueChange(e) {
			this.props.onValueChange({ value: this._eventToBool(e) });
		},
		_boolToString: function _boolToString(value) {
			if (this.props.multiple) {
				// do not use $.map since it removes null values
				if (value !== undefined) {
					value = value.slice(0);
					for (var i = 0; i < value.length; ++i) {
						value[i] = value[i] === true ? 'true' : value[i] === false ? 'false' : value[i];
					}
				}
				return value;
			} else {
				return value === true ? 'true' : value === false ? 'false' : value;
			}
		},
		_eventToBool: function _eventToBool(e) {
			if (this.props.multiple) {
				// do not use $.map since it removes null values
				if (e.value !== undefined) {
					var value = [];
					for (var i = 0; i < e.value.slice(0).length; ++i) {
						value[i] = value[i] === 'true' ? true : value[i] === 'false' ? false : value[i];
					}
				}
				return value;
			} else if (e.checked !== undefined) {
				return e.checked;
			} else {
				return e.value === 'true' ? true : e.value === 'false' ? false : e.value;
			}
		}
	});
	
	exports.default = _react2.default.createFactory(BoolControl);

/***/ },

/***/ 104:
/*!********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/CodeEditor.js ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _Ace = __webpack_require__(/*! ./wrapper/Ace */ 72);
	
	var _Ace2 = _interopRequireDefault(_Ace);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * @memberOf component
	 */
	var CodeEditor = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'CodeEditor',
		propTypes: {
			id: _react2.default.PropTypes.string,
			name: _react2.default.PropTypes.string,
			placeholder: _react2.default.PropTypes.string,
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			maxLength: _react2.default.PropTypes.number,
			mode: _react2.default.PropTypes.oneOf(['ftl', 'html', 'javascript', 'json', 'markdown', 'markdown', 'mysql', 'python', 'r', 'plain_text', 'properties', 'text', 'xml']),
			value: _react2.default.PropTypes.string,
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		render: function render() {
			return (0, _Ace2.default)({
				id: this.props.id,
				name: this.props.name,
				placeholder: this.props.placeholder,
				required: this.props.required,
				disabled: this.props.disabled,
				readOnly: this.props.readOnly,
				maxLength: this.props.maxLength,
				mode: this.props.language,
				value: this.props.value,
				onChange: this._handleChange
			});
		},
		_handleChange: function _handleChange(value) {
			this.props.onValueChange({ value: value !== '' ? value : null });
		}
	});
	
	exports.default = _react2.default.createFactory(CodeEditor);

/***/ },

/***/ 105:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/DateControl.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DateTimePicker = __webpack_require__(/*! ./wrapper/DateTimePicker */ 117);
	
	var _DateTimePicker2 = _interopRequireDefault(_DateTimePicker);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * @memberOf component
	 */
	var DateControl = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'DateControl',
		propTypes: {
			name: _react2.default.PropTypes.string,
			time: _react2.default.PropTypes.bool,
			placeholder: _react2.default.PropTypes.string,
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.string,
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		render: function render() {
			return (0, _DateTimePicker2.default)({
				name: this.props.name,
				time: this.props.time,
				placeholder: this.props.placeholder,
				required: this.props.required,
				disabled: this.props.disabled,
				readOnly: this.props.readOnly,
				focus: this.props.focus,
				value: this.props.value,
				onChange: this._handleChange
			});
		},
		_handleChange: function _handleChange(value) {
			this.props.onValueChange({ value: value });
		}
	});
	
	exports.default = _react2.default.createFactory(DateControl);

/***/ },

/***/ 106:
/*!*************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/EntitySelectBox.js ***!
  \*************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _EntityLoaderMixin = __webpack_require__(/*! ./mixin/EntityLoaderMixin */ 52);
	
	var _EntityLoaderMixin2 = _interopRequireDefault(_EntityLoaderMixin);
	
	var _ReactLayeredComponentMixin = __webpack_require__(/*! ./mixin/ReactLayeredComponentMixin */ 40);
	
	var _ReactLayeredComponentMixin2 = _interopRequireDefault(_ReactLayeredComponentMixin);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _Select = __webpack_require__(/*! ./wrapper/Select2 */ 73);
	
	var _Select2 = _interopRequireDefault(_Select);
	
	var _Form = __webpack_require__(/*! ./Form */ 47);
	
	var _Form2 = _interopRequireDefault(_Form);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _HtmlUtils = __webpack_require__(/*! ../utils/HtmlUtils */ 75);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div;
	
	var api = new _RestClientV2.default();
	
	var EntitySelectBox = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _EntityLoaderMixin2.default, _ReactLayeredComponentMixin2.default],
		displayName: 'EntitySelectBox',
		propTypes: {
			entity: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.object]).isRequired,
			query: _react2.default.PropTypes.object,
			mode: _react2.default.PropTypes.oneOf(['view', 'create']),
			name: _react2.default.PropTypes.string,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			multiple: _react2.default.PropTypes.bool,
			required: _react2.default.PropTypes.bool,
			placeholder: _react2.default.PropTypes.string,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.object, _react2.default.PropTypes.array]),
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				mode: 'view'
			};
		},
		getInitialState: function getInitialState() {
			return {
				entity: null,
				modal: false
			};
		},
		render: function render() {
			if (this.state.entity === null) {
				// entity meta data not fetched yet
				return (0, _Spinner2.default)();
			}
	
			var props = this.props;
			var entity = this.state.entity;
	
			var options = {
				enable: !this.props.disabled,
				id: entity.idAttribute,
				multiple: props.multiple,
				allowClear: props.required ? false : true,
				placeholder: props.placeholder || ' ', // cannot be an empty string
				closeOnSelect: props.multiple !== true,
				query: this._select2Query,
				formatResult: this._select2FormatResult,
				formatSelection: this._select2FormatSelection
			};
	
			return (0, _Select2.default)({
				options: options,
				name: this.props.name,
				disabled: this.props.disabled,
				readOnly: this.props.readOnly,
				focus: this.props.focus,
				value: this.props.value,
				addonBtn: this.props.mode === 'create' && entity.writable === true,
				addonBtnTitle: this.props.mode === 'create' && entity.writable === true ? 'Create ' + this.state.entity.label : undefined,
				onAddonBtnClick: this._handleAddonBtnClick,
				onChange: this._handleChange
			});
		},
		renderLayer: function renderLayer() {
			if (this.state.entity === null) {
				return (0, _Spinner2.default)();
			} else if (this.props.mode === 'create') {
				return this.state.modal ? (0, _Form2.default)({
					entity: this.state.entity.name,
					showHidden: true,
					cancelBtn: true,
					modal: true,
					onSubmitCancel: this._onModalHide,
					onSubmitSuccess: this._onModalHide
				}) : div();
			} else {
				return div();
			}
		},
		_handleChange: function _handleChange(value) {
			var val = this.props.multiple && value.length === 0 ? undefined : value;
			this.props.onValueChange({ value: val });
		},
		_handleAddonBtnClick: function _handleAddonBtnClick() {
			this.setState({ modal: true });
		},
		_onModalHide: function _onModalHide() {
			this.setState({ modal: false });
		},
		_createQuery: function _createQuery(term) {
			var rules = [];
			var nestedRule = null;
	
			if (this.props.query) {
				rules.push(this.props.query);
				if (term.length > 0) {
					rules.push({ operator: 'AND' });
					nestedRule = { operator: 'NESTED', nestedRules: [] };
					rules.push(nestedRule);
				}
			}
	
			var likeRules = nestedRule === null ? rules : nestedRule.nestedRules;
			if (term.length > 0) {
				var attrs = this._getAttrs();
				for (var i = 0; i < attrs.length; ++i) {
					var operator = 'LIKE';
					switch (this.state.entity.attributes[attrs[i]].fieldType) {
						case 'INT':
						case 'LONG':
						case 'BOOL':
						case 'DATE':
						case 'DATE_TIME':
						case 'DECIMAL':
							operator = 'EQUALS';
							break;
						case 'TEXT':
							operator = 'SEARCH';
							break;
						case 'COMPOUND':
							continue;
					}
					if (i > 0) {
						likeRules.push({ operator: 'OR' });
					}
					likeRules.push({ field: attrs[i], operator: operator, value: term });
				}
			}
			return rules;
		},
		_select2FormatResult: function _select2FormatResult(item) {
			var attrs = this._getAttrs();
			if (attrs.length > 1) {
				var items = [];
				items.push('<div class="row">');
	
				var width = Math.round(12 / attrs.length); // FIXME fix in case of 5, 7 etc. lookup attributes
				for (var i = 0; i < attrs.length; ++i) {
					var attrName = attrs[i];
					var attrLabel = this.state.entity.attributes[attrName].label;
					var attrValue = item[attrName] !== undefined ? item[attrName] : '';
					items.push('<div class="col-md-' + width + '">');
					items.push((0, _HtmlUtils.htmlEscape)(attrLabel) + ': <b>' + (0, _HtmlUtils.htmlEscape)(attrValue) + '</b>');
					items.push('</div>');
				}
	
				items.push('</div>');
	
				return items.join('');
			} else {
				return item[attrs[0]];
			}
		},
		_select2FormatSelection: function _select2FormatSelection(item) {
			return item[this.state.entity.labelAttribute];
		},
		_select2Query: function _select2Query(query) {
			var num = 25;
			var q = {
				q: {
					start: (query.page - 1) * num,
					num: num,
					sort: {
						orders: [{
							direction: 'ASC',
							property: this._getAttrs()[0]
						}]
					},
					q: this._createQuery(query.term),
					expand: this._getAttrsWithRefEntity()
				}
			};
	
			api.getAsync(this.state.entity.hrefCollection, q).done(function (data) {
				query.callback({ results: data.items, more: data.nextHref ? true : false });
			});
		},
		_getAttrs: function _getAttrs() {
			// display lookup attributes in dropdown or label attribute if no lookup attributes are defined
			var entity = this.state.entity;
			if (entity.lookupAttributes && entity.lookupAttributes.length > 0) {
				return entity.lookupAttributes;
			} else {
				return [entity.labelAttribute];
			}
		},
		_getAttrsWithRefEntity: function _getAttrsWithRefEntity() {
			var attrsWithRefEntity = _underscore2.default.filter(this.state.entity.attributes, function (attr) {
				switch (attr.fieldType) {
					case 'CATEGORICAL':
					case 'CATEGORICAL_MREF':
					case 'MREF':
					case 'XREF':
						return true;
					default:
						return false;
				}
			});
			return _underscore2.default.map(attrsWithRefEntity, function (attr) {
				return attr.name;
			});
		}
	});
	
	exports.default = _react2.default.createFactory(EntitySelectBox);

/***/ },

/***/ 107:
/*!**************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/FormControlGroup.js ***!
  \**************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _AttributeLoaderMixin = __webpack_require__(/*! ./mixin/AttributeLoaderMixin */ 51);
	
	var _AttributeLoaderMixin2 = _interopRequireDefault(_AttributeLoaderMixin);
	
	var _FormControl = __webpack_require__(/*! ./FormControl */ 66);
	
	var _FormControl2 = _interopRequireDefault(_FormControl);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    p = _react2.default.DOM.p,
	    fieldset = _react2.default.DOM.fieldset,
	    legend = _react2.default.DOM.legend;;
	
	/**
	* @memberOf component
	*/
	var FormControlGroup = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _AttributeLoaderMixin2.default],
		displayName: 'FormControlGroup',
		propTypes: {
			entity: _react2.default.PropTypes.object,
			entityInstance: _react2.default.PropTypes.object,
			attr: _react2.default.PropTypes.object.isRequired,
			value: _react2.default.PropTypes.object,
			mode: _react2.default.PropTypes.oneOf(['create', 'edit', 'view']),
			formLayout: _react2.default.PropTypes.oneOf(['horizontal', 'vertical']),
			colOffset: _react2.default.PropTypes.number,
			errorMessages: _react2.default.PropTypes.object.isRequired,
			focus: _react2.default.PropTypes.bool,
			onValueChange: _react2.default.PropTypes.func.isRequired,
			onBlur: _react2.default.PropTypes.func.isRequired,
			categoricalMrefShowSelectAll: _react2.default.PropTypes.bool,
			showAsteriskIfNotNillable: _react2.default.PropTypes.bool
		},
		getInitialState: function getInitialState() {
			return {
				attr: null
			};
		},
		render: function render() {
			if (this.state.attr === null) {
				// attribute not available yet
				return (0, _Spinner2.default)();
			}
			var attributes = this.state.attr.attributes;
	
			// add control for each attribute
			var foundFocusControl = !this.props.focus;
			var controls = [];
			var hasVisible = false;
			for (var i = 0; i < attributes.length; ++i) {
				var attr = attributes[i];
				var ControlFactory = attr.fieldType === 'COMPOUND' ? FormControlGroupFactory : _FormControl2.default;
				var controlProps = {
					entity: this.props.entity,
					attr: attr,
					value: this.props.entityInstance ? this.props.entityInstance[attr.name] : undefined,
					entityInstance: this.props.entityInstance,
					mode: this.props.mode,
					formLayout: this.props.formLayout,
					colOffset: this.props.colOffset,
					saveOnBlur: this.props.saveOnBlur,
					validate: this.props.validate,
					onValueChange: this.props.onValueChange,
					onBlur: this.props.onBlur,
					categoricalMrefShowSelectAll: this.props.categoricalMrefShowSelectAll,
					showAsteriskIfNotNillable: this.props.showAsteriskIfNotNillable,
					key: '' + i
				};
	
				if (attr.fieldType === 'COMPOUND') {
					_underscore2.default.extend(controlProps, {
						errorMessages: this.props.errorMessages,
						hideOptional: this.props.hideOptional
					});
				} else {
					controlProps['errorMessage'] = this.props.errorMessages[attr.name];
				}
				// IE9 does not support the autofocus attribute, focus the first visible input manually
				if (!foundFocusControl && attr.visible === true) {
					_underscore2.default.extend(controlProps, { focus: true });
					foundFocusControl = true;
				}
	
				var Control = ControlFactory(controlProps);
				if (attr.nillable === true && this.props.hideOptional === true || attr.visibleExpression !== undefined && this.props.entity.allAttributes[attr.name].visible !== true) {
					Control = div({ className: 'hide' }, Control);
				} else {
					hasVisible = true;
				}
				controls.push(Control);
			}
	
			var Fieldset = fieldset({}, legend({}, this.props.attr.label), p({}, this.props.attr.description), div({ className: 'row' }, div({ className: 'col-md-offset-1 col-md-11' }, controls)));
	
			if (!hasVisible) {
				Fieldset = div({ className: 'hide' }, Fieldset);
			}
			return Fieldset;
		}
	});
	
	var FormControlGroupFactory = _react2.default.createFactory(FormControlGroup);
	exports.default = FormControlGroupFactory;

/***/ },

/***/ 108:
/*!***************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Pager.js ***!
  \***************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var ul = _react2.default.DOM.ul,
	    li = _react2.default.DOM.li,
	    div = _react2.default.DOM.div,
	    span = _react2.default.DOM.span,
	    a = _react2.default.DOM.a;
	
	/**
	 * @memberOf component
	 */
	var Pager = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Pager',
		propTypes: {
			nrItems: _react2.default.PropTypes.number.isRequired,
			nrItemsPerPage: _react2.default.PropTypes.number.isRequired,
			start: _react2.default.PropTypes.number.isRequired,
			onPageChange: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onPageChange: function onPageChange() {}
			};
		},
		render: function render() {
			var nrPages = Math.ceil(this.props.nrItems / this.props.nrItemsPerPage);
			if (nrPages === 0 || nrPages === 1) {
				return div();
			}
	
			var ListElements = [];
			var page = Math.floor(this.props.start / this.props.nrItemsPerPage) + 1;
	
			// previous page
			if (page === 1) {
				ListElements.push(li({ className: 'disabled', key: 'prev' }, span(null, 'Previous')));
			} else {
				ListElements.push(li({ className: 'page-prev', key: 'prev', onClick: this._handlePageChange.bind(this, page - 1) }, a({ href: '#' }, 'Previous')));
			}
	
			// pages
			for (var i = 1; i <= nrPages; ++i) {
				if (i === page) {
					ListElements.push(li({ className: 'active', key: '' + i }, span(null, i)));
				} else if (i === 1 || i === nrPages || i > page - 3 && i < page + 3 || i < 7 && page < 5 || i > nrPages - 6 && page > nrPages - 4) {
					ListElements.push(li({ className: 'page', onClick: this._handlePageChange.bind(this, i), key: '' + i }, a({ href: '#' }, i)));
				} else if (i === 2 || i === nrPages - 1) {
					ListElements.push(li({ className: 'disabled', key: '' + i }, span(null, '...')));
				}
			}
	
			// next page
			if (page === nrPages) {
				ListElements.push(li({ className: 'disabled', key: 'next' }, span(null, 'Next')));
			} else {
				ListElements.push(li({ className: 'page-next', onClick: this._handlePageChange.bind(this, page + 1), key: 'next' }, a({ href: '#' }, 'Next')));
			}
	
			return ul({ className: 'pagination', style: { margin: 0 } }, ListElements);
		},
		_handlePageChange: function _handlePageChange(page) {
			this.props.onPageChange({
				page: page,
				start: (page - 1) * this.props.nrItemsPerPage
			});
		}
	});
	
	exports.default = _react2.default.createFactory(Pager);

/***/ },

/***/ 109:
/*!*****************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Popover.js ***!
  \*****************************************************************/
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function($) {"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var span = _react2.default.DOM.span;
	
	/**
	 * @memberOf component
	 */
	var Popover = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Popover',
		propTypes: {
			value: _react2.default.PropTypes.string.isRequired,
			popoverValue: _react2.default.PropTypes.string.isRequired
		},
		componentDidMount: function componentDidMount() {
			var $container = $(this.refs.popover.getDOMNode());
			$container.popover({
				trigger: 'hover click',
				placement: 'bottom',
				container: 'body'
			});
		},
		componentWillUnmount: function componentWillUnmount() {
			var $container = $(this.refs.popover.getDOMNode());
			$container.popover('destroy');
		},
		render: function render() {
			return span({
				'data-content': this.props.popoverValue,
				'data-toggle': 'popover',
				ref: 'popover'
			}, this.props.value);
		}
	});
	
	exports.default = _react2.default.createFactory(Popover);
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(/*! jquery */ 5)))

/***/ },

/***/ 110:
/*!*******************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/SelectBox.js ***!
  \*******************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div;
	var select = _react2.default.DOM.select;
	var option = _react2.default.DOM.option;
	
	/**
	 * @memberOf component
	 */
	var SelectBox = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'SelectBox',
		propTypes: {
			options: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.shape({
				value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
				text: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number])
			})),
			value: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]),
			onChange: _react2.default.PropTypes.func.isRequired
		},
		getDefaultProps: function getDefaultProps() {
			return {
				options: []
			};
		},
		getInitialState: function getInitialState() {
			return {
				value: this.props.value
			};
		},
		render: function render() {
			return select({ className: 'form-control', value: this.state.value, onChange: this._handleChange }, this.props.options.map(function (item, i) {
				return option({ value: item.value, key: item.value }, item.text);
			}));
		},
		_handleChange: function _handleChange(e) {
			this.setState({ value: e.target.value });
			this.props.onChange(e);
		}
	});
	
	exports.default = _react2.default.createFactory(SelectBox);

/***/ },

/***/ 111:
/*!***************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Table.js ***!
  \***************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Table = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV2 */ 41);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _SelectBox = __webpack_require__(/*! ./SelectBox */ 110);
	
	var _SelectBox2 = _interopRequireDefault(_SelectBox);
	
	var _Pager = __webpack_require__(/*! ./Pager */ 108);
	
	var _Pager2 = _interopRequireDefault(_Pager);
	
	var _Icon = __webpack_require__(/*! ./Icon */ 48);
	
	var _Icon2 = _interopRequireDefault(_Icon);
	
	var _Popover = __webpack_require__(/*! ./Popover */ 109);
	
	var _Popover2 = _interopRequireDefault(_Popover);
	
	var _ReactLayeredComponentMixin = __webpack_require__(/*! ./mixin/ReactLayeredComponentMixin */ 40);
	
	var _ReactLayeredComponentMixin2 = _interopRequireDefault(_ReactLayeredComponentMixin);
	
	var _Modal = __webpack_require__(/*! ./Modal */ 39);
	
	var _Modal2 = _interopRequireDefault(_Modal);
	
	var _Form = __webpack_require__(/*! ./Form */ 47);
	
	var _Form2 = _interopRequireDefault(_Form);
	
	var _Dialog = __webpack_require__(/*! ./Dialog */ 65);
	
	var _Dialog2 = _interopRequireDefault(_Dialog);
	
	var _AttributeFunctions = __webpack_require__(/*! rest-client/AttributeFunctions */ 74);
	
	__webpack_require__(/*! ./css/Table.css */ 413);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    table = _react2.default.DOM.table,
	    thead = _react2.default.DOM.thead,
	    tbody = _react2.default.DOM.tbody,
	    tr = _react2.default.DOM.tr,
	    th = _react2.default.DOM.th,
	    td = _react2.default.DOM.td,
	    a = _react2.default.DOM.a,
	    span = _react2.default.DOM.span,
	    em = _react2.default.DOM.em,
	    br = _react2.default.DOM.br,
	    label = _react2.default.DOM.label;
	
	var api = new _RestClientV2.default();
	
	/**
	 * @memberOf component.mixin
	 */
	var AttrUtilsMixin = {
		_isSelectedAttr: function _isSelectedAttr(attr, selectedAttrs) {
			return selectedAttrs['*'] !== undefined || selectedAttrs[attr.name] !== undefined;
		},
		_isExpandedAttr: function _isExpandedAttr(attr, selectedAttrs) {
			return selectedAttrs[attr.name] !== null && selectedAttrs[attr.name] !== undefined;
		},
		_canExpandAttr: function _canExpandAttr(attr, path) {
			// expanding mrefs in expanded attr not supported
			return (0, _AttributeFunctions.isRefAttr)(attr) && !((0, _AttributeFunctions.isMrefAttr)(attr) && _underscore2.default.size(path) > 0);
		}
	};
	
	/**
	 * @memberOf component
	 */
	var Table = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, AttrUtilsMixin],
		displayName: 'Table',
		propTypes: {
			entity: _react2.default.PropTypes.string.isRequired,
			attrs: _react2.default.PropTypes.object,
			query: _react2.default.PropTypes.object,
			sort: _react2.default.PropTypes.object,
			maxRows: _react2.default.PropTypes.number,
			onRowAdd: _react2.default.PropTypes.func,
			onRowEdit: _react2.default.PropTypes.func,
			onRowDelete: _react2.default.PropTypes.func,
			onRowInspect: _react2.default.PropTypes.func,
			onRowClick: _react2.default.PropTypes.func,
			onExecute: _react2.default.PropTypes.func,
			enableAdd: _react2.default.PropTypes.bool,
			enableEdit: _react2.default.PropTypes.bool,
			enableDelete: _react2.default.PropTypes.bool,
			enableInspect: _react2.default.PropTypes.bool,
			enableExecute: _react2.default.PropTypes.bool,
			onSort: _react2.default.PropTypes.func,
			defaultSelectFirstRow: _react2.default.PropTypes.bool,
			selectedRow: _react2.default.PropTypes.object
		},
		getInitialState: function getInitialState() {
			return {
				data: null,
				attrs: this.props.attrs,
				sort: this.props.sort,
				start: 0,
				maxRows: this.props.maxRows
			};
		},
		getDefaultProps: function getDefaultProps() {
			return {
				attrs: { '*': null },
				maxRows: 20,
				onRowAdd: function onRowAdd() {},
				onRowEdit: function onRowEdit() {},
				onRowDelete: function onRowDelete() {},
				onRowInspect: null,
				enableAdd: true,
				enableEdit: true,
				enableDelete: true,
				enableInspect: true,
				enableExecute: false,
				onRowClick: null,
				onExecute: null,
				onSort: function onSort() {},
				defaultSelectFirstRow: false,
				selectedRow: null
			};
		},
		componentDidMount: function componentDidMount() {
			this._refreshData(this.props, this.state);
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			// reset pager on query change
			var nextState = _underscore2.default.extend({}, this.state, { attrs: nextProps.attrs });
			if (JSON.stringify(this.props.query) !== JSON.stringify(nextProps.query)) {
				_underscore2.default.extend(nextState, { start: 0 });
			}
			this._refreshData(nextProps, nextState);
		},
		render: function render() {
			if (this.state.data === null) {
				return (0, _Spinner2.default)(); // entity not available yet
			}
	
			var writable = this.state.data.meta.writable;
	
			var TableHeader = TableHeaderFactory({
				entity: this.state.data.meta,
				attrs: this.state.attrs,
				sort: this.state.sort,
				enableAdd: writable && this.props.enableAdd === true,
				enableEdit: writable && this.props.enableEdit === true,
				enableDelete: writable && this.props.enableDelete === true,
				enableInspect: this.props.enableInspect === true && this.props.onRowInspect !== null,
				enableExecute: this.props.enableExecute === true && this.props.onExecute != null,
				onSort: this._handleSort,
				onExpand: this._handleExpand,
				onCollapse: this._handleCollapse,
				onCreate: this._handleCreate,
				onExecute: this.props.onExecute
			});
	
			var TableBody = TableBodyFactory({
				data: this.state.data,
				attrs: this.state.attrs,
				enableEdit: writable && this.props.enableEdit === true,
				enableDelete: writable && this.props.enableDelete === true,
				enableInspect: this.props.enableInspect === true && this.props.onRowInspect !== null,
				enableExecute: this.props.enableExecute === true && this.props.onExecute != null,
				onEdit: this._handleEdit,
				onDelete: this._handleDelete,
				onRowInspect: this.props.onRowInspect,
				onRowClick: this.props.onRowClick,
				onExecute: this.props.onExecute,
				selectedRow: this.props.selectedRow
			});
	
			var className = 'table table-striped table-condensed table-bordered molgenis-table';
	
			if (this.props.onRowClick !== null) className = className + " table-hover";
	
			return div(null, div({ className: 'molgenis-table-container' }, table({ className: className }, TableHeader, TableBody)), div({ className: 'row' }, div({ className: 'col-md-3 form-inline' }, div({
				'className': 'form-group'
			}, label(null, "Rows per page: " + String.fromCharCode(160)), (0, _SelectBox2.default)({
				options: [{ value: 20, text: 20 }, { value: 30, text: 30 }, { value: 50, text: 50 }, { value: 100, text: 100 }],
				onChange: this._handleRowsPerPageChange
			}))), div({ className: 'col-md-6' }, div({ className: 'text-center' }, (0, _Pager2.default)({
				nrItems: this.state.data.total,
				nrItemsPerPage: this.state.maxRows,
				start: this.state.data.start,
				onPageChange: this._handlePageChange
			}))), div({ className: 'col-md-3' }, span({ className: 'pull-right' }, em(null, this.state.data.total + ' item' + (this.state.data.total !== 1 ? 's' : '') + ' found')))));
		},
		_refreshData: function _refreshData(props, state) {
			var opts = {
				attrs: { '~id': null }, // always include the id attribute
				num: state.maxRows
			};
	
			// add selected attrs
			if (state.attrs && _underscore2.default.size(state.attrs) > 0) {
				_underscore2.default.extend(opts.attrs, state.attrs);
			}
	
			if (props.query) {
				opts.q = props.query.q;
			}
			if (state.sort) {
				opts.sort = {
					'orders': [{
						'attr': state.sort.attr.name,
						'direction': state.sort.order
					}]
				};
			}
			if (state.start !== 0) {
				opts.start = state.start;
			}
			api.get(props.entity, opts).done(function (data) {
				var newState = _underscore2.default.extend({}, state, { data: data });
				if (this.isMounted()) {
					if (this.props.onRowClick !== null && this.props.defaultSelectFirstRow === true && this.props.selectedRow === null && data && data.items && data.items.length > 0) {
						this.props.onRowClick(data.items[0]);
					}
					this.setState(newState);
				}
			}.bind(this));
		},
		_handleExpand: function _handleExpand(e) {
			var attrs = JSON.parse(JSON.stringify(this.state.attrs)); // deep clone
	
			for (var i = 0, attrsAtDepth = attrs; i < e.attrPath.length; ++i) {
				var attr = e.attrPath[i];
				if (!attrsAtDepth[attr]) {
					attrsAtDepth[attr] = i < e.attrPath.length - 1 ? {} : { '*': null };
				}
				attrsAtDepth = attrsAtDepth[attr];
			}
	
			this._refreshData(this.props, _underscore2.default.extend({}, this.state, { attrs: attrs }));
		},
		_handleCollapse: function _handleCollapse(e) {
			var attrs = _underscore2.default.extend({}, this.state.attrs);
	
			for (var i = 0, attrsAtDepth = attrs; i < e.attrPath.length; ++i) {
				var attr = e.attrPath[i];
				if (i < e.attrPath.length - 1) {
					attrsAtDepth = attrsAtDepth[attr];
				} else {
					attrsAtDepth[attr] = null;
				}
			}
	
			this._refreshData(this.props, _underscore2.default.extend({}, this.state, { attrs: attrs }));
		},
		_handleCreate: function _handleCreate() {
			this._resetTable();
			this.props.onRowAdd();
		},
		_handleEdit: function _handleEdit() {
			this._resetTable();
			this.props.onRowEdit();
		},
		_handleDelete: function _handleDelete() {
			this._resetTable();
			this.props.onRowDelete();
		},
		_resetTable: function _resetTable() {
			this._refreshData(this.props, _underscore2.default.extend({}, this.state, { start: 0 }));
		},
		_handleSort: function _handleSort(e) {
			this._refreshData(this.props, _underscore2.default.extend({}, this.state, { sort: e }));
			this.props.onSort(e);
		},
		_handlePageChange: function _handlePageChange(e) {
			this._refreshData(this.props, _underscore2.default.extend({}, this.state, { start: e.start }));
		},
		_handleRowsPerPageChange: function _handleRowsPerPageChange(e) {
			this._refreshData(this.props, _underscore2.default.extend({}, this.state, {
				start: 0,
				maxRows: parseInt(e.target.value)
			}));
		}
	});
	
	/**
	 * @memberOf component
	 */
	var TableHeader = _react2.default.createClass({
		mixins: [AttrUtilsMixin],
		displayName: 'TableHeader',
		propTypes: {
			entity: _react2.default.PropTypes.object.isRequired,
			attrs: _react2.default.PropTypes.object.isRequired,
			sort: _react2.default.PropTypes.object,
			onSort: _react2.default.PropTypes.func,
			onExpand: _react2.default.PropTypes.func,
			onCollapse: _react2.default.PropTypes.func,
			onCreate: _react2.default.PropTypes.func,
			enableAdd: _react2.default.PropTypes.bool,
			enableEdit: _react2.default.PropTypes.bool,
			enableDelete: _react2.default.PropTypes.bool,
			enableInspect: _react2.default.PropTypes.bool,
			enableExecute: _react2.default.PropTypes.bool
		},
		render: function render() {
			return thead(null, tr(null, this._createHeaders(this.props.attrs)));
		},
		_createHeaders: function _createHeaders(attrs) {
			var Headers = [];
			if (this.props.enableAdd === true) {
				Headers.push(th({ className: 'compact', key: 'add' }, EntityCreateBtnFactory({
					entity: this.props.entity,
					onCreate: this.props.onCreate
				})));
			}
			if (this.props.enableAdd === false && this.props.enableEdit === true) {
				Headers.push(th({ className: 'compact', key: 'edit' }));
			}
			if (this.props.enableDelete === true) {
				Headers.push(th({ className: 'compact', key: 'delete' }));
			}
			if (this.props.enableInspect) {
				Headers.push(th({ className: 'compact', key: 'inspect' }));
			}
			if (this.props.enableExecute) {
				Headers.push(th({ className: 'compact', key: 'execute' }));
			}
			this._createHeadersRec(this.props.entity.attributes, attrs, Headers, [], false);
			return Headers;
		},
		_createHeadersRec: function _createHeadersRec(attrs, selectedAttrs, Headers, path, expanded) {
			if (_underscore2.default.size(selectedAttrs) > 0) {
				for (var i = 0; i < attrs.length; ++i) {
					if (attrs[i].visible === true) {
						var attr = attrs[i];
						if (this._isSelectedAttr(attr, selectedAttrs)) {
							if ((0, _AttributeFunctions.isCompoundAttr)(attr)) {
								// for a selected compound attribute select all child attributes (= the wildcard),
								// child attributes might be expanded so include the selected attributes as well when recursing
								this._createHeadersRec(attr.attributes, _underscore2.default.extend({ '*': null }, selectedAttrs), Headers, path, expanded);
							} else {
								var attrPath = path.concat(attr.name);
								if (this._isExpandedAttr(attr, selectedAttrs)) {
									var EntityCollapseBtn = EntityCollapseBtnFactory({
										attrPath: attrPath,
										onCollapse: this.props.onCollapse
									});
									Headers.push(th({ className: 'expanded-left compact', key: 'c' + attrPath.join() }, EntityCollapseBtn));
									this._createHeadersRec(attr.refEntity.attributes, selectedAttrs[attr.name], Headers, path.concat(attr.name), true);
								} else {
									if (this._canExpandAttr(attr, path)) {
										var EntityExpandBtn = EntityExpandBtnFactory({
											attrPath: attrPath,
											onExpand: this.props.onExpand
										});
										Headers.push(th({ className: 'compact', key: 'e' + attrPath.join() }, EntityExpandBtn));
									}
									var TableHeaderCell = TableHeaderCellFactory({
										className: i === attrs.length - 1 && expanded ? 'expanded-right' : undefined,
										attr: attr,
										path: path,
										canSort: path.length === 0, // only allow sorting of top-level attributes
										sortOrder: this._getSortOrder(attr, path),
										onSort: this.props.onSort,
										key: attrPath.join()
									});
									Headers.push(TableHeaderCell);
								}
							}
						}
					}
				}
			} else {
				// add an empty non-compacted column so that compact column stay compact
				Headers.push(th({ key: 'dummy' }));
			}
		},
		_getSortOrder: function _getSortOrder(attr, path) {
			var sort = this.props.sort;
			return sort && this._getAttrId(sort.attr, sort.path) === this._getAttrId(attr, path) ? sort.order : null;
		},
		_getAttrId: function _getAttrId(attr, path) {
			return path.concat(attr.name).join('.');
		}
	});
	var TableHeaderFactory = _react2.default.createFactory(TableHeader);
	
	/**
	 * @memberOf component
	 */
	var TableHeaderCell = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, AttrUtilsMixin],
		displayName: 'TableHeaderCell',
		propTypes: {
			attr: _react2.default.PropTypes.object.isRequired,
			path: _react2.default.PropTypes.array.isRequired,
			canSort: _react2.default.PropTypes.bool,
			sortOrder: _react2.default.PropTypes.oneOf(['asc', 'desc']),
			onSort: _react2.default.PropTypes.func,
			className: _react2.default.PropTypes.string
		},
		getDefaultProps: function getDefaultProps() {
			return {
				sortOrder: null,
				onSort: function onSort() {}
			};
		},
		render: function render() {
			var SortIcon = this.props.sortOrder !== null ? (0, _Icon2.default)({
				style: { marginLeft: 5 },
				name: this.props.sortOrder === 'asc' ? 'sort-by-alphabet' : 'sort-by-alphabet-alt'
			}) : null;
	
			var Label = this.props.attr.description ? span(null, (0, _Popover2.default)({
				value: this.props.attr.label,
				popoverValue: this.props.attr.description
			})) : this.props.attr.label;
	
			return th({ className: this.props.className }, this.props.canSort ? span({ style: { cursor: 'pointer' }, onClick: this._handleSort }, Label, SortIcon) : Label);
		},
		_handleSort: function _handleSort(e) {
			this.props.onSort({
				attr: this.props.attr,
				path: this.props.path,
				order: this.props.sortOrder === null ? 'asc' : this.props.sortOrder === 'asc' ? 'desc' : 'asc'
			});
		}
	});
	var TableHeaderCellFactory = _react2.default.createFactory(TableHeaderCell);
	
	/**
	 * @memberOf component
	 */
	var TableBody = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, AttrUtilsMixin],
		displayName: 'TableBody',
		propTypes: {
			data: _react2.default.PropTypes.object.isRequired,
			attrs: _react2.default.PropTypes.object.isRequired,
			enableEdit: _react2.default.PropTypes.bool,
			enableDelete: _react2.default.PropTypes.bool,
			enableInspect: _react2.default.PropTypes.bool,
			enableExecute: _react2.default.PropTypes.bool,
			onEdit: _react2.default.PropTypes.func,
			onDelete: _react2.default.PropTypes.func,
			onRowInspect: _react2.default.PropTypes.func,
			onRowClick: _react2.default.PropTypes.func,
			onExecute: _react2.default.PropTypes.func,
			selectedRow: _react2.default.PropTypes.object
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onEdit: function onEdit() {},
				onDelete: function onDelete() {},
				onRowInspect: function onRowInspect() {},
				onRowClick: function onRowClick() {},
				onExecute: function onExecute() {},
				selectedRow: null
			};
		},
		render: function render() {
			return tbody(null, this._createRows(this.props.data.meta));
		},
		_createRows: function _createRows(entity) {
			var Rows = [];
			for (var i = 0; i < this.props.data.items.length; ++i) {
				var item = this.props.data.items[i];
	
				Rows.push(tr({
					key: '' + i,
					className: this.props.selectedRow && this.props.selectedRow.id === item.id ? 'info' : '',
					onClick: this.props.onRowClick !== null ? this.props.onRowClick.bind(null, item) : null
				}, this._createCols(item, entity)));
			}
			return Rows;
		},
		_createCols: function _createCols(item, entity) {
			var Cols = [];
			if (this.props.enableEdit === true) {
				var EntityEditBtn = EntityEditBtnFactory({
					name: entity.name,
					id: item[entity.idAttribute],
					onEdit: this.props.onEdit
				});
				Cols.push(td({ className: 'compact', key: 'edit' }, EntityEditBtn));
			}
			if (this.props.enableDelete === true) {
				var EntityDeleteBtn = EntityDeleteBtnFactory({
					name: entity.name,
					id: item[entity.idAttribute],
					onDelete: this.props.onDelete
				});
				Cols.push(td({ className: 'compact', key: 'delete' }, EntityDeleteBtn));
			}
			if (this.props.enableInspect === true && this.props.onRowInspect !== null) {
				var EntityInspectBtn = EntityInspectBtnFactory({
					name: entity.name,
					id: item[entity.idAttribute],
					onInspect: this.props.onRowInspect
				});
				Cols.push(td({ className: 'compact', key: 'inspect' }, EntityInspectBtn));
			}
			if (this.props.enableExecute === true && this.props.onExecute !== null) {
				var EntityExecuteBtn = EntityExecuteBtnFactory({
					name: entity.name,
					id: item[entity.idAttribute],
					onExecute: this.props.onExecute
				});
				Cols.push(td({ className: 'compact', key: 'execute' }, EntityExecuteBtn));
			}
			this._createColsRec(item, entity, entity.attributes, this.props.attrs, Cols, [], false, undefined);
			return Cols;
		},
		_createColsRec: function _createColsRec(item, entity, attrs, selectedAttrs, Cols, path, expanded, parentAttr) {
			if (_underscore2.default.size(selectedAttrs) > 0) {
				for (var j = 0; j < attrs.length; ++j) {
					var attr = attrs[j];
					if (this._isSelectedAttr(attr, selectedAttrs)) {
						if (attr.visible === true) {
							var attrPath = path.concat(attr.name);
							if ((0, _AttributeFunctions.isCompoundAttr)(attr)) {
								this._createColsRec(item, entity, attr.attributes, { '*': null }, Cols, path, expanded, parentAttr);
							} else {
	
								if (this._isExpandedAttr(attr, selectedAttrs)) {
									Cols.push(td({ className: 'expanded-left', key: attrPath.join() }));
									var value = item !== undefined && item !== null ? _underscore2.default.isArray(item) ? _underscore2.default.map(item, function (value) {
										return value[attr.name];
									}) : item[attr.name] : null;
									this._createColsRec(value, attr.refEntity, attr.refEntity.attributes, selectedAttrs[attr.name], Cols, attrPath, true, attr);
								} else {
									if (this._canExpandAttr(attr, path)) {
										Cols.push(td({ key: 'e' + attrPath.join() }));
									}
									var value = item !== undefined && item !== null ? _underscore2.default.isArray(item) ? _underscore2.default.map(item, function (value) {
										return value[attr.name];
									}) : item[attr.name] : null;
									var TableCell = TableCellFactory({
										className: j === attrs.length - 1 && expanded ? 'expanded-right' : undefined,
										entity: entity,
										attr: attr,
										value: value,
										expanded: expanded,
										onEdit: this.props.onEdit,
										key: attrPath.join(),
										parentAttr: parentAttr
									});
									Cols.push(TableCell);
								}
							}
						}
					}
				}
			} else {
				// add an empty non-compacted column so that compact column stay compact
				Cols.push(td({ key: 'dummy' }));
			}
		}
	});
	var TableBodyFactory = _react2.default.createFactory(TableBody);
	
	/**
	 * @memberOf component
	 */
	var TableCell = _react2.default.createClass({
		displayName: 'TableCell',
		mixins: [AttrUtilsMixin],
		propTypes: {
			entity: _react2.default.PropTypes.object.isRequired,
			attr: _react2.default.PropTypes.object.isRequired,
			value: _react2.default.PropTypes.any,
			expanded: _react2.default.PropTypes.bool,
			className: _react2.default.PropTypes.string,
			onEdit: _react2.default.PropTypes.func,
			parentAttr: _react2.default.PropTypes.object
		},
		shouldComponentUpdate: function shouldComponentUpdate(nextProps, nextState) {
			return !_underscore2.default.isEqual(this.state, nextState) || !_underscore2.default.isEqual(this.props.entity.name, nextProps.entity.name) || !_underscore2.default.isEqual(this.props.attr.name, nextProps.attr.name) || !_underscore2.default.isEqual(this.props.value, nextProps.value);
		},
		render: function render() {
			var CellContentBlocks;
			// treat expanded mref differently
			if (this.props.expanded && _underscore2.default.isArray(this.props.value) && (this.props.parentAttr.fieldType === 'MREF' || this.props.parentAttr.fieldType === 'CATEGORICAL_MREF')) {
				CellContentBlocks = _underscore2.default.flatten(_underscore2.default.map(this.props.value, function (value, i) {
					if (value !== null && value !== undefined) {
						var CellContentForValue = this._createTableCellContent(value, 'c' + i);
						return i < this.props.value.length - 1 ? [CellContentForValue, br({ key: 'b' + i })] : CellContentForValue;
					} else {
						return br();
					}
				}.bind(this)));
			} else {
				CellContentBlocks = this.props.value !== null && this.props.value !== undefined ? [this._createTableCellContent(this.props.value)] : [];
			}
	
			return td({ className: this.props.className }, CellContentBlocks);
		},
		_createTableCellContent: function _createTableCellContent(value, key) {
			return TableCellContentFactory({
				entity: this.props.entity,
				attr: this.props.attr,
				value: value,
				className: this.props.className,
				onEdit: this.props.onEdit,
				key: key
			});
		}
	});
	var TableCellFactory = _react2.default.createFactory(TableCell);
	
	/**
	 * @memberOf component
	 */
	var TableCellContent = _react2.default.createClass({
		mixins: [AttrUtilsMixin, _ReactLayeredComponentMixin2.default],
		displayName: 'TableCellContent',
		propTypes: {
			entity: _react2.default.PropTypes.object.isRequired,
			attr: _react2.default.PropTypes.object.isRequired,
			value: _react2.default.PropTypes.any,
			className: _react2.default.PropTypes.string,
			onEdit: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onEdit: function onEdit() {}
			};
		},
		getInitialState: function getInitialState() {
			return {
				showRef: false
			};
		},
		shouldComponentUpdate: function shouldComponentUpdate(nextProps, nextState) {
			return !_underscore2.default.isEqual(this.state, nextState) || !_underscore2.default.isEqual(this.props.entity.name, nextProps.entity.name) || !_underscore2.default.isEqual(this.props.attr.name, nextProps.attr.name) || !_underscore2.default.isEqual(this.props.value, nextProps.value);
		},
		render: function render() {
			return this._createValue(this.props.value);
		},
		renderLayer: function renderLayer() {
			if (this.state.showRef) {
				var refEntity = this.props.attr.refEntity;
	
				var operator, value;
				if ((0, _AttributeFunctions.isXrefAttr)(this.props.attr)) {
					operator = 'EQUALS';
					value = this.props.value[refEntity.idAttribute];
				} else {
					operator = 'IN';
					value = _underscore2.default.map(this.props.value, function (item) {
						return item[refEntity.idAttribute];
					});
				}
	
				var nestedTable = TableFactory({
					entity: this.props.attr.refEntity.name,
					query: {
						'q': [{
							'field': refEntity.idAttribute,
							'operator': operator,
							'value': value
						}]
					},
					enableAdd: false,
					enableDelete: false,
					enableInspect: false,
					onRowEdit: function (e) {
						this.props.onEdit(e);
					}.bind(this)
				});
	
				var OkBtn = div({ className: 'row', style: { textAlign: 'right' } }, div({ className: 'col-md-12' }, (0, _Button2.default)({ text: 'Ok', style: 'primary', onClick: this._toggleModal.bind(null, false) }, 'Ok')));
	
				return (0, _Modal2.default)({
					title: this.props.attr.label,
					show: true,
					onHide: this._toggleModal.bind(null, false)
				}, nestedTable, OkBtn);
			} else {
				return null;
			}
		},
		_createValue: function _createValue(value) {
			var CellContent,
			    attr = this.props.attr;
	
			if (value === undefined || value === null) {
				CellContent = span(null, String.fromCharCode(160)); // &nbsp;
			} else {
					switch (attr.fieldType) {
						case 'BOOL':
							CellContent = span(null, value.toString());
							break;
						case 'CATEGORICAL':
						case 'XREF':
							if (attr.expression) {
								// computed refs refer to entities that only exist within the context of entity that refers to them
								CellContent = span(null, value[attr.refEntity.labelAttribute]);
							} else {
								CellContent = a({ href: '#', onClick: this._toggleModal.bind(null, true) }, span(null, value[attr.refEntity.labelAttribute]));
							}
							break;
						case 'FILE':
							CellContent = div(null, a({ href: '#', onClick: this._toggleModal.bind(null, true) }, span(null, value[attr.refEntity.labelAttribute])), ' ', a({ href: value['url'] }, (0, _Icon2.default)({
								name: 'download',
								style: { cursor: 'pointer' }
							})));
							break;
						case 'CATEGORICAL_MREF':
						case 'MREF':
							CellContent = span(null, _underscore2.default.flatten(_underscore2.default.map(value, function (item, i) {
								var Element;
								if (attr.expression) {
									// computed refs refer to entities that only exist within the context of entity that refers to them
									Element = span(null, item[attr.refEntity.labelAttribute]);
								} else {
									Element = a({ href: '#', onClick: this._toggleModal.bind(null, true), key: 'a' + i }, span(null, item[attr.refEntity.labelAttribute]));
								}
								var Seperator = i < value.length - 1 ? span({ key: 's' + i }, ',') : null;
								return [Element, Seperator];
							}.bind(this))));
							break;
						case 'EMAIL':
							CellContent = a({ href: 'mailto:' + value }, value);
							break;
						case 'HYPERLINK':
							CellContent = a({ href: value, target: '_blank' }, value);
							break;
						case 'HTML':
						case 'SCRIPT':
						case 'TEXT':
							var maxLength = 50;
							if (value.length > maxLength) {
								CellContent = span(null, (0, _Popover2.default)({
									value: value.substring(0, maxLength - 3) + '...',
									popoverValue: value
								}));
							} else {
								CellContent = span(null, value);
							}
							break;
						default:
							CellContent = span(null, value);
							break;
					}
				}
	
			return CellContent;
		},
		_toggleModal: function _toggleModal(show) {
			this.setState({
				showRef: show
			});
		}
	});
	var TableCellContentFactory = _react2.default.createFactory(TableCellContent);
	
	/**
	 * @memberOf component
	 */
	var EntityExpandBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'EntityExpandBtn',
		propTypes: {
			attrPath: _react2.default.PropTypes.array.isRequired,
			onExpand: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onExpand: function onExpand() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'expand',
				size: 'xsmall',
				title: 'Expand entity',
				onClick: this._handleExpand
			});
		},
		_handleExpand: function _handleExpand() {
			this.props.onExpand({
				attrPath: this.props.attrPath
			});
		}
	});
	var EntityExpandBtnFactory = _react2.default.createFactory(EntityExpandBtn);
	
	/**
	 * @memberOf component
	 */
	var EntityCollapseBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'EntityCollapseBtn',
		propTypes: {
			attrPath: _react2.default.PropTypes.array.isRequired,
			onCollapse: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onCollapse: function onCollapse() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'collapse-up',
				size: 'xsmall',
				title: 'Collapse entity',
				onClick: this._handleCollapse
			});
		},
		_handleCollapse: function _handleCollapse() {
			this.props.onCollapse({
				attrPath: this.props.attrPath
			});
		}
	});
	var EntityCollapseBtnFactory = _react2.default.createFactory(EntityCollapseBtn);
	
	/**
	 * @memberOf component
	 */
	var EntityCreateBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _ReactLayeredComponentMixin2.default],
		displayName: 'EntityCreateBtn',
		propTypes: {
			entity: _react2.default.PropTypes.object.isRequired,
			onCreate: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return {
				form: false
			};
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onCreate: function onCreate() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'plus',
				title: 'Add row',
				style: 'success',
				size: 'xsmall',
				onClick: this._handleCreate
			});
		},
		renderLayer: function renderLayer() {
			return this.state.form ? (0, _Form2.default)({
				entity: this.props.entity.name,
				mode: 'create',
				showHidden: true,
				modal: true,
				onSubmitSuccess: this._handleCreateConfirm,
				onSubmitCancel: this._handleCreateCancel
			}) : null;
		},
		_handleCreate: function _handleCreate() {
			this.setState({
				form: true
			});
		},
		_handleCreateCancel: function _handleCreateCancel() {
			this.setState({
				form: false
			});
		},
		_handleCreateConfirm: function _handleCreateConfirm(e) {
			this.setState({
				form: false
			});
			this.props.onCreate({
				href: this.props._href
			});
		}
	});
	var EntityCreateBtnFactory = _react2.default.createFactory(EntityCreateBtn);
	
	/**
	 * @memberOf component
	 */
	var EntityEditBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _ReactLayeredComponentMixin2.default],
		displayName: 'EntityEditBtn',
		propTypes: {
			name: _react2.default.PropTypes.string.isRequired,
			id: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]).isRequired,
			onEdit: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return {
				form: false
			};
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onEdit: function onEdit() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'edit',
				title: 'Edit row',
				size: 'xsmall',
				onClick: this._handleEdit
			});
		},
		renderLayer: function renderLayer() {
			return this.state.form ? (0, _Form2.default)({
				entity: this.props.name,
				entityInstance: this.props.id,
				mode: 'edit',
				showHidden: true,
				modal: true,
				onSubmitSuccess: this._handleEditConfirm,
				onSubmitCancel: this._handleEditCancel
			}) : null;
		},
		_handleEdit: function _handleEdit() {
			this.setState({
				form: true
			});
		},
		_handleEditCancel: function _handleEditCancel() {
			this.setState({
				form: false
			});
		},
		_handleEditConfirm: function _handleEditConfirm() {
			this.setState({
				form: false
			});
			this.props.onEdit({
				name: this.props.name,
				id: this.props.id
			});
		}
	});
	var EntityEditBtnFactory = _react2.default.createFactory(EntityEditBtn);
	
	/**
	 * @memberOf component
	 */
	var EntityDeleteBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default, _ReactLayeredComponentMixin2.default],
		displayName: 'EntityDeleteBtn',
		propTypes: {
			name: _react2.default.PropTypes.string.isRequired,
			id: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]).isRequired,
			onDelete: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return {
				dialog: false
			};
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onDelete: function onDelete() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'trash',
				title: 'Delete row',
				style: 'danger',
				size: 'xsmall',
				onClick: this._handleDelete
			});
		},
		renderLayer: function renderLayer() {
			return this.state.dialog ? (0, _Dialog2.default)({
				type: 'confirm',
				message: 'Are you sure you want to delete this row?',
				onCancel: this._handleDeleteCancel,
				onConfirm: this._handleDeleteConfirm
			}) : null;
		},
		_handleDelete: function _handleDelete() {
			this.setState({
				dialog: true
			});
		},
		_handleDeleteCancel: function _handleDeleteCancel() {
			this.setState({
				dialog: false
			});
		},
		_handleDeleteConfirm: function _handleDeleteConfirm() {
			this.setState({
				dialog: false
			});
			api.remove(this.props.name, this.props.id).done(function () {
				this.props.onDelete({
					name: this.props.name,
					id: this.props.id
				});
			}.bind(this));
		}
	});
	var EntityDeleteBtnFactory = _react2.default.createFactory(EntityDeleteBtn);
	
	/**
	 * @memberOf component
	 */
	var EntityInspectBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'EntityInspectBtn',
		propTypes: {
			name: _react2.default.PropTypes.string.isRequired,
			id: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]).isRequired,
			onInspect: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return {
				dialog: false
			};
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onInspect: function onInspect() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'search',
				style: 'info',
				title: 'Inspect row',
				size: 'xsmall',
				onClick: this._handleClick
			});
		},
		_handleClick: function _handleClick() {
			this.props.onInspect({
				name: this.props.name,
				id: this.props.id
			});
		}
	});
	var EntityInspectBtnFactory = _react2.default.createFactory(EntityInspectBtn);
	
	/**
	 * @memberOf component
	 */
	var EntityExecuteBtn = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'EntityExecuteBtn',
		propTypes: {
			name: _react2.default.PropTypes.string.isRequired,
			id: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.number]).isRequired,
			onExecute: _react2.default.PropTypes.func
		},
		getDefaultProps: function getDefaultProps() {
			return {
				onExecute: function onExecute() {}
			};
		},
		render: function render() {
			return (0, _Button2.default)({
				icon: 'play',
				style: 'success',
				title: 'Execute now',
				size: 'xsmall',
				onClick: this._handleClick
			});
		},
		_handleClick: function _handleClick() {
			this.props.onExecute({
				name: this.props.name,
				id: this.props.id
			});
		}
	});
	var EntityExecuteBtnFactory = _react2.default.createFactory(EntityExecuteBtn);
	
	exports.Table = Table;
	
	var TableFactory = _react2.default.createFactory(Table);
	exports.default = TableFactory;

/***/ },

/***/ 112:
/*!******************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/TextArea.js ***!
  \******************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var textarea = _react2.default.DOM.textarea;
	
	/**
	 * @memberOf component
	 */
	var TextArea = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'TextArea',
		propTypes: {
			id: _react2.default.PropTypes.string,
			name: _react2.default.PropTypes.string,
			placeholder: _react2.default.PropTypes.string,
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readOnly: _react2.default.PropTypes.bool,
			maxLength: _react2.default.PropTypes.number,
			value: _react2.default.PropTypes.string,
			onValueChange: _react2.default.PropTypes.func.isRequired,
			onBlur: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return { value: this.props.value };
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			this.setState({
				value: nextProps.value
			});
		},
		render: function render() {
			return textarea({
				className: 'form-control',
				id: this.props.id,
				name: this.props.name,
				placeholder: this.props.placeholder,
				required: this.props.required,
				disabled: this.props.disabled,
				readOnly: this.props.readOnly,
				maxLength: this.props.maxLength,
				value: this.state.value,
				onChange: this._handleChange,
				onBlur: this._handleBlur
			});
		},
		_handleChange: function _handleChange(event) {
			this._handleChangeOrBlur(event, true, this.props.onValueChange);
		},
		_handleBlur: function _handleBlur(event) {
			if (this.props.onBlur) {
				this._handleChangeOrBlur(event, false, this.props.onBlur);
			}
		},
		_handleChangeOrBlur: function _handleChangeOrBlur(event, updateState, callback) {
			var value = event.target.value;
			// apply constraint: maximum number of characters allowed in input
			if (this.props.maxLength) {
				value = value.substr(0, this.props.maxLength);
			}
			if (updateState) {
				this.setState({ value: value });
			}
			value = value !== '' ? value : null;
			callback({ value: value });
		}
	});
	
	exports.default = _react2.default.createFactory(TextArea);

/***/ },

/***/ 113:
/*!********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/UploadForm.js ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.UploadForm = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Input = __webpack_require__(/*! ./Input */ 49);
	
	var _RadioGroup = __webpack_require__(/*! ./RadioGroup */ 50);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var UploadForm = _react2.default.createClass({
		displayName: 'UploadForm',
		propTypes: {
			width: _react2.default.PropTypes.oneOf(['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12']),
			showAction: _react2.default.PropTypes.bool,
			onSubmit: _react2.default.PropTypes.func.isRequired,
			validExtensions: _react2.default.PropTypes.array
		},
		getInitialState: function getInitialState() {
			return {
				file: null,
				showNameField: false,
				fileName: null,
				action: 'ADD'
			};
		},
		getDefaultProps: function getDefaultProps() {
			return {
				width: '6',
				showAction: false
			};
		},
		render: function render() {
			var gridWidth = this.props.width ? 'col-md-' + this.props.width : 'col-md-12';
			var actions = [{ value: 'ADD', label: 'ADD' }, { value: 'ADD_UPDATE_EXISTING', label: 'ADD/UPDATE' }, { value: 'UPDATE', label: 'UPDATE' }];
			return _react2.default.createElement(
				'form',
				null,
				_react2.default.createElement(
					'div',
					{ className: gridWidth },
					_react2.default.createElement(
						'div',
						{ className: 'form-group' },
						_react2.default.createElement('input', { type: 'file', onChange: this._setFile }),
						this.state.warning && _react2.default.createElement(
							'span',
							{ id: 'helpBlock', 'class': 'help-block' },
							this.state.warning
						)
					),
					this.state.showNameField && _react2.default.createElement(
						'div',
						{ className: 'form-group' },
						_react2.default.createElement(
							'label',
							{ htmlFor: 'file-name-input-field' },
							'Name'
						),
						_react2.default.createElement(_Input.Input, { id: 'file-name-input-field', type: 'string', onValueChange: this._setFileName, required: true, value: this.state.fileName })
					),
					this.props.showAction && _react2.default.createElement(
						'div',
						{ className: 'form-group' },
						_react2.default.createElement(
							'label',
							{ htmlFor: 'action-field' },
							'Action'
						),
						_react2.default.createElement(_RadioGroup.RadioGroup, { name: 'action-field', layout: 'vertical', options: actions, type: 'radio', onValueChange: this._setAction, required: false, value: this.state.action })
					),
					this.state.file && _react2.default.createElement(
						'div',
						{ className: 'form-group' },
						_react2.default.createElement(_Button.Button, { id: 'upload-file-btn', type: 'submit', style: 'default', size: 'medium', onClick: this._onSubmit, text: 'Upload',
							disabled: this.state.showNameField && !this.state.fileName })
					)
				)
			);
		},
		_setFile: function _setFile(event) {
			var file = event.target.files[0];
			var fileName = file.name.toLowerCase();
			var showNameField = fileName.endsWith('.vcf') || fileName.endsWith('.vcf.gz');
			if (this.props.validExtensions && !this.props.validExtensions.find(function (extension) {
				return fileName.endsWith(extension);
			})) {
				this.setState({ warning: 'Invalid file name, extension must be ' + this.props.validExtensions });
			} else {
				if (showNameField) {
					// Remove extension
					fileName = fileName.replace(/\.vcf|\.vcf\.gz/, '');
					// Maximum length is 30 chars, but we need to take into account that the samples are post fixed "_SAMPLES"
					fileName = fileName.substring(0, 21);
					// Remove illegal chars
					fileName = fileName.replace(/\-|\.|\*|\$|\&|\%|\^|\(|\)|\#|\!|\@|\?/g, '_');
					// Don't allow entitynames starting with a number
					fileName = fileName.replace(/^[0-9]/g, '_');
					this.setState({ fileName: fileName });
				}
				this.setState({ file: file, showNameField: showNameField, warning: undefined });
			}
		},
		_setFileName: function _setFileName(fileName) {
			this.setState({ fileName: fileName.value });
		},
		_setAction: function _setAction(action) {
			this.setState({ action: action.value });
		},
		_onSubmit: function _onSubmit(event) {
			event.preventDefault();
			this.props.onSubmit(this.state);
		}
	});
	
	exports.UploadForm = UploadForm;
	exports.default = _react2.default.createFactory(UploadForm);

/***/ },

/***/ 114:
/*!***************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/JobContainer.js ***!
  \***************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.JobContainer = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV2 */ 41);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _Spinner = __webpack_require__(/*! ../Spinner */ 12);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _Job = __webpack_require__(/*! ./Job */ 68);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _SetIntervalMixin = __webpack_require__(/*! ../mixin/SetIntervalMixin */ 71);
	
	var _SetIntervalMixin2 = _interopRequireDefault(_SetIntervalMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var JobContainer = _react2.default.createClass({
	    mixins: [_DeepPureRenderMixin2.default, _SetIntervalMixin2.default],
	    displayName: 'JobContainer',
	    propTypes: {
	        jobHref: _react2.default.PropTypes.string,
	        onCompletion: _react2.default.PropTypes.func
	    },
	    getInitialState: function getInitialState() {
	        return {
	            job: null
	        };
	    },
	    componentDidMount: function componentDidMount() {
	        this.retrieveJob();
	        this.setInterval(this.retrieveJob, 1000);
	    },
	    render: function render() {
	        if (this.state.job) {
	            return _react2.default.createElement(_Job.Job, { job: this.state.job });
	        } else {
	            return _react2.default.createElement(_Spinner.Spinner, null);
	        }
	    },
	    retrieveJob: function retrieveJob() {
	        var self = this;
	        _jquery2.default.get(this.props.jobHref, function (job) {
	            self.setState({ job: job });
	            if ((job.status === 'SUCCESS' || job.status === 'FAILED' || job.status === 'FINISHED') && self.props.onCompletion) {
	                self.props.onCompletion(job);
	            }
	        });
	    }
	}); /**
	     * The JobContainer retrieves progress for a single Job execution and renders it
	     * using the Job component.
	     *
	     * @module JobContainer
	     *
	     * @exports JobContainer factory
	     */
	
	
	exports.JobContainer = JobContainer;
	exports.default = _react2.default.createFactory(JobContainer);

/***/ },

/***/ 115:
/*!***********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/JobTable.js ***!
  \***********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.JobTable = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _moment = __webpack_require__(/*! moment */ 1);
	
	var _moment2 = _interopRequireDefault(_moment);
	
	var _twix = __webpack_require__(/*! twix */ 416);
	
	var _twix2 = _interopRequireDefault(_twix);
	
	__webpack_require__(/*! moment-duration-format */ 318);
	
	var _Button = __webpack_require__(/*! ../Button */ 16);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var JobTable = _react2.default.createClass({
		displayName: 'JobTable',
		propTypes: {
			jobs: _react2.default.PropTypes.array.isRequired,
			onSelect: _react2.default.PropTypes.func,
			customColumns: _react2.default.PropTypes.array
		},
		render: function render() {
			var _this = this;
	
			var _props = this.props;
			var jobs = _props.jobs;
			var customColumns = _props.customColumns;
	
			return _react2.default.createElement(
				'div',
				{ className: 'panel panel-primary' },
				_react2.default.createElement(
					'div',
					{ className: 'panel-heading' },
					'Finished Jobs'
				),
				_react2.default.createElement(
					'div',
					{ className: 'panel-body', style: { overflowX: 'auto' } },
					_react2.default.createElement(
						'table',
						{ className: 'table table-striped' },
						_react2.default.createElement(
							'thead',
							null,
							_react2.default.createElement('th', null),
							_react2.default.createElement(
								'th',
								null,
								'Status'
							),
							_react2.default.createElement(
								'th',
								null,
								'When'
							),
							_react2.default.createElement(
								'th',
								null,
								'Duration'
							),
							customColumns && customColumns.map(function (cc) {
								return _react2.default.createElement(
									'th',
									null,
									cc.th
								);
							}),
							_react2.default.createElement(
								'th',
								null,
								'Result'
							)
						),
						_react2.default.createElement(
							'tbody',
							null,
							jobs.map(function (job, index) {
								return _react2.default.createElement(
									'tr',
									{ key: job.identifier },
									_react2.default.createElement(
										'td',
										null,
										_react2.default.createElement(_Button.Button, { icon: 'search', style: 'info', size: 'xsmall',
											onClick: function onClick() {
												return _this.props.onSelect(job.identifier);
											} })
									),
									_react2.default.createElement(
										'td',
										null,
										_this._renderStatus(job.status)
									),
									_react2.default.createElement(
										'td',
										null,
										_this._getTwix(job)
									),
									_react2.default.createElement(
										'td',
										null,
										_this._getDuration(job)
									),
									customColumns && customColumns.map(function (cc) {
										return _react2.default.createElement(
											'td',
											null,
											cc.td(job)
										);
									}),
									_react2.default.createElement(
										'td',
										null,
										job.resultUrl && _react2.default.createElement(
											'a',
											{ href: job.resultUrl },
											'Go to result'
										)
									)
								);
							})
						)
					)
				)
			);
		},
		_renderStatus: function _renderStatus(status) {
			switch (status) {
				case 'FAILED':
					return _react2.default.createElement(
						'span',
						{ className: 'label label-warning' },
						'Failed'
					);
				case 'SUCCESS':
					return _react2.default.createElement(
						'span',
						{ className: 'label label-success' },
						'Success'
					);
				case 'PENDING':
					return _react2.default.createElement(
						'span',
						{ className: 'label label-primary' },
						'Pending'
					);
				case 'CANCELED':
					return _react2.default.createElement(
						'span',
						{ className: 'label label-default' },
						'Canceled'
					);
				case 'RUNNING':
					return _react2.default.createElement(
						'span',
						{ className: 'label label-info' },
						'Running'
					);
			}
		},
		_getTwix: function _getTwix(job) {
			var startDate = (0, _moment2.default)(job.startDate);
			var endDate = (0, _moment2.default)(job.endDate);
			return startDate.twix(endDate).format() + " (" + endDate.fromNow() + ")";
		},
		_getDuration: function _getDuration(job) {
			var startDate = (0, _moment2.default)(job.startDate);
			var endDate = (0, _moment2.default)(job.endDate);
			return _moment2.default.duration(endDate.diff(startDate), 'milliseconds').format("h[h], m[m], s[s]");
		}
	}); /**
	     * Renders a Table with information for each job that is passed down from its
	     * parent component
	     *
	     * @module JobTable
	     *
	     * @param jobs
	     *            An array of job objects with status other then RUNNING
	     *
	     * @exports JobTable class
	     */
	
	
	exports.JobTable = JobTable;
	exports.default = _react2.default.createFactory(JobTable);

/***/ },

/***/ 116:
/*!*******************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/Jobs.js ***!
  \*******************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.Jobs = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _RunningJobs = __webpack_require__(/*! ./RunningJobs */ 270);
	
	var _JobTable = __webpack_require__(/*! ./JobTable */ 115);
	
	var _Modal = __webpack_require__(/*! ../Modal */ 39);
	
	var _JobDetails = __webpack_require__(/*! ./JobDetails */ 268);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var Jobs = _react2.default.createClass({
	    displayName: 'Jobs',
	    propTypes: {
	        jobs: _react2.default.PropTypes.array.isRequired,
	        onSelect: _react2.default.PropTypes.func.isRequired,
	        selectedJobId: _react2.default.PropTypes.string
	    },
	    render: function render() {
	        var _props = this.props;
	        var jobs = _props.jobs;
	        var onSelect = _props.onSelect;
	        var selectedJobId = _props.selectedJobId;
	
	        var selectedJob = jobs.find(function (job) {
	            return job.identifier === selectedJobId;
	        });
	        var runningJobs = jobs.filter(function (job) {
	            return job.status === 'RUNNING';
	        });
	        var finishedJobs = jobs.filter(function (job) {
	            return job.status !== 'RUNNING';
	        });
	
	        return _react2.default.createElement(
	            'div',
	            null,
	            runningJobs.length > 0 && _react2.default.createElement(
	                'div',
	                { className: 'row' },
	                _react2.default.createElement(
	                    'div',
	                    { className: 'col-md-12' },
	                    _react2.default.createElement(_RunningJobs.RunningJobs, { jobs: runningJobs,
	                        onSelect: onSelect })
	                )
	            ),
	            finishedJobs.length > 0 && _react2.default.createElement(
	                'div',
	                { className: 'row' },
	                _react2.default.createElement(
	                    'div',
	                    { className: 'col-md-12' },
	                    _react2.default.cloneElement(this.props.children, {
	                        jobs: finishedJobs,
	                        onSelect: onSelect
	                    })
	                )
	            ),
	            jobs.length === 0 && _react2.default.createElement(
	                'div',
	                { className: 'row' },
	                _react2.default.createElement(
	                    'div',
	                    { className: 'col-md-12' },
	                    _react2.default.createElement(
	                        'p',
	                        null,
	                        'No jobs found.'
	                    )
	                )
	            ),
	            selectedJob && _react2.default.createElement(
	                _Modal.Modal,
	                { onHide: function onHide() {
	                        return onSelect(null);
	                    },
	                    title: 'Job details', show: true, size: "large",
	                    footer: true },
	                _react2.default.createElement(_JobDetails.JobDetails, { job: selectedJob })
	            )
	        );
	    }
	}); /**
	     * This module receives an array of job objects and renders ProgressBar
	     * components for RUNNING jobs and lists jobs with other status in a table.
	     *
	     * @module Jobs
	     *
	     * @param jobs
	     *            An array of job objects
	     *
	     * @exports Job class
	     */
	
	
	exports.Jobs = Jobs;
	exports.default = _react2.default.createFactory(Jobs);

/***/ },

/***/ 117:
/*!********************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/wrapper/DateTimePicker.js ***!
  \********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function($) {"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	__webpack_require__(/*! ../css/wrapper/DateTimePicker.css */ 414);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    input = _react2.default.DOM.input,
	    span = _react2.default.DOM.span;
	
	/**
	 * React component for Datepicker (http://eonasdan.github.io/bootstrap-datetimepicker/)
	 * 
	 * @memberOf component.wrapper
	 */
	var DateTimePicker = _react2.default.createClass({ // FIXME should use controlled input
		displayName: 'DateTimePicker',
		mixins: [_DeepPureRenderMixin2.default],
		propTypes: {
			id: _react2.default.PropTypes.string,
			name: _react2.default.PropTypes.string,
			time: _react2.default.PropTypes.bool,
			placeholder: _react2.default.PropTypes.string,
			required: _react2.default.PropTypes.bool,
			disabled: _react2.default.PropTypes.bool,
			readonly: _react2.default.PropTypes.bool,
			focus: _react2.default.PropTypes.bool,
			value: _react2.default.PropTypes.string,
			onChange: _react2.default.PropTypes.func.isRequired
		},
		componentDidMount: function componentDidMount() {
			var props = this.props;
	
			var format = props.time === true ? 'YYYY-MM-DDTHH:mm:ssZZ' : 'YYYY-MM-DD';
	
			var $container = $(this.refs.datepicker.getDOMNode());
			$container.datetimepicker({
				format: format
			});
	
			$container.on('dp.change', function (event) {
				this._handleValueChange(event.date ? event.date.format(format) : null);
			}.bind(this));
	
			if (!this.props.required) {
				var $clearBtn = $(this.refs.clearbtn.getDOMNode());
				$clearBtn.on('click', function () {
					this._handleValueChange(null);
				}.bind(this));
			}
	
			this._focus();
		},
		componentWillUnmount: function componentWillUnmount() {
			var $container = $(this.refs.datepicker.getDOMNode());
			$container.datetimepicker('destroy');
		},
		getInitialState: function getInitialState() {
			return { value: this.props.value };
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			this.setState({
				value: nextProps.value
			});
		},
		render: function render() {
			var placeholder = this.props.placeholder;
			var required = this.props.required;
			var disabled = this.props.disabled;
			var readOnly = this.props.readOnly;
	
			return div({ className: 'input-group date group-append', ref: 'datepicker' }, input({
				type: 'text',
				className: 'form-control',
				id: this.props.id,
				name: this.props.name,
				value: this.state.value,
				placeholder: placeholder,
				required: required,
				disabled: disabled,
				readOnly: readOnly,
				onChange: this._handleChange,
				ref: this.props.focus ? 'input' : undefined
			}), // FIXME use Input
			!required ? span({ className: 'input-group-addon' }, span({ className: 'glyphicon glyphicon-remove empty-date-input', ref: 'clearbtn' })) : null, span({ className: 'input-group-addon datepickerbutton' }, span({ className: 'glyphicon glyphicon-calendar' })));
		},
		componentDidUpdate: function componentDidUpdate() {
			this._focus();
		},
		_handleChange: function _handleChange(event) {
			this.setState({ value: event.target.value });
		},
		_handleValueChange: function _handleValueChange(value) {
			this.setState({ value: value });
			this.props.onChange(value);
		},
		_focus: function _focus() {
			if (this.props.focus) {
				this.refs.input.getDOMNode().focus();
			}
		}
	});
	
	exports.default = _react2.default.createFactory(DateTimePicker);
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(/*! jquery */ 5)))

/***/ },

/***/ 118:
/*!*******************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/wrapper/JQRangeSlider.js ***!
  \*******************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function($) {"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	__webpack_require__(/*! ../css/wrapper/iThing-min.css */ 415);
	
	__webpack_require__(/*! ../css/wrapper/JQRangeSlider.css */ 253);
	
	__webpack_require__(/*! ../css/wrapper/jquery-ui-1.9.2.custom.min.css */ 254);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div;
	
	/**
	 * React component for range slider jQRangeSlider (http://ghusse.github.io/jQRangeSlider/)
	 * 
	 * @memberOf component.wrapper
	 */
	var JQRangeSlider = _react2.default.createClass({
		displayName: 'JQRangeSlider',
		mixins: [_DeepPureRenderMixin2.default],
		propTypes: {
			id: _react2.default.PropTypes.string,
			options: _react2.default.PropTypes.object,
			disabled: _react2.default.PropTypes.bool,
			onChange: _react2.default.PropTypes.func.isRequired
		},
		componentDidMount: function componentDidMount() {
			var $container = $(this.refs.rangeslider.getDOMNode());
			$container.editRangeSlider(this.props.options);
	
			if (this.props.disabled) {
				$container.editRangeSlider('disable');
			}
	
			var props = this.props;
			/* jshint unused: false */
			$container.on('userValuesChanged', function (e, data) {
				props.onChange([data.values.min, data.values.max]);
			});
			/* jshint unused: true */
		},
		componentWillUnmount: function componentWillUnmount() {
			var $container = $(this.refs.rangeslider.getDOMNode());
			$container.off();
			$container.editRangeSlider('destroy');
		},
		render: function render() {
			// workaround for JQRangeSlider edit boxes going out of bounds
			return div({ className: 'row' }, div({ className: 'col-md-offset-1 col-md-10' }, div({ id: this.props.id, ref: 'rangeslider' })));
		},
		componentDidUpdate: function componentDidUpdate() {
			if (this.isMounted()) {
				var $container = $(this.refs.rangeslider.getDOMNode());
				$container.editRangeSlider(this.props.disabled ? 'disable' : 'enable');
				$container.editRangeSlider('values', this.props.value[0], this.props.value[1]);
			}
		}
	});
	
	exports.default = _react2.default.createFactory(JQRangeSlider);
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(/*! jquery */ 5)))

/***/ },

/***/ 119:
/*!****************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/wrapper/JQueryForm.js ***!
  \****************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _jqueryForm = __webpack_require__(/*! jquery-form */ 316);
	
	var _jqueryForm2 = _interopRequireDefault(_jqueryForm);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var form = _react2.default.DOM.form;
	
	/**
	* React component for jQuery Form Plugin (http://malsup.com/jquery/form/)
	* 
	* @memberOf component.wrapper
	*/
	var JQueryForm = _react2.default.createClass({
		displayName: 'JQueryForm',
		mixins: [_DeepPureRenderMixin2.default],
		propTypes: {
			className: _react2.default.PropTypes.string,
			action: _react2.default.PropTypes.string.isRequired,
			method: _react2.default.PropTypes.string,
			noValidate: _react2.default.PropTypes.bool,
			beforeSubmit: _react2.default.PropTypes.func,
			success: _react2.default.PropTypes.func,
			error: _react2.default.PropTypes.func
		},
		submit: function submit() {
			var $form = (0, _jquery2.default)(this.refs.form.getDOMNode());
			$form.ajaxSubmit({
				resetForm: false,
				beforeSubmit: this.props.beforeSubmit,
				success: this.props.success,
				error: this.props.error
			});
		},
		componentDidMount: function componentDidMount() {
			this.refs.form.getDOMNode().submit = this.submit;
		},
		componentWillUnmount: function componentWillUnmount() {
			var $form = (0, _jquery2.default)(this.refs.form.getDOMNode());
			$form.ajaxFormUnbind();
		},
		render: function render() {
			return form(_underscore2.default.extend({}, this.props, { ref: 'form' }), this.props.children);
		}
	});
	
	exports.default = _react2.default.createFactory(JQueryForm);

/***/ },

/***/ 220:
/*!****************************************************!*\
  !*** ./~/react-notification-system/dist/styles.js ***!
  \****************************************************/
/***/ function(module, exports) {

	// Used for calculations
	var defaultWidth = 320;
	var defaultColors = {
	  success: '#5ea400',
	  error: '#ec3d3d',
	  warning: '#ebad1a',
	  info: '#369cc7'
	}
	
	var STYLES = {
	
	  Wrapper: {},
	  Containers: {
	    DefaultStyle: {
	      fontFamily: 'inherit',
	      position: 'fixed',
	      width: defaultWidth,
	      padding: '0 10px 10px 10px',
	      zIndex: 9998,
	      WebkitBoxSizing: 'border-box',
	      MozBoxSizing: 'border-box',
	      boxSizing: 'border-box',
	      height: 'auto'
	    },
	
	    tl: {
	      top: "0px",
	      bottom: "auto",
	      left: '0px',
	      right: 'auto'
	    },
	
	    tr: {
	      top: "0px",
	      bottom: "auto",
	      left: 'auto',
	      right: '0px'
	    },
	
	    tc: {
	      top: "0px",
	      bottom: "auto",
	      margin: "0 auto",
	      left: "50%",
	      marginLeft: -(defaultWidth/2)
	    },
	
	    bl: {
	      top: "auto",
	      bottom: "0px",
	      left: '0px',
	      right: 'auto'
	    },
	
	    br: {
	      top: "auto",
	      bottom: "0px",
	      left: 'auto',
	      right: '0px'
	    },
	
	    bc: {
	      top: "auto",
	      bottom: "0px",
	      margin: "0 auto",
	      left: "50%",
	      marginLeft: -(defaultWidth/2)
	    }
	
	  },
	
	  NotificationItem: {
	    DefaultStyle: {
	      position: 'relative',
	      width: '100%',
	      cursor: 'pointer',
	      borderRadius: '2px',
	      fontSize: '13px',
	      border: '1px solid',
	      borderTopWidth: '4px',
	      margin: '10px 0 0',
	      padding: '10px',
	      display: 'block',
	      WebkitBoxSizing: 'border-box',
	      MozBoxSizing: 'border-box',
	      boxSizing: 'border-box',
	      WebkitBoxShadow: '0px 0px 5px 2px rgba(0,0,0,0.1)',
	      MozBoxShadow: '0px 0px 5px 2px rgba(0,0,0,0.1)',
	      boxShadow: '0px 0px 5px 2px rgba(0,0,0,0.1)',
	      opacity: 0,
	      transition: '0.3s ease-in-out',
	
	      isHidden: {
	        opacity: 0
	      },
	
	      isVisible: {
	        opacity: 0.9
	      }
	    },
	
	    success: {
	      borderColor: '#d0ddbe',
	      borderTopColor: defaultColors.success,
	      backgroundColor: '#f0f5ea',
	      color: '#4b583a'
	    },
	
	    error: {
	      borderColor: '#edbfbf',
	      borderTopColor: defaultColors.error,
	      backgroundColor: '#f4e9e9',
	      color: '#412f2f'
	    },
	
	    warning: {
	      borderColor: '#ecd9ab',
	      borderTopColor: defaultColors.warning,
	      backgroundColor: '#f9f6f0',
	      color: '#5a5343'
	    },
	
	    info: {
	      borderColor: '#b2d0dd',
	      borderTopColor: defaultColors.info,
	      backgroundColor: '#e8f0f4',
	      color: '#41555d'
	    }
	  },
	
	  Title: {
	    DefaultStyle: {
	      fontSize: '14px',
	      margin: '0 0 5px 0',
	      padding: 0,
	      fontWeight: 'bold'
	    },
	
	    success: {
	      color: defaultColors.success
	    },
	
	    error: {
	      color: defaultColors.error
	    },
	
	    warning: {
	      color: defaultColors.warning
	    },
	
	    info: {
	      color: defaultColors.info
	    }
	
	  },
	
	  MessageWrapper: {
	    DefaultStyle: {
	      margin: 0,
	      padding: 0
	    }
	  },
	
	  Dismiss: {
	    DefaultStyle: {
	      fontFamily: 'Arial',
	      fontSize: '17px',
	      position: 'absolute',
	      top: '4px',
	      right: '5px',
	      lineHeight: '15px',
	      backgroundColor: '#dededf',
	      color: '#ffffff',
	      borderRadius: '50%',
	      width: '14px',
	      height: '14px',
	      fontWeight: 'bold',
	      textAlign: 'center'
	    },
	
	    success: {
	      color: '#f0f5ea',
	      backgroundColor: '#b0ca92'
	    },
	
	    error: {
	      color: '#f4e9e9',
	      backgroundColor: '#e4bebe'
	    },
	
	    warning: {
	      color: '#f9f6f0',
	      backgroundColor: '#e1cfac'
	    },
	
	    info: {
	      color: '#e8f0f4',
	      backgroundColor: '#a4becb'
	    }
	  },
	
	  Action: {
	    DefaultStyle: {
	      background: '#ffffff',
	      borderRadius: '2px',
	      padding: '6px 20px',
	      fontWeight: 'bold',
	      margin: '10px 0 0 0',
	      border: 0
	    },
	
	    success: {
	      backgroundColor: defaultColors.success,
	      color: '#ffffff'
	    },
	
	    error: {
	      backgroundColor: defaultColors.error,
	      color: '#ffffff'
	    },
	
	    warning: {
	      backgroundColor: defaultColors.warning,
	      color: '#ffffff'
	    },
	
	    info: {
	      backgroundColor: defaultColors.info,
	      color: '#ffffff'
	    }
	  },
	
	  ActionWrapper: {
	    DefaultStyle: {
	      margin: 0,
	      padding: 0
	    }
	  }
	};
	
	module.exports = STYLES;


/***/ },

/***/ 221:
/*!**************************************************************!*\
  !*** ./~/react-notification-system/~/object-assign/index.js ***!
  \**************************************************************/
/***/ function(module, exports) {

	'use strict';
	/* eslint-disable no-unused-vars */
	var hasOwnProperty = Object.prototype.hasOwnProperty;
	var propIsEnumerable = Object.prototype.propertyIsEnumerable;
	
	function toObject(val) {
		if (val === null || val === undefined) {
			throw new TypeError('Object.assign cannot be called with null or undefined');
		}
	
		return Object(val);
	}
	
	function shouldUseNative() {
		try {
			if (!Object.assign) {
				return false;
			}
	
			// Detect buggy property enumeration order in older V8 versions.
	
			// https://bugs.chromium.org/p/v8/issues/detail?id=4118
			var test1 = new String('abc');  // eslint-disable-line
			test1[5] = 'de';
			if (Object.getOwnPropertyNames(test1)[0] === '5') {
				return false;
			}
	
			// https://bugs.chromium.org/p/v8/issues/detail?id=3056
			var test2 = {};
			for (var i = 0; i < 10; i++) {
				test2['_' + String.fromCharCode(i)] = i;
			}
			var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
				return test2[n];
			});
			if (order2.join('') !== '0123456789') {
				return false;
			}
	
			// https://bugs.chromium.org/p/v8/issues/detail?id=3056
			var test3 = {};
			'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
				test3[letter] = letter;
			});
			if (Object.keys(Object.assign({}, test3)).join('') !==
					'abcdefghijklmnopqrst') {
				return false;
			}
	
			return true;
		} catch (e) {
			// We don't expect any of the above to throw, but better to be safe.
			return false;
		}
	}
	
	module.exports = shouldUseNative() ? Object.assign : function (target, source) {
		var from;
		var to = toObject(target);
		var symbols;
	
		for (var s = 1; s < arguments.length; s++) {
			from = Object(arguments[s]);
	
			for (var key in from) {
				if (hasOwnProperty.call(from, key)) {
					to[key] = from[key];
				}
			}
	
			if (Object.getOwnPropertySymbols) {
				symbols = Object.getOwnPropertySymbols(from);
				for (var i = 0; i < symbols.length; i++) {
					if (propIsEnumerable.call(from, symbols[i])) {
						to[symbols[i]] = from[symbols[i]];
					}
				}
			}
		}
	
		return to;
	};


/***/ },

/***/ 259:
/*!*********************************************************!*\
  !*** ./src/main/javascript/modules/i18n/I18nStrings.js ***!
  \*********************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.I18nStrings = I18nStrings;
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var i18nStrings = undefined;
	
	function I18nStrings(callback) {
	    if (!i18nStrings) {
	        _jquery2.default.ajax({
	            type: 'GET',
	            url: '/api/v2/i18n',
	            contentType: 'application/json',
	            async: true,
	            success: function success(data) {
	                i18nStrings = data;
	                callback(data);
	            }
	        });
	    } else {
	        callback(i18nStrings);
	    }
	}

/***/ },

/***/ 260:
/*!************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/AggregateTable.js ***!
  \************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV2 */ 41);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div,
	    table = _react2.default.DOM.table,
	    thead = _react2.default.DOM.thead,
	    tbody = _react2.default.DOM.tbody,
	    tr = _react2.default.DOM.tr,
	    th = _react2.default.DOM.th,
	    td = _react2.default.DOM.td,
	    a = _react2.default.DOM.a,
	    span = _react2.default.DOM.span,
	    em = _react2.default.DOM.em,
	    br = _react2.default.DOM.br,
	    label = _react2.default.DOM.label;
	
	var api = new _RestClientV2.default();
	
	var AGGREGATE_ANONYMIZATION_VALUE = -1;
	
	/**
	 * @memberOf component
	 */
	var AggregateTable = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'Table',
		propTypes: {
			entity: _react2.default.PropTypes.string.isRequired,
			x: _react2.default.PropTypes.string,
			y: _react2.default.PropTypes.string,
			distinct: _react2.default.PropTypes.string,
			query: _react2.default.PropTypes.array
		},
		getInitialState: function getInitialState() {
			return {
				data: null
			};
		},
		componentDidMount: function componentDidMount() {
			this._refreshData(this.props, this.state);
		},
		componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
			// reset pager on query change
			var nextState = _underscore2.default.extend({}, this.state, { attrs: nextProps.attrs });
			if (JSON.stringify(this.props.query) !== JSON.stringify(nextProps.query)) {
				_underscore2.default.extend(nextState, { start: 0 });
			}
			this._refreshData(nextProps, nextState);
		},
		render: function render() {
			if (this.state.data === null) {
				return (0, _Spinner2.default)(); // entity not available yet
			}
	
			if (this.state.data.aggs.matrix.length == 0) {
				return div(null, span(null, "No results found"));
			}
	
			var className = 'table table-striped';
			var AggregateTableHeader = AggregateTableHeaderFactory({
				labels: this.state.data.aggs.yLabels,
				attr: this.state.data.yAttr
			});
	
			var AggregateTableBody = AggregateTableBodyFactory({
				labels: this.state.data.aggs.xLabels,
				attr: this.state.data.xAttr,
				dimension: this.state.data.aggs.yLabels.length === 0 ? 1 : 2,
				matrix: this.state.data.aggs.matrix,
				threshold: this.state.data.aggs.threshold
			});
	
			return div(null, table({ className: className }, AggregateTableHeader, AggregateTableBody));
		},
		_refreshData: function _refreshData(props, state) {
			var opts = {
				aggs: {
					x: props.x,
					y: props.y,
					distinct: props.distinct
				},
				q: props.query
			};
	
			api.get(props.entity, opts).done(function (data) {
				var newState = _underscore2.default.extend({}, state, { data: data });
				if (this.isMounted()) {
					this.setState(newState);
				}
			}.bind(this));
		}
	});
	
	var AggregateTableHeader = _react2.default.createClass({
		displayName: 'AggregateTableHeader',
		propTypes: {
			labels: _react2.default.PropTypes.array.isRequired,
			attr: _react2.default.PropTypes.object
		},
		render: function render() {
			var HeaderCells = [];
			HeaderCells.push(this._createHeaderFirst());
			if (this.props.attr) {
				for (var i = 0; i < this.props.labels.length; ++i) {
					var label = this._toLabel(this.props.labels[i]);
					HeaderCells.push(this._createHeader(label, i));
				}
			}
			HeaderCells.push(this._createHeaderLast());
	
			return thead(null, tr(null, HeaderCells));
		},
		_createHeaderFirst: function _createHeaderFirst() {
			return td({ style: { width: '18%' }, key: 'first' });
		},
		_createHeader: function _createHeader(label, i) {
			return th({ key: 'c' + i }, div({ className: 'text-center' }, label !== null ? label : 'N/A' // FIXME i18N missingTemplate({}) FIXME label can be object
			));
		},
		_createHeaderLast: function _createHeaderLast() {
			return th({ key: 'last' }, div({ className: 'text-center' }, 'Total'));
		},
		_toLabel: function _toLabel(label) {
			if (label === null) {
				return 'N/A';
			} else if (this.props.attr.refEntity) {
				return label[this.props.attr.refEntity.labelAttribute];
			} else {
				return label;
			}
		}
	});
	var AggregateTableHeaderFactory = _react2.default.createFactory(AggregateTableHeader);
	
	var AggregateTableBody = _react2.default.createClass({
		displayName: 'AggregateTableBody',
		propTypes: {
			labels: _react2.default.PropTypes.array.isRequired,
			attr: _react2.default.PropTypes.object.isRequired,
			matrix: _react2.default.PropTypes.array.isRequired,
			dimension: _react2.default.PropTypes.number,
			threshold: _react2.default.PropTypes.number
		},
		render: function render() {
			var Rows = [];
			for (var i = 0; i < this.props.matrix.length; ++i) {
				Rows.push(this._createRow(this.props.labels[i], this.props.matrix[i], i));
			}
	
			// Row containing total column counts
			Rows.push(this._createRowLast());
	
			return tbody(null, Rows);
		},
		_createRow: function _createRow(label, rowData, rowIndex) {
			var Cells = [];
			Cells.push(th({ key: 'c' + rowIndex + '-first' }, this._toLabel(label)));
	
			if (this.props.dimension > 1) {
				var count = 0;
				var isAnonymized = false;
				for (var i = 0; i < rowData.length; ++i) {
					var cellCount = rowData[i];
					if (cellCount === AGGREGATE_ANONYMIZATION_VALUE) {
						cellCount = "≤" + this.props.threshold; // lesser than or equal
					}
					var Cell = td({ key: 'c' + rowIndex + '-' + i }, div({ className: 'text-center' }, cellCount));
					Cells.push(Cell);
				}
			}
			Cells.push(this._createColLast(rowData, 'c' + rowIndex + '-last'));
	
			return tr({ key: 'r' + rowIndex }, Cells);
		},
		_createColLast: function _createColLast(rowData, key) {
			var total = 0;
			var isAnonymized = false;
			for (var i = 0; i < rowData.length; ++i) {
				var cellCount = rowData[i];
				if (cellCount === AGGREGATE_ANONYMIZATION_VALUE) {
					total += this.props.threshold;
					isAnonymized = true;
				} else {
					total += cellCount;
				}
			}
			return td({ key: key }, div({ className: 'text-center' }, isAnonymized ? "≤" + total : total));
		},
		_createRowLast: function _createRowLast() {
			var nrCols = this.props.matrix[0].length;
	
			var tableTotal = 0;
			var isTableAnonymized = false;
	
			var Cells = [];
			Cells.push(th({ key: 'c-last-first' }, 'Total'));
			for (var col = 0; col < nrCols; ++col) {
				var colTotal = 0;
				var isColAnonymized = false;
				for (var row = 0; row < this.props.matrix.length; ++row) {
					var cellCount = this.props.matrix[row][col];
					if (cellCount === AGGREGATE_ANONYMIZATION_VALUE) {
						colTotal += this.props.threshold;
						isColAnonymized = true;
					} else {
						colTotal += cellCount;
					}
				}
	
				if (this.props.dimension > 1) {
					var Cell = td({ key: 'r-last-' + col }, div({ className: 'text-center' }, isColAnonymized ? "≤" + colTotal : colTotal));
					Cells.push(Cell);
				}
	
				tableTotal += colTotal;
				isTableAnonymized = isTableAnonymized | isColAnonymized;
			}
	
			// Cell containing total of totals
			var TableTotalCell = td({ key: 'c-last-last' }, div({ className: 'text-center' }, isTableAnonymized ? "≤" + tableTotal : tableTotal));
			Cells.push(TableTotalCell);
	
			return tr({ key: 'r-last' }, Cells);
		},
		_toLabel: function _toLabel(label) {
			if (label === null) {
				return 'N/A';
			} else if (this.props.attr.refEntity) {
				return label[this.props.attr.refEntity.labelAttribute];
			} else {
				return label;
			}
		}
	});
	var AggregateTableBodyFactory = _react2.default.createFactory(AggregateTableBody);
	
	exports.default = _react2.default.createFactory(AggregateTable);

/***/ },

/***/ 261:
/*!**********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/ConfirmClick.js ***!
  \**********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.ConfirmClick = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _ReactLayeredComponentMixin = __webpack_require__(/*! ./mixin/ReactLayeredComponentMixin */ 40);
	
	var _ReactLayeredComponentMixin2 = _interopRequireDefault(_ReactLayeredComponentMixin);
	
	var _Dialog = __webpack_require__(/*! ./Dialog */ 65);
	
	var _Dialog2 = _interopRequireDefault(_Dialog);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var ConfirmClick = _react2.default.createClass({
	    mixins: [_ReactLayeredComponentMixin2.default],
	    displayName: 'ConfirmClick',
	    propTypes: {
	        onClick: _react2.default.PropTypes.func,
	        confirmMessage: _react2.default.PropTypes.string.isRequired
	    },
	    getInitialState: function getInitialState() {
	        return {
	            dialog: false
	        };
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            onClick: function onClick() {}
	        };
	    },
	    render: function render() {
	        return _react2.default.cloneElement(this.props.children, { onClick: this._showDialog });
	    },
	    renderLayer: function renderLayer() {
	        return this.state.dialog ? (0, _Dialog2.default)({
	            type: 'confirm',
	            message: this.props.confirmMessage,
	            onCancel: this._hideDialog,
	            onConfirm: this._onConfirm
	        }) : null;
	    },
	    _showDialog: function _showDialog() {
	        this.setState({
	            dialog: true
	        });
	    },
	    _hideDialog: function _hideDialog() {
	        this.setState({
	            dialog: false
	        });
	    },
	    _onConfirm: function _onConfirm() {
	        this._hideDialog();
	        this.props.onClick();
	    }
	});
	
	exports.ConfirmClick = ConfirmClick;
	exports.default = _react2.default.createFactory(ConfirmClick);

/***/ },

/***/ 262:
/*!**************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/FileIngestPlugin.js ***!
  \**************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	
	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();
	
	var _Table = __webpack_require__(/*! ./Table */ 111);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }
	
	var FileIngestPlugin = function (_Component) {
	  _inherits(FileIngestPlugin, _Component);
	
	  function FileIngestPlugin(props) {
	    _classCallCheck(this, FileIngestPlugin);
	
	    var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(FileIngestPlugin).call(this, props));
	
	    _this.state = { selectedFileIngest: null };
	    _this.refresh = _this.refresh.bind(_this);
	    _this.onFileIngestSelect = _this.onFileIngestSelect.bind(_this);
	    _this.onExecute = _this.onExecute.bind(_this);
	    _this.onFileIngestDelete = _this.onFileIngestDelete.bind(_this);
	    return _this;
	  }
	
	  _createClass(FileIngestPlugin, [{
	    key: 'render',
	    value: function render() {
	      var fileIngest = this.state.selectedFileIngest;
	
	      return _react2.default.createElement(
	        'div',
	        null,
	        _react2.default.createElement(
	          'legend',
	          null,
	          'Automatic imports'
	        ),
	        _react2.default.createElement(
	          'div',
	          { className: 'ingest-table' },
	          _react2.default.createElement(_Table.Table, { entity: 'FileIngest',
	            attrs: { name: null, url: null, entityMetaData: null, cronexpression: null, active: null },
	            defaultSelectFirstRow: true,
	            selectedRow: this.state.selectedFileIngest,
	            onRowClick: this.onFileIngestSelect,
	            enableExecute: true,
	            onExecute: this.onExecute,
	            onRowDelete: this.onFileIngestDelete })
	        ),
	        fileIngest === null ? '' : _react2.default.createElement(
	          'div',
	          null,
	          _react2.default.createElement(
	            'legend',
	            null,
	            '\'',
	            fileIngest.name,
	            '\' import jobs',
	            _react2.default.createElement(
	              'span',
	              null,
	              ' (Target: ',
	              _react2.default.createElement(
	                'a',
	                { href: '/menu/main/dataexplorer?entity=' + fileIngest.entityMetaData.fullName },
	                fileIngest.entityMetaData.simpleName
	              ),
	              ')'
	            )
	          ),
	          _react2.default.createElement(
	            'div',
	            { className: 'ingest-table' },
	            _react2.default.createElement(_Table.Table, { entity: 'FileIngestJobExecution',
	              enableAdd: false,
	              sort: { attr: { name: 'startDate' }, order: 'desc', path: [] },
	              attrs: { status: null, startDate: null, endDate: null, progressMessage: null, file: null },
	              query: { q: [{ field: 'fileIngest', operator: 'EQUALS', value: fileIngest.id }] } })
	          )
	        )
	      );
	    }
	  }, {
	    key: 'componentDidMount',
	    value: function componentDidMount() {
	      setInterval(this.refresh, 20000);
	    }
	  }, {
	    key: 'refresh',
	    value: function refresh() {
	      this.setState(this.state);
	    }
	  }, {
	    key: 'onFileIngestSelect',
	    value: function onFileIngestSelect(fileIngest) {
	      this.setState({ selectedFileIngest: fileIngest });
	    }
	  }, {
	    key: 'onExecute',
	    value: function onExecute(e) {
	      var _this2 = this;
	
	      _jquery2.default.post('/plugin/fileingest/run/' + e.id).done(function (e) {
	        window.molgenis.createAlert([{ message: 'New job scheduled' }], 'success');
	        setTimeout(_this2.refresh, 2000);
	      });
	    }
	  }, {
	    key: 'onFileIngestDelete',
	    value: function onFileIngestDelete() {
	      window.molgenis.createAlert([{ message: 'Job deleted' }], 'success');
	      this.setState({ 'selectedFileIngest': null });
	      this.refresh();
	    }
	  }]);
	
	  return FileIngestPlugin;
	}(_react.Component);
	
	exports.default = _react2.default.createFactory(FileIngestPlugin);

/***/ },

/***/ 263:
/*!***************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/LanguageSelectBox.js ***!
  \***************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function($) {"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV1 */ 26);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _Select = __webpack_require__(/*! ./wrapper/Select2 */ 73);
	
	var _Select2 = _interopRequireDefault(_Select);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var api = new _RestClientV2.default();
	
	/**
	 * Shows a Select2 box for switching the user language
	 * 
	 * @memberOf component
	 */
	var LanguageSelectBox = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'LanguageSelectBox',
		propTypes: {
			onValueChange: _react2.default.PropTypes.func
		},
		getInitialState: function getInitialState() {
			return {
				select2Data: null,
				selectedLanguage: null
			};
		},
		componentDidMount: function componentDidMount() {
			this._loadLanguages();
		},
		render: function render() {
			if (this.state.select2Data === null) {
				return (0, _Spinner2.default)();
			}
	
			if (this.state.select2Data.length > 1) {
				return (0, _Select2.default)({
					options: {
						data: this.state.select2Data
					},
					value: this.state.selectedLanguage,
					name: 'languages',
					onChange: this._handleChange
				});
			}
	
			return _react2.default.DOM.div();
		},
		_loadLanguages: function _loadLanguages() {
			var self = this;
			api.getAsync('/api/v2/languages').done(function (languages) {
				var selectedLanguage = null;
				var select2Data = languages.items.map(function (item) {
					if (item.code === languages.meta.languageCode) {
						selectedLanguage = { id: item.code, text: item.name };
					}
					return { id: item.code, text: item.name };
				});
	
				self.setState({
					select2Data: select2Data,
					selectedLanguage: selectedLanguage
				});
			});
		},
		_handleChange: function _handleChange(language) {
			$.ajax({
				type: 'POST',
				url: '/plugin/useraccount/language/update',
				data: 'languageCode=' + language.id,
				success: function success() {
					location.reload(true);
				}
			});
		}
	});
	
	exports.default = _react2.default.createFactory(LanguageSelectBox);
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(/*! jquery */ 5)))

/***/ },

/***/ 264:
/*!***********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/Questionnaire.js ***!
  \***********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _EntityLoaderMixin = __webpack_require__(/*! ./mixin/EntityLoaderMixin */ 52);
	
	var _EntityLoaderMixin2 = _interopRequireDefault(_EntityLoaderMixin);
	
	var _EntityInstanceLoaderMixin = __webpack_require__(/*! ./mixin/EntityInstanceLoaderMixin */ 69);
	
	var _EntityInstanceLoaderMixin2 = _interopRequireDefault(_EntityInstanceLoaderMixin);
	
	var _I18nStringsMixin = __webpack_require__(/*! ./mixin/I18nStringsMixin */ 53);
	
	var _I18nStringsMixin2 = _interopRequireDefault(_I18nStringsMixin);
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Form = __webpack_require__(/*! ./Form */ 47);
	
	var _Form2 = _interopRequireDefault(_Form);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _underscore = __webpack_require__(/*! underscore */ 10);
	
	var _underscore2 = _interopRequireDefault(_underscore);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var div = _react2.default.DOM.div;
	
	var Questionnaire = _react2.default.createClass({
	  mixins: [_DeepPureRenderMixin2.default, _EntityLoaderMixin2.default, _EntityInstanceLoaderMixin2.default, _I18nStringsMixin2.default],
	  displayName: 'Questionnaire',
	  propTypes: {
	    entity: _react2.default.PropTypes.string.isRequired,
	    entityInstance: _react2.default.PropTypes.string.isRequired,
	    onContinueLaterClick: _react2.default.PropTypes.func,
	    successUrl: _react2.default.PropTypes.string
	  },
	  getDefaultProps: function getDefaultProps() {
	    return {
	      successUrl: null,
	      onContinueLaterClick: function onContinueLaterClick() {}
	    };
	  },
	  getInitialState: function getInitialState() {
	    return {
	      entity: null, // transfered from props to state, loaded from server if required
	      entityInstance: null, // transfered from props to state, loaded from server if required
	      i18nStrings: null //loaded from server
	    };
	  },
	  _onSubmitClick: function _onSubmitClick(e) {
	    this.refs.form.submit(e);
	  },
	  render: function render() {
	    if (this.state.entity === null || this.state.entityInstance === null || this.state.i18nStrings === null) {
	      return (0, _Spinner2.default)();
	    }
	
	    // a edit form with save-on-blur doesn't have a submit button
	    var QuestionnaireButtons = this.state.entityInstance.status !== 'SUBMITTED' ? div({ className: 'row', style: { textAlign: 'right' } }, div({ className: 'col-md-12' }, (0, _Button2.default)({ text: this.state.i18nStrings.questionnaire_save_and_continue, onClick: this.props.onContinueLaterClick }), (0, _Button2.default)({ type: 'button', style: 'primary', css: { marginLeft: 5 }, text: this.state.i18nStrings.questionnaire_submit, onClick: this._onSubmitClick }))) : null;
	
	    var Form = (0, _Form2.default)({
	      entity: this.state.entity,
	      entityInstance: this.state.entityInstance,
	      mode: this.state.entityInstance.status === 'SUBMITTED' ? 'view' : 'edit',
	      formLayout: 'vertical',
	      modal: false,
	      enableOptionalFilter: false,
	      saveOnBlur: true,
	      enableFormIndex: true,
	      enableAlertMessageInFormIndex: true,
	      categoricalMrefShowSelectAll: false,
	      showAsteriskIfNotNillable: false,
	      beforeSubmit: this._handleBeforeSubmit,
	      onValueChange: this._handleValueChange,
	      onSubmitSuccess: this._handleSubmitSuccess,
	      ref: 'form'
	    }, QuestionnaireButtons);
	
	    return div(null, Form);
	  },
	  _handleValueChange: function _handleValueChange(e) {
	    // update value in entity instance
	    var entityInstance = _underscore2.default.extend({}, this.state.entityInstance);
	    entityInstance[e.attr] = e.value;
	    this.setState({ entityInstance: entityInstance });
	  },
	  _handleBeforeSubmit: function _handleBeforeSubmit(arr, $form, options) {
	
	    var values = {};
	    _underscore2.default.each(this.state.entity.allAttributes, function (attr) {
	      var value = this.state.entityInstance[attr.name];
	
	      if (value !== null && value !== undefined) {
	        switch (attr.fieldType) {
	          case 'CATEGORICAL':
	          case 'XREF':
	            values[attr.name] = value[attr.refEntity.idAttribute];
	            break;
	          case 'CATEGORICAL_MREF':
	          case 'MREF':
	            values[attr.name] = _underscore2.default.map(value.items, function (item) {
	              return item[attr.refEntity.idAttribute];
	            }).join();
	            break;
	          case 'COMPOUND':
	            //nothing, no value
	            break;
	          default:
	            values[attr.name] = value;
	            break;
	        }
	      }
	    }, this);
	
	    for (var i = 0; i < arr.length; ++i) {
	      var attrName = arr[i].name;
	      var attr = this.state.entity.allAttributes[attrName];
	
	      //Set value of attribute with visibleExpression that is not visible to null
	      if (attr.visibleExpression && evalScript(attr.visibleExpression, values) === false) {
	        arr[i].value = null;
	      }
	
	      //Set status to SUBMITTED
	      if (attrName === 'status') {
	        arr[i].value = 'SUBMITTED';
	      }
	    }
	  },
	  _handleSubmitSuccess: function _handleSubmitSuccess() {
	    if (this.props.successUrl !== null) {
	      document.location = this.props.successUrl;
	    }
	  }
	});
	
	exports.default = _react2.default.createFactory(Questionnaire);

/***/ },

/***/ 265:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/RangeSlider.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _JQRangeSlider = __webpack_require__(/*! ./wrapper/JQRangeSlider */ 118);
	
	var _JQRangeSlider2 = _interopRequireDefault(_JQRangeSlider);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * Range slider control for number types
	 * 
	 * @memberOf component
	 */
	var RangeSlider = _react2.default.createClass({ // FIXME support readOnly
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'RangeSlider',
		propTypes: {
			id: _react2.default.PropTypes.string,
			range: _react2.default.PropTypes.shape({ min: _react2.default.PropTypes.number.isRequired, max: _react2.default.PropTypes.number.isRequired }).isRequired,
			value: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.number),
			step: _react2.default.PropTypes.string,
			disabled: _react2.default.PropTypes.bool,
			onValueChange: _react2.default.PropTypes.func.isRequired
		},
		render: function render() {
			var range = this.props.range;
			var value = this.props.value;
	
			var fromValue = value && value[0] ? value[0] : range.min;
			var toValue = value && value[1] ? value[1] : range.max;
			var options = {
				symmetricPositionning: true,
				bounds: { min: range.min, max: range.max },
				defaultValues: { min: fromValue, max: toValue },
				step: this.props.step,
				type: 'number'
			};
	
			return (0, _JQRangeSlider2.default)({
				id: this.props.id,
				options: options,
				disabled: this.props.disabled,
				value: [fromValue, toValue],
				onChange: this._handleChange
			});
		},
		_handleChange: function _handleChange(value) {
			this.props.onValueChange({ value: value });
		}
	});
	
	exports.default = _react2.default.createFactory(RangeSlider);

/***/ },

/***/ 266:
/*!*************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/UploadContainer.js ***!
  \*************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.UploadContainer = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _UploadForm = __webpack_require__(/*! ./UploadForm */ 113);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _AlertMessage = __webpack_require__(/*! ./AlertMessage */ 63);
	
	var _AlertMessage2 = _interopRequireDefault(_AlertMessage);
	
	var _JobContainer = __webpack_require__(/*! ./jobs/JobContainer */ 114);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var UploadContainer = _react2.default.createClass({
		displayName: 'UploadContainer',
		propTypes: {
			url: _react2.default.PropTypes.string.isRequired,
			width: _react2.default.PropTypes.oneOf(['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12']),
			onSubmit: _react2.default.PropTypes.func,
			onCompletion: _react2.default.PropTypes.func,
			validExtensions: _react2.default.PropTypes.array
		},
		getInitialState: function getInitialState() {
			return {
				job: null
			};
		},
		_onSubmit: function _onSubmit(form) {
			var _this = this;
	
			var data = new FormData();
			data.append('file', form.file);
			data.append('entityName', form.fileName);
			data.append('action', form.action);
			data.append('notify', false);
	
			var submission = _jquery2.default.ajax({
				url: this.props.url,
				type: 'POST',
				data: data,
				cache: false,
				dataType: 'json',
				// Don't process the files
				processData: false,
				// Set content type to false as jQuery will tell the server its a
				// query string request
				contentType: false,
				success: function success(data) {
					return _this.setState({ job: data });
				}
			});
			if (this.props.onSubmit) {
				submission.always(this.props.onSubmit);
			}
		},
		render: function render() {
			return _react2.default.createElement(
				'div',
				null,
				this.state.job ? _react2.default.createElement(_JobContainer.JobContainer, {
					jobHref: this.state.job,
					onCompletion: this._onCompletion
				}) : _react2.default.createElement(_UploadForm.UploadForm, {
					width: this.props.width,
					onSubmit: this._onSubmit,
					validExtensions: this.props.validExtensions
				})
			);
		},
		_onCompletion: function _onCompletion(job) {
			if (this.props.onCompletion) {
				this.props.onCompletion(job);
			}
			this.setState({ job: null });
		}
	});
	
	exports.UploadContainer = UploadContainer;
	exports.default = _react2.default.createFactory(UploadContainer);

/***/ },

/***/ 267:
/*!***************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/index.js ***!
  \***************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _mixin = __webpack_require__(/*! ./mixin */ 272);
	
	var _mixin2 = _interopRequireDefault(_mixin);
	
	var _wrapper = __webpack_require__(/*! ./wrapper */ 273);
	
	var _wrapper2 = _interopRequireDefault(_wrapper);
	
	var _Button = __webpack_require__(/*! ./Button */ 16);
	
	var _Button2 = _interopRequireDefault(_Button);
	
	var _AggregateTable = __webpack_require__(/*! ./AggregateTable */ 260);
	
	var _AggregateTable2 = _interopRequireDefault(_AggregateTable);
	
	var _AlertMessage = __webpack_require__(/*! ./AlertMessage */ 63);
	
	var _AlertMessage2 = _interopRequireDefault(_AlertMessage);
	
	var _AttributeControl = __webpack_require__(/*! ./AttributeControl */ 102);
	
	var _AttributeControl2 = _interopRequireDefault(_AttributeControl);
	
	var _BoolControl = __webpack_require__(/*! ./BoolControl */ 103);
	
	var _BoolControl2 = _interopRequireDefault(_BoolControl);
	
	var _CheckboxGroup = __webpack_require__(/*! ./CheckboxGroup */ 64);
	
	var _CheckboxGroup2 = _interopRequireDefault(_CheckboxGroup);
	
	var _CodeEditor = __webpack_require__(/*! ./CodeEditor */ 104);
	
	var _CodeEditor2 = _interopRequireDefault(_CodeEditor);
	
	var _DateControl = __webpack_require__(/*! ./DateControl */ 105);
	
	var _DateControl2 = _interopRequireDefault(_DateControl);
	
	var _Dialog = __webpack_require__(/*! ./Dialog */ 65);
	
	var _Dialog2 = _interopRequireDefault(_Dialog);
	
	var _EntitySelectBox = __webpack_require__(/*! ./EntitySelectBox */ 106);
	
	var _EntitySelectBox2 = _interopRequireDefault(_EntitySelectBox);
	
	var _Form = __webpack_require__(/*! ./Form */ 47);
	
	var _Form2 = _interopRequireDefault(_Form);
	
	var _FormControl = __webpack_require__(/*! ./FormControl */ 66);
	
	var _FormControl2 = _interopRequireDefault(_FormControl);
	
	var _FormControlGroup = __webpack_require__(/*! ./FormControlGroup */ 107);
	
	var _FormControlGroup2 = _interopRequireDefault(_FormControlGroup);
	
	var _Icon = __webpack_require__(/*! ./Icon */ 48);
	
	var _Icon2 = _interopRequireDefault(_Icon);
	
	var _Input = __webpack_require__(/*! ./Input */ 49);
	
	var _Input2 = _interopRequireDefault(_Input);
	
	var _LanguageSelectBox = __webpack_require__(/*! ./LanguageSelectBox */ 263);
	
	var _LanguageSelectBox2 = _interopRequireDefault(_LanguageSelectBox);
	
	var _Modal = __webpack_require__(/*! ./Modal */ 39);
	
	var _Modal2 = _interopRequireDefault(_Modal);
	
	var _Pager = __webpack_require__(/*! ./Pager */ 108);
	
	var _Pager2 = _interopRequireDefault(_Pager);
	
	var _Popover = __webpack_require__(/*! ./Popover */ 109);
	
	var _Popover2 = _interopRequireDefault(_Popover);
	
	var _Questionnaire = __webpack_require__(/*! ./Questionnaire */ 264);
	
	var _Questionnaire2 = _interopRequireDefault(_Questionnaire);
	
	var _RadioGroup = __webpack_require__(/*! ./RadioGroup */ 50);
	
	var _RadioGroup2 = _interopRequireDefault(_RadioGroup);
	
	var _RangeSlider = __webpack_require__(/*! ./RangeSlider */ 265);
	
	var _RangeSlider2 = _interopRequireDefault(_RangeSlider);
	
	var _SelectBox = __webpack_require__(/*! ./SelectBox */ 110);
	
	var _SelectBox2 = _interopRequireDefault(_SelectBox);
	
	var _Spinner = __webpack_require__(/*! ./Spinner */ 12);
	
	var _Spinner2 = _interopRequireDefault(_Spinner);
	
	var _Table = __webpack_require__(/*! ./Table */ 111);
	
	var _Table2 = _interopRequireDefault(_Table);
	
	var _ConfirmClick = __webpack_require__(/*! ./ConfirmClick */ 261);
	
	var _ConfirmClick2 = _interopRequireDefault(_ConfirmClick);
	
	var _TextArea = __webpack_require__(/*! ./TextArea */ 112);
	
	var _TextArea2 = _interopRequireDefault(_TextArea);
	
	var _ProgressBar = __webpack_require__(/*! ./ProgressBar */ 67);
	
	var _ProgressBar2 = _interopRequireDefault(_ProgressBar);
	
	var _FileIngestPlugin = __webpack_require__(/*! ./FileIngestPlugin */ 262);
	
	var _FileIngestPlugin2 = _interopRequireDefault(_FileIngestPlugin);
	
	var _jobs = __webpack_require__(/*! ./jobs */ 271);
	
	var _jobs2 = _interopRequireDefault(_jobs);
	
	var _UploadContainer = __webpack_require__(/*! ./UploadContainer */ 266);
	
	var _UploadContainer2 = _interopRequireDefault(_UploadContainer);
	
	var _UploadForm = __webpack_require__(/*! ./UploadForm */ 113);
	
	var _UploadForm2 = _interopRequireDefault(_UploadForm);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	// The React components
	exports.default = {
		'mixin': _mixin2.default,
		'wrapper': _wrapper2.default,
		'Button': _Button2.default,
		'AggregateTable': _AggregateTable2.default,
		'AlertMessage': _AlertMessage2.default,
		'AttributeControl': _AttributeControl2.default,
		'BoolControl': _BoolControl2.default,
		'CheckboxGroup': _CheckboxGroup2.default,
		'CodeEditor': _CodeEditor2.default,
		'DateControl': _DateControl2.default,
		'Dialog': _Dialog2.default,
		'EntitySelectBox': _EntitySelectBox2.default,
		'Form': _Form2.default,
		'FormControl': _FormControl2.default,
		'FormControlGroup': _FormControlGroup2.default,
		'Icon': _Icon2.default,
		'Input': _Input2.default,
		'LanguageSelectBox': _LanguageSelectBox2.default,
		'Modal': _Modal2.default,
		'Pager': _Pager2.default,
		'Popover': _Popover2.default,
		'Questionnaire': _Questionnaire2.default,
		'RadioGroup': _RadioGroup2.default,
		'RangeSlider': _RangeSlider2.default,
		'SelectBox': _SelectBox2.default,
		'Spinner': _Spinner2.default,
		'Table': _Table2.default,
		'TextArea': _TextArea2.default,
		'ProgressBar': _ProgressBar2.default,
		'jobs': _jobs2.default,
		'FileIngestPlugin': _FileIngestPlugin2.default,
		'ConfirmClick': _ConfirmClick2.default,
		'UploadContainer': _UploadContainer2.default,
		'UploadForm': _UploadForm2.default
	}; /**
	    * This module exposes all the react components.
	    * Mainly used for legacy javascript.
	    * 
	    * @module
	    */

/***/ },

/***/ 268:
/*!*************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/JobDetails.js ***!
  \*************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.JobDetails = undefined;
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; }; /**
	                                                                                                                                                                                                                                                   * JobDetails shows job details
	                                                                                                                                                                                                                                                   *
	                                                                                                                                                                                                                                                   * @module Job
	                                                                                                                                                                                                                                                   *
	                                                                                                                                                                                                                                                   * @param job
	                                                                                                                                                                                                                                                   *            A key value object containing all the details of a job including
	                                                                                                                                                                                                                                                   *            its status and progress message plus details specific to this type
	                                                                                                                                                                                                                                                   *            of job.
	                                                                                                                                                                                                                                                   *
	                                                                                                                                                                                                                                                   * @exports JobDetails class
	                                                                                                                                                                                                                                                   */
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _ProgressBar = __webpack_require__(/*! ../ProgressBar */ 67);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _Ace = __webpack_require__(/*! ../wrapper/Ace */ 72);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var JobDetails = _react2.default.createClass({
	    mixins: [_DeepPureRenderMixin2.default],
	    displayName: 'JobDetails',
	    propTypes: {
	        job: _react2.default.PropTypes.object.isRequired
	    },
	    render: function render() {
	        var job = this.props.job;
	
	        return _react2.default.createElement(
	            'div',
	            null,
	            _react2.default.createElement(
	                'form',
	                { className: 'form-horizontal' },
	                Object.keys(job).map(function (key) {
	                    return _react2.default.createElement(
	                        'div',
	                        { className: 'form-group' },
	                        _react2.default.createElement(
	                            'label',
	                            { className: 'col-sm-2 control-label' },
	                            key
	                        ),
	                        _react2.default.createElement(
	                            'div',
	                            { className: 'col-sm-10' },
	                            key === 'log' ? _react2.default.createElement(_Ace.Ace, { readOnly: true,
	                                value: job.log,
	                                mode: 'text',
	                                tail: true }) : _react2.default.createElement(
	                                'p',
	                                { className: 'form-control-static' },
	                                _typeof(job[key]) === 'object' ? job[key]['__labelValue'] : job[key]
	                            )
	                        )
	                    );
	                })
	            )
	        );
	    }
	});
	
	exports.JobDetails = JobDetails;
	exports.default = _react2.default.createFactory(JobDetails);

/***/ },

/***/ 269:
/*!****************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/JobsContainer.js ***!
  \****************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _RestClientV = __webpack_require__(/*! rest-client/RestClientV2 */ 41);
	
	var _RestClientV2 = _interopRequireDefault(_RestClientV);
	
	var _Spinner = __webpack_require__(/*! ../Spinner */ 12);
	
	var _jquery = __webpack_require__(/*! jquery */ 5);
	
	var _jquery2 = _interopRequireDefault(_jquery);
	
	var _reactNotificationSystem = __webpack_require__(/*! react-notification-system */ 325);
	
	var _reactNotificationSystem2 = _interopRequireDefault(_reactNotificationSystem);
	
	var _Jobs = __webpack_require__(/*! ./Jobs */ 116);
	
	var _SetIntervalMixin = __webpack_require__(/*! ../mixin/SetIntervalMixin */ 71);
	
	var _SetIntervalMixin2 = _interopRequireDefault(_SetIntervalMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var JobsContainer = _react2.default.createClass({
	    mixins: [_SetIntervalMixin2.default],
	    displayName: 'JobsContainer',
	    propTypes: {
	        url: _react2.default.PropTypes.string,
	        interval: _react2.default.PropTypes.number
	    },
	    _notificationSystem: null,
	    getInitialState: function getInitialState() {
	        return {
	            jobs: null,
	            selectedJobId: null
	        };
	    },
	    componentDidMount: function componentDidMount() {
	        this.retrieveJobs();
	        this.setInterval(this.retrieveJobs, this.props.interval || 1000);
	        this._notificationSystem = this.refs.notificationSystem;
	    },
	    render: function render() {
	        return _react2.default.createElement(
	            'div',
	            null,
	            _react2.default.createElement(_reactNotificationSystem2.default, { ref: 'notificationSystem' }),
	            this.state.jobs === null ? _react2.default.createElement(_Spinner.Spinner, null) : _react2.default.cloneElement(this.props.children, {
	                jobs: this.state.jobs,
	                onSelect: this._onJobSelect,
	                selectedJobId: this.state.selectedJobId
	            })
	        );
	    },
	    _onJobSelect: function _onJobSelect(selectedJobId) {
	        this.setState({ selectedJobId: selectedJobId });
	    },
	    _getNewlyFinishedJobs: function _getNewlyFinishedJobs(jobs) {
	        if (!this.state.jobs) {
	            return [];
	        }
	        var runningJobIDs = this.state.jobs.filter(function (job) {
	            return job.status === 'RUNNING';
	        }).map(function (job) {
	            return job.identifier;
	        });
	        return jobs.filter(function (newJob) {
	            return newJob.status !== 'RUNNING' && runningJobIDs.indexOf(newJob.identifier) >= 0;
	        });
	    },
	    retrieveJobs: function retrieveJobs() {
	        var self = this;
	        _jquery2.default.get(this.props.url, function (data) {
	            self._getNewlyFinishedJobs(data).forEach(function (job) {
	                var notification = {
	                    title: 'Job finished',
	                    message: job.progressMessage,
	                    level: job.status === 'SUCCESS' ? 'success' : 'warning',
	                    position: 'tr',
	                    action: job.resultUrl && {
	                        label: 'Go to result',
	                        callback: function callback() {
	                            window.location = job.resultUrl;
	                        }
	                    }
	                };
	                self._notificationSystem.addNotification(notification);
	            });
	            self.setState({ jobs: data });
	        });
	    }
	}); /**
	     * The JobsContainer retrieves jobs from the server and feeds it to its
	     * child component to render, typically a Jobs component.
	     * Shows a spinner while fetching.
	     * Shows a notification when a job that was previously running finishes.
	     *
	     * @module JobsContainer
	     *
	     * @param url
	     *            String representation of the URL where the jobs can be retrieved
	     * @param interval
	     *            Timeout in milliseconds between retrieval of the jobs, default 1000
	     *
	     * @exports JobsContainer factory
	     */
	
	
	exports.default = _react2.default.createFactory(JobsContainer);

/***/ },

/***/ 270:
/*!**************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/RunningJobs.js ***!
  \**************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.RunningJobs = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Job = __webpack_require__(/*! ./Job */ 68);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ../mixin/DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var RunningJobs = _react2.default.createClass({
		mixins: [_DeepPureRenderMixin2.default],
		displayName: 'RunningJobs',
		propTypes: {
			jobs: _react2.default.PropTypes.array.isRequired,
			onSelect: _react2.default.PropTypes.func
		},
		render: function render() {
			var _props = this.props;
			var jobs = _props.jobs;
			var onSelect = _props.onSelect;
	
			return _react2.default.createElement(
				'div',
				{ className: 'panel panel-primary' },
				_react2.default.createElement(
					'div',
					{ className: 'panel-heading' },
					'Running Jobs'
				),
				_react2.default.createElement(
					'div',
					{ className: 'panel-body' },
					jobs.map(function (job) {
						return _react2.default.createElement(_Job.Job, { job: job,
							key: job.identifier,
							onClick: function onClick() {
								return onSelect(job.identifier);
							} });
					})
				)
			);
		}
	}); /**
	     * Renders a ProgressBar component for each job passed down from its parent
	     * component
	     * 
	     * @module RunningJobs
	     * 
	     * @param jobs
	     *            An array of job objects with status RUNNING
	     * 
	     * @exports RunningJobs class
	     */
	
	
	exports.RunningJobs = RunningJobs;
	exports.default = _react2.default.createFactory(RunningJobs);

/***/ },

/***/ 271:
/*!********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/jobs/index.js ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.Jobs = exports.JobTable = exports.JobsContainer = exports.JobContainer = exports.Job = undefined;
	
	var _react = __webpack_require__(/*! react */ 3);
	
	var _react2 = _interopRequireDefault(_react);
	
	var _Job = __webpack_require__(/*! ./Job */ 68);
	
	var _Job2 = _interopRequireDefault(_Job);
	
	var _Jobs = __webpack_require__(/*! ./Jobs */ 116);
	
	var _Jobs2 = _interopRequireDefault(_Jobs);
	
	var _JobContainer = __webpack_require__(/*! ./JobContainer */ 114);
	
	var _JobContainer2 = _interopRequireDefault(_JobContainer);
	
	var _JobsContainer = __webpack_require__(/*! ./JobsContainer */ 269);
	
	var _JobsContainer2 = _interopRequireDefault(_JobsContainer);
	
	var _JobTable = __webpack_require__(/*! ./JobTable */ 115);
	
	var _JobTable2 = _interopRequireDefault(_JobTable);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	exports.Job = _Job2.default;
	exports.JobContainer = _JobContainer2.default;
	exports.JobsContainer = _JobsContainer2.default;
	exports.JobTable = _JobTable2.default;
	exports.Jobs = _Jobs2.default;
	exports.default = { Job: _Job2.default, JobContainer: _JobContainer2.default, JobsContainer: _JobsContainer2.default, JobTable: _JobTable2.default, Jobs: _Jobs2.default };

/***/ },

/***/ 272:
/*!*********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/mixin/index.js ***!
  \*********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	
	var _AttributeLoaderMixin = __webpack_require__(/*! ./AttributeLoaderMixin */ 51);
	
	var _AttributeLoaderMixin2 = _interopRequireDefault(_AttributeLoaderMixin);
	
	var _DeepPureRenderMixin = __webpack_require__(/*! ./DeepPureRenderMixin */ 6);
	
	var _DeepPureRenderMixin2 = _interopRequireDefault(_DeepPureRenderMixin);
	
	var _EntityInstanceLoaderMixin = __webpack_require__(/*! ./EntityInstanceLoaderMixin */ 69);
	
	var _EntityInstanceLoaderMixin2 = _interopRequireDefault(_EntityInstanceLoaderMixin);
	
	var _EntityLoaderMixin = __webpack_require__(/*! ./EntityLoaderMixin */ 52);
	
	var _EntityLoaderMixin2 = _interopRequireDefault(_EntityLoaderMixin);
	
	var _GroupMixin = __webpack_require__(/*! ./GroupMixin */ 70);
	
	var _GroupMixin2 = _interopRequireDefault(_GroupMixin);
	
	var _I18nStringsMixin = __webpack_require__(/*! ./I18nStringsMixin */ 53);
	
	var _I18nStringsMixin2 = _interopRequireDefault(_I18nStringsMixin);
	
	var _ReactLayeredComponentMixin = __webpack_require__(/*! ./ReactLayeredComponentMixin */ 40);
	
	var _ReactLayeredComponentMixin2 = _interopRequireDefault(_ReactLayeredComponentMixin);
	
	var _SetIntervalMixin = __webpack_require__(/*! ./SetIntervalMixin */ 71);
	
	var _SetIntervalMixin2 = _interopRequireDefault(_SetIntervalMixin);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * This module exposes all the mixin classes.
	 * Mainly used for legacy javascript.
	 * 
	 * @module mixin
	 */
	
	var mixin = {
		'AttributeLoaderMixin': _AttributeLoaderMixin2.default,
		'DeepPureRenderMixin': _DeepPureRenderMixin2.default,
		'EntityInstanceLoaderMixin': _EntityInstanceLoaderMixin2.default,
		'EntityLoaderMixin': _EntityLoaderMixin2.default,
		'GroupMixin': _GroupMixin2.default,
		'I18nStringsMixin': _I18nStringsMixin2.default,
		'ReactLayeredComponentMixin': _ReactLayeredComponentMixin2.default,
		'SetIntervalMixin': _SetIntervalMixin2.default
	};
	
	exports.default = mixin;

/***/ },

/***/ 273:
/*!***********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/wrapper/index.js ***!
  \***********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	
	var _Ace = __webpack_require__(/*! ./Ace */ 72);
	
	var _Ace2 = _interopRequireDefault(_Ace);
	
	var _DateTimePicker = __webpack_require__(/*! ./DateTimePicker */ 117);
	
	var _DateTimePicker2 = _interopRequireDefault(_DateTimePicker);
	
	var _JQRangeSlider = __webpack_require__(/*! ./JQRangeSlider */ 118);
	
	var _JQRangeSlider2 = _interopRequireDefault(_JQRangeSlider);
	
	var _JQueryForm = __webpack_require__(/*! ./JQueryForm */ 119);
	
	var _JQueryForm2 = _interopRequireDefault(_JQueryForm);
	
	var _Select = __webpack_require__(/*! ./Select2 */ 73);
	
	var _Select2 = _interopRequireDefault(_Select);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var wrapper = {
	  'Ace': _Ace2.default,
	  'DateTimePicker': _DateTimePicker2.default,
	  'JQRangeSlider': _JQRangeSlider2.default,
	  'JQueryForm': _JQueryForm2.default,
	  'Select2': _Select2.default
	}; /**
	    * This module exposes all the wrapper classes.
	    * Mainly used for legacy javascript.
	    * 
	    * @module wrapper
	    */
	
	exports.default = wrapper;

/***/ },

/***/ 274:
/*!***********************************************************!*\
  !*** ./src/main/javascript/molgenis-global-ui-webpack.js ***!
  \***********************************************************/
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var _reactComponents = __webpack_require__(/*! react-components */ 267);
	
	var _reactComponents2 = _interopRequireDefault(_reactComponents);
	
	var _addons = __webpack_require__(/*! react/addons */ 222);
	
	var _addons2 = _interopRequireDefault(_addons);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	window.top.molgenis = window.top.molgenis || {};
	window.top.molgenis.ui = _reactComponents2.default;
	window.top.React = _addons2.default;

/***/ },

/***/ 307:
/*!**************************************************************************************!*\
  !*** ./~/css-loader!./src/main/javascript/modules/react-components/css/Checkbox.css ***!
  \**************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(/*! ./../../../../../../~/css-loader/lib/css-base.js */ 20)();
	// imports
	
	
	// module
	exports.push([module.id, "/* Fix for https://github.com/twbs/bootstrap/issues/13997 */\n.checkbox label {\n    min-height: 20px;   \n}", ""]);
	
	// exports


/***/ },

/***/ 308:
/*!***********************************************************************************!*\
  !*** ./~/css-loader!./src/main/javascript/modules/react-components/css/Radio.css ***!
  \***********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(/*! ./../../../../../../~/css-loader/lib/css-base.js */ 20)();
	// imports
	
	
	// module
	exports.push([module.id, "/* Fix for https://github.com/twbs/bootstrap/issues/13997 */\n.radio label {\n    min-height: 20px;   \n}", ""]);
	
	// exports


/***/ },

/***/ 309:
/*!***********************************************************************************!*\
  !*** ./~/css-loader!./src/main/javascript/modules/react-components/css/Table.css ***!
  \***********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(/*! ./../../../../../../~/css-loader/lib/css-base.js */ 20)();
	// imports
	
	
	// module
	exports.push([module.id, ".molgenis-table-container {\n\tmargin-bottom: 10px;\n\toverflow: auto;\n\twhite-space: nowrap;\n}\n\n.molgenis-table {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\n\n.molgenis-table thead th.compact {\n    width: 1px;\n    white-space: nowrap;\n}\n\n.table-hover tbody tr {\n    cursor: pointer;\n}\n\n.molgenis-table .show-popover {\n\tcursor: pointer;\n}\n\n.molgenis-table .table-hover tr:hover {\n    background-color: #7CBAD1;\n}\n\n.molgenis-table .popover-content {\n\tword-wrap: break-word;\t\n}\n\n/* define borders on the left and right expanded without specifying border colors */  \n.molgenis-table {\n    border-style: none;\t\n}\n\n.molgenis-table thead > tr > th:not(.expanded-left):not(.expanded-right), .molgenis-table tbody > tr > td:not(.expanded-left):not(.expanded-right) {\n    border-left-style: none;\n    border-right-style: none;\n}\n\n.molgenis-table tbody > tr:last-child > td {\n    border-bottom-style: none;\n}\n\n.molgenis-table th.expanded-left, .molgenis-table td.expanded-left {\n    border-right-style: none;\n}\n\n.molgenis-table th.expanded-right, .molgenis-table td.expanded-right {\n    border-left-style: none;\n}", ""]);
	
	// exports


/***/ },

/***/ 310:
/*!****************************************************************************************************!*\
  !*** ./~/css-loader!./src/main/javascript/modules/react-components/css/wrapper/DateTimePicker.css ***!
  \****************************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(/*! ./../../../../../../../~/css-loader/lib/css-base.js */ 20)();
	// imports
	
	
	// module
	exports.push([module.id, "/* Css fix in case of multiple addons */\n.input-group-addon:not(:first-child):not(:last-child) {\n    border-left: 0px;\n}", ""]);
	
	// exports


/***/ },

/***/ 312:
/*!************************************************************************************************!*\
  !*** ./~/css-loader!./src/main/javascript/modules/react-components/css/wrapper/iThing-min.css ***!
  \************************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(/*! ./../../../../../../../~/css-loader/lib/css-base.js */ 20)();
	// imports
	
	
	// module
	exports.push([module.id, ".ui-rangeSlider{height:30px;padding-top:40px}.ui-rangeSlider,.ui-rangeSlider-container,.ui-rangeSlider-arrow{-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box}.ui-rangeSlider-withArrows .ui-rangeSlider-container{margin:0 15px}.ui-rangeSlider-withArrows .ui-rangeSlider-container,.ui-rangeSlider-noArrow .ui-rangeSlider-container,.ui-rangeSlider-arrow{-webkit-box-shadow:inset 0 4px 6px -2px RGBA(0,0,0,.5);-moz-box-shadow:inset 0 4px 6px -2px RGBA(0,0,0,.5);box-shadow:inset 0 4px 6px -2px RGBA(0,0,0,.5)}.ui-rangeSlider-disabled.ui-rangeSlider-withArrows .ui-rangeSlider-container,.ui-rangeSlider-disabled.ui-rangeSlider-noArrow .ui-rangeSlider-container,.ui-rangeSlider-disabled .ui-rangeSlider-arrow{-webkit-box-shadow:inset 0 4px 6px -2px RGBA(0,0,0,.3);-moz-box-shadow:inset 0 4px 6px -2px RGBA(0,0,0,.3);box-shadow:inset 0 4px 6px -2px RGBA(0,0,0,.3)}.ui-rangeSlider-noArrow .ui-rangeSlider-container{-moz-border-radius:4px;border-radius:4px;border-left:solid 1px #515862;border-right:solid 1px #515862}.ui-rangeSlider-disabled.ui-rangeSlider-noArrow .ui-rangeSlider-container{border-color:#8490a3}.ui-rangeSlider-container,.ui-rangeSlider-arrow{height:30px;border-top:solid 1px #232a32;border-bottom:solid 1px #6a7179}.ui-rangeSlider-disabled .ui-rangeSlider-container,.ui-rangeSlider-disabled .ui-rangeSlider-arrow{border-top-color:#49576b;border-bottom-color:#9ca7b3}.ui-rangeSlider-container,.ui-rangeSlider-arrow,.ui-rangeSlider-label{background:#67707F;background:-moz-linear-gradient(top,#67707F 0,#888DA0 100%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0%,#67707F),color-stop(100%,#888DA0))}.ui-rangeSlider-disabled .ui-rangeSlider-container,.ui-rangeSlider-disabled .ui-rangeSlider-arrow,.ui-rangeSlider-disabled .ui-rangeSlider-label{background:#95a4bd;background:-moz-linear-gradient(top,#95a4bd 0,#b2bbd8 100%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0%,#95a4bd),color-stop(100%,#b2bbd8))}.ui-rangeSlider-arrow{width:14px;cursor:pointer}.ui-rangeSlider-leftArrow{border-radius:4px 0 0 4px;border-left:solid 1px #515862}.ui-rangeSlider-disabled .ui-rangeSlider-leftArrow{border-left-color:#8792a2}.ui-rangeSlider-rightArrow{border-radius:0 4px 4px 0;border-right:solid 1px #515862}.ui-rangeSlider-disabled .ui-rangeSlider-rightArrow{border-right-color:#8792a2}.ui-rangeSlider-arrow-inner{position:absolute;top:50%;border:10px solid transparent;width:0;height:0;margin-top:-10px}.ui-rangeSlider-leftArrow .ui-rangeSlider-arrow-inner{border-right:10px solid #a4a8b7;left:0;margin-left:-8px}.ui-rangeSlider-leftArrow:hover .ui-rangeSlider-arrow-inner{border-right:10px solid #b3b6c2}.ui-rangeSlider-disabled .ui-rangeSlider-leftArrow .ui-rangeSlider-arrow-inner,.ui-rangeSlider-disabled .ui-rangeSlider-leftArrow:hover .ui-rangeSlider-arrow-inner{border-right-color:#bbc0cf}.ui-rangeSlider-rightArrow .ui-rangeSlider-arrow-inner{border-left:10px solid #a4a8b7;right:0;margin-right:-8px}.ui-rangeSlider-rightArrow:hover .ui-rangeSlider-arrow-inner{border-left:10px solid #b3b6c2}.ui-rangeSlider-disabled .ui-rangeSlider-rightArrow .ui-rangeSlider-arrow-inner,.ui-rangeSlider-disabled .ui-rangeSlider-rightArrow:hover .ui-rangeSlider-arrow-inner{border-left-color:#bbc0cf}.ui-rangeSlider-innerBar{width:110%;height:100%;left:-10px;overflow:hidden}.ui-rangeSlider-bar{background:#68a1d6;height:29px;margin:1px 0;-moz-border-radius:4px;border-radius:4px;cursor:move;cursor:grab;cursor:-moz-grab;-webkit-box-shadow:inset 0 2px 6px RGBA(0,0,0,.5);-moz-box-shadow:inset 0 2px 6px RGBA(0,0,0,.5);box-shadow:inset 0 2px 6px RGBA(0,0,0,.5)}.ui-rangeSlider-disabled .ui-rangeSlider-bar{background:#93aeca;-webkit-box-shadow:inset 0 2px 6px RGBA(0,0,0,.3);-moz-box-shadow:inset 0 2px 6px RGBA(0,0,0,.3);box-shadow:inset 0 2px 6px RGBA(0,0,0,.3)}.ui-rangeSlider-handle{width:10px;height:30px;background:transparent;cursor:col-resize}.ui-rangeSlider-label{padding:5px 10px;bottom:40px;-moz-border-radius:4px;border-radius:4px;-webkit-box-shadow:0 1px 0 #c2c5d6;-moz-box-shadow:0 1px 0 #c2c5d6;box-shadow:0 1px 0 #c2c5d6;color:#fff;font-size:15px;cursor:col-resize}.ui-rangeSlider-label-inner{position:absolute;top:100%;left:50%;display:block;z-index:99;border-left:10px solid transparent;border-right:10px solid transparent;margin-left:-10px;border-top:10px solid #888DA0}.ui-rangeSlider-disabled .ui-rangeSlider-label-inner{border-top-color:#b2bbd8}.ui-editRangeSlider-inputValue{width:3em;text-align:right;font-size:15px}.ui-rangeSlider .ui-ruler-scale{position:absolute;top:0;left:0;bottom:0;right:0}.ui-rangeSlider .ui-ruler-tick{float:left}.ui-rangeSlider .ui-ruler-scale0 .ui-ruler-tick-inner{color:#fff;margin-top:1px;border-left:1px solid #fff;height:29px;padding-left:2px;position:relative}.ui-rangeSlider .ui-ruler-scale0 .ui-ruler-tick-label{position:absolute;bottom:6px}.ui-rangeSlider .ui-ruler-scale1 .ui-ruler-tick-inner{border-left:1px solid #fff;margin-top:25px;height:5px}", ""]);
	
	// exports


/***/ },

/***/ 316:
/*!**************************************!*\
  !*** ./~/jquery-form/jquery.form.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	 * jQuery Form Plugin
	 * version: 3.50.0-2014.02.05
	 * Requires jQuery v1.5 or later
	 * Copyright (c) 2013 M. Alsup
	 * Examples and documentation at: http://malsup.com/jquery/form/
	 * Project repository: https://github.com/malsup/form
	 * Dual licensed under the MIT and GPL licenses.
	 * https://github.com/malsup/form#copyright-and-license
	 */
	/*global ActiveXObject */
	
	// AMD support
	(function (factory) {
	    "use strict";
	    if (true) {
	        // using AMD; register as anon module
	        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ 5)], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	    } else {
	        // no AMD; invoke directly
	        factory( (typeof(jQuery) != 'undefined') ? jQuery : window.Zepto );
	    }
	}
	
	(function($) {
	"use strict";
	
	/*
	    Usage Note:
	    -----------
	    Do not use both ajaxSubmit and ajaxForm on the same form.  These
	    functions are mutually exclusive.  Use ajaxSubmit if you want
	    to bind your own submit handler to the form.  For example,
	
	    $(document).ready(function() {
	        $('#myForm').on('submit', function(e) {
	            e.preventDefault(); // <-- important
	            $(this).ajaxSubmit({
	                target: '#output'
	            });
	        });
	    });
	
	    Use ajaxForm when you want the plugin to manage all the event binding
	    for you.  For example,
	
	    $(document).ready(function() {
	        $('#myForm').ajaxForm({
	            target: '#output'
	        });
	    });
	
	    You can also use ajaxForm with delegation (requires jQuery v1.7+), so the
	    form does not have to exist when you invoke ajaxForm:
	
	    $('#myForm').ajaxForm({
	        delegation: true,
	        target: '#output'
	    });
	
	    When using ajaxForm, the ajaxSubmit function will be invoked for you
	    at the appropriate time.
	*/
	
	/**
	 * Feature detection
	 */
	var feature = {};
	feature.fileapi = $("<input type='file'/>").get(0).files !== undefined;
	feature.formdata = window.FormData !== undefined;
	
	var hasProp = !!$.fn.prop;
	
	// attr2 uses prop when it can but checks the return type for
	// an expected string.  this accounts for the case where a form 
	// contains inputs with names like "action" or "method"; in those
	// cases "prop" returns the element
	$.fn.attr2 = function() {
	    if ( ! hasProp ) {
	        return this.attr.apply(this, arguments);
	    }
	    var val = this.prop.apply(this, arguments);
	    if ( ( val && val.jquery ) || typeof val === 'string' ) {
	        return val;
	    }
	    return this.attr.apply(this, arguments);
	};
	
	/**
	 * ajaxSubmit() provides a mechanism for immediately submitting
	 * an HTML form using AJAX.
	 */
	$.fn.ajaxSubmit = function(options) {
	    /*jshint scripturl:true */
	
	    // fast fail if nothing selected (http://dev.jquery.com/ticket/2752)
	    if (!this.length) {
	        log('ajaxSubmit: skipping submit process - no element selected');
	        return this;
	    }
	
	    var method, action, url, $form = this;
	
	    if (typeof options == 'function') {
	        options = { success: options };
	    }
	    else if ( options === undefined ) {
	        options = {};
	    }
	
	    method = options.type || this.attr2('method');
	    action = options.url  || this.attr2('action');
	
	    url = (typeof action === 'string') ? $.trim(action) : '';
	    url = url || window.location.href || '';
	    if (url) {
	        // clean url (don't include hash vaue)
	        url = (url.match(/^([^#]+)/)||[])[1];
	    }
	
	    options = $.extend(true, {
	        url:  url,
	        success: $.ajaxSettings.success,
	        type: method || $.ajaxSettings.type,
	        iframeSrc: /^https/i.test(window.location.href || '') ? 'javascript:false' : 'about:blank'
	    }, options);
	
	    // hook for manipulating the form data before it is extracted;
	    // convenient for use with rich editors like tinyMCE or FCKEditor
	    var veto = {};
	    this.trigger('form-pre-serialize', [this, options, veto]);
	    if (veto.veto) {
	        log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');
	        return this;
	    }
	
	    // provide opportunity to alter form data before it is serialized
	    if (options.beforeSerialize && options.beforeSerialize(this, options) === false) {
	        log('ajaxSubmit: submit aborted via beforeSerialize callback');
	        return this;
	    }
	
	    var traditional = options.traditional;
	    if ( traditional === undefined ) {
	        traditional = $.ajaxSettings.traditional;
	    }
	
	    var elements = [];
	    var qx, a = this.formToArray(options.semantic, elements);
	    if (options.data) {
	        options.extraData = options.data;
	        qx = $.param(options.data, traditional);
	    }
	
	    // give pre-submit callback an opportunity to abort the submit
	    if (options.beforeSubmit && options.beforeSubmit(a, this, options) === false) {
	        log('ajaxSubmit: submit aborted via beforeSubmit callback');
	        return this;
	    }
	
	    // fire vetoable 'validate' event
	    this.trigger('form-submit-validate', [a, this, options, veto]);
	    if (veto.veto) {
	        log('ajaxSubmit: submit vetoed via form-submit-validate trigger');
	        return this;
	    }
	
	    var q = $.param(a, traditional);
	    if (qx) {
	        q = ( q ? (q + '&' + qx) : qx );
	    }
	    if (options.type.toUpperCase() == 'GET') {
	        options.url += (options.url.indexOf('?') >= 0 ? '&' : '?') + q;
	        options.data = null;  // data is null for 'get'
	    }
	    else {
	        options.data = q; // data is the query string for 'post'
	    }
	
	    var callbacks = [];
	    if (options.resetForm) {
	        callbacks.push(function() { $form.resetForm(); });
	    }
	    if (options.clearForm) {
	        callbacks.push(function() { $form.clearForm(options.includeHidden); });
	    }
	
	    // perform a load on the target only if dataType is not provided
	    if (!options.dataType && options.target) {
	        var oldSuccess = options.success || function(){};
	        callbacks.push(function(data) {
	            var fn = options.replaceTarget ? 'replaceWith' : 'html';
	            $(options.target)[fn](data).each(oldSuccess, arguments);
	        });
	    }
	    else if (options.success) {
	        callbacks.push(options.success);
	    }
	
	    options.success = function(data, status, xhr) { // jQuery 1.4+ passes xhr as 3rd arg
	        var context = options.context || this ;    // jQuery 1.4+ supports scope context
	        for (var i=0, max=callbacks.length; i < max; i++) {
	            callbacks[i].apply(context, [data, status, xhr || $form, $form]);
	        }
	    };
	
	    if (options.error) {
	        var oldError = options.error;
	        options.error = function(xhr, status, error) {
	            var context = options.context || this;
	            oldError.apply(context, [xhr, status, error, $form]);
	        };
	    }
	
	     if (options.complete) {
	        var oldComplete = options.complete;
	        options.complete = function(xhr, status) {
	            var context = options.context || this;
	            oldComplete.apply(context, [xhr, status, $form]);
	        };
	    }
	
	    // are there files to upload?
	
	    // [value] (issue #113), also see comment:
	    // https://github.com/malsup/form/commit/588306aedba1de01388032d5f42a60159eea9228#commitcomment-2180219
	    var fileInputs = $('input[type=file]:enabled', this).filter(function() { return $(this).val() !== ''; });
	
	    var hasFileInputs = fileInputs.length > 0;
	    var mp = 'multipart/form-data';
	    var multipart = ($form.attr('enctype') == mp || $form.attr('encoding') == mp);
	
	    var fileAPI = feature.fileapi && feature.formdata;
	    log("fileAPI :" + fileAPI);
	    var shouldUseFrame = (hasFileInputs || multipart) && !fileAPI;
	
	    var jqxhr;
	
	    // options.iframe allows user to force iframe mode
	    // 06-NOV-09: now defaulting to iframe mode if file input is detected
	    if (options.iframe !== false && (options.iframe || shouldUseFrame)) {
	        // hack to fix Safari hang (thanks to Tim Molendijk for this)
	        // see:  http://groups.google.com/group/jquery-dev/browse_thread/thread/36395b7ab510dd5d
	        if (options.closeKeepAlive) {
	            $.get(options.closeKeepAlive, function() {
	                jqxhr = fileUploadIframe(a);
	            });
	        }
	        else {
	            jqxhr = fileUploadIframe(a);
	        }
	    }
	    else if ((hasFileInputs || multipart) && fileAPI) {
	        jqxhr = fileUploadXhr(a);
	    }
	    else {
	        jqxhr = $.ajax(options);
	    }
	
	    $form.removeData('jqxhr').data('jqxhr', jqxhr);
	
	    // clear element array
	    for (var k=0; k < elements.length; k++) {
	        elements[k] = null;
	    }
	
	    // fire 'notify' event
	    this.trigger('form-submit-notify', [this, options]);
	    return this;
	
	    // utility fn for deep serialization
	    function deepSerialize(extraData){
	        var serialized = $.param(extraData, options.traditional).split('&');
	        var len = serialized.length;
	        var result = [];
	        var i, part;
	        for (i=0; i < len; i++) {
	            // #252; undo param space replacement
	            serialized[i] = serialized[i].replace(/\+/g,' ');
	            part = serialized[i].split('=');
	            // #278; use array instead of object storage, favoring array serializations
	            result.push([decodeURIComponent(part[0]), decodeURIComponent(part[1])]);
	        }
	        return result;
	    }
	
	     // XMLHttpRequest Level 2 file uploads (big hat tip to francois2metz)
	    function fileUploadXhr(a) {
	        var formdata = new FormData();
	
	        for (var i=0; i < a.length; i++) {
	            formdata.append(a[i].name, a[i].value);
	        }
	
	        if (options.extraData) {
	            var serializedData = deepSerialize(options.extraData);
	            for (i=0; i < serializedData.length; i++) {
	                if (serializedData[i]) {
	                    formdata.append(serializedData[i][0], serializedData[i][1]);
	                }
	            }
	        }
	
	        options.data = null;
	
	        var s = $.extend(true, {}, $.ajaxSettings, options, {
	            contentType: false,
	            processData: false,
	            cache: false,
	            type: method || 'POST'
	        });
	
	        if (options.uploadProgress) {
	            // workaround because jqXHR does not expose upload property
	            s.xhr = function() {
	                var xhr = $.ajaxSettings.xhr();
	                if (xhr.upload) {
	                    xhr.upload.addEventListener('progress', function(event) {
	                        var percent = 0;
	                        var position = event.loaded || event.position; /*event.position is deprecated*/
	                        var total = event.total;
	                        if (event.lengthComputable) {
	                            percent = Math.ceil(position / total * 100);
	                        }
	                        options.uploadProgress(event, position, total, percent);
	                    }, false);
	                }
	                return xhr;
	            };
	        }
	
	        s.data = null;
	        var beforeSend = s.beforeSend;
	        s.beforeSend = function(xhr, o) {
	            //Send FormData() provided by user
	            if (options.formData) {
	                o.data = options.formData;
	            }
	            else {
	                o.data = formdata;
	            }
	            if(beforeSend) {
	                beforeSend.call(this, xhr, o);
	            }
	        };
	        return $.ajax(s);
	    }
	
	    // private function for handling file uploads (hat tip to YAHOO!)
	    function fileUploadIframe(a) {
	        var form = $form[0], el, i, s, g, id, $io, io, xhr, sub, n, timedOut, timeoutHandle;
	        var deferred = $.Deferred();
	
	        // #341
	        deferred.abort = function(status) {
	            xhr.abort(status);
	        };
	
	        if (a) {
	            // ensure that every serialized input is still enabled
	            for (i=0; i < elements.length; i++) {
	                el = $(elements[i]);
	                if ( hasProp ) {
	                    el.prop('disabled', false);
	                }
	                else {
	                    el.removeAttr('disabled');
	                }
	            }
	        }
	
	        s = $.extend(true, {}, $.ajaxSettings, options);
	        s.context = s.context || s;
	        id = 'jqFormIO' + (new Date().getTime());
	        if (s.iframeTarget) {
	            $io = $(s.iframeTarget);
	            n = $io.attr2('name');
	            if (!n) {
	                $io.attr2('name', id);
	            }
	            else {
	                id = n;
	            }
	        }
	        else {
	            $io = $('<iframe name="' + id + '" src="'+ s.iframeSrc +'" />');
	            $io.css({ position: 'absolute', top: '-1000px', left: '-1000px' });
	        }
	        io = $io[0];
	
	
	        xhr = { // mock object
	            aborted: 0,
	            responseText: null,
	            responseXML: null,
	            status: 0,
	            statusText: 'n/a',
	            getAllResponseHeaders: function() {},
	            getResponseHeader: function() {},
	            setRequestHeader: function() {},
	            abort: function(status) {
	                var e = (status === 'timeout' ? 'timeout' : 'aborted');
	                log('aborting upload... ' + e);
	                this.aborted = 1;
	
	                try { // #214, #257
	                    if (io.contentWindow.document.execCommand) {
	                        io.contentWindow.document.execCommand('Stop');
	                    }
	                }
	                catch(ignore) {}
	
	                $io.attr('src', s.iframeSrc); // abort op in progress
	                xhr.error = e;
	                if (s.error) {
	                    s.error.call(s.context, xhr, e, status);
	                }
	                if (g) {
	                    $.event.trigger("ajaxError", [xhr, s, e]);
	                }
	                if (s.complete) {
	                    s.complete.call(s.context, xhr, e);
	                }
	            }
	        };
	
	        g = s.global;
	        // trigger ajax global events so that activity/block indicators work like normal
	        if (g && 0 === $.active++) {
	            $.event.trigger("ajaxStart");
	        }
	        if (g) {
	            $.event.trigger("ajaxSend", [xhr, s]);
	        }
	
	        if (s.beforeSend && s.beforeSend.call(s.context, xhr, s) === false) {
	            if (s.global) {
	                $.active--;
	            }
	            deferred.reject();
	            return deferred;
	        }
	        if (xhr.aborted) {
	            deferred.reject();
	            return deferred;
	        }
	
	        // add submitting element to data if we know it
	        sub = form.clk;
	        if (sub) {
	            n = sub.name;
	            if (n && !sub.disabled) {
	                s.extraData = s.extraData || {};
	                s.extraData[n] = sub.value;
	                if (sub.type == "image") {
	                    s.extraData[n+'.x'] = form.clk_x;
	                    s.extraData[n+'.y'] = form.clk_y;
	                }
	            }
	        }
	
	        var CLIENT_TIMEOUT_ABORT = 1;
	        var SERVER_ABORT = 2;
	                
	        function getDoc(frame) {
	            /* it looks like contentWindow or contentDocument do not
	             * carry the protocol property in ie8, when running under ssl
	             * frame.document is the only valid response document, since
	             * the protocol is know but not on the other two objects. strange?
	             * "Same origin policy" http://en.wikipedia.org/wiki/Same_origin_policy
	             */
	            
	            var doc = null;
	            
	            // IE8 cascading access check
	            try {
	                if (frame.contentWindow) {
	                    doc = frame.contentWindow.document;
	                }
	            } catch(err) {
	                // IE8 access denied under ssl & missing protocol
	                log('cannot get iframe.contentWindow document: ' + err);
	            }
	
	            if (doc) { // successful getting content
	                return doc;
	            }
	
	            try { // simply checking may throw in ie8 under ssl or mismatched protocol
	                doc = frame.contentDocument ? frame.contentDocument : frame.document;
	            } catch(err) {
	                // last attempt
	                log('cannot get iframe.contentDocument: ' + err);
	                doc = frame.document;
	            }
	            return doc;
	        }
	
	        // Rails CSRF hack (thanks to Yvan Barthelemy)
	        var csrf_token = $('meta[name=csrf-token]').attr('content');
	        var csrf_param = $('meta[name=csrf-param]').attr('content');
	        if (csrf_param && csrf_token) {
	            s.extraData = s.extraData || {};
	            s.extraData[csrf_param] = csrf_token;
	        }
	
	        // take a breath so that pending repaints get some cpu time before the upload starts
	        function doSubmit() {
	            // make sure form attrs are set
	            var t = $form.attr2('target'), 
	                a = $form.attr2('action'), 
	                mp = 'multipart/form-data',
	                et = $form.attr('enctype') || $form.attr('encoding') || mp;
	
	            // update form attrs in IE friendly way
	            form.setAttribute('target',id);
	            if (!method || /post/i.test(method) ) {
	                form.setAttribute('method', 'POST');
	            }
	            if (a != s.url) {
	                form.setAttribute('action', s.url);
	            }
	
	            // ie borks in some cases when setting encoding
	            if (! s.skipEncodingOverride && (!method || /post/i.test(method))) {
	                $form.attr({
	                    encoding: 'multipart/form-data',
	                    enctype:  'multipart/form-data'
	                });
	            }
	
	            // support timout
	            if (s.timeout) {
	                timeoutHandle = setTimeout(function() { timedOut = true; cb(CLIENT_TIMEOUT_ABORT); }, s.timeout);
	            }
	
	            // look for server aborts
	            function checkState() {
	                try {
	                    var state = getDoc(io).readyState;
	                    log('state = ' + state);
	                    if (state && state.toLowerCase() == 'uninitialized') {
	                        setTimeout(checkState,50);
	                    }
	                }
	                catch(e) {
	                    log('Server abort: ' , e, ' (', e.name, ')');
	                    cb(SERVER_ABORT);
	                    if (timeoutHandle) {
	                        clearTimeout(timeoutHandle);
	                    }
	                    timeoutHandle = undefined;
	                }
	            }
	
	            // add "extra" data to form if provided in options
	            var extraInputs = [];
	            try {
	                if (s.extraData) {
	                    for (var n in s.extraData) {
	                        if (s.extraData.hasOwnProperty(n)) {
	                           // if using the $.param format that allows for multiple values with the same name
	                           if($.isPlainObject(s.extraData[n]) && s.extraData[n].hasOwnProperty('name') && s.extraData[n].hasOwnProperty('value')) {
	                               extraInputs.push(
	                               $('<input type="hidden" name="'+s.extraData[n].name+'">').val(s.extraData[n].value)
	                                   .appendTo(form)[0]);
	                           } else {
	                               extraInputs.push(
	                               $('<input type="hidden" name="'+n+'">').val(s.extraData[n])
	                                   .appendTo(form)[0]);
	                           }
	                        }
	                    }
	                }
	
	                if (!s.iframeTarget) {
	                    // add iframe to doc and submit the form
	                    $io.appendTo('body');
	                }
	                if (io.attachEvent) {
	                    io.attachEvent('onload', cb);
	                }
	                else {
	                    io.addEventListener('load', cb, false);
	                }
	                setTimeout(checkState,15);
	
	                try {
	                    form.submit();
	                } catch(err) {
	                    // just in case form has element with name/id of 'submit'
	                    var submitFn = document.createElement('form').submit;
	                    submitFn.apply(form);
	                }
	            }
	            finally {
	                // reset attrs and remove "extra" input elements
	                form.setAttribute('action',a);
	                form.setAttribute('enctype', et); // #380
	                if(t) {
	                    form.setAttribute('target', t);
	                } else {
	                    $form.removeAttr('target');
	                }
	                $(extraInputs).remove();
	            }
	        }
	
	        if (s.forceSync) {
	            doSubmit();
	        }
	        else {
	            setTimeout(doSubmit, 10); // this lets dom updates render
	        }
	
	        var data, doc, domCheckCount = 50, callbackProcessed;
	
	        function cb(e) {
	            if (xhr.aborted || callbackProcessed) {
	                return;
	            }
	            
	            doc = getDoc(io);
	            if(!doc) {
	                log('cannot access response document');
	                e = SERVER_ABORT;
	            }
	            if (e === CLIENT_TIMEOUT_ABORT && xhr) {
	                xhr.abort('timeout');
	                deferred.reject(xhr, 'timeout');
	                return;
	            }
	            else if (e == SERVER_ABORT && xhr) {
	                xhr.abort('server abort');
	                deferred.reject(xhr, 'error', 'server abort');
	                return;
	            }
	
	            if (!doc || doc.location.href == s.iframeSrc) {
	                // response not received yet
	                if (!timedOut) {
	                    return;
	                }
	            }
	            if (io.detachEvent) {
	                io.detachEvent('onload', cb);
	            }
	            else {
	                io.removeEventListener('load', cb, false);
	            }
	
	            var status = 'success', errMsg;
	            try {
	                if (timedOut) {
	                    throw 'timeout';
	                }
	
	                var isXml = s.dataType == 'xml' || doc.XMLDocument || $.isXMLDoc(doc);
	                log('isXml='+isXml);
	                if (!isXml && window.opera && (doc.body === null || !doc.body.innerHTML)) {
	                    if (--domCheckCount) {
	                        // in some browsers (Opera) the iframe DOM is not always traversable when
	                        // the onload callback fires, so we loop a bit to accommodate
	                        log('requeing onLoad callback, DOM not available');
	                        setTimeout(cb, 250);
	                        return;
	                    }
	                    // let this fall through because server response could be an empty document
	                    //log('Could not access iframe DOM after mutiple tries.');
	                    //throw 'DOMException: not available';
	                }
	
	                //log('response detected');
	                var docRoot = doc.body ? doc.body : doc.documentElement;
	                xhr.responseText = docRoot ? docRoot.innerHTML : null;
	                xhr.responseXML = doc.XMLDocument ? doc.XMLDocument : doc;
	                if (isXml) {
	                    s.dataType = 'xml';
	                }
	                xhr.getResponseHeader = function(header){
	                    var headers = {'content-type': s.dataType};
	                    return headers[header.toLowerCase()];
	                };
	                // support for XHR 'status' & 'statusText' emulation :
	                if (docRoot) {
	                    xhr.status = Number( docRoot.getAttribute('status') ) || xhr.status;
	                    xhr.statusText = docRoot.getAttribute('statusText') || xhr.statusText;
	                }
	
	                var dt = (s.dataType || '').toLowerCase();
	                var scr = /(json|script|text)/.test(dt);
	                if (scr || s.textarea) {
	                    // see if user embedded response in textarea
	                    var ta = doc.getElementsByTagName('textarea')[0];
	                    if (ta) {
	                        xhr.responseText = ta.value;
	                        // support for XHR 'status' & 'statusText' emulation :
	                        xhr.status = Number( ta.getAttribute('status') ) || xhr.status;
	                        xhr.statusText = ta.getAttribute('statusText') || xhr.statusText;
	                    }
	                    else if (scr) {
	                        // account for browsers injecting pre around json response
	                        var pre = doc.getElementsByTagName('pre')[0];
	                        var b = doc.getElementsByTagName('body')[0];
	                        if (pre) {
	                            xhr.responseText = pre.textContent ? pre.textContent : pre.innerText;
	                        }
	                        else if (b) {
	                            xhr.responseText = b.textContent ? b.textContent : b.innerText;
	                        }
	                    }
	                }
	                else if (dt == 'xml' && !xhr.responseXML && xhr.responseText) {
	                    xhr.responseXML = toXml(xhr.responseText);
	                }
	
	                try {
	                    data = httpData(xhr, dt, s);
	                }
	                catch (err) {
	                    status = 'parsererror';
	                    xhr.error = errMsg = (err || status);
	                }
	            }
	            catch (err) {
	                log('error caught: ',err);
	                status = 'error';
	                xhr.error = errMsg = (err || status);
	            }
	
	            if (xhr.aborted) {
	                log('upload aborted');
	                status = null;
	            }
	
	            if (xhr.status) { // we've set xhr.status
	                status = (xhr.status >= 200 && xhr.status < 300 || xhr.status === 304) ? 'success' : 'error';
	            }
	
	            // ordering of these callbacks/triggers is odd, but that's how $.ajax does it
	            if (status === 'success') {
	                if (s.success) {
	                    s.success.call(s.context, data, 'success', xhr);
	                }
	                deferred.resolve(xhr.responseText, 'success', xhr);
	                if (g) {
	                    $.event.trigger("ajaxSuccess", [xhr, s]);
	                }
	            }
	            else if (status) {
	                if (errMsg === undefined) {
	                    errMsg = xhr.statusText;
	                }
	                if (s.error) {
	                    s.error.call(s.context, xhr, status, errMsg);
	                }
	                deferred.reject(xhr, 'error', errMsg);
	                if (g) {
	                    $.event.trigger("ajaxError", [xhr, s, errMsg]);
	                }
	            }
	
	            if (g) {
	                $.event.trigger("ajaxComplete", [xhr, s]);
	            }
	
	            if (g && ! --$.active) {
	                $.event.trigger("ajaxStop");
	            }
	
	            if (s.complete) {
	                s.complete.call(s.context, xhr, status);
	            }
	
	            callbackProcessed = true;
	            if (s.timeout) {
	                clearTimeout(timeoutHandle);
	            }
	
	            // clean up
	            setTimeout(function() {
	                if (!s.iframeTarget) {
	                    $io.remove();
	                }
	                else { //adding else to clean up existing iframe response.
	                    $io.attr('src', s.iframeSrc);
	                }
	                xhr.responseXML = null;
	            }, 100);
	        }
	
	        var toXml = $.parseXML || function(s, doc) { // use parseXML if available (jQuery 1.5+)
	            if (window.ActiveXObject) {
	                doc = new ActiveXObject('Microsoft.XMLDOM');
	                doc.async = 'false';
	                doc.loadXML(s);
	            }
	            else {
	                doc = (new DOMParser()).parseFromString(s, 'text/xml');
	            }
	            return (doc && doc.documentElement && doc.documentElement.nodeName != 'parsererror') ? doc : null;
	        };
	        var parseJSON = $.parseJSON || function(s) {
	            /*jslint evil:true */
	            return window['eval']('(' + s + ')');
	        };
	
	        var httpData = function( xhr, type, s ) { // mostly lifted from jq1.4.4
	
	            var ct = xhr.getResponseHeader('content-type') || '',
	                xml = type === 'xml' || !type && ct.indexOf('xml') >= 0,
	                data = xml ? xhr.responseXML : xhr.responseText;
	
	            if (xml && data.documentElement.nodeName === 'parsererror') {
	                if ($.error) {
	                    $.error('parsererror');
	                }
	            }
	            if (s && s.dataFilter) {
	                data = s.dataFilter(data, type);
	            }
	            if (typeof data === 'string') {
	                if (type === 'json' || !type && ct.indexOf('json') >= 0) {
	                    data = parseJSON(data);
	                } else if (type === "script" || !type && ct.indexOf("javascript") >= 0) {
	                    $.globalEval(data);
	                }
	            }
	            return data;
	        };
	
	        return deferred;
	    }
	};
	
	/**
	 * ajaxForm() provides a mechanism for fully automating form submission.
	 *
	 * The advantages of using this method instead of ajaxSubmit() are:
	 *
	 * 1: This method will include coordinates for <input type="image" /> elements (if the element
	 *    is used to submit the form).
	 * 2. This method will include the submit element's name/value data (for the element that was
	 *    used to submit the form).
	 * 3. This method binds the submit() method to the form for you.
	 *
	 * The options argument for ajaxForm works exactly as it does for ajaxSubmit.  ajaxForm merely
	 * passes the options argument along after properly binding events for submit elements and
	 * the form itself.
	 */
	$.fn.ajaxForm = function(options) {
	    options = options || {};
	    options.delegation = options.delegation && $.isFunction($.fn.on);
	
	    // in jQuery 1.3+ we can fix mistakes with the ready state
	    if (!options.delegation && this.length === 0) {
	        var o = { s: this.selector, c: this.context };
	        if (!$.isReady && o.s) {
	            log('DOM not ready, queuing ajaxForm');
	            $(function() {
	                $(o.s,o.c).ajaxForm(options);
	            });
	            return this;
	        }
	        // is your DOM ready?  http://docs.jquery.com/Tutorials:Introducing_$(document).ready()
	        log('terminating; zero elements found by selector' + ($.isReady ? '' : ' (DOM not ready)'));
	        return this;
	    }
	
	    if ( options.delegation ) {
	        $(document)
	            .off('submit.form-plugin', this.selector, doAjaxSubmit)
	            .off('click.form-plugin', this.selector, captureSubmittingElement)
	            .on('submit.form-plugin', this.selector, options, doAjaxSubmit)
	            .on('click.form-plugin', this.selector, options, captureSubmittingElement);
	        return this;
	    }
	
	    return this.ajaxFormUnbind()
	        .bind('submit.form-plugin', options, doAjaxSubmit)
	        .bind('click.form-plugin', options, captureSubmittingElement);
	};
	
	// private event handlers
	function doAjaxSubmit(e) {
	    /*jshint validthis:true */
	    var options = e.data;
	    if (!e.isDefaultPrevented()) { // if event has been canceled, don't proceed
	        e.preventDefault();
	        $(e.target).ajaxSubmit(options); // #365
	    }
	}
	
	function captureSubmittingElement(e) {
	    /*jshint validthis:true */
	    var target = e.target;
	    var $el = $(target);
	    if (!($el.is("[type=submit],[type=image]"))) {
	        // is this a child element of the submit el?  (ex: a span within a button)
	        var t = $el.closest('[type=submit]');
	        if (t.length === 0) {
	            return;
	        }
	        target = t[0];
	    }
	    var form = this;
	    form.clk = target;
	    if (target.type == 'image') {
	        if (e.offsetX !== undefined) {
	            form.clk_x = e.offsetX;
	            form.clk_y = e.offsetY;
	        } else if (typeof $.fn.offset == 'function') {
	            var offset = $el.offset();
	            form.clk_x = e.pageX - offset.left;
	            form.clk_y = e.pageY - offset.top;
	        } else {
	            form.clk_x = e.pageX - target.offsetLeft;
	            form.clk_y = e.pageY - target.offsetTop;
	        }
	    }
	    // clear form vars
	    setTimeout(function() { form.clk = form.clk_x = form.clk_y = null; }, 100);
	}
	
	
	// ajaxFormUnbind unbinds the event handlers that were bound by ajaxForm
	$.fn.ajaxFormUnbind = function() {
	    return this.unbind('submit.form-plugin click.form-plugin');
	};
	
	/**
	 * formToArray() gathers form element data into an array of objects that can
	 * be passed to any of the following ajax functions: $.get, $.post, or load.
	 * Each object in the array has both a 'name' and 'value' property.  An example of
	 * an array for a simple login form might be:
	 *
	 * [ { name: 'username', value: 'jresig' }, { name: 'password', value: 'secret' } ]
	 *
	 * It is this array that is passed to pre-submit callback functions provided to the
	 * ajaxSubmit() and ajaxForm() methods.
	 */
	$.fn.formToArray = function(semantic, elements) {
	    var a = [];
	    if (this.length === 0) {
	        return a;
	    }
	
	    var form = this[0];
	    var formId = this.attr('id');
	    var els = semantic ? form.getElementsByTagName('*') : form.elements;
	    var els2;
	
	    if (els && !/MSIE [678]/.test(navigator.userAgent)) { // #390
	        els = $(els).get();  // convert to standard array
	    }
	
	    // #386; account for inputs outside the form which use the 'form' attribute
	    if ( formId ) {
	        els2 = $(':input[form=' + formId + ']').get();
	        if ( els2.length ) {
	            els = (els || []).concat(els2);
	        }
	    }
	
	    if (!els || !els.length) {
	        return a;
	    }
	
	    var i,j,n,v,el,max,jmax;
	    for(i=0, max=els.length; i < max; i++) {
	        el = els[i];
	        n = el.name;
	        if (!n || el.disabled) {
	            continue;
	        }
	
	        if (semantic && form.clk && el.type == "image") {
	            // handle image inputs on the fly when semantic == true
	            if(form.clk == el) {
	                a.push({name: n, value: $(el).val(), type: el.type });
	                a.push({name: n+'.x', value: form.clk_x}, {name: n+'.y', value: form.clk_y});
	            }
	            continue;
	        }
	
	        v = $.fieldValue(el, true);
	        if (v && v.constructor == Array) {
	            if (elements) {
	                elements.push(el);
	            }
	            for(j=0, jmax=v.length; j < jmax; j++) {
	                a.push({name: n, value: v[j]});
	            }
	        }
	        else if (feature.fileapi && el.type == 'file') {
	            if (elements) {
	                elements.push(el);
	            }
	            var files = el.files;
	            if (files.length) {
	                for (j=0; j < files.length; j++) {
	                    a.push({name: n, value: files[j], type: el.type});
	                }
	            }
	            else {
	                // #180
	                a.push({ name: n, value: '', type: el.type });
	            }
	        }
	        else if (v !== null && typeof v != 'undefined') {
	            if (elements) {
	                elements.push(el);
	            }
	            a.push({name: n, value: v, type: el.type, required: el.required});
	        }
	    }
	
	    if (!semantic && form.clk) {
	        // input type=='image' are not found in elements array! handle it here
	        var $input = $(form.clk), input = $input[0];
	        n = input.name;
	        if (n && !input.disabled && input.type == 'image') {
	            a.push({name: n, value: $input.val()});
	            a.push({name: n+'.x', value: form.clk_x}, {name: n+'.y', value: form.clk_y});
	        }
	    }
	    return a;
	};
	
	/**
	 * Serializes form data into a 'submittable' string. This method will return a string
	 * in the format: name1=value1&amp;name2=value2
	 */
	$.fn.formSerialize = function(semantic) {
	    //hand off to jQuery.param for proper encoding
	    return $.param(this.formToArray(semantic));
	};
	
	/**
	 * Serializes all field elements in the jQuery object into a query string.
	 * This method will return a string in the format: name1=value1&amp;name2=value2
	 */
	$.fn.fieldSerialize = function(successful) {
	    var a = [];
	    this.each(function() {
	        var n = this.name;
	        if (!n) {
	            return;
	        }
	        var v = $.fieldValue(this, successful);
	        if (v && v.constructor == Array) {
	            for (var i=0,max=v.length; i < max; i++) {
	                a.push({name: n, value: v[i]});
	            }
	        }
	        else if (v !== null && typeof v != 'undefined') {
	            a.push({name: this.name, value: v});
	        }
	    });
	    //hand off to jQuery.param for proper encoding
	    return $.param(a);
	};
	
	/**
	 * Returns the value(s) of the element in the matched set.  For example, consider the following form:
	 *
	 *  <form><fieldset>
	 *      <input name="A" type="text" />
	 *      <input name="A" type="text" />
	 *      <input name="B" type="checkbox" value="B1" />
	 *      <input name="B" type="checkbox" value="B2"/>
	 *      <input name="C" type="radio" value="C1" />
	 *      <input name="C" type="radio" value="C2" />
	 *  </fieldset></form>
	 *
	 *  var v = $('input[type=text]').fieldValue();
	 *  // if no values are entered into the text inputs
	 *  v == ['','']
	 *  // if values entered into the text inputs are 'foo' and 'bar'
	 *  v == ['foo','bar']
	 *
	 *  var v = $('input[type=checkbox]').fieldValue();
	 *  // if neither checkbox is checked
	 *  v === undefined
	 *  // if both checkboxes are checked
	 *  v == ['B1', 'B2']
	 *
	 *  var v = $('input[type=radio]').fieldValue();
	 *  // if neither radio is checked
	 *  v === undefined
	 *  // if first radio is checked
	 *  v == ['C1']
	 *
	 * The successful argument controls whether or not the field element must be 'successful'
	 * (per http://www.w3.org/TR/html4/interact/forms.html#successful-controls).
	 * The default value of the successful argument is true.  If this value is false the value(s)
	 * for each element is returned.
	 *
	 * Note: This method *always* returns an array.  If no valid value can be determined the
	 *    array will be empty, otherwise it will contain one or more values.
	 */
	$.fn.fieldValue = function(successful) {
	    for (var val=[], i=0, max=this.length; i < max; i++) {
	        var el = this[i];
	        var v = $.fieldValue(el, successful);
	        if (v === null || typeof v == 'undefined' || (v.constructor == Array && !v.length)) {
	            continue;
	        }
	        if (v.constructor == Array) {
	            $.merge(val, v);
	        }
	        else {
	            val.push(v);
	        }
	    }
	    return val;
	};
	
	/**
	 * Returns the value of the field element.
	 */
	$.fieldValue = function(el, successful) {
	    var n = el.name, t = el.type, tag = el.tagName.toLowerCase();
	    if (successful === undefined) {
	        successful = true;
	    }
	
	    if (successful && (!n || el.disabled || t == 'reset' || t == 'button' ||
	        (t == 'checkbox' || t == 'radio') && !el.checked ||
	        (t == 'submit' || t == 'image') && el.form && el.form.clk != el ||
	        tag == 'select' && el.selectedIndex == -1)) {
	            return null;
	    }
	
	    if (tag == 'select') {
	        var index = el.selectedIndex;
	        if (index < 0) {
	            return null;
	        }
	        var a = [], ops = el.options;
	        var one = (t == 'select-one');
	        var max = (one ? index+1 : ops.length);
	        for(var i=(one ? index : 0); i < max; i++) {
	            var op = ops[i];
	            if (op.selected) {
	                var v = op.value;
	                if (!v) { // extra pain for IE...
	                    v = (op.attributes && op.attributes.value && !(op.attributes.value.specified)) ? op.text : op.value;
	                }
	                if (one) {
	                    return v;
	                }
	                a.push(v);
	            }
	        }
	        return a;
	    }
	    return $(el).val();
	};
	
	/**
	 * Clears the form data.  Takes the following actions on the form's input fields:
	 *  - input text fields will have their 'value' property set to the empty string
	 *  - select elements will have their 'selectedIndex' property set to -1
	 *  - checkbox and radio inputs will have their 'checked' property set to false
	 *  - inputs of type submit, button, reset, and hidden will *not* be effected
	 *  - button elements will *not* be effected
	 */
	$.fn.clearForm = function(includeHidden) {
	    return this.each(function() {
	        $('input,select,textarea', this).clearFields(includeHidden);
	    });
	};
	
	/**
	 * Clears the selected form elements.
	 */
	$.fn.clearFields = $.fn.clearInputs = function(includeHidden) {
	    var re = /^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i; // 'hidden' is not in this list
	    return this.each(function() {
	        var t = this.type, tag = this.tagName.toLowerCase();
	        if (re.test(t) || tag == 'textarea') {
	            this.value = '';
	        }
	        else if (t == 'checkbox' || t == 'radio') {
	            this.checked = false;
	        }
	        else if (tag == 'select') {
	            this.selectedIndex = -1;
	        }
			else if (t == "file") {
				if (/MSIE/.test(navigator.userAgent)) {
					$(this).replaceWith($(this).clone(true));
				} else {
					$(this).val('');
				}
			}
	        else if (includeHidden) {
	            // includeHidden can be the value true, or it can be a selector string
	            // indicating a special test; for example:
	            //  $('#myForm').clearForm('.special:hidden')
	            // the above would clean hidden inputs that have the class of 'special'
	            if ( (includeHidden === true && /hidden/.test(t)) ||
	                 (typeof includeHidden == 'string' && $(this).is(includeHidden)) ) {
	                this.value = '';
	            }
	        }
	    });
	};
	
	/**
	 * Resets the form data.  Causes all form elements to be reset to their original value.
	 */
	$.fn.resetForm = function() {
	    return this.each(function() {
	        // guard against an input with the name of 'reset'
	        // note that IE reports the reset function as an 'object'
	        if (typeof this.reset == 'function' || (typeof this.reset == 'object' && !this.reset.nodeType)) {
	            this.reset();
	        }
	    });
	};
	
	/**
	 * Enables or disables any matching elements.
	 */
	$.fn.enable = function(b) {
	    if (b === undefined) {
	        b = true;
	    }
	    return this.each(function() {
	        this.disabled = !b;
	    });
	};
	
	/**
	 * Checks/unchecks any matching checkboxes or radio buttons and
	 * selects/deselects and matching option elements.
	 */
	$.fn.selected = function(select) {
	    if (select === undefined) {
	        select = true;
	    }
	    return this.each(function() {
	        var t = this.type;
	        if (t == 'checkbox' || t == 'radio') {
	            this.checked = select;
	        }
	        else if (this.tagName.toLowerCase() == 'option') {
	            var $sel = $(this).parent('select');
	            if (select && $sel[0] && $sel[0].type == 'select-one') {
	                // deselect all other options
	                $sel.find('option').selected(false);
	            }
	            this.selected = select;
	        }
	    });
	};
	
	// expose debug var
	$.fn.ajaxSubmit.debug = false;
	
	// helper fn for console logging
	function log() {
	    if (!$.fn.ajaxSubmit.debug) {
	        return;
	    }
	    var msg = '[jquery.form] ' + Array.prototype.join.call(arguments,'');
	    if (window.console && window.console.log) {
	        window.console.log(msg);
	    }
	    else if (window.opera && window.opera.postError) {
	        window.opera.postError(msg);
	    }
	}
	
	}));
	


/***/ },

/***/ 318:
/*!****************************************************************!*\
  !*** ./~/moment-duration-format/lib/moment-duration-format.js ***!
  \****************************************************************/
/***/ function(module, exports, __webpack_require__) {

	/*! Moment Duration Format v1.3.0
	 *  https://github.com/jsmreese/moment-duration-format 
	 *  Date: 2014-07-15
	 *
	 *  Duration format plugin function for the Moment.js library
	 *  http://momentjs.com/
	 *
	 *  Copyright 2014 John Madhavan-Reese
	 *  Released under the MIT license
	 */
	
	(function (root, undefined) {
	
		// repeatZero(qty)
		// returns "0" repeated qty times
		function repeatZero(qty) {
			var result = "";
			
			// exit early
			// if qty is 0 or a negative number
			// or doesn't coerce to an integer
			qty = parseInt(qty, 10);
			if (!qty || qty < 1) { return result; }
			
			while (qty) {
				result += "0";
				qty -= 1;
			}
			
			return result;
		}
		
		// padZero(str, len [, isRight])
		// pads a string with zeros up to a specified length
		// will not pad a string if its length is aready
		// greater than or equal to the specified length
		// default output pads with zeros on the left
		// set isRight to `true` to pad with zeros on the right
		function padZero(str, len, isRight) {
			if (str == null) { str = ""; }
			str = "" + str;
			
			return (isRight ? str : "") + repeatZero(len - str.length) + (isRight ? "" : str);
		}
		
		// isArray
		function isArray(array) {
			return Object.prototype.toString.call(array) === "[object Array]";
		}
		
		// isObject
		function isObject(obj) {
			return Object.prototype.toString.call(obj) === "[object Object]";
		}
		
		// findLast
		function findLast(array, callback) {
			var index = array.length;
	
			while (index -= 1) {
				if (callback(array[index])) { return array[index]; }
			}
		}
	
		// find
		function find(array, callback) {
			var index = 0,
				max = array.length,
				match;
				
			if (typeof callback !== "function") {
				match = callback;
				callback = function (item) {
					return item === match;
				};
			}
	
			while (index < max) {
				if (callback(array[index])) { return array[index]; }
				index += 1;
			}
		}
		
		// each
		function each(array, callback) {
			var index = 0,
				max = array.length;
				
			if (!array || !max) { return; }
	
			while (index < max) {
				if (callback(array[index], index) === false) { return; }
				index += 1;
			}
		}
		
		// map
		function map(array, callback) {
			var index = 0,
				max = array.length,
				ret = [];
	
			if (!array || !max) { return ret; }
					
			while (index < max) {
				ret[index] = callback(array[index], index);
				index += 1;
			}
			
			return ret;
		}
		
		// pluck
		function pluck(array, prop) {
			return map(array, function (item) {
				return item[prop];
			});
		}
		
		// compact
		function compact(array) {
			var ret = [];
			
			each(array, function (item) {
				if (item) { ret.push(item); }
			});
			
			return ret;
		}
		
		// unique
		function unique(array) {
			var ret = [];
			
			each(array, function (_a) {
				if (!find(ret, _a)) { ret.push(_a); }
			});
			
			return ret;
		}
		
		// intersection
		function intersection(a, b) {
			var ret = [];
			
			each(a, function (_a) {
				each(b, function (_b) {
					if (_a === _b) { ret.push(_a); }
				});
			});
			
			return unique(ret);
		}
		
		// rest
		function rest(array, callback) {
			var ret = [];
			
			each(array, function (item, index) {
				if (!callback(item)) {
					ret = array.slice(index);
					return false;
				}
			});
			
			return ret;
		}
	
		// initial
		function initial(array, callback) {
			var reversed = array.slice().reverse();
			
			return rest(reversed, callback).reverse();
		}
		
		// extend
		function extend(a, b) {
			for (var key in b) {
				if (b.hasOwnProperty(key)) { a[key] = b[key]; }
			}
			
			return a;
		}
				
		// define internal moment reference
		var moment;
	
		if (true) {
			try { moment = __webpack_require__(/*! moment */ 1); } 
			catch (e) {}
		} 
		
		if (!moment && root.moment) {
			moment = root.moment;
		}
		
		if (!moment) {
			throw "Moment Duration Format cannot find Moment.js";
		}
		
		// moment.duration.format([template] [, precision] [, settings])
		moment.duration.fn.format = function () {
	
			var tokenizer, tokens, types, typeMap, momentTypes, foundFirst, trimIndex,
				args = [].slice.call(arguments),
				settings = extend({}, this.format.defaults),
				// keep a shadow copy of this moment for calculating remainders
				remainder = moment.duration(this);
	
			// add a reference to this duration object to the settings for use
			// in a template function
			settings.duration = this;
	
			// parse arguments
			each(args, function (arg) {
				if (typeof arg === "string" || typeof arg === "function") {
					settings.template = arg;
					return;
				}
	
				if (typeof arg === "number") {
					settings.precision = arg;
					return;
				}
	
				if (isObject(arg)) {
					extend(settings, arg);
				}
			});
	
			// types
			types = settings.types = (isArray(settings.types) ? settings.types : settings.types.split(" "));
	
			// template
			if (typeof settings.template === "function") {
				settings.template = settings.template.apply(settings);
			}
	
			// tokenizer regexp
			tokenizer = new RegExp(map(types, function (type) {
				return settings[type].source;
			}).join("|"), "g");
	
			// token type map function
			typeMap = function (token) {
				return find(types, function (type) {
					return settings[type].test(token);
				});
			};
	
			// tokens array
			tokens = map(settings.template.match(tokenizer), function (token, index) {
				var type = typeMap(token),
					length = token.length;
	
				return {
					index: index,
					length: length,
	
					// replace escaped tokens with the non-escaped token text
					token: (type === "escape" ? token.replace(settings.escape, "$1") : token),
	
					// ignore type on non-moment tokens
					type: ((type === "escape" || type === "general") ? null : type)
	
					// calculate base value for all moment tokens
					//baseValue: ((type === "escape" || type === "general") ? null : this.as(type))
				};
			}, this);
	
			// unique moment token types in the template (in order of descending magnitude)
			momentTypes = intersection(types, unique(compact(pluck(tokens, "type"))));
	
			// exit early if there are no momentTypes
			if (!momentTypes.length) {
				return pluck(tokens, "token").join("");
			}
	
			// calculate values for each token type in the template
			each(momentTypes, function (momentType, index) {
				var value, wholeValue, decimalValue, isLeast, isMost;
	
				// calculate integer and decimal value portions
				value = remainder.as(momentType);
				wholeValue = (value > 0 ? Math.floor(value) : Math.ceil(value));
				decimalValue = value - wholeValue;
	
				// is this the least-significant moment token found?
				isLeast = ((index + 1) === momentTypes.length);
	
				// is this the most-significant moment token found?
				isMost = (!index);
	
				// update tokens array
				// using this algorithm to not assume anything about
				// the order or frequency of any tokens
				each(tokens, function (token) {
					if (token.type === momentType) {
						extend(token, {
							value: value,
							wholeValue: wholeValue,
							decimalValue: decimalValue,
							isLeast: isLeast,
							isMost: isMost
						});
	
						if (isMost) {
							// note the length of the most-significant moment token:
							// if it is greater than one and forceLength is not set, default forceLength to `true`
							if (settings.forceLength == null && token.length > 1) {
								settings.forceLength = true;
							}
	
							// rationale is this:
							// if the template is "h:mm:ss" and the moment value is 5 minutes, the user-friendly output is "5:00", not "05:00"
							// shouldn't pad the `minutes` token even though it has length of two
							// if the template is "hh:mm:ss", the user clearly wanted everything padded so we should output "05:00"
							// if the user wanted the full padded output, they can set `{ trim: false }` to get "00:05:00"
						}
					}
				});
	
				// update remainder
				remainder.subtract(wholeValue, momentType);
			});
		
			// trim tokens array
			if (settings.trim) {
				tokens = (settings.trim === "left" ? rest : initial)(tokens, function (token) {
					// return `true` if:
					// the token is not the least moment token (don't trim the least moment token)
					// the token is a moment token that does not have a value (don't trim moment tokens that have a whole value)
					return !(token.isLeast || (token.type != null && token.wholeValue));
				});
			}
			
			
			// build output
	
			// the first moment token can have special handling
			foundFirst = false;
	
			// run the map in reverse order if trimming from the right
			if (settings.trim === "right") {
				tokens.reverse();
			}
	
			tokens = map(tokens, function (token) {
				var val,
					decVal;
	
				if (!token.type) {
					// if it is not a moment token, use the token as its own value
					return token.token;
				}
	
				// apply negative precision formatting to the least-significant moment token
				if (token.isLeast && (settings.precision < 0)) {
					val = (Math.floor(token.wholeValue * Math.pow(10, settings.precision)) * Math.pow(10, -settings.precision)).toString();
				} else {
					val = token.wholeValue.toString();
				}
				
				// remove negative sign from the beginning
				val = val.replace(/^\-/, "");
	
				// apply token length formatting
				// special handling for the first moment token that is not the most significant in a trimmed template
				if (token.length > 1 && (foundFirst || token.isMost || settings.forceLength)) {
					val = padZero(val, token.length);
				}
	
				// add decimal value if precision > 0
				if (token.isLeast && (settings.precision > 0)) {
					decVal = token.decimalValue.toString().replace(/^\-/, "").split(/\.|e\-/);
					switch (decVal.length) {
						case 1:
							val += "." + padZero(decVal[0], settings.precision, true).slice(0, settings.precision);
							break;
							
						case 2:
							val += "." + padZero(decVal[1], settings.precision, true).slice(0, settings.precision);		
							break;
							
						case 3:
							val += "." + padZero(repeatZero((+decVal[2]) - 1) + (decVal[0] || "0") + decVal[1], settings.precision, true).slice(0, settings.precision);		
							break;
						
						default:
							throw "Moment Duration Format: unable to parse token decimal value.";
					}
				}
				
				// add a negative sign if the value is negative and token is most significant
				if (token.isMost && token.value < 0) {
					val = "-" + val;
				}
	
				foundFirst = true;
	
				return val;
			});
	
			// undo the reverse if trimming from the right
			if (settings.trim === "right") {
				tokens.reverse();
			}
	
			return tokens.join("");
		};
	
		moment.duration.fn.format.defaults = {
			// token definitions
			escape: /\[(.+?)\]/,
			years: /[Yy]+/,
			months: /M+/,
			weeks: /[Ww]+/,
			days: /[Dd]+/,
			hours: /[Hh]+/,
			minutes: /m+/,
			seconds: /s+/,
			milliseconds: /S+/,
			general: /.+?/,
	
			// token type names
			// in order of descending magnitude
			// can be a space-separated token name list or an array of token names
			types: "escape years months weeks days hours minutes seconds milliseconds general",
	
			// format options
	
			// trim
			// "left" - template tokens are trimmed from the left until the first moment token that has a value >= 1
			// "right" - template tokens are trimmed from the right until the first moment token that has a value >= 1
			// (the final moment token is not trimmed, regardless of value)
			// `false` - template tokens are not trimmed
			trim: "left",
	
			// precision
			// number of decimal digits to include after (to the right of) the decimal point (positive integer)
			// or the number of digits to truncate to 0 before (to the left of) the decimal point (negative integer)
			precision: 0,
	
			// force first moment token with a value to render at full length even when template is trimmed and first moment token has length of 1
			forceLength: null,
	
			// template used to format duration
			// may be a function or a string
			// template functions are executed with the `this` binding of the settings object
			// so that template strings may be dynamically generated based on the duration object
			// (accessible via `this.duration`)
			// or any of the other settings
			template: function () {
				var types = this.types,
					dur = this.duration,
					lastType = findLast(types, function (type) {
						return dur._data[type];
					});
	
				// default template strings for each duration dimension type
				switch (lastType) {
					case "seconds":
						return "h:mm:ss";
					case "minutes":
						return "d[d] h:mm";
					case "hours":
						return "d[d] h[h]";
					case "days":
						return "M[m] d[d]";
					case "weeks":
						return "y[y] w[w]";
					case "months":
						return "y[y] M[m]";
					case "years":
						return "y[y]";
					default:
						return "y[y] M[m] d[d] h:mm:ss";
				}
			}
		};
	
	})(this);


/***/ },

/***/ 323:
/*!********************************************************************!*\
  !*** ./~/react-notification-system/dist/notification-container.js ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(/*! react */ 3);
	var NotificationItem = __webpack_require__(/*! ./notification-item */ 324);
	var Constants = __webpack_require__(/*! ./constants */ 78);
	var Helpers = __webpack_require__(/*! ./helpers */ 79);
	
	var NotificationContainer = React.createClass({displayName: "NotificationContainer",
	
	  propTypes: {
	    position: React.PropTypes.string.isRequired,
	    notifications: React.PropTypes.array.isRequired
	  },
	
	  _style: {},
	
	  componentWillMount: function() {
	    // Fix position if width is overrided
	    this._style = this.props.getStyles.container(this.props.position);
	
	    if (this.props.getStyles.overrideWidth && (this.props.position === Constants.positions.tc || this.props.position === Constants.positions.bc)) {
	      this._style['marginLeft'] = -(this.props.getStyles.overrideWidth / 2);
	    }
	  },
	
	  render: function() {
	    var self = this;
	
	    if ([Constants.positions.bl, Constants.positions.br, Constants.positions.bc].indexOf(this.props.position) > -1) {
	      this.props.notifications.reverse();
	    }
	
	    var notifications = this.props.notifications.map(function(notification) {
	      return (
	        React.createElement(NotificationItem, {
	          ref: 'notification-' + notification.uid, 
	          key: notification.uid, 
	          notification: notification, 
	          getStyles: self.props.getStyles, 
	          onRemove: self.props.onRemove, 
	          noAnimation: self.props.noAnimation, 
	          allowHTML: self.props.allowHTML}
	        )
	      );
	    });
	
	    return (
	      React.createElement("div", {className: 'notifications-' + this.props.position, style: this._style}, 
	        notifications
	      )
	    );
	  }
	});
	
	
	module.exports = NotificationContainer;


/***/ },

/***/ 324:
/*!***************************************************************!*\
  !*** ./~/react-notification-system/dist/notification-item.js ***!
  \***************************************************************/
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(/*! react */ 3);
	var Constants = __webpack_require__(/*! ./constants */ 78);
	var Styles = __webpack_require__(/*! ./styles */ 220);
	var Helpers = __webpack_require__(/*! ./helpers */ 79);
	var merge = __webpack_require__(/*! object-assign */ 221);
	
	var NotificationItem = React.createClass({displayName: "NotificationItem",
	
	  propTypes: {
	    notification: React.PropTypes.object,
	
	    onRemove: React.PropTypes.func,
	    allowHTML: React.PropTypes.bool
	  },
	
	  getDefaultProps: function() {
	    return {
	      noAnimation: false,
	      onRemove: function(uid) {},
	      allowHTML: false
	    };
	  },
	
	  getInitialState: function() {
	    return {
	      visible: false,
	      removed: false,
	    };
	  },
	
	  componentWillMount: function() {
	    var getStyles = this.props.getStyles;
	    var level = this.props.notification.level;
	
	    this._noAnimation = this.props.noAnimation;
	
	    this._styles = {
	      notification: getStyles.notification(level),
	      title: getStyles.title(level),
	      dismiss: getStyles.dismiss(level),
	      messageWrapper: getStyles.messageWrapper(level),
	      actionWrapper: getStyles.actionWrapper(level),
	      action: getStyles.action(level)
	    };
	
	    if (!this.props.notification.dismissible) {
	      this._styles.notification.cursor = 'default';
	    }
	  },
	
	  _styles: {},
	
	  _notificationTimer: null,
	
	  _height: 0,
	
	  _noAnimation: null,
	
	  _isMounted: false,
	
	  _getCssPropertyByPosition: function() {
	    var position = this.props.notification.position;
	    var css = {};
	
	    switch (position) {
	      case Constants.positions.tl:
	      case Constants.positions.bl:
	        css = {
	          property: 'left',
	          value: -200
	        };
	        break;
	
	      case Constants.positions.tr:
	      case Constants.positions.br:
	        css = {
	          property: 'right',
	          value: -200
	        };
	        break;
	
	      case Constants.positions.tc:
	        css = {
	          property: 'top',
	          value: -100
	        };
	        break;
	
	      case Constants.positions.bc:
	        css = {
	          property: 'bottom',
	          value: -100
	        };
	        break;
	    }
	
	    return css;
	  },
	
	  _defaultAction: function(event) {
	    event.preventDefault();
	    var notification = this.props.notification;
	    this._hideNotification();
	    notification.action.callback();
	  },
	
	  _hideNotification: function() {
	    if (this._notificationTimer) {
	      this._notificationTimer.clear();
	    }
	
	    if (this._isMounted) {
	      this.setState({
	        visible: false,
	        removed: true
	      });
	    }
	
	    if (this._noAnimation) {
	      this._removeNotification();
	    }
	  },
	
	  _removeNotification: function() {
	    this.props.onRemove(this.props.notification.uid);
	  },
	
	  _dismiss: function() {
	    if (!this.props.notification.dismissible) {
	      return;
	    }
	
	    this._hideNotification();
	  },
	
	  _showNotification: function() {
	    var self = this;
	    setTimeout(function(){
	      if (self._isMounted) {
	        self.setState({
	          visible: true,
	        });
	      }
	    }, 50);
	  },
	
	  componentDidMount: function() {
	    var self = this;
			var transitionEvent = whichTransitionEvent();
	    var notification = this.props.notification;
	
	    var element = React.findDOMNode(this);
	
	    this._height = element.offsetHeight;
	
	    this._isMounted = true;
	
	    // Watch for transition end
	    var count = 0;
	
	    if (!this._noAnimation) {
	      if (transitionEvent) {
	        element.addEventListener(transitionEvent, function() {
	          if (count > 0) return;
	          if(self.state.removed) {
	            count++;
	            self._removeNotification();
	          }
	        });
	      } else {
	        this._noAnimation = true;
	      }
	    }
	
	
	    if (notification.autoDismiss) {
	      this._notificationTimer = new Helpers.timer(function(){
	        self._hideNotification();
	      }, notification.autoDismiss * 1000);
	
	      element.addEventListener('mouseenter', function() {
	        self._notificationTimer.pause();
	      });
	
	      element.addEventListener('mouseleave', function() {
	        self._notificationTimer.resume();
	      });
	    }
	
	    this._showNotification();
	
	  },
	
	  componentWillUnmount: function() {
	    this._isMounted = false;
	  },
	
	  _allowHTML: function(string) {
	    if (true) {
	      return {__html: string};
	    }
	
	    return string;
	  },
	
	  render: function() {
	    var self = this;
	    var notification = this.props.notification;
	
	    var className = 'notification notification-' + notification.level;
	
	    var notificationStyle = merge({}, this._styles.notification);
	
	    if (this.state.visible) {
	      className = className + ' notification-visible';
	    } else {
	      className = className + ' notification-hidden';
	    }
	
	    if (!notification.dismissible) {
	      className = className + ' notification-not-dismissible';
	    }
	
	    if (this.props.getStyles.overrideStyle) {
	      var cssByPos = this._getCssPropertyByPosition();
	      if (!this.state.visible && !this.state.removed) {
	        notificationStyle[cssByPos.property] = cssByPos.value;
	      }
	
	      if (this.state.visible && !this.state.removed) {
	        notificationStyle.height = this._height;
	        notificationStyle[cssByPos.property] = 0;
	      }
	
	      if (this.state.removed) {
	        notificationStyle.overlay = 'hidden';
	        notificationStyle.height = 0;
	        notificationStyle.marginTop = 0;
	        notificationStyle.paddingTop = 0;
	        notificationStyle.paddingBottom = 0;
	      }
	      notificationStyle.opacity = this.state.visible ? this._styles.notification.isVisible.opacity : this._styles.notification.isHidden.opacity;
	    }
	
	    var dismiss = null;
	    var actionButton = null;
	    var title = null;
	    var message = null;
	
	    if (notification.title) {
	      title = React.createElement("h4", {className: "notification-title", style: this._styles.title}, notification.title);
	    }
	
	    if (notification.message) {
	      if (this.props.allowHTML) {
	        message = (
	          React.createElement("div", {className: "notification-message", style: this._styles.messageWrapper, dangerouslySetInnerHTML: this._allowHTML(notification.message)})
	        );
	      } else {
	        message = (
	          React.createElement("div", {className: "notification-message", style: this._styles.messageWrapper}, notification.message)
	        );
	      }
	    }
	
	    if (notification.dismissible) {
	      dismiss = React.createElement("span", {className: "notification-dismiss", style: this._styles.dismiss}, "×");
	    }
	
	    if (notification.action) {
	      actionButton = (
	        React.createElement("div", {className: "notification-action-wrapper", style: this._styles.actionWrapper}, 
	          React.createElement("button", {className: "notification-action-button", onClick: this._defaultAction, style: this._styles.action}, notification.action.label)
	        )
	      );
	    }
	
	    return (
	      React.createElement("div", {className: className, onClick: this._dismiss, style: notificationStyle}, 
	        title, 
	        message, 
	        dismiss, 
	        actionButton
	      )
	    );
	  }
	
	});
	
	/* From Modernizr */
	function whichTransitionEvent(){
	    var t;
	    var el = document.createElement('fakeelement');
	    var transitions = {
	      'transition':'transitionend',
	      'OTransition':'oTransitionEnd',
	      'MozTransition':'transitionend',
	      'WebkitTransition':'webkitTransitionEnd'
	    };
	
	    for(t in transitions){
	        if( el.style[t] !== undefined ){
	            return transitions[t];
	        }
	    }
	}
	
	
	module.exports = NotificationItem;


/***/ },

/***/ 325:
/*!*****************************************************************!*\
  !*** ./~/react-notification-system/dist/notification-system.js ***!
  \*****************************************************************/
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(/*! react */ 3);
	var merge = __webpack_require__(/*! object-assign */ 221);
	var NotificationContainer = __webpack_require__(/*! ./notification-container */ 323);
	var Constants = __webpack_require__(/*! ./constants */ 78);
	var Styles = __webpack_require__(/*! ./styles */ 220);
	var Helpers = __webpack_require__(/*! ./helpers */ 79);
	
	var NotificationSystem = React.createClass({displayName: "NotificationSystem",
	
	  uid: 3400,
	
	  _getStyles: {
	    overrideStyle: {},
	
	    overrideWidth: null,
	
	    setOverrideStyle: function(style) {
	      this.overrideStyle = style;
	    },
	
	    wrapper: function() {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.Wrapper || {};
	      return merge({}, Styles.Wrapper, this.overrideStyle);
	    },
	
	    container: function(position) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.Containers || {};
	
	      this.overrideWidth = Styles.Containers.DefaultStyle.width;
	
	      if (override.DefaultStyle && override.DefaultStyle.width) {
	        this.overrideWidth = override.DefaultStyle.width;
	      }
	
	      if (override[position] && override[position].width) {
	        this.overrideWidth = override[position].width;
	      }
	
	      return merge({}, Styles.Containers.DefaultStyle, Styles.Containers[position], override.DefaultStyle, override[position]);
	    },
	
	    notification: function(level) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.NotificationItem || {};
	      return merge({}, Styles.NotificationItem.DefaultStyle, Styles.NotificationItem[level], override.DefaultStyle, override[level]);
	    },
	
	    title: function(level) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.Title || {};
	      return merge({}, Styles.Title.DefaultStyle, Styles.Title[level], override.DefaultStyle, override[level]);
	    },
	
	    messageWrapper: function(level) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.MessageWrapper || {};
	      return merge({}, Styles.MessageWrapper.DefaultStyle, Styles.MessageWrapper[level], override.DefaultStyle, override[level]);
	    },
	
	    dismiss: function(level) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.Dismiss || {};
	      return merge({}, Styles.Dismiss.DefaultStyle, Styles.Dismiss[level], override.DefaultStyle, override[level]);
	    },
	
	    action: function(level) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.Action || {};
	      return merge({}, Styles.Action.DefaultStyle, Styles.Action[level], override.DefaultStyle, override[level]);
	    },
	
	    actionWrapper: function(level) {
	      if (!this.overrideStyle) return {};
	      var override = this.overrideStyle.ActionWrapper || {};
	      return merge({}, Styles.ActionWrapper.DefaultStyle, Styles.ActionWrapper[level], override.DefaultStyle, override[level]);
	    },
	
	  },
	
	  _didNotificationRemoved: function(uid) {
	    var notification;
	    var notifications = this.state.notifications.filter(function(toCheck) {
	      if (toCheck.uid === uid) {
	        notification = toCheck;
	      }
				return toCheck.uid !== uid;
		  });
	
		  if (notification && notification.onRemove) {
	      notification.onRemove(notification);
	    }
	
	    this.setState({ notifications: notifications });
	  },
	
	  getInitialState: function() {
	    return {
	      notifications: []
	    }
	  },
	
	  getDefaultProps: function() {
	    return {
	      style: {},
	      noAnimation: false
	    }
	  },
	
	  addNotification: function(notification) {
	    var self = this;
	    var notification = merge({}, Constants.notification, notification);
	
	    var error = false;
	
	    try {
	      if (!notification.level) {
	        throw "notification level is required."
	      }
	
	      if (isNaN(notification.autoDismiss)) {
	        throw "'autoDismiss' must be a number."
	      }
	
	      if (Object.keys(Constants.positions).indexOf(notification.position) === -1) {
	        throw "'"+ notification.position +"' is not a valid position."
	      }
	
	      if (Object.keys(Constants.levels).indexOf(notification.level) === -1) {
	        throw "'"+ notification.level +"' is not a valid level."
	      }
	
	    } catch(err) {
	      error = true;
	      console.error('Error adding notification: '+err);
	    }
	
	    if (!error) {
	      var notifications = this.state.notifications;
	
	      // Some preparations
	      notification.position = notification.position.toLowerCase();
	      notification.level = notification.level.toLowerCase();
	      notification.autoDismiss = parseInt(notification.autoDismiss);
	
	      notification.uid = notification.uid || this.uid;
	      notification.ref = "notification-" + notification.uid;
	      this.uid += 1;
	
	      // do not add if the notification already exists based on supplied uid
	      for (var i = 0; i < notifications.length; i++) {
	        if (notifications[i].uid === notification.uid) {
	          return;
	        }
	      }
	
	      notifications.push(notification);
	
	      this.setState({
	        notifications: notifications
	      });
	
	      return notification;
	    }
	
	  },
	
	  removeNotification: function(notification) {
	    var container = this.refs['container-' + notification.position];
	
	    if (container) {
	      var notification = container.refs['notification-' + notification.uid];
	      
	      if (notification) {
	        notification._hideNotification();
	      }
	    }
	  },
	
	  componentDidMount: function() {
	    this._getStyles.setOverrideStyle(this.props.style);
	  },
	
	  render: function() {
	    var self = this;
	    var containers = null;
	    var notifications = this.state.notifications;
	
	    if (notifications.length) {
	      containers = Object.keys(Constants.positions).map(function(position) {
	
	        var _notifications = notifications.filter(function(notification) {
	          return position === notification.position;
	        });
	
	        if (_notifications.length) {
	          return (
	            React.createElement(NotificationContainer, {
	              ref: 'container-'+ position, 
	              key: position, 
	              position: position, 
	              notifications: _notifications, 
	              getStyles: self._getStyles, 
	              onRemove: self._didNotificationRemoved, 
	              noAnimation: self.props.noAnimation, 
	              allowHTML: self.props.allowHTML}
	            )
	          );
	        }
	      });
	    }
	
	
	    return (
	      React.createElement("div", {className: "notifications-wrapper", style: this._getStyles.wrapper()}, 
	        containers
	      )
	
	    );
	  }
	});
	
	module.exports = NotificationSystem;


/***/ },

/***/ 411:
/*!***********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/css/Checkbox.css ***!
  \***********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(/*! !./../../../../../../~/css-loader!./Checkbox.css */ 307);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(/*! ./../../../../../../~/style-loader/addStyles.js */ 24)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../../../../node_modules/css-loader/index.js!./Checkbox.css", function() {
				var newContent = require("!!./../../../../../../node_modules/css-loader/index.js!./Checkbox.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },

/***/ 412:
/*!********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/css/Radio.css ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(/*! !./../../../../../../~/css-loader!./Radio.css */ 308);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(/*! ./../../../../../../~/style-loader/addStyles.js */ 24)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../../../../node_modules/css-loader/index.js!./Radio.css", function() {
				var newContent = require("!!./../../../../../../node_modules/css-loader/index.js!./Radio.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },

/***/ 413:
/*!********************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/css/Table.css ***!
  \********************************************************************/
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(/*! !./../../../../../../~/css-loader!./Table.css */ 309);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(/*! ./../../../../../../~/style-loader/addStyles.js */ 24)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../../../../node_modules/css-loader/index.js!./Table.css", function() {
				var newContent = require("!!./../../../../../../node_modules/css-loader/index.js!./Table.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },

/***/ 414:
/*!*************************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/css/wrapper/DateTimePicker.css ***!
  \*************************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(/*! !./../../../../../../../~/css-loader!./DateTimePicker.css */ 310);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(/*! ./../../../../../../../~/style-loader/addStyles.js */ 24)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../../../../../node_modules/css-loader/index.js!./DateTimePicker.css", function() {
				var newContent = require("!!./../../../../../../../node_modules/css-loader/index.js!./DateTimePicker.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },

/***/ 415:
/*!*********************************************************************************!*\
  !*** ./src/main/javascript/modules/react-components/css/wrapper/iThing-min.css ***!
  \*********************************************************************************/
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(/*! !./../../../../../../../~/css-loader!./iThing-min.css */ 312);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(/*! ./../../../../../../../~/style-loader/addStyles.js */ 24)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../../../../../node_modules/css-loader/index.js!./iThing-min.css", function() {
				var newContent = require("!!./../../../../../../../node_modules/css-loader/index.js!./iThing-min.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },

/***/ 416:
/*!*****************************!*\
  !*** ./~/twix/dist/twix.js ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(module) {// Generated by CoffeeScript 1.10.0
	(function() {
	  var hasModule, isArray, makeTwix,
	    slice = [].slice;
	
	  hasModule = (typeof module !== "undefined" && module !== null) && (module.exports != null);
	
	  isArray = function(input) {
	    return Object.prototype.toString.call(input) === '[object Array]';
	  };
	
	  makeTwix = function(moment) {
	    var Twix;
	    if (moment == null) {
	      throw new Error("Can't find moment");
	    }
	    Twix = (function() {
	      function Twix(start, end, parseFormat, options) {
	        var ref;
	        if (options == null) {
	          options = {};
	        }
	        if (typeof parseFormat !== 'string') {
	          options = parseFormat != null ? parseFormat : {};
	          parseFormat = null;
	        }
	        if (typeof options === 'boolean') {
	          options = {
	            allDay: options
	          };
	        }
	        this._oStart = moment(start, parseFormat, options.parseStrict);
	        this._oEnd = moment(end, parseFormat, options.parseStrict);
	        this.allDay = (ref = options.allDay) != null ? ref : false;
	        this._mutated();
	      }
	
	      Twix._extend = function() {
	        var attr, first, j, len, other, others;
	        first = arguments[0], others = 2 <= arguments.length ? slice.call(arguments, 1) : [];
	        for (j = 0, len = others.length; j < len; j++) {
	          other = others[j];
	          for (attr in other) {
	            if (typeof other[attr] !== 'undefined') {
	              first[attr] = other[attr];
	            }
	          }
	        }
	        return first;
	      };
	
	      Twix.prototype.start = function() {
	        return this._start.clone();
	      };
	
	      Twix.prototype.end = function() {
	        return this._end.clone();
	      };
	
	      Twix.prototype.isSame = function(period) {
	        return this._start.isSame(this._end, period);
	      };
	
	      Twix.prototype.length = function(period) {
	        return this._displayEnd.diff(this._start, period);
	      };
	
	      Twix.prototype.count = function(period) {
	        var end, start;
	        start = this.start().startOf(period);
	        end = this.end().startOf(period);
	        return end.diff(start, period) + 1;
	      };
	
	      Twix.prototype.countInner = function(period) {
	        var end, ref, start;
	        ref = this._inner(period), start = ref[0], end = ref[1];
	        if (start >= end) {
	          return 0;
	        }
	        return end.diff(start, period);
	      };
	
	      Twix.prototype.iterate = function(intervalAmount, period, minHours) {
	        var end, hasNext, ref, start;
	        ref = this._prepIterateInputs(intervalAmount, period, minHours), intervalAmount = ref[0], period = ref[1], minHours = ref[2];
	        start = this.start().startOf(period);
	        end = this.end().startOf(period);
	        if (this.allDay) {
	          end = end.add(1, 'd');
	        }
	        hasNext = (function(_this) {
	          return function() {
	            return (!_this.allDay && start <= end && (!minHours || !start.isSame(end) || _this._end.hours() > minHours)) || (_this.allDay && start < end);
	          };
	        })(this);
	        return this._iterateHelper(period, start, hasNext, intervalAmount);
	      };
	
	      Twix.prototype.iterateInner = function(intervalAmount, period) {
	        var end, hasNext, ref, ref1, start;
	        ref = this._prepIterateInputs(intervalAmount, period), intervalAmount = ref[0], period = ref[1];
	        ref1 = this._inner(period, intervalAmount), start = ref1[0], end = ref1[1];
	        hasNext = function() {
	          return start < end;
	        };
	        return this._iterateHelper(period, start, hasNext, intervalAmount);
	      };
	
	      Twix.prototype.humanizeLength = function() {
	        if (this.allDay) {
	          if (this.isSame('d')) {
	            return 'all day';
	          } else {
	            return this._start.from(this.end().add(1, 'd'), true);
	          }
	        } else {
	          return this._start.from(this._end, true);
	        }
	      };
	
	      Twix.prototype.asDuration = function(units) {
	        var diff;
	        diff = this._end.diff(this._start);
	        return moment.duration(diff);
	      };
	
	      Twix.prototype.isPast = function() {
	        return this._lastMilli < moment();
	      };
	
	      Twix.prototype.isFuture = function() {
	        return this._start > moment();
	      };
	
	      Twix.prototype.isCurrent = function() {
	        return !this.isPast() && !this.isFuture();
	      };
	
	      Twix.prototype.contains = function(mom) {
	        if (!moment.isMoment(mom)) {
	          mom = moment(mom);
	        }
	        return this._start <= mom && this._lastMilli >= mom;
	      };
	
	      Twix.prototype.isEmpty = function() {
	        return this._start.isSame(this._displayEnd);
	      };
	
	      Twix.prototype.overlaps = function(other) {
	        return this._displayEnd.isAfter(other._start) && this._start.isBefore(other._displayEnd);
	      };
	
	      Twix.prototype.engulfs = function(other) {
	        return this._start <= other._start && this._displayEnd >= other._displayEnd;
	      };
	
	      Twix.prototype.union = function(other) {
	        var allDay, newEnd, newStart;
	        allDay = this.allDay && other.allDay;
	        newStart = this._start < other._start ? this._start : other._start;
	        newEnd = this._lastMilli > other._lastMilli ? (allDay ? this._end : this._displayEnd) : (allDay ? other._end : other._displayEnd);
	        return new Twix(newStart, newEnd, allDay);
	      };
	
	      Twix.prototype.intersection = function(other) {
	        var allDay, newEnd, newStart;
	        allDay = this.allDay && other.allDay;
	        newStart = this._start > other._start ? this._start : other._start;
	        newEnd = this._lastMilli < other._lastMilli ? (allDay ? this._end : this._displayEnd) : (allDay ? other._end : other._displayEnd);
	        return new Twix(newStart, newEnd, allDay);
	      };
	
	      Twix.prototype.xor = function() {
	        var allDay, arr, endTime, i, item, j, k, last, len, len1, o, open, other, others, ref, results, start, t;
	        others = 1 <= arguments.length ? slice.call(arguments, 0) : [];
	        open = 0;
	        start = null;
	        results = [];
	        allDay = ((function() {
	          var j, len, results1;
	          results1 = [];
	          for (j = 0, len = others.length; j < len; j++) {
	            o = others[j];
	            if (o.allDay) {
	              results1.push(o);
	            }
	          }
	          return results1;
	        })()).length === others.length;
	        arr = [];
	        ref = [this].concat(others);
	        for (i = j = 0, len = ref.length; j < len; i = ++j) {
	          item = ref[i];
	          arr.push({
	            time: item._start,
	            i: i,
	            type: 0
	          });
	          arr.push({
	            time: item._displayEnd,
	            i: i,
	            type: 1
	          });
	        }
	        arr = arr.sort(function(a, b) {
	          return a.time - b.time;
	        });
	        for (k = 0, len1 = arr.length; k < len1; k++) {
	          other = arr[k];
	          if (other.type === 1) {
	            open -= 1;
	          }
	          if (open === other.type) {
	            start = other.time;
	          }
	          if (open === (other.type + 1) % 2) {
	            if (start) {
	              last = results[results.length - 1];
	              if (last && last._end.isSame(start)) {
	                last._oEnd = other.time;
	                last._mutated();
	              } else {
	                endTime = allDay ? other.time.clone().subtract(1, 'd') : other.time;
	                t = new Twix(start, endTime, allDay);
	                if (!t.isEmpty()) {
	                  results.push(t);
	                }
	              }
	            }
	            start = null;
	          }
	          if (other.type === 0) {
	            open += 1;
	          }
	        }
	        return results;
	      };
	
	      Twix.prototype.difference = function() {
	        var j, len, others, ref, results1, t;
	        others = 1 <= arguments.length ? slice.call(arguments, 0) : [];
	        ref = this.xor.apply(this, others).map((function(_this) {
	          return function(i) {
	            return _this.intersection(i);
	          };
	        })(this));
	        results1 = [];
	        for (j = 0, len = ref.length; j < len; j++) {
	          t = ref[j];
	          if (!t.isEmpty() && t.isValid()) {
	            results1.push(t);
	          }
	        }
	        return results1;
	      };
	
	      Twix.prototype.split = function() {
	        var args, dur, end, final, i, mom, start, time, times, vals;
	        args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
	        end = start = this.start();
	        if (moment.isDuration(args[0])) {
	          dur = args[0];
	        } else if ((!moment.isMoment(args[0]) && !isArray(args[0]) && typeof args[0] === 'object') || (typeof args[0] === 'number' && typeof args[1] === 'string')) {
	          dur = moment.duration(args[0], args[1]);
	        } else if (isArray(args[0])) {
	          times = args[0];
	        } else {
	          times = args;
	        }
	        if (times) {
	          times = (function() {
	            var j, len, results1;
	            results1 = [];
	            for (j = 0, len = times.length; j < len; j++) {
	              time = times[j];
	              results1.push(moment(time));
	            }
	            return results1;
	          })();
	          times = ((function() {
	            var j, len, results1;
	            results1 = [];
	            for (j = 0, len = times.length; j < len; j++) {
	              mom = times[j];
	              if (mom.isValid() && mom >= start) {
	                results1.push(mom);
	              }
	            }
	            return results1;
	          })()).sort();
	        }
	        if ((dur && dur.asMilliseconds() === 0) || (times && times.length === 0)) {
	          return [this];
	        }
	        vals = [];
	        i = 0;
	        final = this._displayEnd;
	        while (start < final && ((times == null) || times[i])) {
	          end = dur ? start.clone().add(dur) : times[i].clone();
	          end = moment.min(final, end);
	          if (!start.isSame(end)) {
	            vals.push(moment.twix(start, end));
	          }
	          start = end;
	          i += 1;
	        }
	        if (!end.isSame(this._displayEnd) && times) {
	          vals.push(moment.twix(end, this._displayEnd));
	        }
	        return vals;
	      };
	
	      Twix.prototype.isValid = function() {
	        return this._start.isValid() && this._end.isValid() && this._start <= this._displayEnd;
	      };
	
	      Twix.prototype.equals = function(other) {
	        return (other instanceof Twix) && this.allDay === other.allDay && this._start.valueOf() === other._start.valueOf() && this._end.valueOf() === other._end.valueOf();
	      };
	
	      Twix.prototype.toString = function() {
	        return "{start: " + (this._start.format()) + ", end: " + (this._end.format()) + ", allDay: " + (this.allDay ? 'true' : 'false') + "}";
	      };
	
	      Twix.prototype.simpleFormat = function(momentOpts, inopts) {
	        var options, s;
	        options = {
	          allDay: '(all day)',
	          template: Twix.formatTemplate
	        };
	        Twix._extend(options, inopts || {});
	        s = options.template(this._start.format(momentOpts), this._end.format(momentOpts));
	        if (this.allDay && options.allDay) {
	          s += " " + options.allDay;
	        }
	        return s;
	      };
	
	      Twix.prototype.format = function(inopts) {
	        var common_bucket, end_bucket, fold, format, fs, global_first, goesIntoTheMorning, j, len, momentHourFormat, needDate, needsMeridiem, options, process, start_bucket, together;
	        if (this.isEmpty()) {
	          return '';
	        }
	        momentHourFormat = this._start.localeData()._longDateFormat['LT'][0];
	        options = {
	          groupMeridiems: true,
	          spaceBeforeMeridiem: true,
	          showDayOfWeek: false,
	          hideTime: false,
	          hideYear: false,
	          implicitMinutes: true,
	          implicitDate: false,
	          implicitYear: true,
	          yearFormat: 'YYYY',
	          monthFormat: 'MMM',
	          weekdayFormat: 'ddd',
	          dayFormat: 'D',
	          meridiemFormat: 'A',
	          hourFormat: momentHourFormat,
	          minuteFormat: 'mm',
	          allDay: 'all day',
	          explicitAllDay: false,
	          lastNightEndsAt: 0,
	          template: Twix.formatTemplate
	        };
	        Twix._extend(options, inopts || {});
	        fs = [];
	        needsMeridiem = options.hourFormat && options.hourFormat[0] === 'h';
	        if (options.showTime != null) {
	          options.hideTime = !options.showTime;
	        }
	        if (options.showYear != null) {
	          options.hideYear = !options.showYear;
	        }
	        if (options.showDate != null) {
	          options.implicitDate = !options.showDate;
	        }
	        goesIntoTheMorning = options.lastNightEndsAt > 0 && !this.allDay && this.end().startOf('d').valueOf() === this.start().add(1, 'd').startOf('d').valueOf() && this._start.hours() > 12 && this._end.hours() < options.lastNightEndsAt;
	        needDate = !options.hideDate && (!options.implicitDate || this.start().startOf('d').valueOf() !== moment().startOf('d').valueOf() || !(this.isSame('d') || goesIntoTheMorning));
	        if (this.allDay && this.isSame('d') && (options.implicitDate || options.explicitAllDay)) {
	          fs.push({
	            name: 'all day simple',
	            fn: function() {
	              return options.allDay;
	            },
	            pre: ' ',
	            slot: 0
	          });
	        }
	        if (needDate && !options.hideYear && (!options.implicitYear || this._start.year() !== moment().year() || !this.isSame('y'))) {
	          fs.push({
	            name: 'year',
	            fn: function(date) {
	              return date.format(options.yearFormat);
	            },
	            pre: ', ',
	            slot: 4
	          });
	        }
	        if (!this.allDay && needDate) {
	          fs.push({
	            name: 'all day month',
	            fn: function(date) {
	              return date.format(options.monthFormat + " " + options.dayFormat);
	            },
	            ignoreEnd: function() {
	              return goesIntoTheMorning;
	            },
	            pre: ' ',
	            slot: 2
	          });
	        }
	        if (this.allDay && needDate) {
	          fs.push({
	            name: 'month',
	            fn: function(date) {
	              return date.format(options.monthFormat);
	            },
	            pre: ' ',
	            slot: 2
	          });
	        }
	        if (this.allDay && needDate) {
	          fs.push({
	            name: 'date',
	            fn: function(date) {
	              return date.format(options.dayFormat);
	            },
	            pre: ' ',
	            slot: 3
	          });
	        }
	        if (needDate && options.showDayOfWeek) {
	          fs.push({
	            name: 'day of week',
	            fn: function(date) {
	              return date.format(options.weekdayFormat);
	            },
	            pre: ' ',
	            slot: 1
	          });
	        }
	        if (options.groupMeridiems && needsMeridiem && !this.allDay && !options.hideTime) {
	          fs.push({
	            name: 'meridiem',
	            fn: function(t) {
	              return t.format(options.meridiemFormat);
	            },
	            slot: 6,
	            pre: options.spaceBeforeMeridiem ? ' ' : ''
	          });
	        }
	        if (!this.allDay && !options.hideTime) {
	          fs.push({
	            name: 'time',
	            fn: function(date) {
	              var str;
	              str = date.minutes() === 0 && options.implicitMinutes && needsMeridiem ? date.format(options.hourFormat) : date.format(options.hourFormat + ":" + options.minuteFormat);
	              if (!options.groupMeridiems && needsMeridiem) {
	                if (options.spaceBeforeMeridiem) {
	                  str += ' ';
	                }
	                str += date.format(options.meridiemFormat);
	              }
	              return str;
	            },
	            slot: 5,
	            pre: ', '
	          });
	        }
	        start_bucket = [];
	        end_bucket = [];
	        common_bucket = [];
	        together = true;
	        process = (function(_this) {
	          return function(format) {
	            var end_str, start_group, start_str;
	            start_str = format.fn(_this._start);
	            end_str = format.ignoreEnd && format.ignoreEnd() ? start_str : format.fn(_this._end);
	            start_group = {
	              format: format,
	              value: function() {
	                return start_str;
	              }
	            };
	            if (end_str === start_str && together) {
	              return common_bucket.push(start_group);
	            } else {
	              if (together) {
	                together = false;
	                common_bucket.push({
	                  format: {
	                    slot: format.slot,
	                    pre: ''
	                  },
	                  value: function() {
	                    return options.template(fold(start_bucket), fold(end_bucket, true).trim());
	                  }
	                });
	              }
	              start_bucket.push(start_group);
	              return end_bucket.push({
	                format: format,
	                value: function() {
	                  return end_str;
	                }
	              });
	            }
	          };
	        })(this);
	        for (j = 0, len = fs.length; j < len; j++) {
	          format = fs[j];
	          process(format);
	        }
	        global_first = true;
	        fold = function(array, skip_pre) {
	          var k, len1, local_first, ref, section, str;
	          local_first = true;
	          str = '';
	          ref = array.sort(function(a, b) {
	            return a.format.slot - b.format.slot;
	          });
	          for (k = 0, len1 = ref.length; k < len1; k++) {
	            section = ref[k];
	            if (!global_first) {
	              if (local_first && skip_pre) {
	                str += ' ';
	              } else {
	                str += section.format.pre;
	              }
	            }
	            str += section.value();
	            global_first = false;
	            local_first = false;
	          }
	          return str;
	        };
	        return fold(common_bucket);
	      };
	
	      Twix.prototype._iterateHelper = function(period, iter, hasNext, intervalAmount) {
	        return {
	          next: function() {
	            var val;
	            if (!hasNext()) {
	              return null;
	            } else {
	              val = iter.clone();
	              iter.add(intervalAmount, period);
	              return val;
	            }
	          },
	          hasNext: hasNext
	        };
	      };
	
	      Twix.prototype._prepIterateInputs = function() {
	        var inputs, intervalAmount, minHours, period, ref, ref1;
	        inputs = 1 <= arguments.length ? slice.call(arguments, 0) : [];
	        if (typeof inputs[0] === 'number') {
	          return inputs;
	        }
	        if (typeof inputs[0] === 'string') {
	          period = inputs.shift();
	          intervalAmount = (ref = inputs.pop()) != null ? ref : 1;
	          if (inputs.length) {
	            minHours = (ref1 = inputs[0]) != null ? ref1 : false;
	          }
	        }
	        if (moment.isDuration(inputs[0])) {
	          period = 'ms';
	          intervalAmount = inputs[0].as(period);
	        }
	        return [intervalAmount, period, minHours];
	      };
	
	      Twix.prototype._inner = function(period, intervalAmount) {
	        var durationCount, durationPeriod, end, modulus, start;
	        if (period == null) {
	          period = 'ms';
	        }
	        if (intervalAmount == null) {
	          intervalAmount = 1;
	        }
	        start = this.start();
	        end = this._displayEnd.clone();
	        if (start > start.clone().startOf(period)) {
	          start.startOf(period).add(intervalAmount, period);
	        }
	        if (end < end.clone().endOf(period)) {
	          end.startOf(period);
	        }
	        durationPeriod = start.twix(end).asDuration(period);
	        durationCount = durationPeriod.get(period);
	        modulus = durationCount % intervalAmount;
	        end.subtract(modulus, period);
	        return [start, end];
	      };
	
	      Twix.prototype._mutated = function() {
	        this._start = this.allDay ? this._oStart.clone().startOf('d') : this._oStart;
	        this._lastMilli = this.allDay ? this._oEnd.clone().endOf('d') : this._oEnd;
	        this._end = this.allDay ? this._oEnd.clone().startOf('d') : this._oEnd;
	        return this._displayEnd = this.allDay ? this._end.clone().add(1, 'd') : this._end;
	      };
	
	      return Twix;
	
	    })();
	    Twix._extend(moment.locale(), {
	      _twix: Twix.defaults
	    });
	    Twix.formatTemplate = function(leftSide, rightSide) {
	      return leftSide + " - " + rightSide;
	    };
	    moment.twix = function() {
	      return (function(func, args, ctor) {
	        ctor.prototype = func.prototype;
	        var child = new ctor, result = func.apply(child, args);
	        return Object(result) === result ? result : child;
	      })(Twix, arguments, function(){});
	    };
	    moment.fn.twix = function() {
	      return (function(func, args, ctor) {
	        ctor.prototype = func.prototype;
	        var child = new ctor, result = func.apply(child, args);
	        return Object(result) === result ? result : child;
	      })(Twix, [this].concat(slice.call(arguments)), function(){});
	    };
	    moment.fn.forDuration = function(duration, allDay) {
	      return new Twix(this, this.clone().add(duration), allDay);
	    };
	    if (moment.duration.fn) {
	      moment.duration.fn.afterMoment = function(startingTime, allDay) {
	        return new Twix(startingTime, moment(startingTime).clone().add(this), allDay);
	      };
	      moment.duration.fn.beforeMoment = function(startingTime, allDay) {
	        return new Twix(moment(startingTime).clone().subtract(this), startingTime, allDay);
	      };
	    }
	    moment.twixClass = Twix;
	    return Twix;
	  };
	
	  if (hasModule) {
	    return module.exports = makeTwix(__webpack_require__(/*! moment */ 1));
	  }
	
	  if (true) {
	    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! moment */ 1)], __WEBPACK_AMD_DEFINE_RESULT__ = function(moment) {
	      return makeTwix(moment);
	    }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	
	  if (this.moment) {
	    this.Twix = makeTwix(this.moment);
	  } else if (typeof moment !== "undefined" && moment !== null) {
	    this.Twix = makeTwix(moment);
	  }
	
	}).call(this);
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(/*! ./../../webpack/buildin/module.js */ 101)(module)))

/***/ }

});
//# sourceMappingURL=molgenis-global-ui.js.map