/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.v4_2;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaEntry;

class Vcf42MetaWriter {
    private static final String HEADER_PREFIX = "##";
    private static final String HEADER_STRUCTURED_ID_KEY = "ID";
    private static final String HEADER_INFO_KEY = "INFO";
    private static final String HEADER_INFO_NUMBER_KEY = "Number";
    private static final String HEADER_INFO_TYPE_KEY = "Type";
    private static final String HEADER_INFO_DESCRIPTION_KEY = "Description";
    private static final String HEADER_INFO_SOURCE_KEY = "Source";
    private static final String HEADER_INFO_VERSION_KEY = "Version";
    private static final String HEADER_FILTER_KEY = "FILTER";
    private static final String HEADER_FILTER_DESCRIPTION_KEY = "Description";
    private static final String HEADER_FORMAT_KEY = "FORMAT";
    private static final String HEADER_FORMAT_NUMBER_KEY = "Number";
    private static final String HEADER_FORMAT_TYPE_KEY = "Type";
    private static final String HEADER_FORMAT_DESCRIPTION_KEY = "Description";
    private static final String HEADER_ALT_KEY = "ALT";
    private static final String HEADER_ALT_DESCRIPTION_KEY = "Description";
    private static final String HEADER_CONTIG_KEY = "contig";
    private static final String HEADER_PEDIGREE_KEY = "PEDIGREE";
    private static final String HEADER_SAMPLE_KEY = "SAMPLE";
    private final Writer writer;

    Vcf42MetaWriter(Writer writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    void write(VcfMeta vcfMeta) {
        this.writeFileFormatHeader();
        this.writeUnstructuredMeta(vcfMeta);
        this.writeStructuredMeta(vcfMeta);
    }

    private void writeFileFormatHeader() {
        try {
            this.writer.write("##fileformat=VCFv4.2");
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeUnstructuredMeta(VcfMeta vcfMeta) {
        vcfMeta.getMeta().forEach((key, value) -> {
            if (!key.equals("fileformat")) {
                this.writeHeader((String)key, (String)value);
            }
        });
    }

    private void writeStructuredMeta(VcfMeta vcfMeta) {
        vcfMeta.getInfoMeta().forEach(this::writeHeader);
        vcfMeta.getFilterMeta().forEach(this::writeHeader);
        vcfMeta.getFormatMeta().forEach(this::writeHeader);
        vcfMeta.getAltMeta().forEach(this::writeHeader);
        vcfMeta.getContigMeta().forEach(this::writeHeader);
        vcfMeta.getSampleMeta().forEach(this::writeHeader);
        vcfMeta.getPedigreeMeta().forEach(this::writeHeader);
    }

    private void writeHeader(String key, String value) {
        try {
            this.writer.write(HEADER_PREFIX);
            this.writer.write(key);
            this.writer.write(61);
            this.writer.write(value);
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeHeader(VcfMetaEntry vcfMetaEntry) {
        try {
            String name = vcfMetaEntry.getName();
            this.writer.write(HEADER_PREFIX);
            this.writer.write(name);
            this.writer.write(61);
            this.writer.write(60);
            Iterator<Map.Entry<String, String>> it = vcfMetaEntry.getProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                this.writeKeyValue(name, entry.getKey(), entry.getValue());
                if (!it.hasNext()) continue;
                this.writer.write(44);
            }
            this.writer.write(62);
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeKeyValue(String name, String key, String value) throws IOException {
        this.writer.write(key);
        this.writer.write(61);
        if (this.isDoubleQuoteValue(name, key, value)) {
            this.writer.write(34);
            this.writer.write(this.escape(value));
            this.writer.write(34);
        } else {
            this.writer.write(value);
        }
    }

    private boolean isDoubleQuoteValue(String name, String key, String value) {
        boolean doubleQuoteValue = value.matches("\\W");
        block9 : switch (name) {
            case "INFO": {
                switch (key) {
                    case "ID": 
                    case "Number": 
                    case "Type": {
                        doubleQuoteValue = false;
                        break block9;
                    }
                    case "Description": 
                    case "Source": 
                    case "Version": {
                        doubleQuoteValue = true;
                        break block9;
                    }
                }
                break;
            }
            case "FILTER": {
                switch (key) {
                    case "ID": {
                        doubleQuoteValue = false;
                        break block9;
                    }
                    case "Description": {
                        doubleQuoteValue = true;
                        break block9;
                    }
                }
                break;
            }
            case "FORMAT": {
                switch (key) {
                    case "ID": 
                    case "Number": 
                    case "Type": {
                        doubleQuoteValue = false;
                        break block9;
                    }
                    case "Description": {
                        doubleQuoteValue = true;
                        break block9;
                    }
                }
                break;
            }
            case "ALT": {
                switch (key) {
                    case "ID": {
                        doubleQuoteValue = false;
                        break block9;
                    }
                    case "Description": {
                        doubleQuoteValue = true;
                        break block9;
                    }
                }
                break;
            }
            case "contig": 
            case "SAMPLE": 
            case "PEDIGREE": {
                if (!HEADER_STRUCTURED_ID_KEY.equals(key)) break;
                doubleQuoteValue = false;
                break;
            }
        }
        return doubleQuoteValue;
    }

    private String escape(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

