/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import java.util.Iterator;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaFormat;

public class VcfGeneticVariantMeta
implements GeneticVariantMeta {
    private final VcfMeta vcfMeta;
    private final Iterable<String> vcfRecordFormat;

    public VcfGeneticVariantMeta(VcfMeta vcfMeta, Iterable<String> vcfRecordFormat) {
        if (vcfMeta == null) {
            throw new IllegalArgumentException("vcfMeta is null");
        }
        if (vcfRecordFormat == null) {
            throw new IllegalArgumentException("vcfRecord is null");
        }
        this.vcfMeta = vcfMeta;
        this.vcfRecordFormat = vcfRecordFormat;
    }

    @Override
    public Iterable<String> getRecordIds() {
        return this.vcfRecordFormat;
    }

    @Override
    public GeneticVariantMeta.Type getRecordType(String recordId) {
        String record;
        boolean found = false;
        Iterator<String> iterator = this.vcfRecordFormat.iterator();
        while (iterator.hasNext() && !(found = (record = iterator.next()).equals(recordId))) {
        }
        if (!found) {
            return null;
        }
        VcfMetaFormat format = this.vcfMeta.getFormatMeta(recordId);
        if (format == null) {
            return null;
        }
        String number = format.getNumber();
        boolean isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.valueOf(number) > 1;
        switch (format.getType()) {
            case CHARACTER: {
                return isListValue ? GeneticVariantMeta.Type.CHAR_LIST : GeneticVariantMeta.Type.CHAR;
            }
            case FLOAT: {
                return isListValue ? GeneticVariantMeta.Type.FLOAT_LIST : GeneticVariantMeta.Type.FLOAT;
            }
            case INTEGER: {
                return isListValue ? GeneticVariantMeta.Type.INTEGER_LIST : GeneticVariantMeta.Type.INTEGER;
            }
            case STRING: {
                return isListValue ? GeneticVariantMeta.Type.STRING_LIST : GeneticVariantMeta.Type.STRING;
            }
        }
        throw new IllegalArgumentException("invalid vcf format type [" + (Object)((Object)format.getType()) + "]");
    }
}

