/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import java.util.HashSet;
import org.molgenis.genotype.util.ChrPos;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;

public class VariantFilterSeqPos
implements VariantFilter {
    private static final String SEP = ":";
    private final HashSet<String> toInclude = new HashSet();

    public void addSeqPos(String seq, int pos) {
        this.toInclude.add(seq + SEP + pos);
    }

    public void addSeqPos(ChrPos chrPos) {
        this.addSeqPos(chrPos.getChr(), chrPos.getPos());
    }

    public void addSeqPos(GeneticVariant variant) {
        this.toInclude.add(variant.getSequenceName() + SEP + variant.getStartPos());
    }

    @Override
    public boolean doesVariantPassFilter(GeneticVariant variant) {
        return this.toInclude.contains(variant.getSequenceName() + SEP + variant.getStartPos());
    }

    @Override
    public boolean doesIdPassFilter(String id) {
        return true;
    }
}

