/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant.range;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.molgenis.genotype.util.ChromosomeComparator;
import org.molgenis.genotype.variant.GeneticVariant;

public class GeneticVariantRangeSubIterator
implements Iterator<GeneticVariant> {
    private int currentIndex;
    private final String seqStopName;
    private final int stopPos;
    private final List<GeneticVariant> sortedVariants;

    public GeneticVariantRangeSubIterator(int listStartIndex, String seqStopName, int stopPos, List<GeneticVariant> sortedVariants) {
        this.currentIndex = listStartIndex - 1;
        this.seqStopName = seqStopName;
        this.stopPos = stopPos;
        this.sortedVariants = sortedVariants;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex + 1 < this.sortedVariants.size()) {
            GeneticVariant nextVariant = this.sortedVariants.get(this.currentIndex + 1);
            if (nextVariant.getSequenceName().equals(this.seqStopName) && nextVariant.getStartPos() <= this.stopPos) {
                return true;
            }
            return ChromosomeComparator.chrASmallerChrB(nextVariant.getSequenceName(), this.seqStopName);
        }
        return false;
    }

    @Override
    public GeneticVariant next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more variants in selected range");
        }
        ++this.currentIndex;
        return this.sortedVariants.get(this.currentIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported ever.");
    }
}

