/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.util.ChromosomeComparator;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantChrPosComparator;
import org.molgenis.genotype.variant.range.GeneticVariantRangeSubIterable;

public class GeneticVariantRange
implements Iterable<GeneticVariant> {
    private static final Logger LOGGER = Logger.getLogger(GeneticVariantRange.class);
    private final List<GeneticVariant> variants;

    public static GeneticVariantRangeCreate createRangeFactory() {
        return new GeneticVariantRangeCreate();
    }

    public static GeneticVariantRangeCreate createRangeFactory(int expectedNumberVariants) {
        return new GeneticVariantRangeCreate(expectedNumberVariants);
    }

    private GeneticVariantRange(List<GeneticVariant> variants) {
        this.variants = variants;
    }

    public Iterable<GeneticVariant> getVariantsByRange(String startSeqName, int startPos, String stopSeqName, int stopPos) {
        if (ChromosomeComparator.chrASmallerChrB(startSeqName, stopSeqName)) {
            throw new GenotypeDataException("Cannot query range. Start chr is larger than stop chr");
        }
        if (startSeqName.equals(startSeqName) && startPos > stopPos) {
            throw new GenotypeDataException("Cannot query range. Start position is larger than stop postion and chr is identical");
        }
        int startIndex = this.binarySearchStartIndex(startSeqName, startPos, stopSeqName, stopPos);
        return new GeneticVariantRangeSubIterable(startIndex, stopSeqName, stopPos, this.variants);
    }

    private int binarySearchStartIndex(String startSeqName, int startPos, String stopSeqName, int stopPos) {
        int startSearch = 0;
        int endSearch = this.variants.size() - 1;
        while (endSearch >= startSearch) {
            int midSearch = startSearch + (endSearch - startSearch) / 2;
            GeneticVariant midSearchVariant = this.variants.get(midSearch);
            if (ChromosomeComparator.chrASmallerChrB(midSearchVariant.getSequenceName(), startSeqName) || midSearchVariant.getSequenceName().equals(startSeqName) && midSearchVariant.getStartPos() < startPos) {
                startSearch = midSearch + 1;
                continue;
            }
            if (ChromosomeComparator.chrASmallerEqualChrB(midSearchVariant.getSequenceName(), stopSeqName) && midSearchVariant.getStartPos() <= stopPos) {
                if (midSearch == 0) {
                    return 0;
                }
                GeneticVariant leftOfMidSearchVariant = this.variants.get(midSearch - 1);
                if (ChromosomeComparator.chrASmallerChrB(leftOfMidSearchVariant.getSequenceName(), startSeqName) || leftOfMidSearchVariant.getSequenceName().equals(startSeqName) && leftOfMidSearchVariant.getStartPos() < startPos) {
                    return midSearch;
                }
                endSearch = midSearch - 1;
                continue;
            }
            endSearch = midSearch - 1;
        }
        return this.variants.size();
    }

    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int startPos, int stopPos) {
        return this.getVariantsByRange(seqName, startPos, seqName, stopPos);
    }

    public Iterable<GeneticVariant> getVariantsBySequence(String seqName) {
        return this.getVariantsByRange(seqName, -1, seqName, Integer.MAX_VALUE);
    }

    public Iterable<GeneticVariant> getVariantAtPos(String seqName, int pos) {
        return this.getVariantsByRange(seqName, pos, seqName, pos);
    }

    public List<GeneticVariant> getAllVrariantsInRange() {
        return this.variants;
    }

    public int size() {
        return this.variants.size();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.getAllVrariantsInRange().iterator();
    }

    public static class GeneticVariantRangeCreate {
        private final ArrayList<GeneticVariant> variants;
        private boolean isSorted;
        private GeneticVariant lastVariant = null;

        public GeneticVariantRangeCreate(ArrayList<GeneticVariant> variants) {
            this.variants = variants;
            this.isSorted = false;
            this.lastVariant = variants.get(variants.size());
        }

        public GeneticVariantRangeCreate() {
            this.variants = new ArrayList();
            this.isSorted = true;
        }

        public GeneticVariantRangeCreate(int expectedNumberVariants) {
            this.variants = new ArrayList(expectedNumberVariants);
            this.isSorted = true;
        }

        public void addVariant(GeneticVariant variant) {
            if (this.lastVariant != null && variant.getSequenceName().equals(this.lastVariant.getSequenceName()) && variant.getStartPos() < this.lastVariant.getStartPos()) {
                this.isSorted = false;
            } else if (this.lastVariant != null && ChromosomeComparator.chrASmallerChrB(variant.getSequenceName(), this.lastVariant.getSequenceName())) {
                this.isSorted = false;
            }
            this.lastVariant = variant;
            this.variants.add(variant);
        }

        public GeneticVariantRange createRange() {
            if (!this.isSorted) {
                LOGGER.info("Variants where not sorted, loading will be faster if the data is pre-sorted");
                Collections.sort(this.variants, new GeneticVariantChrPosComparator());
            }
            return new GeneticVariantRange(this.variants);
        }

        public int size() {
            return this.variants.size();
        }
    }
}

