/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.GenotypeDataException;

public class Utils {
    public static final Map<Character, Character> COMPLEMENTAL_NUCLEOTIDES = new HashMap<Character, Character>();
    private static final Logger LOGGER = Logger.getLogger(GenotypeData.class);

    public static <T> List<T> iteratorToList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static boolean isSnp(List<String> alleles) {
        for (String allele : alleles) {
            if (allele == null || allele.length() == 1) continue;
            return false;
        }
        return true;
    }

    public static char getComplementNucleotide(char allele) {
        Character complementAllele = COMPLEMENTAL_NUCLEOTIDES.get(Character.valueOf(allele));
        if (complementAllele == null) {
            throw new GenotypeDataException("Failed to get comlpement for allele: " + allele);
        }
        return complementAllele.charValue();
    }

    public static void createEmptyFile(File file, String fileName) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new GenotypeDataException("Cannot overwrite dir with " + fileName + " file:" + file.getAbsolutePath());
            }
            if (file.isFile()) {
                LOGGER.warn("Overriding " + fileName + " file " + file.getAbsolutePath());
                if (!file.delete()) {
                    throw new GenotypeDataException("Failed to overwrite " + fileName + " file: " + file.getAbsolutePath());
                }
            }
        }
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new GenotypeDataException("Failed to create parent dirs for " + fileName + " file: " + file.getAbsolutePath());
        }
        try {
            if (!file.createNewFile()) {
                throw new GenotypeDataException("Error creating " + fileName + " file: " + file.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            throw new GenotypeDataException("Error creating " + fileName + " file: " + file.getAbsolutePath(), ex);
        }
        if (!file.canWrite()) {
            throw new GenotypeDataException("Created " + fileName + " file but can not write to file: " + file.getAbsolutePath());
        }
    }

    static {
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('A'), Character.valueOf('T'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('a'), Character.valueOf('t'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('T'), Character.valueOf('A'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('t'), Character.valueOf('a'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('C'), Character.valueOf('G'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('c'), Character.valueOf('g'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('G'), Character.valueOf('C'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('g'), Character.valueOf('c'));
        COMPLEMENTAL_NUCLEOTIDES.put(Character.valueOf('0'), Character.valueOf('0'));
    }
}

