/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.util.MafResult;

public class MafCalculator {
    public static MafResult calculateMaf(Alleles alleles, Allele reference, List<Alleles> samplesAlleles) {
        if (alleles.getAlleles().isEmpty() || alleles.getAlleles().size() == 1) {
            return new MafResult(Allele.ZERO, 0.0);
        }
        TObjectIntHashMap alleleCounts = new TObjectIntHashMap(alleles.getAlleleCount());
        for (Allele allele : alleles.getAlleles()) {
            if (allele == Allele.ZERO) continue;
            alleleCounts.put((Object)allele, 0);
        }
        if (alleleCounts.isEmpty()) {
            return new MafResult(Allele.ZERO, 0.0);
        }
        for (Alleles sampleAlleles : samplesAlleles) {
            if (sampleAlleles == null) continue;
            for (Allele sampleAllele : sampleAlleles.getAlleles()) {
                if (sampleAllele == null || sampleAllele == Allele.ZERO || alleleCounts.increment((Object)sampleAllele)) continue;
                throw new GenotypeDataException("No counter for allele: " + sampleAllele + " expected one of the following alleles: " + alleles);
            }
        }
        Allele provisionalMinorAllele = reference != null ? reference : alleles.getAlleles().get(0);
        int provisionalMinorAlleleCount = alleleCounts.get((Object)provisionalMinorAllele);
        int totalAlleleCount = 0;
        for (Allele allele : alleles.getAlleles()) {
            int alleleCount = alleleCounts.get((Object)allele);
            totalAlleleCount += alleleCount;
            if (alleleCount >= provisionalMinorAlleleCount) continue;
            provisionalMinorAlleleCount = alleleCount;
            provisionalMinorAllele = allele;
        }
        return new MafResult(provisionalMinorAllele, (float)provisionalMinorAlleleCount / (float)totalAlleleCount);
    }
}

