/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.tabix;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.VariantQuery;
import org.molgenis.genotype.VariantQueryResult;
import org.molgenis.genotype.tabix.TabixIndex;
import org.molgenis.genotype.tabix.TabixQueryResult;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.VariantLineMapper;

public class TabixQuery
implements VariantQuery {
    private BlockCompressedInputStream inputStream;
    private final TabixIndex index;
    private final VariantLineMapper variantLineMapper;

    public TabixQuery(File bzipFile, TabixIndex index, VariantLineMapper variantLineMapper) {
        if (bzipFile == null) {
            throw new IllegalArgumentException("BzipFile is null");
        }
        if (index == null) {
            throw new IllegalArgumentException("Index is null");
        }
        if (variantLineMapper == null) {
            throw new IllegalArgumentException("VariantLineMapper is null");
        }
        try {
            this.inputStream = new BlockCompressedInputStream(bzipFile);
        }
        catch (IOException e) {
            throw new GenotypeDataException("IOExcption creating BlockCompressedInputStream for " + bzipFile.getName(), e);
        }
        this.index = index;
        this.variantLineMapper = variantLineMapper;
    }

    @Override
    public VariantQueryResult executeQuery(String sequence, int startPos, int stopPos) {
        if (startPos < 0) {
            throw new IllegalArgumentException("StartPos must be bigger then 0");
        }
        if (stopPos <= startPos) {
            throw new IllegalArgumentException("StopPos must be bigger then startPos ");
        }
        try {
            TabixIndex.TabixIterator tabixIterator = this.index.queryTabixIndex(sequence, startPos, stopPos, this.inputStream);
            return new TabixQueryResult(this.inputStream, new TabixQueryIterator(tabixIterator, this.variantLineMapper));
        }
        catch (IOException e) {
            throw new GenotypeDataException(e);
        }
    }

    @Override
    public VariantQueryResult executeQuery(String sequence) {
        return this.executeQuery(sequence, 0, Integer.MAX_VALUE);
    }

    @Override
    public VariantQueryResult executeQuery(String sequence, int startPos) {
        return this.executeQuery(sequence, startPos - 1, startPos);
    }

    private static class TabixQueryIterator
    implements Iterator<GeneticVariant> {
        private final TabixIndex.TabixIterator tabixIterator;
        private final VariantLineMapper variantLineMapper;
        private String line;

        public TabixQueryIterator(TabixIndex.TabixIterator tabixIterator, VariantLineMapper variantLineMapper) throws IOException {
            this.tabixIterator = tabixIterator;
            this.variantLineMapper = variantLineMapper;
            this.line = tabixIterator == null ? null : tabixIterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public GeneticVariant next() {
            GeneticVariant variant = this.variantLineMapper.mapLine(this.line);
            try {
                this.line = this.tabixIterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception calling next on TabixIndex.TabixIterator", e);
            }
            return variant;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

