/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.sampleFilter;

import java.util.Collection;
import java.util.HashSet;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.sampleFilter.SampleFilter;

public class SampleIdIncludeFilter
implements SampleFilter {
    private final HashSet<String> includedSampleIds;

    public SampleIdIncludeFilter(Collection<String> includedSampleIds) {
        this.includedSampleIds = new HashSet<String>(includedSampleIds);
    }

    public SampleIdIncludeFilter(String ... ids) {
        this.includedSampleIds = new HashSet();
        for (String id : ids) {
            this.includedSampleIds.add(id);
        }
    }

    public SampleIdIncludeFilter(HashSet<String> includedSampleIds) {
        this.includedSampleIds = includedSampleIds;
    }

    @Override
    public boolean doesSamplePassFilter(Sample sample) {
        return this.includedSampleIds.contains(sample.getId());
    }
}

