/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeWriter;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.plink.FormatPlinkChr;
import org.molgenis.genotype.util.Utils;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.NotASnpException;

public class PedMapGenotypeWriter
implements GenotypeWriter {
    private static Logger LOGGER = Logger.getLogger(PedMapGenotypeWriter.class);
    private final GenotypeData genotypeData;
    private final char SEPARATOR = (char)32;
    private static final DecimalFormat PHENO_FORMATTER = new DecimalFormat("0.#####");
    private static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    private static final Alleles BI_ALLELIC_MISSING = Alleles.createAlleles(Allele.ZERO, Allele.ZERO);
    private int writtenSamplesCounter;
    private int writtenVariantsCounter;
    private int excludedVariantsCounter;

    public PedMapGenotypeWriter(GenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    @Override
    public void write(String basePath) throws IOException, NotASnpException {
        this.write(new File(basePath + ".ped"), new File(basePath + ".map"));
    }

    public void write(File pedFile, File mapFile) throws IOException, NotASnpException {
        if (pedFile == null) {
            throw new IllegalArgumentException("No ped file specified to write to");
        }
        if (mapFile == null) {
            throw new IllegalArgumentException("No map file specified to write to");
        }
        this.writtenSamplesCounter = 0;
        this.writtenVariantsCounter = 0;
        this.excludedVariantsCounter = 0;
        this.writeMapFile(mapFile);
        this.writePedFile(pedFile);
        LOGGER.info("PED/MAP plink data write completed.\n - Number of samples: " + this.writtenSamplesCounter + "\n" + " - Number of SNPs: " + this.writtenVariantsCounter + "\n" + " - Excluded non biallelic SNPs: " + this.excludedVariantsCounter);
    }

    private void writeMapFile(File mapFile) throws IOException {
        Utils.createEmptyFile(mapFile, "map");
        BufferedWriter mapFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mapFile), FILE_ENCODING));
        for (GeneticVariant variant : this.genotypeData) {
            if (variant.getAlleleCount() > 2 || !variant.isSnp()) {
                LOGGER.warn("Skipping variant: " + variant.getPrimaryVariantId() + ", it is not a biallelic SNP");
                ++this.excludedVariantsCounter;
                continue;
            }
            mapFileWriter.append(FormatPlinkChr.formatChr(variant.getSequenceName()));
            mapFileWriter.append(' ');
            mapFileWriter.append(variant.getPrimaryVariantId() == null ? variant.getSequenceName() + ":" + variant.getStartPos() : variant.getPrimaryVariantId());
            mapFileWriter.append(' ');
            mapFileWriter.append('0');
            mapFileWriter.append(' ');
            mapFileWriter.append(String.valueOf(variant.getStartPos()));
            mapFileWriter.append('\n');
            ++this.writtenVariantsCounter;
        }
        mapFileWriter.close();
    }

    private void writePedFile(File pedFile) throws IOException {
        LOGGER.info("Writing genotype data to: " + pedFile);
        Utils.createEmptyFile(pedFile, "bim");
        BufferedWriter pedFilewriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pedFile), FILE_ENCODING));
        int sampleInt = 0;
        for (Sample sample : this.genotypeData.getSamples()) {
            if (sampleInt == 0) {
                ++this.writtenSamplesCounter;
            }
            pedFilewriter.append(sample.getFamilyId() != null ? sample.getFamilyId() : "0");
            pedFilewriter.append(' ');
            pedFilewriter.append(sample.getId());
            pedFilewriter.append(' ');
            pedFilewriter.append(sample.getFatherId());
            pedFilewriter.append(' ');
            pedFilewriter.append(sample.getMotherId());
            pedFilewriter.append(' ');
            pedFilewriter.append(Byte.toString(sample.getSex().getPlinkSex()));
            pedFilewriter.append(' ');
            pedFilewriter.append(PHENO_FORMATTER.format(this.getPhenotype(sample)));
            for (GeneticVariant variant : this.genotypeData) {
                Alleles variantAlleles = variant.getVariantAlleles();
                if (variant.getAlleleCount() > 2 || !variant.isSnp()) continue;
                Iterator<Alleles> sampleAllelesIterator = variant.getSampleVariants().iterator();
                for (int i = 0; i < sampleInt; ++i) {
                    sampleAllelesIterator.next();
                }
                Alleles sampleAlleles = sampleAllelesIterator.next();
                if (sampleAlleles.contains(Allele.ZERO) || sampleAlleles.getAlleleCount() < 2) {
                    sampleAlleles = BI_ALLELIC_MISSING;
                } else if (sampleAlleles.getAlleleCount() > 2 || !variantAlleles.containsAll(sampleAlleles)) {
                    throw new GenotypeDataException("Trying to write alleles " + sampleAlleles.getAllelesAsString() + " for " + variantAlleles + " SNP");
                }
                pedFilewriter.append(' ');
                pedFilewriter.append(sampleAlleles.getAlleles().get(0).toString());
                pedFilewriter.append(' ');
                pedFilewriter.append(sampleAlleles.getAlleles().get(1).toString());
            }
            pedFilewriter.append('\n');
            if (++sampleInt % 100 != 0) continue;
            System.out.println(sampleInt + " samples writen to ped file");
        }
        pedFilewriter.close();
        LOGGER.info("All samples and genotypes written to ped file");
    }

    private double getPhenotype(Sample sample) {
        Object value = sample.getAnnotationValues().get("phenotype");
        if (value == null) {
            return -9.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return Double.valueOf(value.toString());
    }
}

