/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;
import org.molgenis.genotype.plink.PlinkSampleAnnotations;
import org.molgenis.genotype.plink.datatypes.MapEntry;
import org.molgenis.genotype.plink.datatypes.PedEntry;
import org.molgenis.genotype.plink.drivers.PedFileDriver;
import org.molgenis.genotype.plink.readers.MapFileReader;
import org.molgenis.genotype.util.Cache;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.util.RecordIteratorCreators;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GeneticVariantMetaMap;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.range.GeneticVariantRange;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class PedMapGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private static final Logger LOG = Logger.getLogger(PedMapGenotypeData.class);
    private final int sampleVariantProviderUniqueId;
    private TIntObjectMap<List<Alleles>> sampleAllelesBySnpIndex = new TIntObjectHashMap(1000, 0.75f);
    private GeneticVariantRange snps;
    private TObjectIntMap<String> snpIndexById = new TObjectIntHashMap(1000, 0.75f, -1);
    private Map<String, SampleAnnotation> sampleAnnotations;
    private final Cache<GeneticVariant, byte[]> calledDosageCache;
    private final Cache<GeneticVariant, float[]> dosageCache;
    private ArrayList<Sample> samples = new ArrayList();
    private Set<String> seqNames = new LinkedHashSet<String>();
    private GeneticVariantMeta geneticVariantMeta = GeneticVariantMetaMap.getGeneticVariantMetaGt();

    public PedMapGenotypeData(String basePath) throws FileNotFoundException, IOException {
        this(new File(basePath + ".ped"), new File(basePath + ".map"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PedMapGenotypeData(File pedFile, File mapFile) throws FileNotFoundException, IOException {
        if (pedFile == null) {
            throw new IllegalArgumentException("PedFile is null");
        }
        if (mapFile == null) {
            throw new IllegalArgumentException("MapFile is null");
        }
        if (!mapFile.isFile()) {
            throw new FileNotFoundException("MAP index file not found at " + mapFile.getAbsolutePath());
        }
        if (!mapFile.canRead()) {
            throw new IOException("MAP index file not found at " + mapFile.getAbsolutePath());
        }
        if (!pedFile.isFile()) {
            throw new FileNotFoundException("PED file not found at " + pedFile.getAbsolutePath());
        }
        if (!pedFile.canRead()) {
            throw new IOException("PED file not found at " + pedFile.getAbsolutePath());
        }
        MapFileReader mapFileReader = null;
        PedFileDriver pedFileDriver = null;
        try {
            pedFileDriver = new PedFileDriver(pedFile);
            this.loadSampleBialleles(pedFileDriver);
            mapFileReader = new MapFileReader(new FileInputStream(mapFile));
            this.loadSnps(mapFileReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pedFileDriver);
            IOUtils.closeQuietly(mapFileReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)pedFileDriver);
        IOUtils.closeQuietly((Closeable)mapFileReader);
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.sampleAnnotations = PlinkSampleAnnotations.getSampleAnnotations();
        this.calledDosageCache = new Cache(100);
        this.dosageCache = new Cache(100);
    }

    private void loadSampleBialleles(PedFileDriver pedFileDriver) {
        int count = 0;
        for (PedEntry entry : pedFileDriver) {
            LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
            annotationValues.put("fatherId", entry.getFather());
            annotationValues.put("motherId", entry.getMother());
            annotationValues.put("sex_generic", (Object)SexAnnotation.getSexAnnotationForPlink(entry.getSex()));
            annotationValues.put("phenotype", entry.getPhenotype());
            this.samples.add(new Sample(entry.getIndividual(), entry.getFamily(), annotationValues));
            int index = 0;
            for (Alleles biallele : entry) {
                ArrayList<Alleles> biallelesForSnp = (ArrayList<Alleles>)this.sampleAllelesBySnpIndex.get(index);
                if (biallelesForSnp == null) {
                    biallelesForSnp = new ArrayList<Alleles>();
                    this.sampleAllelesBySnpIndex.put(index, biallelesForSnp);
                }
                biallelesForSnp.add(biallele);
                ++index;
            }
            if (++count % 100 != 0) continue;
            LOG.info("Loaded [" + count + "] samples");
        }
        LOG.info("Total [" + count + "] samples");
    }

    private void loadSnps(MapFileReader reader) {
        int index = 0;
        GeneticVariantRange.GeneticVariantRangeCreate rangeFactory = GeneticVariantRange.createRangeFactory();
        for (MapEntry entry : reader) {
            String id = entry.getSNP();
            String sequenceName = entry.getChromosome();
            this.seqNames.add(sequenceName);
            int startPos = (int)entry.getBpPos();
            List sampleAlleles = (List)this.sampleAllelesBySnpIndex.get(index);
            ArrayList<String> alleles = new ArrayList<String>(2);
            for (Alleles biallele : sampleAlleles) {
                String allele2;
                String allele1;
                String string = allele1 = biallele.get(0) == Allele.ZERO ? null : biallele.get(0).toString();
                if (allele1 != null && !alleles.contains(allele1)) {
                    alleles.add(allele1);
                }
                if ((allele2 = biallele.get(1) == Allele.ZERO ? null : biallele.get(1).toString()) == null || alleles.contains(allele2)) continue;
                alleles.add(allele2);
            }
            GeneticVariant snp = ReadOnlyGeneticVariant.createVariant(this.geneticVariantMeta, id, startPos, sequenceName, (SampleVariantsProvider)this, alleles);
            rangeFactory.addVariant(snp);
            this.snpIndexById.put((Object)snp.getPrimaryVariantId(), index);
            if (++index % 100000 != 0) continue;
            LOG.info("Loaded [" + index + "] snps");
        }
        this.snps = rangeFactory.createRange();
        LOG.info("Total [" + index + "] snps");
    }

    public List<Sequence> getSequences() {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(this.seqNames.size());
        for (String seqName : this.seqNames) {
            sequences.add(new SimpleSequence(seqName, null, this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        if (variant.getPrimaryVariantId() == null) {
            throw new IllegalArgumentException("Not a snp, missing primaryVariantId");
        }
        int index = this.snpIndexById.get((Object)variant.getPrimaryVariantId());
        if (index == -1) {
            throw new IllegalArgumentException("Unknown primaryVariantId [" + variant.getPrimaryVariantId() + "]");
        }
        List bialleles = (List)this.sampleAllelesBySnpIndex.get(index);
        return Collections.unmodifiableList(bialleles);
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.seqNames);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.snps.getVariantAtPos(seqName, startPos);
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.snps.iterator();
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.snps.getVariantsBySequence(seqName);
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        List<Boolean> phasing = Collections.nCopies(this.getSampleVariants(variant).size(), false);
        return phasing;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotations;
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.snps.getVariantsByRange(seqName, rangeStart, rangeEnd);
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        if (this.calledDosageCache.containsKey(variant)) {
            return this.calledDosageCache.get(variant);
        }
        byte[] calledDosage = CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        this.calledDosageCache.put(variant, calledDosage);
        return calledDosage;
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        if (this.dosageCache.containsKey(variant)) {
            return this.dosageCache.get(variant);
        }
        float[] dosage = CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        this.dosageCache.put(variant, dosage);
        return dosage;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return true;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertCalledAllelesToProbability(variant.getSampleVariants(), variant.getVariantAlleles());
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords(GeneticVariant variant) {
        return RecordIteratorCreators.createIteratorFromAlleles(variant.getSampleVariants());
    }
}

