/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.multipart;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;

public class MultiPartVariantsIterable
implements Iterable<GeneticVariant> {
    private final Iterable<RandomAccessGenotypeData> datasets;

    public MultiPartVariantsIterable(Iterable<RandomAccessGenotypeData> collection) {
        this.datasets = collection;
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return new MultiPartVariantIterator(this.datasets);
    }

    private static class MultiPartVariantIterator
    implements Iterator<GeneticVariant> {
        private Iterator<RandomAccessGenotypeData> datasetIterator;
        private Iterator<GeneticVariant> datasetVariantIterator;
        private boolean done = false;

        public MultiPartVariantIterator(Iterable<RandomAccessGenotypeData> datasets) {
            this.datasetIterator = datasets.iterator();
            if (this.datasetIterator.hasNext()) {
                this.datasetVariantIterator = this.datasetIterator.next().iterator();
            } else {
                this.done = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            while (!this.datasetVariantIterator.hasNext()) {
                if (this.datasetIterator.hasNext()) {
                    this.datasetVariantIterator = this.datasetIterator.next().iterator();
                    continue;
                }
                this.done = true;
                return false;
            }
            return true;
        }

        @Override
        public GeneticVariant next() {
            if (this.hasNext()) {
                return this.datasetVariantIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

