/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.editable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.editable.EditableSampleVariantsProvider;
import org.molgenis.genotype.editable.VariantInformation;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GeneticVariantMetaMap;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;

public class EditableGenotypeDosageSampleVariantsProvider
implements EditableSampleVariantsProvider {
    private final int sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
    private final GeneticVariantMeta geneticVariantMeta;
    private final int numberSamples;
    private final List<Boolean> phasing;
    private final HashMap<VariantInformation, List<Alleles>> sampleVariants;
    private final HashMap<VariantInformation, float[]> sampleDosages;

    public EditableGenotypeDosageSampleVariantsProvider(int numberSamples) {
        HashMap<String, GeneticVariantMeta.Type> variantMeta = new HashMap<String, GeneticVariantMeta.Type>(2);
        variantMeta.put("GT", GeneticVariantMeta.Type.ALLELES);
        variantMeta.put("DS", GeneticVariantMeta.Type.FLOAT);
        this.geneticVariantMeta = GeneticVariantMetaMap.createGeneticVariantMeta(variantMeta);
        this.numberSamples = numberSamples;
        this.phasing = Collections.unmodifiableList(Collections.nCopies(numberSamples, false));
        this.sampleVariants = new HashMap();
        this.sampleDosages = new HashMap();
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        List<Alleles> alleles = this.sampleVariants.get(new VariantInformation(variant.getPrimaryVariantId(), variant.getStartPos(), variant.getSequenceName(), variant.getVariantAlleles()));
        if (alleles == null) {
            throw new GenotypeDataException("No alleles for variant: " + variant.getPrimaryVariantId() + " in editable data");
        }
        return alleles;
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords(GeneticVariant variant) {
        return new FixedSizeIterableTriTyper(variant);
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        return this.phasing;
    }

    @Override
    public int cacheSize() {
        return this.sampleVariants.size();
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        float[] dosages = this.sampleDosages.get(new VariantInformation(variant.getPrimaryVariantId(), variant.getStartPos(), variant.getSequenceName(), variant.getVariantAlleles()));
        if (dosages == null) {
            throw new GenotypeDataException("No dosage for variant: " + variant.getPrimaryVariantId() + " in editable data");
        }
        return dosages;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertDosageToProbabilityHeuristic(variant.getSampleDosages());
    }

    @Override
    public GeneticVariantMeta getGeneticVariantMeta() {
        return this.geneticVariantMeta;
    }

    public void setDosageAndGenotypes(VariantInformation variant, List<Alleles> alleles, float[] dosages) {
        if (alleles.size() != dosages.length) {
            throw new GenotypeDataException();
        }
        if (alleles.size() != this.numberSamples) {
            throw new GenotypeDataException();
        }
        this.sampleVariants.put(variant, alleles);
        this.sampleDosages.put(variant, dosages);
    }

    public void setDosageAndGenotypes(GeneticVariant variant, List<Alleles> alleles, float[] dosages) {
        this.setDosageAndGenotypes(new VariantInformation(variant.getPrimaryVariantId(), variant.getStartPos(), variant.getSequenceName(), variant.getVariantAlleles()), alleles, dosages);
    }

    private class FixedSizeIterableTriTyper
    implements FixedSizeIterable<GenotypeRecord> {
        private final List<Alleles> alleles;
        private final float[] dosages;

        public FixedSizeIterableTriTyper(GeneticVariant variant) {
            this.alleles = variant.getSampleVariants();
            this.dosages = variant.getSampleDosages();
        }

        @Override
        public int size() {
            return this.alleles.size();
        }

        @Override
        public Iterator<GenotypeRecord> iterator() {
            return new Iterator<GenotypeRecord>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i + 1 < FixedSizeIterableTriTyper.this.alleles.size();
                }

                @Override
                public GenotypeRecord next() {
                    ++this.i;
                    return new TriTyperGenotypeRecord(this.i);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported ever yet.");
                }
            };
        }

        private class TriTyperGenotypeRecord
        implements GenotypeRecord {
            private final int i;

            public TriTyperGenotypeRecord(int i) {
                this.i = i;
            }

            @Override
            public Object getGenotypeRecordData(String recordId) {
                if (recordId.equals("GT")) {
                    return FixedSizeIterableTriTyper.this.alleles.get(this.i);
                }
                if (recordId.equals("DS")) {
                    return Float.valueOf(FixedSizeIterableTriTyper.this.dosages[this.i]);
                }
                return null;
            }

            @Override
            public Alleles getSampleAlleles() {
                return (Alleles)FixedSizeIterableTriTyper.this.alleles.get(this.i);
            }

            @Override
            public float[] getSampleProbs() {
                return null;
            }

            @Override
            public float getSampleDosage() {
                return FixedSizeIterableTriTyper.this.dosages[this.i];
            }

            @Override
            public boolean containsGenotypeRecord(String recordId) {
                return recordId.equals("GT") | recordId.equals("DS");
            }
        }
    }
}

