/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.annotation;

public enum SexAnnotation {
    MALE(1, "Male"),
    FEMALE(2, "Female"),
    UNKNOWN(0, "Unknown");

    private final byte plinkSex;
    private final String gender;

    private SexAnnotation(byte plinkSex, String gender) {
        this.plinkSex = plinkSex;
        this.gender = gender;
    }

    public byte getPlinkSex() {
        return this.plinkSex;
    }

    public static SexAnnotation getSexAnnotationForPlink(byte plinkSex) {
        switch (plinkSex) {
            case 1: {
                return MALE;
            }
            case 2: {
                return FEMALE;
            }
        }
        return UNKNOWN;
    }

    public static SexAnnotation getSexAnnotationForTriTyper(String ttSex) {
        if (ttSex == null) {
            return UNKNOWN;
        }
        if (ttSex.toLowerCase().equals("female")) {
            return FEMALE;
        }
        if (ttSex.toLowerCase().equals("male")) {
            return MALE;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.gender;
    }

    public String getGender() {
        return this.gender;
    }
}

