/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.util.Arrays;
import java.util.List;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sequence;

public class SimpleSequence
implements Sequence {
    private static final List<String> CHROMOSOMES = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "x", "y", "xy", "mt", "23", "24", "25", "26");
    private static final List<String> AUTOSOMES = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22");
    private String name;
    private Integer length;
    private RandomAccessGenotypeData genotypeData;

    public SimpleSequence(String name, Integer length, RandomAccessGenotypeData genotypeData) {
        this.name = name.intern();
        this.length = length;
        this.genotypeData = genotypeData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public boolean isChromosome() {
        return CHROMOSOMES.contains(this.name.toLowerCase());
    }

    @Override
    public boolean isAutosome() {
        return AUTOSOMES.contains(this.name.toLowerCase());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.genotypeData == null ? 0 : this.genotypeData.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleSequence other = (SimpleSequence)obj;
        if (this.genotypeData == null ? other.genotypeData != null : !this.genotypeData.equals(other.genotypeData)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

