/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.reportrvcf;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfRecord;
import org.molgenis.data.annotation.makervcf.structs.RVCF;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;

public class HomHetCounts {
    private VcfReader vcf;
    private PrintWriter pw;
    int nrOfSamples;
    public static String HEADER = "Gene\tHetAbs\tHomAbs\tHomFrac\tHetFrac";

    public static void main(String[] args) throws Exception {
        HomHetCounts hhc = new HomHetCounts(new File(args[0]), new File(args[1]), 2504);
        hhc.go();
    }

    public HomHetCounts(File rvcfInput, File outputHHC, int nrOfSamples) throws Exception {
        this.vcf = GavinUtils.getVcfReader(rvcfInput);
        this.pw = new PrintWriter(outputHHC);
        this.nrOfSamples = nrOfSamples;
    }

    public void go() throws Exception {
        HashMap<String, Integer> geneToHom = new HashMap<String, Integer>();
        HashMap<String, Integer> geneToHet = new HashMap<String, Integer>();
        HashSet<String> sampleGeneCombo = new HashSet<String>();
        for (VcfRecord aVcf : this.vcf) {
            AnnotatedVcfRecord record = new AnnotatedVcfRecord(aVcf);
            for (RVCF rvcf : record.getRvcf()) {
                String gene = rvcf.getGene();
                if (!geneToHom.containsKey(gene)) {
                    geneToHom.put(gene, 0);
                    geneToHet.put(gene, 0);
                }
                for (String sample : rvcf.getSampleGenotype().keySet()) {
                    int count;
                    if (MatchVariantsToGenotypeAndInheritance.Status.isHomozygous(rvcf.getSampleGenotype().get(sample)) && !sampleGeneCombo.contains(gene + "_" + sample)) {
                        count = (Integer)geneToHom.get(gene);
                        geneToHom.put(gene, count + 1);
                        sampleGeneCombo.add(gene + "_" + sample);
                    }
                    if (sampleGeneCombo.contains(gene + "_" + sample)) continue;
                    count = (Integer)geneToHet.get(gene);
                    geneToHet.put(gene, count + 1);
                    sampleGeneCombo.add(gene + "_" + sample);
                }
            }
        }
        this.pw.println(HEADER);
        for (String gene : geneToHom.keySet()) {
            this.pw.println(gene + "\t" + geneToHom.get(gene) + "\t" + geneToHet.get(gene) + "\t" + (double)((Integer)geneToHom.get(gene)).intValue() / (double)this.nrOfSamples + "\t" + (double)((Integer)geneToHet.get(gene)).intValue() / (double)this.nrOfSamples);
        }
        this.pw.flush();
        this.pw.close();
    }
}

