/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineFDRwithAllGenes {
    private static final Logger LOG = LoggerFactory.getLogger(CombineFDRwithAllGenes.class);
    private final String allGenesFilename;
    private final String fdrR0_1Filename;
    private final String fdrAllGenesFilename;

    public CombineFDRwithAllGenes(String allGenesFilename, String fdrR0_1Filename, String fdrAllGenesFilename) throws FileNotFoundException {
        this.allGenesFilename = allGenesFilename;
        this.fdrR0_1Filename = fdrR0_1Filename;
        this.fdrAllGenesFilename = fdrAllGenesFilename;
        HashSet<String> allGenes = new HashSet<String>();
        File allGenesFile = new File(this.allGenesFilename);
        File FDRfile = new File(this.fdrR0_1Filename);
        File outputFDR = new File(this.fdrAllGenesFilename);
        Scanner allGenesScanner = new Scanner(allGenesFile);
        while (allGenesScanner.hasNextLine()) {
            allGenes.add(allGenesScanner.nextLine());
        }
        allGenesScanner.close();
        Scanner fdrScanner = new Scanner(FDRfile);
        fdrScanner.nextLine();
        HashMap<String, String> geneToLine = new HashMap<String, String>();
        while (fdrScanner.hasNextLine()) {
            String line = fdrScanner.nextLine();
            String[] split = line.split("\t", -1);
            geneToLine.put(split[0], line);
        }
        fdrScanner.close();
        LOG.info("read FDR data for {} genes", (Object)geneToLine.size());
        PrintWriter pw = new PrintWriter(outputFDR);
        pw.println("Gene\tAffectedAbs\tCarrierAbs\tAffectedFrac\tCarrierFrac");
        for (String gene : allGenes) {
            if (geneToLine.containsKey(gene)) {
                pw.println((String)geneToLine.get(gene));
                geneToLine.remove(gene);
                continue;
            }
            pw.println(gene + "\t0\t0\t0.0\t0.0");
        }
        if (geneToLine.size() > 0) {
            LOG.info("weird - check all genes but still some left...");
            for (String key : geneToLine.keySet()) {
                pw.println((String)geneToLine.get(key));
                LOG.info("leftover gene: {}", (Object)key);
            }
        }
        pw.flush();
        pw.close();
    }

    public static void main(String[] args) throws Exception {
        String allGenesFilename = args[0];
        String fdrR0_1Filename = args[1];
        String fdrAllGenesFilename = args[2];
        new CombineFDRwithAllGenes(allGenesFilename, fdrR0_1Filename, fdrAllGenesFilename);
    }
}

