/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.util.HandleMissingCaddScores;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;

public class CaddWebserviceOutputAnnotator {
    File vcfToAnnotate;
    File caddWebserviceOutput;
    HandleMissingCaddScores hmcs;
    BufferedWriter outputVCFWriter;

    public CaddWebserviceOutputAnnotator(File vcfToAnnotate, File caddWebserviceOutput, File outputFile) throws Exception {
        if (!vcfToAnnotate.isFile()) {
            throw new FileNotFoundException("VCF file " + vcfToAnnotate.getAbsolutePath() + " does not exist or is directory");
        }
        if (!caddWebserviceOutput.isFile()) {
            throw new FileNotFoundException("CADD webservice output file " + caddWebserviceOutput.getAbsolutePath() + " does not exist or is directory");
        }
        if (outputFile.isFile()) {
            System.out.println("Warning: output file " + outputFile.getAbsolutePath() + " already exists, overwriting content!");
        }
        this.vcfToAnnotate = vcfToAnnotate;
        this.caddWebserviceOutput = caddWebserviceOutput;
        this.hmcs = new HandleMissingCaddScores(HandleMissingCaddScores.Mode.ANALYSIS, caddWebserviceOutput);
        this.outputVCFWriter = new BufferedWriter(new FileWriter(outputFile));
    }

    public void annotate() throws Exception {
        VcfReader vcfReader = GavinUtils.getVcfReader(this.vcfToAnnotate);
        for (VcfRecord aVcfReader : vcfReader) {
            GavinRecord vcfEntity = new GavinRecord(aVcfReader);
            for (int altIndex = 0; altIndex < vcfEntity.getAlts().length; ++altIndex) {
                if (vcfEntity.getCaddPhredScore(altIndex) != null) continue;
                Double cadd = this.hmcs.dealWithCaddScores(vcfEntity, altIndex);
                vcfEntity.setCaddPhredScore(altIndex, cadd);
                System.out.println("setting missing CADD score " + cadd);
            }
        }
        System.out.println("Done!");
    }

    public static void main(String[] args) throws Exception {
        File vcfToAnnotate = new File(args[0]);
        File caddWebserviceOutput = new File(args[1]);
        File outputFile = new File(args[2]);
        CaddWebserviceOutputAnnotator cwoa = new CaddWebserviceOutputAnnotator(vcfToAnnotate, caddWebserviceOutput, outputFile);
        cwoa.annotate();
    }
}

