/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.structs;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.molgenis.cgd.CGDEntry;
import org.molgenis.data.annotation.core.entity.impl.gavin.Judgment;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;

public class Relevance {
    private Judgment judgment;
    private String allele;
    private String gene;
    private String FDR;
    private Map<String, MatchVariantsToGenotypeAndInheritance.Status> sampleStatus;
    private Map<String, String> sampleGenotypes;
    private Set<String> parentsWithReferenceCalls;
    private double alleleFreq;
    private double gonlAlleleFreq;
    private String transcript;
    CGDEntry cgdInfo;

    public Relevance(String allele, @Nullable String transcript, double alleleFreq, double gonlAlleleFreq, String gene, Judgment judgment) {
        this.allele = allele;
        this.transcript = transcript;
        this.alleleFreq = alleleFreq;
        this.gonlAlleleFreq = gonlAlleleFreq;
        this.gene = gene;
        this.judgment = judgment;
    }

    public String getFDR() {
        return this.FDR != null ? this.FDR : "";
    }

    public void setFDR(String FDR2) {
        this.FDR = FDR2;
    }

    public Set<String> getParentsWithReferenceCalls() {
        return this.parentsWithReferenceCalls;
    }

    public void setParentsWithReferenceCalls(Set<String> parentsWithReferenceCalls) {
        this.parentsWithReferenceCalls = parentsWithReferenceCalls;
    }

    public String getAllele() {
        return this.allele;
    }

    public String getGene() {
        return this.gene;
    }

    public double getAlleleFreq() {
        return this.alleleFreq;
    }

    public double getGonlAlleleFreq() {
        return this.gonlAlleleFreq;
    }

    public Optional<String> getTranscript() {
        return this.transcript != null ? Optional.of(this.transcript) : Optional.empty();
    }

    public Judgment getJudgment() {
        return this.judgment;
    }

    public String toStringShort() {
        return "Relevance{in gene " + this.gene + ", judgment:" + this.judgment + '}';
    }

    public String toString() {
        return "Relevance{judgment=" + this.judgment + ", allele='" + this.allele + '\'' + ", gene='" + this.gene + '\'' + ", FDR='" + this.FDR + '\'' + ", sampleStatus=" + this.sampleStatus + ", sampleGenotypes=" + this.sampleGenotypes + ", parentsWithReferenceCalls=" + this.parentsWithReferenceCalls + ", alleleFreq=" + this.alleleFreq + ", gonlAlleleFreq=" + this.gonlAlleleFreq + ", transcript='" + this.transcript + '\'' + ", cgdInfo=" + this.cgdInfo + '}';
    }

    public CGDEntry getCgdInfo() {
        return this.cgdInfo;
    }

    public void setCgdInfo(CGDEntry cgdInfo) {
        this.cgdInfo = cgdInfo;
    }

    public Map<String, MatchVariantsToGenotypeAndInheritance.Status> getSampleStatus() {
        return this.sampleStatus != null ? this.sampleStatus : new HashMap<String, MatchVariantsToGenotypeAndInheritance.Status>();
    }

    public void setSampleStatus(Map<String, MatchVariantsToGenotypeAndInheritance.Status> sampleStatus) {
        this.sampleStatus = sampleStatus;
    }

    public void setSampleGenotypes(Map<String, String> sampleGenotypes) {
        this.sampleGenotypes = sampleGenotypes;
    }

    public Map<String, String> getSampleGenotypes() {
        return this.sampleGenotypes != null ? this.sampleGenotypes : new HashMap<String, String>();
    }
}

