/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.structs;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.RVCF;

public class RVCFUtils {
    public static final String RVCF_SAMPLESEP = "/";
    public static final String EMPTY_VALUE = ".";
    private static final String RVCF_GENEALLELECOMBISEP = ",";
    private static final String RVCF_FIELDSEP = "|";
    private static final String RVCF_KEYVALSEP = ":";
    private static final String VCF_INFOFIELDSEP = ";";

    private RVCFUtils() {
    }

    public static String getMergedFieldVcfString(RVCF rvcf) {
        return RVCFUtils.escapeToSafeVCF(rvcf.getAllele()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getAlleleFreq()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getGene()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getFDR()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getTranscript()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getPhenotype()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getPhenotypeInheritance()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getPhenotypeOnset()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getPhenotypeDetails()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getPhenotypeGroup()) + RVCF_FIELDSEP + RVCFUtils.printSampleStatus(rvcf.getSampleStatus()) + RVCF_FIELDSEP + RVCFUtils.printSampleList(rvcf.getSamplePhenotype()) + RVCF_FIELDSEP + RVCFUtils.printSampleList(rvcf.getSampleGenotype(), true) + RVCF_FIELDSEP + RVCFUtils.printSampleList(rvcf.getSampleGroup()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getVariantSignificance()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getVariantSignificanceSource()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getVariantSignificanceJustification()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getVariantMultiGenic()) + RVCF_FIELDSEP + RVCFUtils.escapeToSafeVCF(rvcf.getVariantGroup());
    }

    public static Map<String, String> createRvcfValues(RVCF rvcf, Map<String, String> currentValues) {
        String prefix = "[" + rvcf.getAllele() + RVCF_FIELDSEP + rvcf.getGene() + "]";
        HashMap<String, String> infoFields = new HashMap<String, String>();
        RVCFUtils.addOrUpdateInfoField("RLV_PRESENT", "TRUE", prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_ALLELE", rvcf.getAllele(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_ALLELEFREQ", rvcf.getAlleleFreq(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_GENE", rvcf.getGene(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_FDR", rvcf.getFDR(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_TRANSCRIPT", rvcf.getTranscript(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_PHENOTYPE", rvcf.getPhenotype(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_PHENOTYPEINHERITANCE", rvcf.getPhenotypeInheritance(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_PHENOTYPEONSET", rvcf.getPhenotypeOnset(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_PHENOTYPEDETAILS", rvcf.getPhenotypeDetails(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_PHENOTYPEGROUP", rvcf.getPhenotypeGroup(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_SAMPLESTATUS", RVCFUtils.printSampleStatus(rvcf.getSampleStatus()), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_SAMPLEPHENOTYPE", RVCFUtils.printSampleList(rvcf.getSamplePhenotype()), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_SAMPLEGENOTYPE", RVCFUtils.printSampleList(rvcf.getSampleGenotype()), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_SAMPLEGROUP", RVCFUtils.printSampleList(rvcf.getSampleGroup()), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_VARIANTSIGNIFICANCE", rvcf.getVariantSignificance(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_VARIANTSIGNIFICANCESOURCE", rvcf.getVariantSignificanceSource(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_VARIANTSIGNIFICANCEJUSTIFICATION", rvcf.getVariantSignificanceJustification(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_VARIANTMULTIGENIC", rvcf.getVariantMultiGenic(), prefix, currentValues, infoFields);
        RVCFUtils.addOrUpdateInfoField("RLV_VARIANTGROUP", rvcf.getVariantGroup(), prefix, currentValues, infoFields);
        return infoFields;
    }

    public static String escapeToSafeVCF(String in) {
        return in.replace(VCF_INFOFIELDSEP, "_").replace(RVCF_FIELDSEP, "_").replace(RVCF_SAMPLESEP, "_").replace(RVCF_GENEALLELECOMBISEP, "_").replaceAll("\\s", "_");
    }

    private static void addOrUpdateInfoField(String key, String value, String prefix, Map<String, String> currentValues, Map<String, String> infoFields) {
        infoFields.put(key, RVCFUtils.createInfoField(value, prefix, currentValues.get(key)));
    }

    private static String createInfoField(String value, String prefix, String currentInfoValue) {
        String newInfoValue = "";
        if (Strings.isNullOrEmpty(currentInfoValue)) {
            newInfoValue = Strings.isNullOrEmpty(value) ? prefix + EMPTY_VALUE : prefix + RVCFUtils.escapeToSafeVCF(value);
        } else {
            if (Strings.isNullOrEmpty(value)) {
                value = EMPTY_VALUE;
            }
            newInfoValue = currentInfoValue + RVCF_GENEALLELECOMBISEP + prefix + RVCFUtils.escapeToSafeVCF(value);
        }
        return newInfoValue;
    }

    private static String printSampleStatus(Map<String, MatchVariantsToGenotypeAndInheritance.Status> samples) {
        HashMap<String, String> samplesString = new HashMap<String, String>();
        for (Map.Entry<String, MatchVariantsToGenotypeAndInheritance.Status> sample : samples.entrySet()) {
            samplesString.put(sample.getKey(), sample.getValue().toString());
        }
        return RVCFUtils.printSampleList(samplesString);
    }

    private static String escapeGenotype(String s) {
        return s.replace(RVCF_SAMPLESEP, "s").replace(RVCF_FIELDSEP, "p");
    }

    public static String unEscapeGenotype(String s) {
        return s.replace("s", RVCF_SAMPLESEP).replace("p", RVCF_FIELDSEP);
    }

    private static String printSampleList(Map<String, String> samples) {
        return RVCFUtils.printSampleList(samples, false);
    }

    private static String printSampleList(Map<String, String> samples, boolean genotypes) {
        if (samples.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> sample : samples.entrySet()) {
            sb.append(RVCFUtils.escapeToSafeVCF(sample.getKey())).append(RVCF_KEYVALSEP).append(genotypes ? RVCFUtils.escapeGenotype(sample.getValue()) : RVCFUtils.escapeToSafeVCF(sample.getValue())).append(RVCF_SAMPLESEP);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

