/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.positionalstream;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.StringUtils;
import org.molgenis.cgd.CGDEntry;
import org.molgenis.cgd.LoadCGD;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.GenoMatchSamples;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.molgenis.data.annotation.makervcf.structs.RelevanceUtils;
import org.molgenis.data.vcf.datastructures.Sample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchVariantsToGenotypeAndInheritance {
    private static final Logger LOG = LoggerFactory.getLogger(MatchVariantsToGenotypeAndInheritance.class);
    Iterator<GavinRecord> gavinRecords;
    Map<String, CGDEntry> cgd;
    int minDepth;
    private Set<String> parents;

    public MatchVariantsToGenotypeAndInheritance(Iterator<GavinRecord> gavinRecords, File cgdFile, Set<String> parents) throws IOException {
        this.gavinRecords = gavinRecords;
        this.cgd = LoadCGD.loadCGD(cgdFile);
        this.minDepth = 1;
        this.parents = parents;
    }

    public Iterator<GavinRecord> go() {
        return new Iterator<GavinRecord>(){

            @Override
            public boolean hasNext() {
                return MatchVariantsToGenotypeAndInheritance.this.gavinRecords.hasNext();
            }

            @Override
            public GavinRecord next() {
                GavinRecord gavinRecord = MatchVariantsToGenotypeAndInheritance.this.gavinRecords.next();
                if (gavinRecord.isRelevant()) {
                    MultiKeyMap fullGenoMatch;
                    try {
                        fullGenoMatch = MatchVariantsToGenotypeAndInheritance.this.findMatchingSamples(gavinRecord);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    for (Relevance rlv : gavinRecord.getRelevance()) {
                        String gene = rlv.getGene();
                        CGDEntry ce = MatchVariantsToGenotypeAndInheritance.this.cgd.get(gene);
                        rlv.setCgdInfo(ce);
                        Status actingTerminology = Status.HOMOZYGOUS;
                        Status nonActingTerminology = Status.HETEROZYGOUS;
                        if (MatchVariantsToGenotypeAndInheritance.this.cgd.containsKey(gene) && CGDEntry.generalizedInheritance.hasKnownInheritance(MatchVariantsToGenotypeAndInheritance.this.cgd.get(gene).getGeneralizedInheritance())) {
                            actingTerminology = Status.AFFECTED;
                            nonActingTerminology = Status.CARRIER;
                        }
                        HashMap<String, Status> sampleStatus = new HashMap<String, Status>();
                        HashMap<String, String> sampleGenotypes = new HashMap<String, String>();
                        GenoMatchSamples genoMatch = (GenoMatchSamples)fullGenoMatch.get(rlv.getGene(), rlv.getAllele());
                        if (genoMatch == null) continue;
                        for (String key : genoMatch.affected.keySet()) {
                            sampleStatus.put(key, actingTerminology);
                            sampleGenotypes.put(key, genoMatch.affected.get(key).getGenotype().get());
                        }
                        for (String key : genoMatch.carriers.keySet()) {
                            sampleStatus.put(key, nonActingTerminology);
                            sampleGenotypes.put(key, genoMatch.carriers.get(key).getGenotype().get());
                        }
                        if (sampleStatus.isEmpty()) continue;
                        rlv.setSampleStatus(sampleStatus);
                        rlv.setSampleGenotypes(sampleGenotypes);
                        rlv.setParentsWithReferenceCalls(genoMatch.parentsWithReferenceCalls);
                        String parentsWithReferenceCalls = genoMatch.parentsWithReferenceCalls.toString();
                        LOG.debug("[MatchVariantsToGenotypeAndInheritance] Assigned sample Status: {}, having genotypes: {}, plus trio parents with reference alleles: {}", sampleStatus, sampleGenotypes, parentsWithReferenceCalls);
                    }
                }
                return gavinRecord;
            }
        };
    }

    public MultiKeyMap findMatchingSamples(GavinRecord record) {
        Set<String> alts = RelevanceUtils.getRelevantAlts(record.getRelevance());
        Set<String> genes = RelevanceUtils.getRelevantGenes(record.getRelevance());
        MultiKeyMap result = new MultiKeyMap();
        HashSet<String> parentsWithReferenceCalls = new HashSet<String>();
        Iterator samples = record.getSamples().iterator();
        int sampleIndex = -1;
        while (samples.hasNext()) {
            Sample sample = (Sample)samples.next();
            if (!sample.getGenotype().isPresent()) continue;
            String genotype = sample.getGenotype().get();
            String sampleName = sample.getId();
            if (sample.getDepth().isPresent() && sample.getDepth().get() < (double)this.minDepth || genotype.equals("./.") || genotype.equals(".|.") || genotype.equals(".")) continue;
            if (genotype.equals("0/0") || genotype.equals("0|0") || genotype.equals("0")) {
                if (!this.parents.contains(sampleName)) continue;
                parentsWithReferenceCalls.add(sampleName);
                continue;
            }
            for (String alt : alts) {
                int altIndex = record.getAltAlleleIndex(alt);
                for (String gene : genes) {
                    GenoMatchSamples match;
                    CGDEntry.generalizedInheritance inheritance;
                    HashMap<String, Sample> carriers = new HashMap<String, Sample>();
                    HashMap<String, Sample> affected = new HashMap<String, Sample>();
                    CGDEntry ce = this.cgd.get(gene);
                    CGDEntry.generalizedInheritance generalizedInheritance2 = inheritance = ce != null ? ce.getGeneralizedInheritance() : CGDEntry.generalizedInheritance.NOTINCGD;
                    if (inheritance.equals((Object)CGDEntry.generalizedInheritance.DOMINANT_OR_RECESSIVE) || inheritance.equals((Object)CGDEntry.generalizedInheritance.DOMINANT)) {
                        if (genotype.contains(altIndex + "")) {
                            affected.put(sampleName, sample);
                        }
                    } else if (inheritance.equals((Object)CGDEntry.generalizedInheritance.RECESSIVE) || inheritance.equals((Object)CGDEntry.generalizedInheritance.X_LINKED) || inheritance.equals((Object)CGDEntry.generalizedInheritance.OTHER) || inheritance.equals((Object)CGDEntry.generalizedInheritance.NOTINCGD) || inheritance.equals((Object)CGDEntry.generalizedInheritance.BLOODGROUP)) {
                        boolean heterozygous;
                        boolean homozygous = genotype.equals(altIndex + "/" + altIndex) || genotype.equals(altIndex + "|" + altIndex);
                        boolean hemizygous = genotype.equals(altIndex + "");
                        boolean bl = heterozygous = genotype.length() == 3 && StringUtils.countMatches(genotype, altIndex + "") == 1;
                        if (homozygous) {
                            affected.put(sampleName, sample);
                        } else if (hemizygous) {
                            affected.put(sampleName, sample);
                        } else if (heterozygous) {
                            carriers.put(sampleName, sample);
                        }
                    } else {
                        throw new RuntimeException("inheritance unknown: " + (Object)((Object)inheritance));
                    }
                    if (result.containsKey(gene, alt)) {
                        match = (GenoMatchSamples)result.get(gene, alt);
                        match.carriers.putAll(carriers);
                        match.affected.putAll(affected);
                        continue;
                    }
                    match = new GenoMatchSamples(carriers, affected);
                    result.put(gene, alt, match);
                }
            }
        }
        for (String alt : alts) {
            for (String gene : genes) {
                if (result.get(gene, alt) == null) continue;
                ((GenoMatchSamples)result.get(gene, alt)).setParentsWithReferenceCalls(parentsWithReferenceCalls);
            }
        }
        return result;
    }

    public static enum Status {
        HETEROZYGOUS,
        HOMOZYGOUS,
        AFFECTED,
        CARRIER,
        BLOODGROUP,
        HOMOZYGOUS_COMPOUNDHET,
        AFFECTED_COMPOUNDHET,
        HETEROZYGOUS_MULTIHIT;


        public static boolean isCompound(Status status) {
            return status == HOMOZYGOUS_COMPOUNDHET || status == AFFECTED_COMPOUNDHET;
        }

        public static boolean isPresumedCarrier(Status status) {
            return status == HETEROZYGOUS || status == HETEROZYGOUS_MULTIHIT || status == CARRIER;
        }

        public static boolean isPresumedAffected(Status status) {
            return status == HOMOZYGOUS || status == HOMOZYGOUS_COMPOUNDHET || status == AFFECTED || status == AFFECTED_COMPOUNDHET;
        }

        public static boolean isHomozygous(String genotype) throws Exception {
            if (genotype.length() == 1) {
                return true;
            }
            if (genotype.length() != 3) {
                throw new Exception("Genotype '" + genotype + "' not length 3");
            }
            return genotype.charAt(0) == genotype.charAt(2);
        }
    }
}

