/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.positionalstream;

import java.util.Collections;
import java.util.Iterator;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAFFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MAFFilter.class);
    private Iterator<GavinRecord> relevantVariants;
    private final boolean keepAllVariants;
    double threshold = 0.05;

    public MAFFilter(Iterator<GavinRecord> relevantVariants, boolean keepAllVariants) {
        this.relevantVariants = relevantVariants;
        this.keepAllVariants = keepAllVariants;
    }

    public Iterator<GavinRecord> go() {
        return new Iterator<GavinRecord>(){
            GavinRecord nextResult;

            @Override
            public boolean hasNext() {
                while (MAFFilter.this.relevantVariants.hasNext()) {
                    GavinRecord gavinRecord = (GavinRecord)MAFFilter.this.relevantVariants.next();
                    if (gavinRecord.isRelevant()) {
                        for (Relevance rlv : gavinRecord.getRelevance()) {
                            if (rlv.getGonlAlleleFreq() < MAFFilter.this.threshold && rlv.getAlleleFreq() < MAFFilter.this.threshold) {
                                this.nextResult = gavinRecord;
                                return true;
                            }
                            LOG.debug("[MAFFilter] Removing relevance for variant at {}:{} because it has AF >{}. ExAC: {}, GoNL: {}", gavinRecord.getChromosome(), gavinRecord.getPosition(), MAFFilter.this.threshold, rlv.getAlleleFreq(), rlv.getGonlAlleleFreq());
                            if (!MAFFilter.this.keepAllVariants) continue;
                            gavinRecord.setRelevances(Collections.emptyList());
                            return true;
                        }
                        continue;
                    }
                    if (!MAFFilter.this.keepAllVariants) continue;
                    this.nextResult = gavinRecord;
                    return true;
                }
                return false;
            }

            @Override
            public GavinRecord next() {
                return this.nextResult;
            }
        };
    }
}

