/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.positionalstream;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.core.entity.impl.gavin.Judgment;
import org.molgenis.data.annotation.core.entity.impl.snpeff.Impact;
import org.molgenis.data.annotation.entity.impl.gavin.GavinAlgorithm;
import org.molgenis.data.annotation.makervcf.structs.GavinCalibrations;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.molgenis.data.annotation.makervcf.util.HandleMissingCaddScores;
import org.molgenis.data.annotation.makervcf.util.LabVariants;
import org.molgenis.data.annotation.makervcf.util.ReportedPathogenic;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverRelevantVariants {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoverRelevantVariants.class);
    private VcfReader vcf;
    private LabVariants lab;
    private GavinCalibrations gavinCalibrations;
    private GavinAlgorithm gavin;
    private HandleMissingCaddScores hmcs;
    private ReportedPathogenic repPatho;
    private boolean keepAllVariants;

    public DiscoverRelevantVariants(File vcfFile, File gavinFile, File repPathoFile, File caddFile, File labVariants, HandleMissingCaddScores.Mode mode, boolean keepAllVariants) throws Exception {
        this.vcf = GavinUtils.getVcfReader(vcfFile);
        this.repPatho = new ReportedPathogenic(repPathoFile);
        this.keepAllVariants = keepAllVariants;
        if (labVariants != null) {
            this.lab = new LabVariants(labVariants);
        }
        this.gavin = new GavinAlgorithm();
        this.gavinCalibrations = GavinUtils.getGeneToEntry(gavinFile);
        this.hmcs = new HandleMissingCaddScores(mode, caddFile);
    }

    public Iterator<GavinRecord> findRelevantVariants() {
        final Iterator<VcfRecord> vcfIterator = this.vcf.iterator();
        return new Iterator<GavinRecord>(){
            GavinRecord nextResult;
            int pos = -1;
            int previousPos = -1;
            String chrom;
            String previousChrom = null;
            String chrPosRefAlt;
            String previouschrPosRefAlt = null;
            Set<String> chromosomesSeenBefore = new HashSet<String>();

            @Override
            public boolean hasNext() {
                while (vcfIterator.hasNext()) {
                    GavinRecord gavinRecord = new GavinRecord((VcfRecord)vcfIterator.next());
                    this.pos = gavinRecord.getPosition();
                    this.chrom = gavinRecord.getChromosome();
                    this.chrPosRefAlt = gavinRecord.getChrPosRefAlt();
                    if (this.previousPos != -1 && this.previousChrom != null && this.pos < this.previousPos && this.previousChrom.equals(this.chrom)) {
                        throw new RuntimeException("Site position " + this.pos + " before " + this.previousPos + " on the same chromosome (" + this.chrom + ") not allowed. Please sort your VCF file.");
                    }
                    if (this.previouschrPosRefAlt != null && this.previouschrPosRefAlt.equals(this.chrPosRefAlt)) {
                        throw new RuntimeException("Chrom-pos-ref-alt combination seen twice: " + this.chrPosRefAlt + ". This is not allowed. Please check your VCF file.");
                    }
                    if (this.previousChrom != null && !this.previousChrom.equals(this.chrom)) {
                        this.chromosomesSeenBefore.add(this.previousChrom);
                    }
                    if (this.chromosomesSeenBefore.contains(this.chrom)) {
                        throw new RuntimeException("Chromosome " + this.chrom + " was interrupted by other chromosomes. Please sort your VCF file.");
                    }
                    this.previousPos = this.pos;
                    this.previousChrom = this.chrom;
                    this.previouschrPosRefAlt = this.chrPosRefAlt;
                    ArrayList<Relevance> relevance = new ArrayList<Relevance>();
                    for (int i = 0; i < gavinRecord.getAlts().length; ++i) {
                        Double cadd;
                        try {
                            cadd = DiscoverRelevantVariants.this.hmcs.dealWithCaddScores(gavinRecord, i);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        if (gavinRecord.getChromosome().equals("MT") || gavinRecord.getChromosome().equals("M") || gavinRecord.getChromosome().equals("mtDNA")) {
                            Judgment repPathoJudgment;
                            Judgment labJudgment;
                            Judgment judgment = null;
                            try {
                                labJudgment = DiscoverRelevantVariants.this.lab != null ? DiscoverRelevantVariants.this.lab.classifyVariant(gavinRecord, gavinRecord.getAlt(i), "MT") : null;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            try {
                                repPathoJudgment = DiscoverRelevantVariants.this.repPatho.classifyVariant(gavinRecord, gavinRecord.getAlt(i), "MT");
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (labJudgment != null && labJudgment.getClassification() == Judgment.Classification.Pathogenic) {
                                judgment = labJudgment;
                            } else if (repPathoJudgment != null && repPathoJudgment.getClassification() == Judgment.Classification.Pathogenic) {
                                judgment = repPathoJudgment;
                            }
                            if (judgment == null || !judgment.getClassification().equals((Object)Judgment.Classification.Pathogenic)) continue;
                            gavinRecord.setGenes(judgment.getGene());
                            relevance.add(new Relevance(gavinRecord.getAlt(i), repPathoJudgment.getGene(), gavinRecord.getExAcAlleleFrequencies(i), gavinRecord.getGoNlAlleleFrequencies(i), repPathoJudgment.getGene(), repPathoJudgment));
                            continue;
                        }
                        if (gavinRecord.getGenes().isEmpty()) {
                            LOG.debug("[DiscoverRelevantVariants] WARNING: no genes for variant {}", (Object)gavinRecord.toStringShort());
                        }
                        for (String gene : gavinRecord.getGenes()) {
                            Judgment repPathoJudgment;
                            Judgment labJudgment;
                            Optional<Impact> impact = gavinRecord.getImpact(i, gene);
                            Optional<String> transcript = gavinRecord.getTranscript(i, gene);
                            Judgment judgment = null;
                            try {
                                labJudgment = DiscoverRelevantVariants.this.lab != null ? DiscoverRelevantVariants.this.lab.classifyVariant(gavinRecord, gavinRecord.getAlt(i), gene) : null;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            try {
                                repPathoJudgment = DiscoverRelevantVariants.this.repPatho.classifyVariant(gavinRecord, gavinRecord.getAlt(i), gene);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            Judgment gavinJudgment = DiscoverRelevantVariants.this.gavin.classifyVariant(impact.orElse(null), cadd, gavinRecord.getExAcAlleleFrequencies(i), gene, DiscoverRelevantVariants.this.gavinCalibrations);
                            if (labJudgment != null && labJudgment.getClassification() == Judgment.Classification.Pathogenic) {
                                judgment = labJudgment;
                            } else if (repPathoJudgment != null && repPathoJudgment.getClassification() == Judgment.Classification.Pathogenic) {
                                judgment = repPathoJudgment;
                            } else if (gavinJudgment != null && gavinJudgment.getClassification() == Judgment.Classification.Pathogenic) {
                                judgment = gavinJudgment.setSource("GAVIN").setType("Predicted pathogenic");
                            }
                            if (judgment == null || judgment.getClassification() != Judgment.Classification.Pathogenic) continue;
                            relevance.add(new Relevance(gavinRecord.getAlt(i), transcript.orElse(null), gavinRecord.getExAcAlleleFrequencies(i), gavinRecord.getGoNlAlleleFrequencies(i), gene, judgment));
                        }
                    }
                    if (!relevance.isEmpty()) {
                        gavinRecord.setRelevances(relevance);
                        this.nextResult = gavinRecord;
                        LOG.debug("[DiscoverRelevantVariants] Found relevant variant: {}", (Object)this.nextResult.toStringShort());
                        return true;
                    }
                    if (!DiscoverRelevantVariants.this.keepAllVariants) continue;
                    this.nextResult = gavinRecord;
                    return true;
                }
                return false;
            }

            @Override
            public GavinRecord next() {
                return this.nextResult;
            }
        };
    }
}

