/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.positionalstream;

import java.util.Collections;
import java.util.Iterator;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupVariantsWithoutSamples {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupVariantsWithoutSamples.class);
    private Iterator<GavinRecord> gavinRecordIterator;
    private boolean keepAllVariants;

    public CleanupVariantsWithoutSamples(Iterator<GavinRecord> gavinRecordIterator, boolean keepAllVariants) {
        this.gavinRecordIterator = gavinRecordIterator;
        this.keepAllVariants = keepAllVariants;
    }

    public Iterator<GavinRecord> go() {
        return new Iterator<GavinRecord>(){
            GavinRecord nextResult;

            @Override
            public boolean hasNext() {
                try {
                    while (CleanupVariantsWithoutSamples.this.gavinRecordIterator.hasNext()) {
                        GavinRecord gavinRecord = (GavinRecord)CleanupVariantsWithoutSamples.this.gavinRecordIterator.next();
                        if (gavinRecord.isRelevant()) {
                            LOG.debug("[CleanupVariantsWithoutSamples] Looking at: {}", (Object)gavinRecord);
                            for (Relevance rlv : gavinRecord.getRelevance()) {
                                if (rlv.getSampleStatus().size() != rlv.getSampleGenotypes().size()) {
                                    throw new Exception("[CleanupVariantsWithoutSamples] rv.getSampleStatus().size() != rv.getSampleGenotypes().size()");
                                }
                                if (rlv.getSampleStatus().size() > 0) {
                                    this.nextResult = gavinRecord;
                                    return true;
                                }
                                if (CleanupVariantsWithoutSamples.this.keepAllVariants) {
                                    gavinRecord.setRelevances(Collections.emptyList());
                                    this.nextResult = gavinRecord;
                                    return true;
                                }
                                LOG.debug("[CleanupVariantsWithoutSamples] Removing variant at {}:{} because it has 0 samples left", (Object)gavinRecord.getChromosome(), (Object)gavinRecord.getPosition());
                            }
                            continue;
                        }
                        this.nextResult = gavinRecord;
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public GavinRecord next() {
                return this.nextResult;
            }
        };
    }
}

