/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import joptsimple.internal.Strings;
import org.molgenis.data.annotation.makervcf.RlvInfoMapper;
import org.molgenis.data.annotation.makervcf.VcfRecordMapperSettings;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfRecord;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VcfRecordMapper {
    private static final Logger LOG = LoggerFactory.getLogger(VcfRecordMapper.class);
    private static final String MISSING_VALUE = ".";
    private final VcfMeta vcfMeta;
    private final VcfRecordMapperSettings vcfRecordMapperSettings;
    private final RlvInfoMapper rlvInfoMapper;

    VcfRecordMapper(VcfMeta vcfMeta, VcfRecordMapperSettings vcfRecordMapperSettings) {
        this.vcfMeta = Objects.requireNonNull(vcfMeta);
        this.vcfRecordMapperSettings = Objects.requireNonNull(vcfRecordMapperSettings);
        this.rlvInfoMapper = new RlvInfoMapper();
    }

    public VcfRecord map(GavinRecord gavinRecord) {
        List<String> tokens = this.createTokens(gavinRecord);
        return new VcfRecord(this.vcfMeta, tokens.toArray(new String[0]));
    }

    private List<String> createTokens(GavinRecord gavinRecord) {
        AnnotatedVcfRecord annotatedVcfRecord;
        Iterable<VcfSample> vcfSamples;
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(gavinRecord.getChromosome());
        tokens.add(String.valueOf(gavinRecord.getPosition()));
        List<String> identifiers = gavinRecord.getIdentifiers();
        tokens.add(!identifiers.isEmpty() ? identifiers.stream().collect(Collectors.joining(";")) : MISSING_VALUE);
        tokens.add(gavinRecord.getRef());
        String[] altTokens = gavinRecord.getAlts();
        if (altTokens.length == 0) {
            tokens.add(MISSING_VALUE);
        } else {
            tokens.add(Arrays.stream(altTokens).collect(Collectors.joining(",")));
        }
        tokens.add(gavinRecord.getQuality().map(Object::toString).orElse(MISSING_VALUE));
        List<String> filterStatus = gavinRecord.getFilterStatus();
        tokens.add(!filterStatus.isEmpty() ? filterStatus.stream().collect(Collectors.joining(";")) : MISSING_VALUE);
        tokens.add(this.createInfoToken(gavinRecord, this.vcfRecordMapperSettings.splitRlvField()));
        if (this.vcfRecordMapperSettings.includeSamples() && (vcfSamples = (annotatedVcfRecord = gavinRecord.getAnnotatedVcfRecord()).getSamples()).iterator().hasNext()) {
            tokens.add(this.createFormatToken(annotatedVcfRecord));
            tokens.addAll(Arrays.asList(annotatedVcfRecord.getSampleTokens()));
        }
        return tokens;
    }

    private String createInfoToken(GavinRecord gavinRecord, boolean splitRlvField) {
        Iterable<VcfInfo> vcfInformations = gavinRecord.getAnnotatedVcfRecord().getInformation();
        boolean hasInformation = vcfInformations.iterator().hasNext();
        StringBuilder stringBuilder = new StringBuilder();
        if (hasInformation) {
            List<String> caddScoresList;
            stringBuilder.append(StreamSupport.stream(vcfInformations.spliterator(), false).filter(vcfInfo -> !vcfInfo.getKey().equals("CADD_SCALED")).map(this::createInfoTokenPart).collect(Collectors.joining(";")));
            Double[] caddScores = gavinRecord.getCaddPhredScores();
            if (caddScores != null && caddScores.length > 0 && !(caddScoresList = Arrays.stream(caddScores).map(this::caddToString).collect(Collectors.toList())).isEmpty()) {
                stringBuilder.append(";").append(this.createInfoTokenPart("CADD_SCALED", Strings.join(caddScoresList, ",")));
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(';');
        }
        if (!gavinRecord.getRelevance().isEmpty()) {
            stringBuilder.append(this.getRlv(gavinRecord, splitRlvField));
        } else {
            stringBuilder.append(this.createInfoTokenPart("RLV_PRESENT", "FALSE"));
        }
        return stringBuilder.toString();
    }

    private String caddToString(Double score) {
        String stringValue = score != null ? Double.toString(score) : MISSING_VALUE;
        return stringValue;
    }

    private String createInfoTokenPart(VcfInfo vcfInfo) {
        return this.createInfoTokenPart(vcfInfo.getKey(), vcfInfo.getValRaw());
    }

    private String createInfoTokenPart(String key, String value) {
        return key + '=' + value;
    }

    private String createFormatToken(AnnotatedVcfRecord vcfEntity) {
        String[] formatTokens = vcfEntity.getFormat();
        return Arrays.stream(formatTokens).collect(Collectors.joining(":"));
    }

    private String createSampleToken(VcfSample vcfSample) {
        String[] sampleTokens = vcfSample.getTokens();
        return Arrays.stream(sampleTokens).collect(Collectors.joining(":"));
    }

    private String getRlv(GavinRecord gavinRecord, boolean splitRlvField) {
        LOG.debug("[MakeRVCFforClinicalVariants] Looking at: {}", (Object)gavinRecord);
        List<Relevance> relevance = gavinRecord.getRelevance();
        String rlv = this.rlvInfoMapper.map(relevance, splitRlvField);
        LOG.debug("[MakeRVCFforClinicalVariants] Converted relevant variant to a VCF INFO field for writing out: {}", (Object)rlv);
        return rlv;
    }
}

