/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.entity.impl.gavin;

import java.util.Map;
import javax.annotation.Nullable;
import org.molgenis.data.annotation.core.entity.impl.gavin.Judgment;
import org.molgenis.data.annotation.core.entity.impl.snpeff.Impact;
import org.molgenis.data.annotation.entity.impl.gavin.GavinEntry;
import org.molgenis.data.annotation.makervcf.structs.GavinCalibrations;

public class GavinAlgorithm {
    public static final int extraSensitivityFactor = 5;

    public Judgment classifyVariant(Impact impact, Double caddScaled, Double exacMAF, String gene, GavinCalibrations gavinCalibrations) {
        Map<String, GavinEntry> geneToEntry = gavinCalibrations.getGavinEntries();
        if (!geneToEntry.containsKey(gene)) {
            return this.genomewideClassifyVariant(impact, caddScaled, exacMAF, gene, gavinCalibrations);
        }
        Double pathoMAFThreshold = geneToEntry.get(gene).getPathoMAFThreshold() != null ? Double.valueOf(geneToEntry.get(gene).getPathoMAFThreshold() * 5.0 * 2.0) : null;
        Double meanPathogenicCADDScore = geneToEntry.get(gene).getMeanPathogenicCADDScore() != null ? Double.valueOf(geneToEntry.get(gene).getMeanPathogenicCADDScore() - 5.0) : null;
        Double meanPopulationCADDScore = geneToEntry.get(gene).getMeanPopulationCADDScore() != null ? Double.valueOf(geneToEntry.get(gene).getMeanPopulationCADDScore() - 5.0) : null;
        Double spec95thPerCADDThreshold = geneToEntry.get(gene).getSpec95thPerCADDThreshold() != null ? Double.valueOf(geneToEntry.get(gene).getSpec95thPerCADDThreshold() - 5.0) : null;
        Double sens95thPerCADDThreshold = geneToEntry.get(gene).getSens95thPerCADDThreshold() != null ? Double.valueOf(geneToEntry.get(gene).getSens95thPerCADDThreshold() - 5.0) : null;
        GavinEntry.Category category = geneToEntry.get(gene).getCategory();
        if (caddScaled != null) {
            switch (category) {
                case C1: 
                case C2: {
                    if (caddScaled > meanPathogenicCADDScore) {
                        return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is greater than " + meanPathogenicCADDScore + " in a gene for which CADD scores are informative.", null, null);
                    }
                    if (!(caddScaled < meanPopulationCADDScore)) break;
                    return new Judgment(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is less than " + meanPopulationCADDScore + " in a gene for which CADD scores are informative.", null, null);
                }
                case C3: 
                case C4: 
                case C5: {
                    if (caddScaled > spec95thPerCADDThreshold) {
                        return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is greater than " + spec95thPerCADDThreshold + " for this gene.", null, null);
                    }
                    if (!(caddScaled < sens95thPerCADDThreshold)) break;
                    return new Judgment(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is less than " + sens95thPerCADDThreshold + " for this gene.", null, null);
                }
            }
        }
        if (pathoMAFThreshold != null && exacMAF > pathoMAFThreshold) {
            return new Judgment(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant MAF of " + exacMAF + " is greater than " + pathoMAFThreshold + ".", null, null);
        }
        String mafReason = "the variant MAF of " + exacMAF + " is less than a MAF of " + pathoMAFThreshold + ".";
        if (impact != null) {
            if (category == GavinEntry.Category.I1 && impact == Impact.HIGH) {
                return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant is of high impact, while there are no known high impact variants in the population. Also, " + mafReason, null, null);
            }
            if (category == GavinEntry.Category.I2 && (impact == Impact.MODERATE || impact == Impact.HIGH)) {
                return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant is of high/moderate impact, while there are no known high/moderate impact variants in the population. Also, " + mafReason, null, null);
            }
            if (category == GavinEntry.Category.I3 && (impact == Impact.LOW || impact == Impact.MODERATE || impact == Impact.HIGH)) {
                return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant is of high/moderate/low impact, while there are no known high/moderate/low impact variants in the population. Also, " + mafReason, null, null);
            }
            if (impact == Impact.MODIFIER) {
                return new Judgment(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant is of 'modifier' impact, and therefore unlikely to be pathogenic. However, " + mafReason, null, null);
            }
        }
        return this.genomewideClassifyVariant(impact, caddScaled, exacMAF, gene, gavinCalibrations);
    }

    public Judgment genomewideClassifyVariant(@Nullable Impact impact, Double caddScaled, Double exacMAF, String gene, GavinCalibrations gavinCalibrations) {
        exacMAF = exacMAF != null ? exacMAF : 0.0;
        double caddThreshold = gavinCalibrations.getGenomewideCaddThreshold();
        double mafThreshold = gavinCalibrations.getGenomewideMafThreshold();
        if (exacMAF > mafThreshold) {
            return new Judgment(Judgment.Classification.Benign, Judgment.Method.genomewide, gene, "Variant MAF of " + exacMAF + " is not rare enough to generally be considered pathogenic.", null, null);
        }
        if (impact != null && impact == Impact.MODIFIER) {
            return new Judgment(Judgment.Classification.Benign, Judgment.Method.genomewide, gene, "Variant is of 'modifier' impact, and therefore unlikely to be pathogenic.", null, null);
        }
        if (caddScaled != null && caddScaled > caddThreshold) {
            return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.genomewide, gene, "Variant MAF of " + exacMAF + " is rare enough to be potentially pathogenic and its CADD score of " + caddScaled + " is greater than a global threshold of " + caddThreshold + ".", null, null);
        }
        if (caddScaled != null && caddScaled <= caddThreshold) {
            return new Judgment(Judgment.Classification.Benign, Judgment.Method.genomewide, gene, "Variant CADD score of " + caddScaled + " is less than a global threshold of " + caddThreshold + ", although the variant MAF of " + exacMAF + " is rare enough to be potentially pathogenic.", null, null);
        }
        return new Judgment(Judgment.Classification.VOUS, Judgment.Method.genomewide, gene, "Unable to classify variant as benign or pathogenic. The combination of " + (Object)((Object)impact) + " impact, a CADD score of " + caddScaled + " and MAF of " + exacMAF + " in " + gene + " is inconclusive.", null, null);
    }
}

