/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.samtools.util.SortingCollection;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFEncoder;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

public class VCFRecordCodec
implements SortingCollection.Codec<VariantContext> {
    final VCFCodec vcfDecoder = new VCFCodec();
    final VCFEncoder vcfEncoder;
    private PrintStream outputStream = null;
    private BufferedReader inputReader = null;

    public VCFRecordCodec(VCFHeader vCFHeader) {
        this.vcfEncoder = new VCFEncoder(vCFHeader, false);
        this.vcfDecoder.setVCFHeader(vCFHeader, VCFHeaderVersion.VCF4_1);
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = new PrintStream(outputStream);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    @Override
    public void encode(VariantContext variantContext) {
        this.outputStream.println(this.vcfEncoder.encode(variantContext));
    }

    @Override
    public VariantContext decode() {
        try {
            String string = this.inputReader.readLine();
            return string != null ? this.vcfDecoder.decode(string) : null;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not decode/read a VCF record for a sorting collection: " + iOException.getMessage(), iOException);
        }
    }

    public VCFRecordCodec clone() {
        return new VCFRecordCodec(this.vcfEncoder.getVCFHeader());
    }
}

