/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.IndexingVariantContextWriter;
import org.broadinstitute.variant.vcf.VCFEncoder;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

class VCFWriter
extends IndexingVariantContextWriter {
    private static final String VERSION_LINE = "##" + VCFHeaderVersion.VCF4_1.getFormatString() + "=" + VCFHeaderVersion.VCF4_1.getVersionString();
    private VCFEncoder vcfEncoder = null;
    protected VCFHeader mHeader = null;
    private final boolean allowMissingFieldsInHeader;
    private final boolean doNotWriteGenotypes;
    private static final int INITIAL_BUFFER_SIZE = 16384;
    private final ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(16384);
    private final Writer writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.lineBuffer, VCFEncoder.VCF_CHARSET));

    public VCFWriter(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, boolean bl, boolean bl2, boolean bl3) {
        super(VCFWriter.writerName(file, outputStream), file, outputStream, sAMSequenceDictionary, bl);
        this.doNotWriteGenotypes = bl2;
        this.allowMissingFieldsInHeader = bl3;
    }

    private void write(String string) throws IOException {
        this.writer.write(string);
    }

    private void writeAndResetBuffer() throws IOException {
        this.writer.flush();
        this.getOutputStream().write(this.lineBuffer.toByteArray());
        this.lineBuffer.reset();
    }

    @Override
    public void writeHeader(VCFHeader vCFHeader) {
        try {
            this.mHeader = VCFWriter.writeHeader(vCFHeader, this.writer, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), this.getStreamName());
            this.vcfEncoder = new VCFEncoder(this.mHeader, this.allowMissingFieldsInHeader);
            this.writeAndResetBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't write file " + this.getStreamName(), iOException);
        }
    }

    public static String getVersionLine() {
        return VERSION_LINE;
    }

    public static VCFHeader writeHeader(VCFHeader vCFHeader, Writer writer, boolean bl, String string, String string2) {
        vCFHeader = bl ? new VCFHeader(vCFHeader.getMetaDataInSortedOrder()) : vCFHeader;
        try {
            writer.write(string + "\n");
            for (VCFHeaderLine object : vCFHeader.getMetaDataInSortedOrder()) {
                if (VCFHeaderVersion.isFormatString(object.getKey())) continue;
                writer.write("##");
                writer.write(object.toString());
                writer.write("\n");
            }
            writer.write("#");
            boolean bl2 = true;
            for (VCFHeader.HEADER_FIELDS hEADER_FIELDS : vCFHeader.getHeaderFields()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    writer.write("\t");
                }
                writer.write(hEADER_FIELDS.toString());
            }
            if (vCFHeader.hasGenotypingData()) {
                writer.write("\t");
                writer.write("FORMAT");
                for (String string3 : vCFHeader.getGenotypeSamples()) {
                    writer.write("\t");
                    writer.write(string3);
                }
            }
            writer.write("\n");
            writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException writing the VCF header to " + string2, iOException);
        }
        return vCFHeader;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to close " + this.getStreamName(), iOException);
        }
        super.close();
    }

    @Override
    public void add(VariantContext variantContext) {
        try {
            super.add(variantContext);
            if (this.doNotWriteGenotypes) {
                this.write(this.vcfEncoder.encode(new VariantContextBuilder(variantContext).noGenotypes().make()));
            } else {
                this.write(this.vcfEncoder.encode(variantContext));
            }
            this.write("\n");
            this.writeAndResetBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to write the VCF object to " + this.getStreamName(), iOException);
        }
    }
}

