/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broad.tribble.Tribble;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.PositionalOutputStream;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;

abstract class IndexingVariantContextWriter
implements VariantContextWriter {
    private final String name;
    private final SAMSequenceDictionary refDict;
    private OutputStream outputStream;
    private PositionalOutputStream positionalOutputStream = null;
    private DynamicIndexCreator indexer = null;
    private LittleEndianOutputStream idxStream = null;
    private static final String SequenceDictionaryPropertyPredicate = "DICT:";

    @Requires(value={"name != null", "! ( location == null && output == null )", "! ( enableOnTheFlyIndexing && location == null )"})
    protected IndexingVariantContextWriter(String string, File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        this.outputStream = outputStream;
        this.name = string;
        this.refDict = sAMSequenceDictionary;
        if (bl) {
            try {
                this.idxStream = new LittleEndianOutputStream(new FileOutputStream(Tribble.indexFile(file)));
                this.indexer = new DynamicIndexCreator(IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
                this.indexer.initialize(file, this.indexer.defaultBinSize());
                this.positionalOutputStream = new PositionalOutputStream(outputStream);
                this.outputStream = this.positionalOutputStream;
            }
            catch (IOException iOException) {
                this.idxStream = null;
                this.indexer = null;
                this.positionalOutputStream = null;
            }
        }
    }

    @Ensures(value={"result != null"})
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Ensures(value={"result != null"})
    public String getStreamName() {
        return this.name;
    }

    @Override
    public abstract void writeHeader(VCFHeader var1);

    @Override
    public void close() {
        try {
            this.outputStream.close();
            if (this.indexer != null) {
                Index index = this.indexer.finalizeIndex(this.positionalOutputStream.getPosition());
                IndexingVariantContextWriter.setIndexSequenceDictionary(index, this.refDict);
                index.write(this.idxStream);
                this.idxStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to close index for " + this.getStreamName(), iOException);
        }
    }

    public SAMSequenceDictionary getRefDict() {
        return this.refDict;
    }

    @Override
    public void add(VariantContext variantContext) {
        if (this.indexer != null) {
            this.indexer.addFeature(variantContext, this.positionalOutputStream.getPosition());
        }
    }

    protected static final String writerName(File file, OutputStream outputStream) {
        return file == null ? outputStream.toString() : file.getAbsolutePath();
    }

    private static void setIndexSequenceDictionary(Index index, SAMSequenceDictionary sAMSequenceDictionary) {
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            String string = SequenceDictionaryPropertyPredicate + sAMSequenceRecord.getSequenceName();
            String string2 = String.valueOf(sAMSequenceRecord.getSequenceLength());
            index.addProperty(string, string2);
        }
    }
}

