/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.bcf2.BCF2Codec;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.bcf2.BCFVersion;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.BCF2Encoder;
import org.broadinstitute.variant.variantcontext.writer.BCF2FieldWriter;
import org.broadinstitute.variant.variantcontext.writer.BCF2FieldWriterManager;
import org.broadinstitute.variant.variantcontext.writer.IndexingVariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VCFWriter;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;

class BCF2Writer
extends IndexingVariantContextWriter {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 1;
    private static final boolean ALLOW_MISSING_CONTIG_LINES = false;
    private final OutputStream outputStream;
    private VCFHeader header;
    private final Map<String, Integer> contigDictionary = new HashMap<String, Integer>();
    private final Map<String, Integer> stringDictionaryMap = new LinkedHashMap<String, Integer>();
    private final boolean doNotWriteGenotypes;
    private String[] sampleNames = null;
    private final BCF2Encoder encoder = new BCF2Encoder();
    final BCF2FieldWriterManager fieldManager = new BCF2FieldWriterManager();
    private VCFHeader lastVCFHeaderOfUnparsedGenotypes = null;
    private boolean canPassOnUnparsedGenotypeDataForLastVCFHeader = false;

    public BCF2Writer(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, boolean bl, boolean bl2) {
        super(BCF2Writer.writerName(file, outputStream), file, outputStream, sAMSequenceDictionary, bl);
        this.outputStream = this.getOutputStream();
        this.doNotWriteGenotypes = bl2;
    }

    @Override
    public void writeHeader(VCFHeader vCFHeader) {
        if ((vCFHeader = new VCFHeader(vCFHeader.getMetaDataInSortedOrder(), vCFHeader.getGenotypeSamples())).getContigLines().isEmpty()) {
            throw new IllegalStateException("Cannot write BCF2 file with missing contig lines");
        }
        this.createContigDictionary(vCFHeader.getContigLines());
        ArrayList<String> arrayList = BCF2Utils.makeDictionary(vCFHeader);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.stringDictionaryMap.put(arrayList.get(i), i);
        }
        this.sampleNames = vCFHeader.getGenotypeSamples().toArray(new String[vCFHeader.getNGenotypeSamples()]);
        this.fieldManager.setup(vCFHeader, this.encoder, this.stringDictionaryMap);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            this.header = VCFWriter.writeHeader(vCFHeader, outputStreamWriter, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), "BCF2 stream");
            outputStreamWriter.append('\u0000');
            outputStreamWriter.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            new BCFVersion(2, 1).write(this.outputStream);
            BCF2Type.INT32.write(byArray.length, this.outputStream);
            this.outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("BCF2 stream: Got IOException while trying to write BCF2 header", iOException);
        }
    }

    @Override
    public void add(VariantContext variantContext) {
        if (this.doNotWriteGenotypes) {
            variantContext = new VariantContextBuilder(variantContext).noGenotypes().make();
        }
        variantContext = variantContext.fullyDecode(this.header, false);
        super.add(variantContext);
        try {
            byte[] byArray = this.buildSitesData(variantContext);
            byte[] byArray2 = this.buildSamplesData(variantContext);
            this.writeBlock(byArray, byArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing record to BCF2 file: " + variantContext.toString(), iOException);
        }
    }

    @Override
    public void close() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to close BCF2 file");
        }
        super.close();
    }

    private byte[] buildSitesData(VariantContext variantContext) throws IOException {
        int n = this.contigDictionary.get(variantContext.getChr());
        if (n == -1) {
            throw new IllegalStateException(String.format("Contig %s not found in sequence dictionary from reference", variantContext.getChr()));
        }
        this.encoder.encodeRawValue(n, BCF2Type.INT32);
        this.encoder.encodeRawValue(variantContext.getStart() - 1, BCF2Type.INT32);
        this.encoder.encodeRawValue(variantContext.getEnd() - variantContext.getStart() + 1, BCF2Type.INT32);
        if (variantContext.hasLog10PError()) {
            this.encoder.encodeRawFloat((float)variantContext.getPhredScaledQual());
        } else {
            this.encoder.encodeRawMissingValue(BCF2Type.FLOAT);
        }
        int n2 = variantContext.getNAlleles();
        int n3 = variantContext.getAttributes().size();
        int n4 = this.getNGenotypeFormatFields(variantContext);
        int n5 = this.header.getNGenotypeSamples();
        this.encoder.encodeRawInt(n2 << 16 | n3 & 0xFFFF, BCF2Type.INT32);
        this.encoder.encodeRawInt(n4 << 24 | n5 & 0xFFFFF, BCF2Type.INT32);
        this.buildID(variantContext);
        this.buildAlleles(variantContext);
        this.buildFilter(variantContext);
        this.buildInfo(variantContext);
        return this.encoder.getRecordBytes();
    }

    private boolean canSafelyWriteRawGenotypesBytes(BCF2Codec.LazyData lazyData) {
        if (lazyData.header != this.lastVCFHeaderOfUnparsedGenotypes) {
            this.canPassOnUnparsedGenotypeDataForLastVCFHeader = BCF2Utils.headerLinesAreOrderedConsistently(this.header, lazyData.header);
            this.lastVCFHeaderOfUnparsedGenotypes = lazyData.header;
        }
        return this.canPassOnUnparsedGenotypeDataForLastVCFHeader;
    }

    private BCF2Codec.LazyData getLazyData(VariantContext variantContext) {
        if (variantContext.getGenotypes().isLazyWithData()) {
            LazyGenotypesContext lazyGenotypesContext = (LazyGenotypesContext)variantContext.getGenotypes();
            if (lazyGenotypesContext.getUnparsedGenotypeData() instanceof BCF2Codec.LazyData && this.canSafelyWriteRawGenotypesBytes((BCF2Codec.LazyData)lazyGenotypesContext.getUnparsedGenotypeData())) {
                return (BCF2Codec.LazyData)lazyGenotypesContext.getUnparsedGenotypeData();
            }
            lazyGenotypesContext.decode();
        }
        return null;
    }

    private int getNGenotypeFormatFields(VariantContext variantContext) {
        BCF2Codec.LazyData lazyData = this.getLazyData(variantContext);
        return lazyData != null ? lazyData.nGenotypeFields : variantContext.calcVCFGenotypeKeys(this.header).size();
    }

    private void buildID(VariantContext variantContext) throws IOException {
        this.encoder.encodeTypedString(variantContext.getID());
    }

    private void buildAlleles(VariantContext variantContext) throws IOException {
        for (Allele allele : variantContext.getAlleles()) {
            byte[] byArray = allele.getDisplayBases();
            if (byArray == null) {
                throw new IllegalStateException("BUG: BCF2Writer encountered null padded allele" + allele);
            }
            this.encoder.encodeTypedString(byArray);
        }
    }

    private void buildFilter(VariantContext variantContext) throws IOException {
        if (variantContext.isFiltered()) {
            this.encodeStringsByRef(variantContext.getFilters());
        } else if (variantContext.filtersWereApplied()) {
            this.encodeStringsByRef(Collections.singleton("PASS"));
        } else {
            this.encoder.encodeTypedMissing(BCF2Type.INT8);
        }
    }

    private void buildInfo(VariantContext variantContext) throws IOException {
        for (Map.Entry<String, Object> entry : variantContext.getAttributes().entrySet()) {
            String string = entry.getKey();
            BCF2FieldWriter.SiteWriter siteWriter = this.fieldManager.getSiteFieldWriter(string);
            if (siteWriter == null) {
                this.errorUnexpectedFieldToWrite(variantContext, string, "INFO");
            }
            siteWriter.start(this.encoder, variantContext);
            siteWriter.site(this.encoder, variantContext);
            siteWriter.done(this.encoder, variantContext);
        }
    }

    private byte[] buildSamplesData(VariantContext variantContext) throws IOException {
        BCF2Codec.LazyData lazyData = this.getLazyData(variantContext);
        if (lazyData != null) {
            return lazyData.bytes;
        }
        List<String> list = variantContext.calcVCFGenotypeKeys(this.header);
        for (String string : list) {
            BCF2FieldWriter.GenotypesWriter genotypesWriter = this.fieldManager.getGenotypeFieldWriter(string);
            if (genotypesWriter == null) {
                this.errorUnexpectedFieldToWrite(variantContext, string, "FORMAT");
            }
            assert (genotypesWriter != null);
            genotypesWriter.start(this.encoder, variantContext);
            for (String string2 : this.sampleNames) {
                Genotype genotype = variantContext.getGenotype(string2);
                if (genotype == null) {
                    genotype = GenotypeBuilder.createMissing(string2, genotypesWriter.nValuesPerGenotype);
                }
                genotypesWriter.addGenotype(this.encoder, variantContext, genotype);
            }
            genotypesWriter.done(this.encoder, variantContext);
        }
        return this.encoder.getRecordBytes();
    }

    private void errorUnexpectedFieldToWrite(VariantContext variantContext, String string, String string2) {
        throw new IllegalStateException("Found field " + string + " in the " + string2 + " fields of VariantContext at " + variantContext.getChr() + ":" + variantContext.getStart() + " from " + variantContext.getSource() + " but this hasn't been defined in the VCFHeader");
    }

    @Requires(value={"infoBlock.length > 0", "genotypesBlock.length >= 0"})
    private void writeBlock(byte[] byArray, byte[] byArray2) throws IOException {
        BCF2Type.INT32.write(byArray.length, this.outputStream);
        BCF2Type.INT32.write(byArray2.length, this.outputStream);
        this.outputStream.write(byArray);
        this.outputStream.write(byArray2);
    }

    @Requires(value={"! strings.isEmpty()"})
    @Ensures(value={"result.isIntegerType()"})
    private BCF2Type encodeStringsByRef(Collection<String> collection) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (String string : collection) {
            Integer n = this.stringDictionaryMap.get(string);
            if (n == null) {
                throw new IllegalStateException("Format error: could not find string " + string + " in header as required by BCF");
            }
            int n2 = n;
            arrayList.add(n2);
        }
        Object object = BCF2Utils.determineIntegerType(arrayList);
        this.encoder.encodeTyped((List<? extends Object>)arrayList, (BCF2Type)((Object)object));
        return object;
    }

    @Requires(value={"contigDictionary.isEmpty()"})
    private void createContigDictionary(Collection<VCFContigHeaderLine> collection) {
        int n = 0;
        for (VCFContigHeaderLine vCFContigHeaderLine : collection) {
            this.contigDictionary.put(vCFContigHeaderLine.getID(), n++);
        }
    }
}

