/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;

public final class BCF2Encoder {
    public static final int WRITE_BUFFER_INITIAL_SIZE = 16384;
    private ByteArrayOutputStream encodeStream = new ByteArrayOutputStream(16384);

    @Ensures(value={"result != null"})
    public byte[] getRecordBytes() {
        byte[] byArray = this.encodeStream.toByteArray();
        this.encodeStream.reset();
        return byArray;
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedMissing(BCF2Type bCF2Type) throws IOException {
        this.encodeType(0, bCF2Type);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTyped(Object object, BCF2Type bCF2Type) throws IOException {
        if (object == null) {
            this.encodeTypedMissing(bCF2Type);
        } else {
            switch (bCF2Type) {
                case INT8: 
                case INT16: 
                case INT32: {
                    this.encodeTypedInt((Integer)object, bCF2Type);
                    break;
                }
                case FLOAT: {
                    this.encodeTypedFloat((Double)object);
                    break;
                }
                case CHAR: {
                    this.encodeTypedString((String)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type encountered " + (Object)((Object)bCF2Type));
                }
            }
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedInt(int n) throws IOException {
        BCF2Type bCF2Type = BCF2Utils.determineIntegerType(n);
        this.encodeTypedInt(n, bCF2Type);
    }

    @Requires(value={"type.isIntegerType()"})
    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedInt(int n, BCF2Type bCF2Type) throws IOException {
        this.encodeType(1, bCF2Type);
        this.encodeRawInt(n, bCF2Type);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedString(String string) throws IOException {
        this.encodeTypedString(string.getBytes());
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedString(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.encodeType(0, BCF2Type.CHAR);
        } else {
            this.encodeType(byArray.length, BCF2Type.CHAR);
            for (int i = 0; i < byArray.length; ++i) {
                this.encodeRawChar(byArray[i]);
            }
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedFloat(double d) throws IOException {
        this.encodeType(1, BCF2Type.FLOAT);
        this.encodeRawFloat(d);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTyped(List<? extends Object> list, BCF2Type bCF2Type) throws IOException {
        if (bCF2Type == BCF2Type.CHAR && list.size() != 0) {
            String string = BCF2Utils.collapseStringList(list);
            list = this.stringToBytes(string);
        }
        this.encodeType(list.size(), bCF2Type);
        this.encodeRawValues(list, bCF2Type);
    }

    public final <T> void encodeRawValues(Collection<T> collection, BCF2Type bCF2Type) throws IOException {
        for (T t : collection) {
            this.encodeRawValue(t, bCF2Type);
        }
    }

    public final <T> void encodeRawValue(T t, BCF2Type bCF2Type) throws IOException {
        try {
            if (t == bCF2Type.getMissingJavaValue()) {
                this.encodeRawMissingValue(bCF2Type);
            } else {
                switch (bCF2Type) {
                    case INT8: 
                    case INT16: 
                    case INT32: {
                        this.encodeRawBytes((Integer)t, bCF2Type);
                        break;
                    }
                    case FLOAT: {
                        this.encodeRawFloat((Double)t);
                        break;
                    }
                    case CHAR: {
                        this.encodeRawChar((Byte)t);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal type encountered " + (Object)((Object)bCF2Type));
                    }
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("BUG: invalid type cast to " + (Object)((Object)bCF2Type) + " from " + t);
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeRawMissingValue(BCF2Type bCF2Type) throws IOException {
        this.encodeRawBytes(bCF2Type.getMissingBytes(), bCF2Type);
    }

    @Requires(value={"size >= 0"})
    public final void encodeRawMissingValues(int n, BCF2Type bCF2Type) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.encodeRawMissingValue(bCF2Type);
        }
    }

    public final void encodeRawChar(byte by) throws IOException {
        this.encodeStream.write(by);
    }

    public final void encodeRawFloat(double d) throws IOException {
        this.encodeRawBytes(Float.floatToIntBits((float)d), BCF2Type.FLOAT);
    }

    @Requires(value={"size >= 0"})
    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeType(int n, BCF2Type bCF2Type) throws IOException {
        if (n <= 14) {
            byte by = BCF2Utils.encodeTypeDescriptor(n, bCF2Type);
            this.encodeStream.write(by);
        } else {
            byte by = BCF2Utils.encodeTypeDescriptor(15, bCF2Type);
            this.encodeStream.write(by);
            this.encodeTypedInt(n);
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeRawInt(int n, BCF2Type bCF2Type) throws IOException {
        bCF2Type.write(n, this.encodeStream);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeRawBytes(int n, BCF2Type bCF2Type) throws IOException {
        bCF2Type.write(n, this.encodeStream);
    }

    @Requires(value={"s != null", "sizeToWrite >= 0"})
    public void encodeRawString(String string, int n) throws IOException {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < n; ++i) {
            if (i < byArray.length) {
                this.encodeRawChar(byArray[i]);
                continue;
            }
            this.encodeRawMissingValue(BCF2Type.CHAR);
        }
    }

    @Requires(value={"o != null"})
    public final BCF2Type encode(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Generic encode cannot deal with null values");
        }
        if (object instanceof List) {
            BCF2Type bCF2Type = this.determineBCFType(((List)object).get(0));
            this.encodeTyped((List)object, bCF2Type);
            return bCF2Type;
        }
        BCF2Type bCF2Type = this.determineBCFType(object);
        this.encodeTyped(object, bCF2Type);
        return bCF2Type;
    }

    @Requires(value={"arg != null"})
    private final BCF2Type determineBCFType(Object object) {
        Object object2;
        Object object3 = object2 = object instanceof List ? ((List)object).get(0) : object;
        if (object2 instanceof Integer) {
            return BCF2Utils.determineIntegerType((Integer)object2);
        }
        if (object2 instanceof String) {
            return BCF2Type.CHAR;
        }
        if (object2 instanceof Double) {
            return BCF2Type.FLOAT;
        }
        throw new IllegalArgumentException("No native encoding for Object of type " + object.getClass().getSimpleName());
    }

    private final List<Byte> stringToBytes(String string) throws IOException {
        if (string == null || string.equals("")) {
            return Collections.emptyList();
        }
        byte[] byArray = string.getBytes();
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(byArray[i]);
        }
        return arrayList;
    }
}

