/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;

public class VariantContextBuilder {
    private boolean fullyDecoded = false;
    private String source = null;
    private String contig = null;
    private long start = -1L;
    private long stop = -1L;
    private Collection<Allele> alleles = null;
    private String ID = ".";
    private GenotypesContext genotypes = GenotypesContext.NO_GENOTYPES;
    private double log10PError = 1.0;
    private Set<String> filters = null;
    private Map<String, Object> attributes = null;
    private boolean attributesCanBeModified = false;
    private final EnumSet<VariantContext.Validation> toValidate = EnumSet.noneOf(VariantContext.Validation.class);

    public VariantContextBuilder() {
    }

    @Requires(value={"source != null", "contig != null", "start >= 0", "stop >= 0", "alleles != null && !alleles.isEmpty()"})
    public VariantContextBuilder(String string, String string2, long l, long l2, Collection<Allele> collection) {
        this.source = string;
        this.contig = string2;
        this.start = l;
        this.stop = l2;
        this.alleles = collection;
        this.attributes = Collections.emptyMap();
        this.toValidate.add(VariantContext.Validation.ALLELES);
    }

    public VariantContextBuilder(VariantContext variantContext) {
        if (variantContext == null) {
            throw new IllegalArgumentException("BUG: VariantContextBuilder parent argument cannot be null in VariantContextBuilder");
        }
        this.alleles = variantContext.alleles;
        this.attributes = variantContext.getAttributes();
        this.attributesCanBeModified = false;
        this.contig = variantContext.contig;
        this.filters = variantContext.getFiltersMaybeNull();
        this.genotypes = variantContext.genotypes;
        this.ID = variantContext.getID();
        this.log10PError = variantContext.getLog10PError();
        this.source = variantContext.getSource();
        this.start = variantContext.getStart();
        this.stop = variantContext.getEnd();
        this.fullyDecoded = variantContext.isFullyDecoded();
    }

    public VariantContextBuilder(VariantContextBuilder variantContextBuilder) {
        if (variantContextBuilder == null) {
            throw new IllegalArgumentException("BUG: VariantContext parent argument cannot be null in VariantContextBuilder");
        }
        this.alleles = variantContextBuilder.alleles;
        this.attributesCanBeModified = false;
        this.contig = variantContextBuilder.contig;
        this.genotypes = variantContextBuilder.genotypes;
        this.ID = variantContextBuilder.ID;
        this.log10PError = variantContextBuilder.log10PError;
        this.source = variantContextBuilder.source;
        this.start = variantContextBuilder.start;
        this.stop = variantContextBuilder.stop;
        this.fullyDecoded = variantContextBuilder.fullyDecoded;
        this.attributes(variantContextBuilder.attributes);
        this.filters(variantContextBuilder.filters);
    }

    public VariantContextBuilder copy() {
        return new VariantContextBuilder(this);
    }

    @Requires(value={"alleles != null", "!alleles.isEmpty()"})
    public VariantContextBuilder alleles(Collection<Allele> collection) {
        this.alleles = collection;
        this.toValidate.add(VariantContext.Validation.ALLELES);
        return this;
    }

    public VariantContextBuilder alleles(List<String> list) {
        ArrayList<Allele> arrayList = new ArrayList<Allele>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(Allele.create(list.get(i), i == 0));
        }
        return this.alleles((Collection<Allele>)arrayList);
    }

    public VariantContextBuilder alleles(String ... stringArray) {
        return this.alleles(Arrays.asList(stringArray));
    }

    public List<Allele> getAlleles() {
        return new ArrayList<Allele>(this.alleles);
    }

    public VariantContextBuilder attributes(Map<String, Object> map) {
        this.attributes = map != null ? map : new HashMap<String, Object>();
        this.attributesCanBeModified = true;
        return this;
    }

    @Requires(value={"key != null"})
    @Ensures(value={"this.attributes.size() == old(this.attributes.size()) || this.attributes.size() == old(this.attributes.size()+1)"})
    public VariantContextBuilder attribute(String string, Object object) {
        this.makeAttributesModifiable();
        this.attributes.put(string, object);
        return this;
    }

    @Requires(value={"key != null"})
    @Ensures(value={"this.attributes.size() == old(this.attributes.size()) || this.attributes.size() == old(this.attributes.size()-1)"})
    public VariantContextBuilder rmAttribute(String string) {
        this.makeAttributesModifiable();
        this.attributes.remove(string);
        return this;
    }

    @Ensures(value={"this.attributesCanBeModified"})
    private void makeAttributesModifiable() {
        if (!this.attributesCanBeModified) {
            this.attributesCanBeModified = true;
            this.attributes = new HashMap<String, Object>(this.attributes);
        }
    }

    public VariantContextBuilder filters(Set<String> set) {
        this.filters = set;
        return this;
    }

    public VariantContextBuilder filters(String ... stringArray) {
        this.filters(new LinkedHashSet<String>(Arrays.asList(stringArray)));
        return this;
    }

    @Requires(value={"filter != null", "!filter.equals(\"PASS\")"})
    public VariantContextBuilder filter(String string) {
        if (this.filters == null) {
            this.filters = new LinkedHashSet<String>(1);
        }
        this.filters.add(string);
        return this;
    }

    public VariantContextBuilder passFilters() {
        return this.filters(VariantContext.PASSES_FILTERS);
    }

    public VariantContextBuilder unfiltered() {
        this.filters = null;
        return this;
    }

    public VariantContextBuilder genotypes(GenotypesContext genotypesContext) {
        this.genotypes = genotypesContext;
        if (genotypesContext != null) {
            this.toValidate.add(VariantContext.Validation.GENOTYPES);
        }
        return this;
    }

    public VariantContextBuilder genotypesNoValidation(GenotypesContext genotypesContext) {
        this.genotypes = genotypesContext;
        return this;
    }

    public VariantContextBuilder genotypes(Collection<Genotype> collection) {
        return this.genotypes(GenotypesContext.copy(collection));
    }

    public VariantContextBuilder genotypes(Genotype ... genotypeArray) {
        return this.genotypes(GenotypesContext.copy(Arrays.asList(genotypeArray)));
    }

    public VariantContextBuilder noGenotypes() {
        this.genotypes = null;
        return this;
    }

    @Requires(value={"ID != null"})
    public VariantContextBuilder id(String string) {
        this.ID = string;
        return this;
    }

    public VariantContextBuilder noID() {
        return this.id(".");
    }

    @Requires(value={"log10PError <= 0 || log10PError == VariantContext.NO_LOG10_PERROR"})
    public VariantContextBuilder log10PError(double d) {
        this.log10PError = d;
        return this;
    }

    @Requires(value={"source != null"})
    public VariantContextBuilder source(String string) {
        this.source = string;
        return this;
    }

    @Requires(value={"contig != null", "start >= 0", "stop >= 0"})
    public VariantContextBuilder loc(String string, long l, long l2) {
        this.contig = string;
        this.start = l;
        this.stop = l2;
        this.toValidate.add(VariantContext.Validation.ALLELES);
        return this;
    }

    @Requires(value={"contig != null"})
    public VariantContextBuilder chr(String string) {
        this.contig = string;
        return this;
    }

    @Requires(value={"start >= 0"})
    public VariantContextBuilder start(long l) {
        this.start = l;
        this.toValidate.add(VariantContext.Validation.ALLELES);
        return this;
    }

    @Requires(value={"stop >= 0"})
    public VariantContextBuilder stop(long l) {
        this.stop = l;
        return this;
    }

    public VariantContextBuilder computeEndFromAlleles(List<Allele> list, int n) {
        return this.computeEndFromAlleles(list, n, -1);
    }

    @Requires(value={"! alleles.isEmpty()", "start > 0", "endForSymbolicAlleles == -1 || endForSymbolicAlleles > 0"})
    public VariantContextBuilder computeEndFromAlleles(List<Allele> list, int n, int n2) {
        this.stop(VariantContextUtils.computeEndFromAlleles(list, n, n2));
        return this;
    }

    public boolean isFullyDecoded() {
        return this.fullyDecoded;
    }

    public VariantContextBuilder fullyDecoded(boolean bl) {
        this.fullyDecoded = bl;
        return this;
    }

    public VariantContext make() {
        return new VariantContext(this.source, this.ID, this.contig, this.start, this.stop, this.alleles, this.genotypes, this.log10PError, this.filters, this.attributes, this.fullyDecoded, this.toValidate);
    }
}

