/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.io.Reader;

public class LongLineBufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static final int DEFAULT_EXPECTED_LINE_LENGTH = 80;
    private StringBuilder lineBuffer = new StringBuilder(80);

    public LongLineBufferedReader(Reader reader, int n) {
        super((Object)reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = reader;
        this.cb = new char[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public LongLineBufferedReader(Reader reader) {
        this(reader, 8192);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                    this.markedChar = 0;
                    n2 = n;
                } else {
                    char[] cArray = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                    this.cb = cArray;
                    this.markedChar = 0;
                    n2 = n;
                }
                this.nextChar = this.nChars = n;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (this.cb[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            return this.cb[this.nextChar++];
        }
    }

    private int read1(char[] cArray, int n, int n2) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (n2 >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                return this.in.read(cArray, n, n2);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cb[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n3 = Math.min(n2, this.nChars - this.nextChar);
        System.arraycopy(this.cb, this.nextChar, cArray, n, n3);
        this.nextChar += n3;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = this.read1(cArray, n, n2);
            if (n4 <= 0) {
                return n4;
            }
            while (n4 < n2 && this.in.ready() && (n3 = this.read1(cArray, n + n4, n2 - n4)) > 0) {
                n4 += n3;
            }
            return n4;
        }
    }

    String readLine(boolean bl) throws IOException {
        this.lineBuffer.setLength(0);
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            this.ensureOpen();
            boolean bl3 = bl2 = bl || this.skipLF;
            while (true) {
                int n;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (this.lineBuffer != null && this.lineBuffer.length() > 0) {
                        return this.lineBuffer.toString();
                    }
                    return null;
                }
                boolean bl4 = false;
                char c = '\u0000';
                if (!bl2 || this.cb[this.nextChar] == '\n') {
                    // empty if block
                }
                this.skipLF = false;
                bl2 = false;
                for (n = ++this.nextChar; n < this.nChars; ++n) {
                    c = this.cb[n];
                    if (c != '\n' && c != '\r') continue;
                    bl4 = true;
                    break;
                }
                int n2 = this.nextChar;
                this.nextChar = n;
                if (bl4) {
                    this.lineBuffer.append(this.cb, n2, n - n2);
                    String string = this.lineBuffer.toString();
                    ++this.nextChar;
                    if (c == '\r') {
                        this.skipLF = true;
                    }
                    return string;
                }
                this.lineBuffer.append(this.cb, n2, n - n2);
            }
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            long l2;
            long l3;
            this.ensureOpen();
            for (l2 = l; l2 > 0L; l2 -= l3) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (l2 <= (l3 = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + l2);
                    l2 = 0L;
                    break;
                }
                this.nextChar = this.nChars;
            }
            return l - l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.ready();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = n;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
        }
    }
}

