/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import org.broad.tribble.gelitext.DiploidGenotypeException;

public enum DiploidGenotype {
    AA,
    AC,
    AG,
    AT,
    CC,
    CG,
    CT,
    GG,
    GT,
    TT;


    public static DiploidGenotype toDiploidGenotype(String string) {
        if (string.length() != 2) {
            throw new DiploidGenotypeException("Genotype string for conversion should be of length 2, we were passed = " + string);
        }
        string = string.toUpperCase();
        for (DiploidGenotype diploidGenotype : DiploidGenotype.values()) {
            if (!diploidGenotype.toString().equals(string)) continue;
            return diploidGenotype;
        }
        throw new DiploidGenotypeException("Unable to find genotype matching " + string);
    }

    public boolean isHet() {
        return this.toString().toCharArray()[0] != this.toString().toCharArray()[1];
    }

    public boolean containsBase(char c) {
        return this.toString().charAt(0) == c || this.toString().charAt(1) == c;
    }
}

